/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.SharedMesh;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.UserDataManager;
import com.jme.scene.state.RenderState;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class SharedNode
extends Node {
    private static final long serialVersionUID = 1L;
    private boolean updatesCollisionTree;

    public SharedNode() {
    }

    public SharedNode(String string, Node node) {
        super(string);
        this.setTarget(node);
    }

    public void draw(Renderer renderer) {
        super.draw(renderer);
    }

    private void setTarget(Node node) {
        if (node.getChildren() != null) {
            for (int i = 0; i < node.getChildren().size(); ++i) {
                this.processTarget(this, node.getChild(i));
            }
        }
        this.copyNode(node, this);
        UserDataManager.getInstance().bind(this, node);
    }

    private void processTarget(Node node, Spatial spatial) {
        if ((spatial.getType() & 1) != 0) {
            Node node2 = (Node)spatial;
            Node node3 = new Node();
            UserDataManager.getInstance().bind(node3, spatial);
            this.copyNode(node2, node3);
            node.attachChild(node3);
            if (node2.getChildren() != null) {
                for (int i = 0; i < node2.getChildren().size(); ++i) {
                    this.processTarget(node3, node2.getChild(i));
                }
            }
        } else if ((spatial.getType() & 4) != 0) {
            if ((spatial.getType() & 8) != 0) {
                SharedMesh sharedMesh = new SharedMesh(this.getName() + spatial.getName(), (SharedMesh)spatial);
                node.attachChild(sharedMesh);
            } else {
                SharedMesh sharedMesh = new SharedMesh(this.getName() + spatial.getName(), (TriMesh)spatial);
                node.attachChild(sharedMesh);
            }
        }
    }

    private void copyNode(Node node, Node node2) {
        node2.setName(this.getName() + node.getName());
        node2.setCullMode(node.cullMode);
        node2.setLightCombineMode(node.lightCombineMode);
        node2.getLocalRotation().set(node.getLocalRotation());
        node2.getLocalScale().set(node.getLocalScale());
        node2.getLocalTranslation().set(node.getLocalTranslation());
        node2.setRenderQueueMode(node.renderQueueMode);
        node2.setTextureCombineMode(node.textureCombineMode);
        node2.setZOrder(node.getZOrder());
        for (int i = 0; i < 17; ++i) {
            RenderState renderState = node.getRenderState(i);
            if (renderState == null) continue;
            node2.setRenderState(renderState);
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.updatesCollisionTree, "updatesCollisionTree", false);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.updatesCollisionTree = inputCapsule.readBoolean("updatesCollisionTree", false);
    }
}

