/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene;

import com.jme.intersection.CollisionResults;
import com.jme.intersection.PickResults;
import com.jme.math.Ray;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;

public class SwitchNode
extends Node {
    private static final long serialVersionUID = 1L;
    public static final int SN_INVALID_CHILD = -1;
    private int activeChild;
    private Spatial activeChildData;

    public SwitchNode() {
    }

    public SwitchNode(String string) {
        super(string);
        this.activeChild = -1;
    }

    public int getActiveChild() {
        return this.activeChild;
    }

    public void setActiveChild(int n) {
        if (n < 0 || n > this.getQuantity()) {
            this.activeChild = -1;
        } else {
            if (this.activeChildData != null) {
                this.activeChildData.setIsCollidable(false);
            }
            this.activeChild = n;
            this.activeChildData = this.getChild(this.activeChild);
            this.activeChildData.setIsCollidable(true);
        }
    }

    public void disableAllChildren() {
        this.activeChild = -1;
    }

    public int attachChild(Spatial spatial) {
        spatial.setIsCollidable(false);
        return super.attachChild(spatial);
    }

    public int attachChildAt(Spatial spatial, int n) {
        spatial.setIsCollidable(false);
        return super.attachChildAt(spatial, n);
    }

    public void draw(Renderer renderer) {
        if (this.activeChild != -1 && this.activeChildData != null) {
            this.activeChildData.onDraw(renderer);
        }
    }

    public void findCollisions(Spatial spatial, CollisionResults collisionResults) {
        if (this == spatial || !this.isCollidable || !spatial.isCollidable()) {
            return;
        }
        if (this.activeChild != -1 && this.activeChildData != null) {
            this.activeChildData.findCollisions(spatial, collisionResults);
        }
    }

    public boolean hasCollision(Spatial spatial, boolean bl) {
        if (this == spatial || !this.isCollidable || !spatial.isCollidable()) {
            return false;
        }
        if (this.activeChild != -1 && this.activeChildData != null) {
            return this.activeChildData.hasCollision(spatial, bl);
        }
        return false;
    }

    public void findPick(Ray ray, PickResults pickResults) {
        if (this.activeChild != -1 && this.activeChildData != null) {
            this.activeChildData.findPick(ray, pickResults);
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.activeChild, "activeChild", 0);
        outputCapsule.write(this.activeChildData, "activeChildData", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.activeChild = inputCapsule.readInt("activeChild", 0);
        this.activeChildData = (Spatial)inputCapsule.readSavable("activeChildData", null);
    }
}

