/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.lod;

import com.jme.math.Vector3f;
import com.jme.scene.lod.CollapseRecord;
import com.jme.scene.lod.ExVector;
import com.jme.scene.lod.VETMesh;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class ClodCreator
extends VETMesh {
    private FloatBuffer vertices;
    private FloatBuffer normals;
    private FloatBuffer colors;
    private FloatBuffer textures;
    private IntBuffer indices;
    private int currentVertex;
    private int currentTriangle;
    private int numbTriangles;
    private int vertQuantity;
    private int[] orderedVertices;
    private int[] permuteVertices;
    private int[] newIndices;
    int heapSize;
    HeapRecord[] heapArray;
    boolean collapsing;
    TreeSet<Integer> deletedVertices;
    ArrayList<CollapseRecord> deletedEdges;
    CollapseRecord[] records;
    private static final Vector3f tempVa = new Vector3f();
    private static final Vector3f tempVb = new Vector3f();
    private static final Vector3f tempVc = new Vector3f();
    private static final Vector3f tempVd = new Vector3f();

    public ClodCreator(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, FloatBuffer floatBuffer3, FloatBuffer floatBuffer4, IntBuffer intBuffer) {
        this.vertices = floatBuffer;
        this.normals = floatBuffer2;
        this.colors = floatBuffer3;
        this.textures = floatBuffer4;
        this.indices = intBuffer;
        this.vertQuantity = floatBuffer.capacity() / 3;
        this.numbTriangles = intBuffer.capacity() / 3;
        this.currentVertex = this.vertQuantity - 1;
        this.currentTriangle = this.numbTriangles - 1;
        this.orderedVertices = new int[this.vertQuantity];
        this.permuteVertices = new int[this.vertQuantity];
        this.newIndices = new int[this.indices.capacity()];
        this.deletedEdges = new ArrayList();
        this.deletedVertices = new TreeSet();
        this.collapsing = false;
        for (int i = 0; i < this.numbTriangles; ++i) {
            VETMesh.Triangle triangle = new VETMesh.Triangle(this, this.indices.get(3 * i), this.indices.get(3 * i + 1), this.indices.get(3 * i + 2));
            this.insertTriangle(triangle);
            this.setData(triangle, new Integer(i));
        }
        if (this.triangleMap.size() != this.numbTriangles) {
            Object object2;
            IntBuffer intBuffer2 = BufferUtils.createIntBuffer(this.triangleMap.size() * 3);
            for (Object object2 : this.triangleMap.keySet()) {
                intBuffer2.put(((VETMesh.Triangle)object2).vert[0]);
                intBuffer2.put(((VETMesh.Triangle)object2).vert[1]);
                intBuffer2.put(((VETMesh.Triangle)object2).vert[2]);
            }
            object2 = new ClodCreator(floatBuffer, floatBuffer2, floatBuffer3, floatBuffer4, intBuffer2);
            this.records = ((ClodCreator)object2).getRecords();
            object2 = null;
            this.indices.rewind();
            this.indices.put(intBuffer2);
            this.triangleMap.clear();
            return;
        }
        this.initializeHeap();
        this.collapsing = true;
        while (this.heapSize > 0) {
            if (this.heapArray[0].m_fMetric == Float.MAX_VALUE) {
                this.flushVertices();
                this.flushTriangles();
                break;
            }
            this.doCollapse();
        }
        this.collapsing = false;
        this.reorder();
        this.records = this.computeRecords();
    }

    public CollapseRecord[] getRecords() {
        return this.records;
    }

    public void doCollapse() {
        int n;
        int n2;
        int n3;
        VETMesh.Edge edge = this.heapArray[0].m_kEdge;
        for (n3 = 0; n3 < 2; ++n3) {
            ExVector exVector = (ExVector)this.getEdges(edge.vert[n3]).clone();
            for (n2 = 0; n2 < exVector.size(); ++n2) {
                VETMesh.EdgeAttribute edgeAttribute = (VETMesh.EdgeAttribute)this.edgeMap.get(exVector.toArray()[n2]);
                if (edgeAttribute.triangleSet.size() != 2) break;
            }
            if (n2 == exVector.size()) break;
        }
        if (n3 < 2 && !this.collapseCausesFolding(n2 = edge.vert[1 - n3], n = edge.vert[n3])) {
            this.remove();
            this.collapseEdge(n2, n);
            return;
        }
        this.update(0, Float.MAX_VALUE);
    }

    public boolean collapseCausesFolding(int n, int n2) {
        VETMesh.VertexAttribute vertexAttribute = (VETMesh.VertexAttribute)this.vertexMap.get(new Integer(n2));
        VETMesh.Edge edge = new VETMesh.Edge(this, n, n2);
        for (int i = 0; i < vertexAttribute.triangleSet.size(); ++i) {
            VETMesh.Triangle triangle = (VETMesh.Triangle)vertexAttribute.triangleSet.toArray()[i];
            if (edge.equals(new VETMesh.Edge(this, triangle.vert[0], triangle.vert[1])) || edge.equals(new VETMesh.Edge(this, triangle.vert[1], triangle.vert[2])) || edge.equals(new VETMesh.Edge(this, triangle.vert[2], triangle.vert[0]))) continue;
            for (int j = 0; j < 3; ++j) {
                int n3;
                int n4;
                int n5;
                if (triangle.vert[j] != n2 || this.triangleMap.get(new VETMesh.Triangle(this, n5 = n, n4 = triangle.vert[(j + 1) % 3], n3 = triangle.vert[(j + 2) % 3])) == null && this.triangleMap.get(new VETMesh.Triangle(this, n5, n3, n4)) == null) continue;
                return true;
            }
        }
        return false;
    }

    public float getMetric(VETMesh.Edge edge, VETMesh.EdgeAttribute edgeAttribute) {
        float f = 10.0f;
        float f2 = 1.0f;
        if (edgeAttribute.triangleSet.size() == 2) {
            BufferUtils.populateFromBuffer(tempVa, this.vertices, edge.vert[0]);
            BufferUtils.populateFromBuffer(tempVb, this.vertices, edge.vert[1]);
            Vector3f vector3f = tempVa.subtractLocal(tempVb);
            float f3 = f * vector3f.length();
            VETMesh.Triangle triangle = (VETMesh.Triangle)edgeAttribute.triangleSet.toArray()[0];
            BufferUtils.populateFromBuffer(tempVc, this.vertices, triangle.vert[0]);
            BufferUtils.populateFromBuffer(tempVa, this.vertices, triangle.vert[1]);
            BufferUtils.populateFromBuffer(tempVb, this.vertices, triangle.vert[2]);
            Vector3f vector3f2 = tempVa.subtractLocal(tempVc);
            Vector3f vector3f3 = tempVb.subtractLocal(tempVc);
            Vector3f vector3f4 = vector3f2.cross(vector3f3, tempVc);
            triangle = (VETMesh.Triangle)edgeAttribute.triangleSet.toArray()[1];
            BufferUtils.populateFromBuffer(tempVd, this.vertices, triangle.vert[0]);
            BufferUtils.populateFromBuffer(tempVa, this.vertices, triangle.vert[1]);
            BufferUtils.populateFromBuffer(tempVb, this.vertices, triangle.vert[2]);
            vector3f2 = tempVa.subtractLocal(tempVd);
            vector3f3 = tempVb.subtractLocal(tempVd);
            Vector3f vector3f5 = vector3f2.crossLocal(vector3f3);
            Vector3f vector3f6 = vector3f4.cross(vector3f5, tempVa);
            return f3 += f2 * vector3f6.length();
        }
        return Float.MAX_VALUE;
    }

    public void removeTriangle(VETMesh.Triangle triangle) {
        int n = (Integer)this.getData(triangle);
        if (n >= 0) {
            this.newIndices[3 * this.currentTriangle] = this.indices.get(3 * n);
            this.newIndices[3 * this.currentTriangle + 1] = this.indices.get(3 * n + 1);
            this.newIndices[3 * this.currentTriangle + 2] = this.indices.get(3 * n + 2);
            --this.currentTriangle;
        }
        super.removeTriangle(triangle);
    }

    public void modifyTriangle(VETMesh.Triangle triangle, int n, int n2) {
        int n3 = (Integer)this.getData(triangle);
        super.removeTriangle(triangle);
        for (int i = 0; i < 3; ++i) {
            if (triangle.vert[i] != n2) continue;
            triangle.vert[i] = n;
            break;
        }
        this.insertTriangle(triangle);
        this.setData(triangle, new Integer(n3));
    }

    public void collapseEdge(int n, int n2) {
        Object object;
        VETMesh.Edge edge = new VETMesh.Edge(this, n, n2);
        VETMesh.EdgeAttribute edgeAttribute = (VETMesh.EdgeAttribute)this.edgeMap.get(edge);
        this.deletedVertices.clear();
        ExVector exVector = (ExVector)edgeAttribute.triangleSet.clone();
        int n3 = exVector.size();
        for (int i = 0; i < exVector.size(); ++i) {
            this.removeTriangle((VETMesh.Triangle)exVector.toArray()[i]);
        }
        VETMesh.VertexAttribute vertexAttribute = (VETMesh.VertexAttribute)this.vertexMap.get(new Integer(n2));
        if (vertexAttribute != null) {
            exVector = (ExVector)vertexAttribute.triangleSet.clone();
            for (int i = 0; i < exVector.size(); ++i) {
                VETMesh.Triangle triangle = (VETMesh.Triangle)exVector.toArray()[i];
                this.modifyTriangle(triangle, n, n2);
            }
        }
        TreeSet<VETMesh.Edge> treeSet = new TreeSet<VETMesh.Edge>();
        ExVector exVector2 = (ExVector)this.getTriangles(n).clone();
        if (exVector2 != null) {
            exVector = (ExVector)exVector2.clone();
            for (int i = 0; i < exVector.size(); ++i) {
                VETMesh.Triangle triangle = (VETMesh.Triangle)exVector.toArray()[i];
                treeSet.add(new VETMesh.Edge(this, triangle.vert[0], triangle.vert[1]));
                treeSet.add(new VETMesh.Edge(this, triangle.vert[1], triangle.vert[2]));
                treeSet.add(new VETMesh.Edge(this, triangle.vert[2], triangle.vert[0]));
            }
            for (VETMesh.Edge edge2 : treeSet) {
                edgeAttribute = (VETMesh.EdgeAttribute)this.edgeMap.get(edge2);
                object = (HeapRecord)edgeAttribute.data;
                float f = this.getMetric(edge2, edgeAttribute);
                if (((HeapRecord)object).m_iHIndex < 0) continue;
                this.update(((HeapRecord)object).m_iHIndex, f);
            }
        }
        Iterator<Integer> iterator = this.deletedVertices.iterator();
        while (iterator.hasNext()) {
            int n4;
            this.orderedVertices[this.currentVertex] = n4 = iterator.next().intValue();
            this.permuteVertices[n4] = this.currentVertex--;
        }
        object = new CollapseRecord(n, n2, this.deletedVertices.size(), n3);
        this.deletedEdges.add((CollapseRecord)object);
    }

    public void flushVertices() {
        for (Integer n : this.vertexMap.keySet()) {
            this.orderedVertices[this.currentVertex] = n;
            this.permuteVertices[n.intValue()] = this.currentVertex--;
        }
    }

    public void flushTriangles() {
        for (Map.Entry entry : this.triangleMap.entrySet()) {
            VETMesh.TriangleAttribute triangleAttribute = (VETMesh.TriangleAttribute)entry.getValue();
            int n = (Integer)triangleAttribute.data;
            if (n < 0) continue;
            this.newIndices[3 * this.currentTriangle] = this.indices.get(3 * n);
            this.newIndices[3 * this.currentTriangle + 1] = this.indices.get(3 * n + 1);
            this.newIndices[3 * this.currentTriangle + 2] = this.indices.get(3 * n + 2);
            --this.currentTriangle;
        }
    }

    public void reorder() {
        int n;
        int n2;
        float[] fArray = new float[this.vertQuantity * 3];
        for (n2 = 0; n2 < this.vertQuantity; ++n2) {
            int n3 = this.orderedVertices[n2] * 3;
            fArray[n2 * 3] = this.vertices.get(n3);
            fArray[n2 * 3 + 1] = this.vertices.get(n3 + 1);
            fArray[n2 * 3 + 2] = this.vertices.get(n3 + 2);
        }
        this.vertices.clear();
        this.vertices.put(fArray);
        fArray = null;
        if (this.normals != null) {
            float[] fArray2 = new float[this.vertQuantity * 3];
            for (n2 = 0; n2 < this.vertQuantity; ++n2) {
                n = this.orderedVertices[n2] * 3;
                fArray2[n2 * 3] = this.normals.get(n);
                fArray2[n2 * 3 + 1] = this.normals.get(n + 1);
                fArray2[n2 * 3 + 2] = this.normals.get(n + 2);
            }
            this.normals.rewind();
            this.normals.put(fArray2);
            fArray2 = null;
        }
        if (this.colors != null) {
            float[] fArray3 = new float[this.vertQuantity * 4];
            for (n2 = 0; n2 < this.vertQuantity; ++n2) {
                n = this.orderedVertices[n2] * 4;
                fArray3[n2 * 4] = this.colors.get(n);
                fArray3[n2 * 4 + 1] = this.colors.get(n + 1);
                fArray3[n2 * 4 + 2] = this.colors.get(n + 2);
                fArray3[n2 * 4 + 3] = this.colors.get(n + 3);
            }
            this.colors.rewind();
            this.colors.put(fArray3);
            fArray3 = null;
        }
        if (this.textures != null) {
            float[] fArray4 = new float[this.vertQuantity * 2];
            for (n2 = 0; n2 < this.vertQuantity; ++n2) {
                n = this.orderedVertices[n2] * 2;
                fArray4[n2 * 2] = this.textures.get(n);
                fArray4[n2 * 2 + 1] = this.textures.get(n + 1);
            }
            this.textures.rewind();
            this.textures.put(fArray4);
            fArray4 = null;
        }
        this.indices.rewind();
        for (n2 = 0; n2 < 3 * this.numbTriangles; ++n2) {
            this.indices.put(this.permuteVertices[this.newIndices[n2]]);
        }
        for (n2 = 0; n2 < this.deletedEdges.size(); ++n2) {
            CollapseRecord collapseRecord = this.deletedEdges.get(n2);
            collapseRecord.vertToKeep = this.permuteVertices[collapseRecord.vertToKeep];
            collapseRecord.vertToThrow = this.permuteVertices[collapseRecord.vertToThrow];
        }
    }

    public CollapseRecord[] computeRecords() {
        int n;
        CollapseRecord collapseRecord;
        int n2;
        int n3;
        int n4 = this.deletedEdges.size() + 1;
        CollapseRecord[] collapseRecordArray = new CollapseRecord[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            collapseRecordArray[n3] = new CollapseRecord();
        }
        collapseRecordArray[0].numbVerts = this.vertQuantity;
        collapseRecordArray[0].numbTriangles = this.numbTriangles;
        n3 = this.vertQuantity;
        int n5 = this.numbTriangles;
        for (n2 = 0; n2 < this.deletedEdges.size(); ++n2) {
            collapseRecord = this.deletedEdges.get(n2);
            CollapseRecord collapseRecord2 = collapseRecordArray[n2 + 1];
            collapseRecord2.vertToKeep = collapseRecord.vertToKeep;
            collapseRecord2.vertToThrow = collapseRecord.vertToThrow;
            collapseRecord2.numbVerts = n3 -= collapseRecord.numbVerts;
            collapseRecord2.numbTriangles = n5 -= collapseRecord.numbTriangles;
            collapseRecord2.numbIndices = 0;
            if (n5 > 0) {
                int n6 = 3 * n5;
                int[] nArray = new int[n6];
                for (n = 0; n < n6; ++n) {
                    if (this.indices.get(n) != collapseRecord2.vertToThrow) continue;
                    this.indices.put(n, collapseRecord2.vertToKeep);
                    nArray[collapseRecord2.numbIndices++] = n;
                }
                if (collapseRecord2.numbIndices > 0) {
                    collapseRecord2.indices = new int[collapseRecord2.numbIndices];
                    for (n = 0; n < collapseRecord2.numbIndices; ++n) {
                        collapseRecord2.indices[n] = nArray[n];
                    }
                }
                nArray = null;
                continue;
            }
            collapseRecord2.indices = null;
        }
        for (n2 = n4 - 1; n2 > 0; --n2) {
            collapseRecord = collapseRecordArray[n2];
            for (n = 0; n < collapseRecord.numbIndices; ++n) {
                int n7 = collapseRecord.indices[n];
                this.indices.put(n7, collapseRecord.vertToThrow);
            }
        }
        return collapseRecordArray;
    }

    public void initializeHeap() {
        this.heapSize = this.edgeMap.size();
        this.heapArray = new HeapRecord[2 * this.heapSize];
        int n = 0;
        for (Map.Entry entry : this.edgeMap.entrySet()) {
            VETMesh.Edge edge = (VETMesh.Edge)entry.getKey();
            VETMesh.EdgeAttribute edgeAttribute = (VETMesh.EdgeAttribute)entry.getValue();
            this.heapArray[n] = (HeapRecord)edgeAttribute.data;
            this.heapArray[n].m_kEdge = edge;
            this.heapArray[n].m_iHIndex = n;
            this.heapArray[n].m_fMetric = this.getMetric(edge, edgeAttribute);
            ++n;
        }
        this.sort();
    }

    public void sort() {
        int n = this.heapSize - 1;
        for (int i = n / 2; i >= 0; --i) {
            HeapRecord heapRecord = this.heapArray[i];
            int n2 = i;
            int n3 = 2 * i + 1;
            while (n3 <= n) {
                if (n3 < n && this.heapArray[n3].m_fMetric > this.heapArray[n3 + 1].m_fMetric) {
                    ++n3;
                }
                if (this.heapArray[n3].m_fMetric >= heapRecord.m_fMetric) break;
                this.heapArray[n3].m_iHIndex = n2;
                this.heapArray[n2] = this.heapArray[n3];
                n2 = n3;
                n3 = 2 * n3 + 1;
            }
            heapRecord.m_iHIndex = n2;
            this.heapArray[n2] = heapRecord;
        }
    }

    public void add(float f) {
        ++this.heapSize;
        int n = this.heapSize - 1;
        HeapRecord heapRecord = this.heapArray[n];
        heapRecord.m_fMetric = f;
        while (n > 0) {
            int n2 = (n - 1) / 2;
            if (this.heapArray[n2].m_fMetric <= f) break;
            this.heapArray[n2].m_iHIndex = n;
            this.heapArray[n] = this.heapArray[n2];
            heapRecord.m_iHIndex = n2;
            heapRecord.m_fMetric = f;
            this.heapArray[n2] = heapRecord;
            n = n2;
        }
        this.heapArray[n].m_fMetric = f;
    }

    public void remove() {
        HeapRecord heapRecord = this.heapArray[0];
        int n = this.heapSize - 1;
        HeapRecord heapRecord2 = this.heapArray[n];
        int n2 = 0;
        int n3 = 1;
        while (n3 <= n) {
            if (n3 < n) {
                int n4 = n3 + 1;
                if (this.heapArray[n3].m_fMetric > this.heapArray[n4].m_fMetric) {
                    n3 = n4;
                }
            }
            if (this.heapArray[n3].m_fMetric >= heapRecord2.m_fMetric) break;
            this.heapArray[n3].m_iHIndex = n2;
            this.heapArray[n2] = this.heapArray[n3];
            n2 = n3;
            n3 = 2 * n3 + 1;
        }
        heapRecord2.m_iHIndex = n2;
        this.heapArray[n2] = heapRecord2;
        --this.heapSize;
        heapRecord.m_iHIndex = -1;
    }

    public void update(int n, float f) {
        block6: {
            HeapRecord heapRecord;
            block7: {
                heapRecord = this.heapArray[n];
                if (!(f > heapRecord.m_fMetric)) break block7;
                heapRecord.m_fMetric = f;
                int n2 = n;
                int n3 = 2 * n2 + 1;
                while (n3 < this.heapSize) {
                    int n4;
                    if (n3 < this.heapSize - 1) {
                        int n5 = n3 + 1;
                        n4 = this.heapArray[n3].m_fMetric <= this.heapArray[n5].m_fMetric ? n3 : n5;
                    } else {
                        n4 = n3;
                    }
                    if (!(this.heapArray[n4].m_fMetric >= f)) {
                        this.heapArray[n4].m_iHIndex = n2;
                        this.heapArray[n2] = this.heapArray[n4];
                        heapRecord.m_iHIndex = n4;
                        this.heapArray[n4] = heapRecord;
                        n2 = n4;
                        n3 = 2 * n2 + 1;
                        continue;
                    }
                    break block6;
                }
                break block6;
            }
            if (!(f < heapRecord.m_fMetric)) break block6;
            heapRecord.m_fMetric = f;
            int n6 = n;
            while (n6 > 0) {
                int n7 = (n6 - 1) / 2;
                if (!(this.heapArray[n7].m_fMetric <= f)) {
                    this.heapArray[n7].m_iHIndex = n6;
                    this.heapArray[n6] = this.heapArray[n7];
                    heapRecord.m_iHIndex = n7;
                    heapRecord.m_fMetric = f;
                    this.heapArray[n7] = heapRecord;
                    n6 = n7;
                    continue;
                }
                break;
            }
        }
    }

    public boolean isValidHeap(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            int n3 = (i - 1) / 2;
            if (n3 <= n) continue;
            if (this.heapArray[n3].m_fMetric > this.heapArray[i].m_fMetric) {
                return false;
            }
            if (this.heapArray[n3].m_iHIndex == n3) continue;
            return false;
        }
        return true;
    }

    public boolean isValidHeap() {
        return this.isValidHeap(0, this.heapSize - 1);
    }

    public void onVertexInsert(Integer n, boolean bl, VETMesh.VertexAttribute vertexAttribute) {
        if (bl && this.collapsing) {
            this.deletedVertices.remove(n);
        }
    }

    public void onVertexRemove(Integer n, boolean bl, VETMesh.VertexAttribute vertexAttribute) {
        if (bl && this.collapsing) {
            this.deletedVertices.add(n);
        }
    }

    public void onEdgeInsert(VETMesh.Edge edge, boolean bl, VETMesh.EdgeAttribute edgeAttribute) {
        if (bl) {
            edgeAttribute.data = new HeapRecord();
            if (this.collapsing) {
                this.heapArray[this.heapSize] = (HeapRecord)edgeAttribute.data;
                this.heapArray[this.heapSize].m_kEdge = edge;
                this.heapArray[this.heapSize].m_iHIndex = this.heapSize;
                this.add(this.getMetric(edge, (VETMesh.EdgeAttribute)this.edgeMap.get(edge)));
            }
        } else if (this.collapsing) {
            HeapRecord heapRecord = (HeapRecord)edgeAttribute.data;
            if (heapRecord.m_iHIndex >= 0) {
                this.update(heapRecord.m_iHIndex, this.getMetric(edge, (VETMesh.EdgeAttribute)this.edgeMap.get(edge)));
            } else {
                heapRecord.m_iHIndex = this.heapSize;
                this.add(this.getMetric(edge, (VETMesh.EdgeAttribute)this.edgeMap.get(edge)));
            }
        }
    }

    public void onEdgeRemove(VETMesh.Edge edge, boolean bl, VETMesh.EdgeAttribute edgeAttribute) {
        if (bl) {
            HeapRecord heapRecord = (HeapRecord)edgeAttribute.data;
            if (heapRecord.m_iHIndex >= 0) {
                this.update(heapRecord.m_iHIndex, -3.4028235E38f);
                this.remove();
            }
            heapRecord = null;
        }
    }

    public void onTriangleInsert(VETMesh.Triangle triangle, boolean bl, VETMesh.TriangleAttribute triangleAttribute) {
        if (bl) {
            triangleAttribute.data = new Integer(-1);
        }
    }

    public void onTriangleRemove(VETMesh.Triangle triangle, boolean bl, VETMesh.TriangleAttribute triangleAttribute) {
        if (bl) {
            triangleAttribute.data = null;
        }
    }

    protected class HeapRecord {
        public VETMesh.Edge m_kEdge;
        public int m_iHIndex;
        public float m_fMetric;

        public HeapRecord() {
            this.m_kEdge = new VETMesh.Edge(ClodCreator.this, -1, -1);
            this.m_iHIndex = -1;
            this.m_fMetric = -1.0f;
        }

        public boolean equals(Object object) {
            HeapRecord heapRecord = (HeapRecord)object;
            return this.m_kEdge.equals(heapRecord.m_kEdge);
        }
    }
}

