/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shadow;

import com.jme.bounding.BoundingBox;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.TriMesh;
import com.jme.scene.VBOInfo;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.MaterialState;
import com.jme.system.DisplaySystem;

public class ShadowVolume
extends TriMesh {
    private static final long serialVersionUID = 1L;
    protected Light light = null;
    protected Vector3f position = new Vector3f();
    protected Vector3f direction = new Vector3f();
    protected boolean update = true;
    protected static int _ordinal = 0;

    public ShadowVolume(Light light) {
        super("LV" + _ordinal++);
        this.light = light;
        this.setModelBound(new BoundingBox());
        this.updateModelBound();
        if (light.getType() == 1) {
            this.position = new Vector3f(((PointLight)light).getLocation());
        } else if (light.getType() == 0) {
            this.direction = new Vector3f(((DirectionalLight)light).getDirection());
        }
        this.setVBOInfo(new VBOInfo(false));
        this.setRenderQueueMode(1);
        MaterialState materialState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
        materialState.setAmbient(new ColorRGBA(0.5f, 0.7f, 0.7f, 0.2f));
        materialState.setDiffuse(new ColorRGBA(0.5f, 0.7f, 0.7f, 0.2f));
        materialState.setEmissive(new ColorRGBA(0.9f, 0.9f, 0.7f, 0.6f));
        materialState.setAmbient(ColorRGBA.white);
        materialState.setDiffuse(ColorRGBA.white);
        materialState.setSpecular(ColorRGBA.white);
        materialState.setEmissive(ColorRGBA.white);
        materialState.setEnabled(true);
        this.setRenderState(materialState);
        AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setEnabled(true);
        this.setRenderState(alphaState);
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f vector3f) {
        this.direction = vector3f;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f vector3f) {
        this.position = vector3f;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean bl) {
        this.update = bl;
    }

    public Light getLight() {
        return this.light;
    }

    public void setLight(Light light) {
        this.light = light;
    }
}

