/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class Pyramid
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private float height;
    private float width;

    public Pyramid() {
    }

    public Pyramid(String string, float f, float f2) {
        super(string);
        this.width = f;
        this.height = f2;
        this.setVertexData();
        this.setNormalData();
        this.setTextureData();
        this.setDefaultColor(ColorRGBA.white);
        this.setIndexData();
    }

    private void setVertexData() {
        Vector3f vector3f = new Vector3f(0.0f, this.height / 2.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(-this.width / 2.0f, -this.height / 2.0f, -this.width / 2.0f);
        Vector3f vector3f3 = new Vector3f(this.width / 2.0f, -this.height / 2.0f, -this.width / 2.0f);
        Vector3f vector3f4 = new Vector3f(this.width / 2.0f, -this.height / 2.0f, this.width / 2.0f);
        Vector3f vector3f5 = new Vector3f(-this.width / 2.0f, -this.height / 2.0f, this.width / 2.0f);
        FloatBuffer floatBuffer = BufferUtils.createVector3Buffer(16);
        floatBuffer.put(vector3f5.x).put(vector3f5.y).put(vector3f5.z);
        floatBuffer.put(vector3f4.x).put(vector3f4.y).put(vector3f4.z);
        floatBuffer.put(vector3f3.x).put(vector3f3.y).put(vector3f3.z);
        floatBuffer.put(vector3f2.x).put(vector3f2.y).put(vector3f2.z);
        floatBuffer.put(vector3f2.x).put(vector3f2.y).put(vector3f2.z);
        floatBuffer.put(vector3f3.x).put(vector3f3.y).put(vector3f3.z);
        floatBuffer.put(vector3f.x).put(vector3f.y).put(vector3f.z);
        floatBuffer.put(vector3f3.x).put(vector3f3.y).put(vector3f3.z);
        floatBuffer.put(vector3f4.x).put(vector3f4.y).put(vector3f4.z);
        floatBuffer.put(vector3f.x).put(vector3f.y).put(vector3f.z);
        floatBuffer.put(vector3f4.x).put(vector3f4.y).put(vector3f4.z);
        floatBuffer.put(vector3f5.x).put(vector3f5.y).put(vector3f5.z);
        floatBuffer.put(vector3f.x).put(vector3f.y).put(vector3f.z);
        floatBuffer.put(vector3f5.x).put(vector3f5.y).put(vector3f5.z);
        floatBuffer.put(vector3f2.x).put(vector3f2.y).put(vector3f2.z);
        floatBuffer.put(vector3f.x).put(vector3f.y).put(vector3f.z);
        floatBuffer.rewind();
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexBuffer(floatBuffer);
    }

    private void setNormalData() {
        FloatBuffer floatBuffer = BufferUtils.createVector3Buffer(16);
        floatBuffer.put(0.0f).put(-1.0f).put(0.0f);
        floatBuffer.put(0.0f).put(-1.0f).put(0.0f);
        floatBuffer.put(0.0f).put(-1.0f).put(0.0f);
        floatBuffer.put(0.0f).put(-1.0f).put(0.0f);
        floatBuffer.put(0.0f).put(0.70710677f).put(-0.70710677f);
        floatBuffer.put(0.0f).put(0.70710677f).put(-0.70710677f);
        floatBuffer.put(0.0f).put(0.70710677f).put(-0.70710677f);
        floatBuffer.put(0.70710677f).put(0.70710677f).put(0.0f);
        floatBuffer.put(0.70710677f).put(0.70710677f).put(0.0f);
        floatBuffer.put(0.70710677f).put(0.70710677f).put(0.0f);
        floatBuffer.put(0.0f).put(0.70710677f).put(0.70710677f);
        floatBuffer.put(0.0f).put(0.70710677f).put(0.70710677f);
        floatBuffer.put(0.0f).put(0.70710677f).put(0.70710677f);
        floatBuffer.put(-0.70710677f).put(0.70710677f).put(0.0f);
        floatBuffer.put(-0.70710677f).put(0.70710677f).put(0.0f);
        floatBuffer.put(-0.70710677f).put(0.70710677f).put(0.0f);
        floatBuffer.rewind();
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setNormalBuffer(floatBuffer);
    }

    private void setTextureData() {
        FloatBuffer floatBuffer = BufferUtils.createVector2Buffer(16);
        floatBuffer.put(1.0f).put(0.0f);
        floatBuffer.put(0.0f).put(0.0f);
        floatBuffer.put(0.0f).put(1.0f);
        floatBuffer.put(1.0f).put(1.0f);
        floatBuffer.put(1.0f).put(0.0f);
        floatBuffer.put(0.75f).put(0.0f);
        floatBuffer.put(0.5f).put(1.0f);
        floatBuffer.put(0.75f).put(0.0f);
        floatBuffer.put(0.5f).put(0.0f);
        floatBuffer.put(0.5f).put(1.0f);
        floatBuffer.put(0.5f).put(0.0f);
        floatBuffer.put(0.25f).put(0.0f);
        floatBuffer.put(0.5f).put(1.0f);
        floatBuffer.put(0.25f).put(0.0f);
        floatBuffer.put(0.0f).put(0.0f);
        floatBuffer.put(0.5f).put(1.0f);
        floatBuffer.rewind();
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setTextureBuffer(floatBuffer, 0);
    }

    private void setIndexData() {
        IntBuffer intBuffer = BufferUtils.createIntBuffer(18);
        intBuffer.put(3).put(2).put(1);
        intBuffer.put(3).put(1).put(0);
        intBuffer.put(6).put(5).put(4);
        intBuffer.put(9).put(8).put(7);
        intBuffer.put(12).put(11).put(10);
        intBuffer.put(15).put(14).put(13);
        intBuffer.rewind();
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setIndexBuffer(intBuffer);
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.height, "height", 0.0f);
        outputCapsule.write(this.width, "width", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.height = inputCapsule.readFloat("height", 0.0f);
        this.width = inputCapsule.readFloat("width", 0.0f);
    }
}

