/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.shape;

import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;

public class Torus
extends TriMesh {
    private static final long serialVersionUID = 1L;
    private int circleSamples;
    private int radialSamples;
    private float innerRadius;
    private float outerRadius;

    public Torus() {
    }

    public Torus(String string, int n, int n2, float f, float f2) {
        super(string);
        this.circleSamples = n;
        this.radialSamples = n2;
        this.innerRadius = f;
        this.outerRadius = f2;
        this.setGeometryData();
        this.setIndexData();
        this.setDefaultColor(ColorRGBA.white);
    }

    private void setGeometryData() {
        int n;
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setVertexCount((this.circleSamples + 1) * (this.radialSamples + 1));
        triangleBatch.setVertexBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.setNormalBuffer(BufferUtils.createVector3Buffer(triangleBatch.getVertexCount()));
        triangleBatch.getTextureBuffers().set(0, BufferUtils.createVector2Buffer(triangleBatch.getVertexCount()));
        float f = 1.0f / (float)this.circleSamples;
        float f2 = 1.0f / (float)this.radialSamples;
        int n2 = 0;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        for (n = 0; n < this.circleSamples; ++n) {
            float f3 = (float)n * f;
            float f4 = (float)Math.PI * 2 * f3;
            float f5 = FastMath.cos(f4);
            float f6 = FastMath.sin(f4);
            vector3f.set(f5, f6, 0.0f);
            vector3f.mult(this.outerRadius, vector3f2);
            int n3 = n2;
            for (int i = 0; i < this.radialSamples; ++i) {
                float f7 = (float)i * f2;
                float f8 = (float)Math.PI * 2 * f7;
                float f9 = FastMath.cos(f8);
                float f10 = FastMath.sin(f8);
                vector3f3.set(vector3f).multLocal(f9);
                vector3f3.z += f10;
                triangleBatch.getNormalBuffer().put(vector3f3.x).put(vector3f3.y).put(vector3f3.z);
                vector3f3.multLocal(this.innerRadius).addLocal(vector3f2);
                triangleBatch.getVertexBuffer().put(vector3f3.x).put(vector3f3.y).put(vector3f3.z);
                triangleBatch.getTextureBuffers().get(0).put(f7).put(f3);
                ++n2;
            }
            BufferUtils.copyInternalVector3(triangleBatch.getVertexBuffer(), n3, n2);
            BufferUtils.copyInternalVector3(triangleBatch.getNormalBuffer(), n3, n2);
            triangleBatch.getTextureBuffers().get(0).put(1.0f).put(f3);
            ++n2;
        }
        n = 0;
        while (n <= this.radialSamples) {
            BufferUtils.copyInternalVector3(triangleBatch.getVertexBuffer(), n, n2);
            BufferUtils.copyInternalVector3(triangleBatch.getNormalBuffer(), n, n2);
            BufferUtils.copyInternalVector2(triangleBatch.getTextureBuffers().get(0), n, n2);
            triangleBatch.getTextureBuffers().get(0).put(n2 * 2 + 1, 1.0f);
            ++n;
            ++n2;
        }
    }

    private void setIndexData() {
        TriangleBatch triangleBatch = this.getBatch(0);
        triangleBatch.setTriangleQuantity(2 * this.circleSamples * this.radialSamples);
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer(3 * triangleBatch.getTriangleCount()));
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.circleSamples; ++i) {
            int n3 = n;
            int n4 = n3 + 1;
            int n5 = n += this.radialSamples + 1;
            int n6 = n5 + 1;
            int n7 = 0;
            while (n7 < this.radialSamples) {
                triangleBatch.getIndexBuffer().put(n3++);
                triangleBatch.getIndexBuffer().put(n5);
                triangleBatch.getIndexBuffer().put(n4);
                triangleBatch.getIndexBuffer().put(n4++);
                triangleBatch.getIndexBuffer().put(n5++);
                triangleBatch.getIndexBuffer().put(n6++);
                ++n7;
                n2 += 6;
            }
        }
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.circleSamples, "circleSamples", 0);
        outputCapsule.write(this.radialSamples, "radialSamples", 0);
        outputCapsule.write(this.innerRadius, "innerRadius", 0.0f);
        outputCapsule.write(this.outerRadius, "outerRadius", 0.0f);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.circleSamples = inputCapsule.readInt("circleSamples", 0);
        this.radialSamples = inputCapsule.readInt("radialSamples", 0);
        this.innerRadius = inputCapsule.readFloat("innerRadius", 0.0f);
        this.outerRadius = inputCapsule.readFloat("outerRaidus", 0.0f);
    }
}

