/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state;

import com.jme.math.Matrix3f;
import com.jme.math.Matrix4f;
import com.jme.scene.state.RenderState;
import com.jme.util.ShaderAttribute;
import com.jme.util.ShaderUniform;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;

public abstract class GLSLShaderObjectsState
extends RenderState {
    public ArrayList<ShaderUniform> uniforms = new ArrayList();
    public ArrayList<ShaderAttribute> attribs = new ArrayList();

    public abstract boolean isSupported();

    public abstract void relinkProgram();

    public void setUniform(String string, int n) {
        ShaderUniform shaderUniform = this.getShaderUniform(string, 0);
        shaderUniform.vint = new int[1];
        shaderUniform.vint[0] = n;
        if (shaderUniform.uniformID == -1) {
            this.uniforms.add(shaderUniform);
        }
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, float f) {
        ShaderUniform shaderUniform = this.getShaderUniform(string, 4);
        shaderUniform.vfloat = new float[1];
        shaderUniform.vfloat[0] = f;
        if (shaderUniform.uniformID == -1) {
            this.uniforms.add(shaderUniform);
        }
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, int n, int n2) {
        ShaderUniform shaderUniform = this.getShaderUniform(string, 1);
        shaderUniform.vint = new int[2];
        shaderUniform.vint[0] = n;
        shaderUniform.vint[1] = n2;
        if (shaderUniform.uniformID == -1) {
            this.uniforms.add(shaderUniform);
        }
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, float f, float f2) {
        ShaderUniform shaderUniform = this.getShaderUniform(string, 5);
        shaderUniform.vfloat = new float[2];
        shaderUniform.vfloat[0] = f;
        shaderUniform.vfloat[1] = f2;
        if (shaderUniform.uniformID == -1) {
            this.uniforms.add(shaderUniform);
        }
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, int n, int n2, int n3) {
        ShaderUniform shaderUniform = this.getShaderUniform(string, 2);
        shaderUniform.vint = new int[3];
        shaderUniform.vint[0] = n;
        shaderUniform.vint[1] = n2;
        shaderUniform.vint[2] = n3;
        if (shaderUniform.uniformID == -1) {
            this.uniforms.add(shaderUniform);
        }
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, float f, float f2, float f3) {
        ShaderUniform shaderUniform = this.getShaderUniform(string, 6);
        shaderUniform.vfloat = new float[3];
        shaderUniform.vfloat[0] = f;
        shaderUniform.vfloat[1] = f2;
        shaderUniform.vfloat[2] = f3;
        if (shaderUniform.uniformID == -1) {
            this.uniforms.add(shaderUniform);
        }
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, int n, int n2, int n3, int n4) {
        ShaderUniform shaderUniform = this.getShaderUniform(string, 3);
        shaderUniform.vint = new int[4];
        shaderUniform.vint[0] = n;
        shaderUniform.vint[1] = n2;
        shaderUniform.vint[2] = n3;
        shaderUniform.vint[3] = n4;
        if (shaderUniform.uniformID == -1) {
            this.uniforms.add(shaderUniform);
        }
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, float f, float f2, float f3, float f4) {
        ShaderUniform shaderUniform = this.getShaderUniform(string, 7);
        shaderUniform.vfloat = new float[4];
        shaderUniform.vfloat[0] = f;
        shaderUniform.vfloat[1] = f2;
        shaderUniform.vfloat[2] = f3;
        shaderUniform.vfloat[3] = f4;
        if (shaderUniform.uniformID == -1) {
            this.uniforms.add(shaderUniform);
        }
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, float[] fArray, boolean bl) {
        if (fArray.length != 4) {
            return;
        }
        ShaderUniform shaderUniform = this.getShaderUniform(string, 8);
        shaderUniform.matrix2f = new float[4];
        shaderUniform.matrix2f = fArray;
        shaderUniform.transpose = bl;
        if (shaderUniform.uniformID == -1) {
            this.uniforms.add(shaderUniform);
        }
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, Matrix3f matrix3f, boolean bl) {
        ShaderUniform shaderUniform = this.getShaderUniform(string, 9);
        shaderUniform.matrix3f = matrix3f;
        shaderUniform.transpose = bl;
        if (shaderUniform.uniformID == -1) {
            this.uniforms.add(shaderUniform);
        }
        this.setNeedsRefresh(true);
    }

    public void setUniform(String string, Matrix4f matrix4f, boolean bl) {
        ShaderUniform shaderUniform = this.getShaderUniform(string, 10);
        shaderUniform.matrix4f = matrix4f;
        shaderUniform.transpose = bl;
        if (shaderUniform.uniformID == -1) {
            this.uniforms.add(shaderUniform);
        }
        this.setNeedsRefresh(true);
    }

    public void clearUniforms() {
        this.uniforms.clear();
    }

    public void setAttribute(String string, short s) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 0);
        shaderAttribute.s1 = s;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void setAttribute(String string, float f) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 4);
        shaderAttribute.f1 = f;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void setAttribute(String string, short s, short s2) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 1);
        shaderAttribute.s1 = s;
        shaderAttribute.s2 = s2;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void setAttribute(String string, float f, float f2) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 5);
        shaderAttribute.f1 = f;
        shaderAttribute.f2 = f2;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void setAttribute(String string, short s, short s2, short s3) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 2);
        shaderAttribute.s1 = s;
        shaderAttribute.s2 = s2;
        shaderAttribute.s3 = s3;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void setAttribute(String string, float f, float f2, float f3) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 6);
        shaderAttribute.f1 = f;
        shaderAttribute.f2 = f2;
        shaderAttribute.f3 = f3;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void setAttribute(String string, short s, short s2, short s3, short s4) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 3);
        shaderAttribute.s1 = s;
        shaderAttribute.s2 = s2;
        shaderAttribute.s3 = s3;
        shaderAttribute.s4 = s4;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void setAttribute(String string, float f, float f2, float f3, float f4) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 7);
        shaderAttribute.f1 = f;
        shaderAttribute.f2 = f2;
        shaderAttribute.f3 = f3;
        shaderAttribute.f4 = f4;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void setAttribute(String string, byte by, byte by2, byte by3, byte by4) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 8);
        shaderAttribute.b1 = by;
        shaderAttribute.b2 = by2;
        shaderAttribute.b3 = by3;
        shaderAttribute.b4 = by4;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void setAttributePointer(String string, int n, boolean bl, int n2, FloatBuffer floatBuffer) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 10);
        shaderAttribute.size = n;
        shaderAttribute.normalized = bl;
        shaderAttribute.stride = n2;
        shaderAttribute.data = floatBuffer;
        shaderAttribute.bufferType = 13;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void setAttributePointer(String string, int n, boolean bl, boolean bl2, int n2, ByteBuffer byteBuffer) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 9);
        shaderAttribute.size = n;
        shaderAttribute.normalized = bl;
        shaderAttribute.unsigned = bl2;
        shaderAttribute.stride = n2;
        shaderAttribute.data = byteBuffer;
        shaderAttribute.bufferType = 17;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void setAttributePointer(String string, int n, boolean bl, boolean bl2, int n2, IntBuffer intBuffer) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 12);
        shaderAttribute.size = n;
        shaderAttribute.normalized = bl;
        shaderAttribute.unsigned = bl2;
        shaderAttribute.stride = n2;
        shaderAttribute.data = intBuffer;
        shaderAttribute.bufferType = 15;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void setAttributePointer(String string, int n, boolean bl, boolean bl2, int n2, ShortBuffer shortBuffer) {
        ShaderAttribute shaderAttribute = this.getShaderAttribute(string, 11);
        shaderAttribute.size = n;
        shaderAttribute.normalized = bl;
        shaderAttribute.unsigned = bl2;
        shaderAttribute.stride = n2;
        shaderAttribute.data = shortBuffer;
        shaderAttribute.bufferType = 16;
        if (shaderAttribute.attributeID == -1) {
            this.attribs.add(shaderAttribute);
        }
        this.setNeedsRefresh(true);
    }

    public void clearAttributes() {
        this.attribs.clear();
    }

    public int getType() {
        return 14;
    }

    private ShaderUniform getShaderUniform(String string, int n) {
        int n2 = this.uniforms.size();
        while (--n2 >= 0) {
            ShaderUniform shaderUniform = this.uniforms.get(n2);
            if (!string.equals(shaderUniform.name)) continue;
            return shaderUniform;
        }
        return new ShaderUniform(string, n);
    }

    private ShaderAttribute getShaderAttribute(String string, int n) {
        int n2 = this.attribs.size();
        while (--n2 >= 0) {
            ShaderAttribute shaderAttribute = this.attribs.get(n2);
            if (!string.equals(shaderAttribute.name)) continue;
            return shaderAttribute;
        }
        return new ShaderAttribute(string, n);
    }

    public abstract void load(URL var1, URL var2);

    public abstract void load(String var1, String var2);

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.writeSavableArrayList(this.uniforms, "uniforms", new ArrayList());
        outputCapsule.writeSavableArrayList(this.attribs, "attribs", new ArrayList());
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.uniforms = inputCapsule.readSavableArrayList("uniforms", new ArrayList());
        this.attribs = inputCapsule.readSavableArrayList("attribs", new ArrayList());
    }

    public Class getClassTag() {
        return GLSLShaderObjectsState.class;
    }
}

