/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.image.Image;
import com.jme.image.Texture;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.RenderContext;
import com.jme.scene.SceneElement;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.lwjgl.records.StateRecord;
import com.jme.scene.state.lwjgl.records.TextureRecord;
import com.jme.scene.state.lwjgl.records.TextureStateRecord;
import com.jme.scene.state.lwjgl.records.TextureUnitRecord;
import com.jme.system.DisplaySystem;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBTextureCompression;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.glu.GLU;
import org.lwjgl.opengl.glu.MipMap;
import org.lwjgl.opengl.glu.Util;

public class LWJGLTextureState
extends TextureState {
    private static final long serialVersionUID = 1L;
    private static int[] imageComponents = new int[]{32854, 32849, 32855, 32856, 32837, 33776, 33777, 33778, 33779, 33776, 33777, 33778, 33779};
    private static int[] imageFormats = new int[]{6408, 6407, 6408, 6408, 6410, 6407, 6408, 6408, 6408};
    private static boolean inited = false;

    public LWJGLTextureState() {
        this.texture = new ArrayList();
        if (!inited) {
            Buffer buffer;
            supportsMultiTexture = GLContext.getCapabilities().GL_ARB_multitexture && GLContext.getCapabilities().OpenGL13;
            supportsEnvDot3 = GLContext.getCapabilities().GL_ARB_texture_env_dot3;
            if (supportsMultiTexture) {
                buffer = BufferUtils.createIntBuffer((int)16);
                GL11.glGetInteger((int)34018, (IntBuffer)buffer);
                numFixedTexUnits = ((IntBuffer)buffer).get(0);
            } else {
                numFixedTexUnits = 1;
            }
            if (GLContext.getCapabilities().GL_ARB_shader_objects && GLContext.getCapabilities().GL_ARB_vertex_shader && GLContext.getCapabilities().GL_ARB_fragment_shader) {
                buffer = BufferUtils.createIntBuffer((int)16);
                GL11.glGetInteger((int)35660, (IntBuffer)buffer);
                numVertexTexUnits = ((IntBuffer)buffer).get(0);
                GL11.glGetInteger((int)34930, (IntBuffer)buffer);
                numFragmentTexUnits = ((IntBuffer)buffer).get(0);
            } else {
                numVertexTexUnits = 0;
                numFragmentTexUnits = 0;
            }
            numTotalTexUnits = Math.max(numFixedTexUnits, Math.max(numFragmentTexUnits, numVertexTexUnits));
            supportsS3TCCompression = GLContext.getCapabilities().GL_EXT_texture_compression_s3tc;
            supportsAniso = GLContext.getCapabilities().GL_EXT_texture_filter_anisotropic;
            if (supportsAniso) {
                buffer = BufferUtils.createFloatBuffer((int)16);
                ((FloatBuffer)buffer).rewind();
                GL11.glGetFloat((int)34047, (FloatBuffer)buffer);
                maxAnisotropic = ((FloatBuffer)buffer).get(0);
            }
            supportsNonPowerTwo = GLContext.getCapabilities().GL_ARB_texture_non_power_of_two;
            this.setTexture(defaultTexture);
            this.load(0);
            this.texture.clear();
            inited = true;
        }
    }

    public void load(int n) {
        Object object;
        Texture texture = this.getTexture(n);
        if (texture == null) {
            return;
        }
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        TextureStateRecord textureStateRecord = null;
        if (renderContext != null) {
            textureStateRecord = (TextureStateRecord)renderContext.getStateRecord(6);
        }
        if (textureStateRecord != null) {
            this.checkAndSetUnit(n, textureStateRecord);
        }
        if (texture.getTextureKey() != null) {
            object = TextureManager.findCachedTexture(texture.getTextureKey());
            if (object == null) {
                TextureManager.addToCache(texture);
            } else if (((Texture)object).getTextureId() != 0) {
                texture.setTextureId(((Texture)object).getTextureId());
                GL11.glBindTexture((int)3553, (int)((Texture)object).getTextureId());
                if (textureStateRecord != null) {
                    textureStateRecord.units[n].boundTexture = texture.getTextureId();
                }
                return;
            }
        }
        object = BufferUtils.createIntBuffer((int)1);
        ((IntBuffer)object).clear();
        GL11.glGenTextures((IntBuffer)object);
        GL11.glBindTexture((int)3553, (int)((IntBuffer)object).get(0));
        if (textureStateRecord != null) {
            textureStateRecord.units[n].boundTexture = ((IntBuffer)object).get(0);
        }
        texture.setTextureId(((IntBuffer)object).get(0));
        TextureManager.registerForCleanup(texture.getTextureKey(), texture.getTextureId());
        Image image = texture.getImage();
        if (image == null) {
            LoggingSystem.getLogger().log(Level.WARNING, "Image data for texture is null.");
        }
        if (supportsAniso) {
            GL11.glTexParameterf((int)3553, (int)34046, (float)Math.max(Math.min(maxAnisotropic, texture.getAnisoLevel()), 1.0f));
        }
        GL11.glPixelStorei((int)3317, (int)1);
        if (image != null) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            if (!(supportsNonPowerTwo || FastMath.isPowerOfTwo(image.getWidth()) && FastMath.isPowerOfTwo(image.getHeight()))) {
                LoggingSystem.getLogger().warning("Attempted to apply texture with size that is not power of 2: " + image.getWidth() + " x " + image.getHeight());
                int n7 = LWJGLMipMap.glGetIntegerv(3379);
                int n8 = image.getWidth();
                n6 = LWJGLMipMap.nearestPower(n8);
                if (n6 > n7) {
                    n6 = n7;
                }
                if ((n5 = LWJGLMipMap.nearestPower(n4 = image.getHeight())) > n7) {
                    n5 = n7;
                }
                LoggingSystem.getLogger().warning("Rescaling image to " + n6 + " x " + n5 + " !!!");
                n3 = imageFormats[image.getType()];
                n2 = 5121;
                int n9 = LWJGLMipMap.bytesPerPixel(n3, n2);
                ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)((n6 + 4) * n5 * n9));
                int n10 = MipMap.gluScaleImage((int)n3, (int)n8, (int)n4, (int)n2, (ByteBuffer)image.getData(), (int)n6, (int)n5, (int)n2, (ByteBuffer)byteBuffer);
                if (n10 != 0) {
                    org.lwjgl.opengl.Util.checkGLError();
                }
                image.setWidth(n6);
                image.setHeight(n5);
                image.setData(byteBuffer);
            }
            if (texture.getMipmap() >= 3 && !image.hasMipmaps() && !image.isCompressedType()) {
                image.getData().rewind();
                GLU.gluBuild2DMipmaps((int)3553, (int)imageComponents[image.getType()], (int)image.getWidth(), (int)image.getHeight(), (int)imageFormats[image.getType()], (int)5121, (ByteBuffer)image.getData());
            } else {
                int[] nArray = image.getMipMapSizes();
                ByteBuffer byteBuffer = image.getData();
                n6 = 1;
                n4 = 0;
                if (nArray == null) {
                    nArray = new int[]{byteBuffer.capacity()};
                } else if (texture.getMipmap() != 0) {
                    n6 = nArray.length;
                }
                for (n5 = 0; n5 < n6; ++n5) {
                    n3 = Math.max(1, image.getWidth() >> n5);
                    n2 = Math.max(1, image.getHeight() >> n5);
                    byteBuffer.position(n4);
                    if (image.isCompressedType()) {
                        byteBuffer.limit(n4 + nArray[n5]);
                        ARBTextureCompression.glCompressedTexImage2DARB((int)3553, (int)n5, (int)imageComponents[image.getType()], (int)n3, (int)n2, (int)0, (ByteBuffer)byteBuffer);
                    } else {
                        byteBuffer.limit(byteBuffer.position() + nArray[n5]);
                        GL11.glTexImage2D((int)3553, (int)n5, (int)imageComponents[image.getType()], (int)n3, (int)n2, (int)0, (int)imageFormats[image.getType()], (int)5121, (ByteBuffer)byteBuffer);
                    }
                    n4 += nArray[n5];
                }
                byteBuffer.clear();
            }
        }
    }

    public void apply() {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        TextureStateRecord textureStateRecord = (TextureStateRecord)renderContext.getStateRecord(6);
        renderContext.currentStates[6] = this;
        if (this.isEnabled()) {
            int n = LWJGLTextureState.getPerspHint(this.getCorrection());
            if (!textureStateRecord.isValid() || textureStateRecord.hint != n) {
                GL11.glHint((int)3152, (int)n);
                textureStateRecord.hint = n;
            }
            for (int i = 0; i < numTotalTexUnits; ++i) {
                TextureUnitRecord textureUnitRecord = textureStateRecord.units[i];
                Texture texture = this.getTexture(i);
                if (texture != null && texture.getTextureId() == 0 && texture.getImage() == null) {
                    texture = null;
                }
                if (texture == null) {
                    if (i >= numFixedTexUnits) continue;
                    if (!textureUnitRecord.isValid() || textureUnitRecord.enabled) {
                        this.checkAndSetUnit(i, textureStateRecord);
                        GL11.glDisable((int)3553);
                        textureUnitRecord.enabled = false;
                    }
                    if (i >= this.idCache.length) continue;
                    this.idCache[i] = 0;
                    continue;
                }
                if (texture.getTextureId() == 0) {
                    this.load(i);
                    if (texture.getTextureId() == 0) {
                        continue;
                    }
                } else if (!textureUnitRecord.isValid() || textureUnitRecord.boundTexture != texture.getTextureId()) {
                    this.checkAndSetUnit(i, textureStateRecord);
                    GL11.glBindTexture((int)3553, (int)texture.getTextureId());
                    textureUnitRecord.boundTexture = texture.getTextureId();
                }
                TextureRecord textureRecord = textureStateRecord.getTextureRecord(texture.getTextureId());
                this.idCache[i] = texture.getTextureId();
                if (i >= numFixedTexUnits) continue;
                if (!textureUnitRecord.isValid() || !textureUnitRecord.enabled) {
                    this.checkAndSetUnit(i, textureStateRecord);
                    GL11.glEnable((int)3553);
                    textureUnitRecord.enabled = true;
                }
                this.applyFilter(texture, textureRecord, i, textureStateRecord);
                this.applyWrap(texture, textureRecord, i, textureStateRecord);
                this.applyTextureTransforms(texture, i, textureStateRecord);
                this.applyBlendColor(texture, textureUnitRecord, i, textureStateRecord);
                this.applyTexCoordGeneration(texture, textureUnitRecord, i, textureStateRecord);
                int n2 = LWJGLTextureState.getGLEnvMode(texture.getApply());
                this.applyEnvMode(n2, textureUnitRecord, i, textureStateRecord);
                if (n2 != 34160 || !supportsMultiTexture) continue;
                this.applyCombineFactors(texture, textureUnitRecord, i, textureStateRecord);
            }
        } else if (supportsMultiTexture) {
            for (int i = 0; i < numFixedTexUnits; ++i) {
                TextureUnitRecord textureUnitRecord = textureStateRecord.units[i];
                if (textureUnitRecord.isValid() && !textureUnitRecord.enabled) continue;
                this.checkAndSetUnit(i, textureStateRecord);
                GL11.glDisable((int)3553);
                textureUnitRecord.enabled = false;
            }
        } else {
            TextureUnitRecord textureUnitRecord = textureStateRecord.units[0];
            if (!textureUnitRecord.isValid() || textureUnitRecord.enabled) {
                GL11.glDisable((int)3553);
                textureUnitRecord.enabled = false;
            }
        }
        if (!textureStateRecord.isValid()) {
            textureStateRecord.validate();
        }
    }

    private void applyCombineFactors(Texture texture, TextureUnitRecord textureUnitRecord, int n, TextureStateRecord textureStateRecord) {
        boolean bl = false;
        if (!(supportsEnvDot3 || texture.getCombineFuncAlpha() != 6 && texture.getCombineFuncAlpha() != 7 && texture.getCombineFuncRGB() != 6 && texture.getCombineFuncRGB() != 7)) {
            this.checkAndSetUnit(n, textureStateRecord);
            bl = true;
            GL11.glDisable((int)3553);
            textureUnitRecord.enabled = false;
            return;
        }
        if (!textureUnitRecord.isValid() || textureUnitRecord.envRGBScale != texture.getCombineScaleRGB()) {
            if (!bl) {
                this.checkAndSetUnit(n, textureStateRecord);
                bl = true;
            }
            GL11.glTexEnvf((int)8960, (int)34163, (float)texture.getCombineScaleRGB());
            textureUnitRecord.envRGBScale = texture.getCombineScaleRGB();
        }
        if (!textureUnitRecord.isValid() || textureUnitRecord.envAlphaScale != texture.getCombineScaleAlpha()) {
            if (!bl) {
                this.checkAndSetUnit(n, textureStateRecord);
                bl = true;
            }
            GL11.glTexEnvf((int)8960, (int)3356, (float)texture.getCombineScaleRGB());
            textureUnitRecord.envAlphaScale = texture.getCombineScaleAlpha();
        }
        int n2 = texture.getCombineFuncRGB();
        if (!textureUnitRecord.isValid() || textureUnitRecord.rgbCombineFunc != n2) {
            if (!bl) {
                this.checkAndSetUnit(n, textureStateRecord);
                bl = true;
            }
            GL11.glTexEnvi((int)8960, (int)34161, (int)LWJGLTextureState.getGLCombineFunc(n2));
            textureUnitRecord.rgbCombineFunc = n2;
        }
        int n3 = texture.getCombineSrc0RGB();
        if (!textureUnitRecord.isValid() || textureUnitRecord.combSrcRGB0 != n3) {
            if (!bl) {
                this.checkAndSetUnit(n, textureStateRecord);
                bl = true;
            }
            GL11.glTexEnvi((int)8960, (int)34176, (int)LWJGLTextureState.getGLCombineSrc(n3));
            textureUnitRecord.combSrcRGB0 = n3;
        }
        int n4 = texture.getCombineOp0RGB();
        if (!textureUnitRecord.isValid() || textureUnitRecord.combOpRGB0 != n4) {
            if (!bl) {
                this.checkAndSetUnit(n, textureStateRecord);
                bl = true;
            }
            GL11.glTexEnvi((int)8960, (int)34192, (int)LWJGLTextureState.getGLCombineOpRGB(n4));
            textureUnitRecord.combOpRGB0 = n4;
        }
        if (n2 != 0) {
            n3 = texture.getCombineSrc1RGB();
            if (!textureUnitRecord.isValid() || textureUnitRecord.combSrcRGB1 != n3) {
                if (!bl) {
                    this.checkAndSetUnit(n, textureStateRecord);
                    bl = true;
                }
                GL11.glTexEnvi((int)8960, (int)34177, (int)LWJGLTextureState.getGLCombineSrc(n3));
                textureUnitRecord.combSrcRGB1 = n3;
            }
            n4 = texture.getCombineOp1RGB();
            if (!textureUnitRecord.isValid() || textureUnitRecord.combOpRGB1 != n4) {
                if (!bl) {
                    this.checkAndSetUnit(n, textureStateRecord);
                    bl = true;
                }
                GL11.glTexEnvi((int)8960, (int)34193, (int)LWJGLTextureState.getGLCombineOpRGB(n4));
                textureUnitRecord.combOpRGB1 = n4;
            }
            if (n2 == 5) {
                n3 = texture.getCombineSrc2RGB();
                if (!textureUnitRecord.isValid() || textureUnitRecord.combSrcRGB2 != n3) {
                    if (!bl) {
                        this.checkAndSetUnit(n, textureStateRecord);
                        bl = true;
                    }
                    GL11.glTexEnvi((int)8960, (int)34178, (int)LWJGLTextureState.getGLCombineSrc(n3));
                    textureUnitRecord.combSrcRGB2 = n3;
                }
                n4 = texture.getCombineOp2RGB();
                if (!textureUnitRecord.isValid() || textureUnitRecord.combOpRGB2 != n4) {
                    if (!bl) {
                        this.checkAndSetUnit(n, textureStateRecord);
                        bl = true;
                    }
                    GL11.glTexEnvi((int)8960, (int)34194, (int)LWJGLTextureState.getGLCombineOpRGB(n4));
                    textureUnitRecord.combOpRGB2 = n4;
                }
            }
        }
        int n5 = texture.getCombineFuncAlpha();
        if (!textureUnitRecord.isValid() || textureUnitRecord.alphaCombineFunc != n5) {
            if (!bl) {
                this.checkAndSetUnit(n, textureStateRecord);
                bl = true;
            }
            GL11.glTexEnvi((int)8960, (int)34162, (int)LWJGLTextureState.getGLCombineFunc(n5));
            textureUnitRecord.alphaCombineFunc = n5;
        }
        int n6 = texture.getCombineSrc0Alpha();
        if (!textureUnitRecord.isValid() || textureUnitRecord.combSrcAlpha0 != n6) {
            if (!bl) {
                this.checkAndSetUnit(n, textureStateRecord);
                bl = true;
            }
            GL11.glTexEnvi((int)8960, (int)34184, (int)LWJGLTextureState.getGLCombineSrc(n6));
            textureUnitRecord.combSrcAlpha0 = n6;
        }
        int n7 = texture.getCombineOp0Alpha();
        if (!textureUnitRecord.isValid() || textureUnitRecord.combOpAlpha0 != n7) {
            if (!bl) {
                this.checkAndSetUnit(n, textureStateRecord);
                bl = true;
            }
            GL11.glTexEnvi((int)8960, (int)34200, (int)LWJGLTextureState.getGLCombineOpAlpha(n7));
            textureUnitRecord.combOpAlpha0 = n7;
        }
        if (n5 != 0) {
            n6 = texture.getCombineSrc1Alpha();
            if (!textureUnitRecord.isValid() || textureUnitRecord.combSrcAlpha1 != n6) {
                if (!bl) {
                    this.checkAndSetUnit(n, textureStateRecord);
                    bl = true;
                }
                GL11.glTexEnvi((int)8960, (int)34185, (int)LWJGLTextureState.getGLCombineSrc(n6));
                textureUnitRecord.combSrcAlpha1 = n6;
            }
            n7 = texture.getCombineOp1Alpha();
            if (!textureUnitRecord.isValid() || textureUnitRecord.combOpAlpha1 != n7) {
                if (!bl) {
                    this.checkAndSetUnit(n, textureStateRecord);
                    bl = true;
                }
                GL11.glTexEnvi((int)8960, (int)34201, (int)LWJGLTextureState.getGLCombineOpAlpha(n7));
                textureUnitRecord.combOpAlpha1 = n7;
            }
            if (n5 == 5) {
                n6 = texture.getCombineSrc2Alpha();
                if (!textureUnitRecord.isValid() || textureUnitRecord.combSrcAlpha2 != n6) {
                    if (!bl) {
                        this.checkAndSetUnit(n, textureStateRecord);
                        bl = true;
                    }
                    GL11.glTexEnvi((int)8960, (int)34186, (int)LWJGLTextureState.getGLCombineSrc(n6));
                    textureUnitRecord.combSrcAlpha2 = n6;
                }
                n7 = texture.getCombineOp2Alpha();
                if (!textureUnitRecord.isValid() || textureUnitRecord.combOpAlpha2 != n7) {
                    if (!bl) {
                        this.checkAndSetUnit(n, textureStateRecord);
                        bl = true;
                    }
                    GL11.glTexEnvi((int)8960, (int)34202, (int)LWJGLTextureState.getGLCombineOpAlpha(n7));
                    textureUnitRecord.combOpAlpha2 = n7;
                }
            }
        }
    }

    private static int getGLCombineOpRGB(int n) {
        switch (n) {
            case 0: {
                return 768;
            }
            case 1: {
                return 769;
            }
            case 2: {
                return 770;
            }
            case 3: {
                return 771;
            }
        }
        return 768;
    }

    private static int getGLCombineOpAlpha(int n) {
        switch (n) {
            case 2: {
                return 770;
            }
            case 3: {
                return 771;
            }
            case 0: {
                return 770;
            }
            case 1: {
                return 771;
            }
        }
        return 770;
    }

    private static int getGLCombineSrc(int n) {
        switch (n) {
            case 0: {
                return 5890;
            }
            case 1: {
                return 34167;
            }
            case 2: {
                return 34166;
            }
            case 3: {
                return 34168;
            }
            case 4: {
                return 33984;
            }
            case 5: {
                return 33985;
            }
            case 6: {
                return 33986;
            }
            case 7: {
                return 33987;
            }
            case 8: {
                return 33988;
            }
            case 9: {
                return 33989;
            }
            case 10: {
                return 33990;
            }
            case 11: {
                return 33991;
            }
            case 12: {
                return 33992;
            }
            case 13: {
                return 33993;
            }
            case 14: {
                return 33994;
            }
            case 15: {
                return 33995;
            }
            case 16: {
                return 33996;
            }
            case 17: {
                return 33997;
            }
            case 18: {
                return 33998;
            }
            case 19: {
                return 33999;
            }
            case 20: {
                return 34000;
            }
            case 21: {
                return 34001;
            }
            case 22: {
                return 34002;
            }
            case 23: {
                return 34003;
            }
            case 24: {
                return 34004;
            }
            case 25: {
                return 34005;
            }
            case 26: {
                return 34006;
            }
            case 27: {
                return 34007;
            }
            case 28: {
                return 34008;
            }
            case 29: {
                return 34009;
            }
            case 30: {
                return 34010;
            }
            case 31: {
                return 34011;
            }
            case 32: {
                return 34012;
            }
            case 33: {
                return 34013;
            }
            case 34: {
                return 34014;
            }
            case 35: {
                return 34015;
            }
        }
        return 34167;
    }

    private static int getGLCombineFunc(int n) {
        switch (n) {
            case 0: {
                return 7681;
            }
            case 2: {
                return 260;
            }
            case 3: {
                return 34164;
            }
            case 4: {
                return 34023;
            }
            case 5: {
                return 34165;
            }
            case 6: {
                return 34478;
            }
            case 7: {
                return 34479;
            }
        }
        return 8448;
    }

    private void applyEnvMode(int n, TextureUnitRecord textureUnitRecord, int n2, TextureStateRecord textureStateRecord) {
        if (!textureUnitRecord.isValid() || textureUnitRecord.envMode != n) {
            this.checkAndSetUnit(n2, textureStateRecord);
            GL11.glTexEnvi((int)8960, (int)8704, (int)n);
            textureUnitRecord.envMode = n;
        }
    }

    private void applyBlendColor(Texture texture, TextureUnitRecord textureUnitRecord, int n, TextureStateRecord textureStateRecord) {
        ColorRGBA colorRGBA = texture.getBlendColor();
        if (colorRGBA == null) {
            colorRGBA = TextureRecord.defaultColor;
        }
        if (!textureUnitRecord.isValid() || textureUnitRecord.blendColor.r != colorRGBA.r || textureUnitRecord.blendColor.g != colorRGBA.g || textureUnitRecord.blendColor.b != colorRGBA.b || textureUnitRecord.blendColor.a != colorRGBA.a) {
            this.checkAndSetUnit(n, textureStateRecord);
            textureUnitRecord.colorBuffer.clear();
            textureUnitRecord.colorBuffer.put(colorRGBA.r).put(colorRGBA.g).put(colorRGBA.b).put(colorRGBA.a);
            textureUnitRecord.colorBuffer.rewind();
            GL11.glTexEnv((int)8960, (int)8705, (FloatBuffer)textureUnitRecord.colorBuffer);
            textureUnitRecord.blendColor.set(colorRGBA);
        }
    }

    private void applyTextureTransforms(Texture texture, int n, TextureStateRecord textureStateRecord) {
        boolean bl;
        boolean bl2 = !textureStateRecord.units[n].identityMatrix;
        boolean bl3 = texture.getMatrix() != null && !texture.getMatrix().isIdentity();
        boolean bl4 = texture.getTranslation() != null && (texture.getTranslation().x != 0.0f || texture.getTranslation().y != 0.0f || texture.getTranslation().z != 0.0f);
        boolean bl5 = texture.getRotation() != null && !texture.getRotation().isIdentity();
        boolean bl6 = bl = texture.getScale() != null && (texture.getScale().x != 1.0f || texture.getScale().y != 1.0f || texture.getScale().z != 1.0f);
        if (bl3 || bl4 || bl5 || bl) {
            this.checkAndSetUnit(n, textureStateRecord);
            GL11.glMatrixMode((int)5890);
            if (bl3) {
                texture.getMatrix().fillFloatBuffer(textureStateRecord.tmp_matrixBuffer, true);
                GL11.glLoadMatrix((FloatBuffer)textureStateRecord.tmp_matrixBuffer);
            } else {
                GL11.glLoadIdentity();
            }
            if (bl4) {
                GL11.glTranslatef((float)texture.getTranslation().x, (float)texture.getTranslation().y, (float)texture.getTranslation().z);
            }
            if (bl5) {
                Vector3f vector3f = textureStateRecord.tmp_rotation1;
                float f = texture.getRotation().toAngleAxis(vector3f) * 57.295776f;
                GL11.glRotatef((float)f, (float)vector3f.x, (float)vector3f.y, (float)vector3f.z);
            }
            if (bl) {
                GL11.glScalef((float)texture.getScale().x, (float)texture.getScale().y, (float)texture.getScale().z);
            }
            GL11.glMatrixMode((int)5888);
            textureStateRecord.units[n].identityMatrix = false;
        } else if (bl2) {
            this.checkAndSetUnit(n, textureStateRecord);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glMatrixMode((int)5888);
            textureStateRecord.units[n].identityMatrix = true;
        }
    }

    private void applyTexCoordGeneration(Texture texture, TextureUnitRecord textureUnitRecord, int n, TextureStateRecord textureStateRecord) {
        this.checkAndSetUnit(n, textureStateRecord);
        if (texture.getEnvironmentalMapMode() == 0) {
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenQ) {
                GL11.glDisable((int)3171);
                textureUnitRecord.textureGenQ = false;
            }
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenR) {
                GL11.glDisable((int)3170);
                textureUnitRecord.textureGenR = false;
            }
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenS) {
                GL11.glDisable((int)3168);
                textureUnitRecord.textureGenS = false;
            }
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenT) {
                GL11.glDisable((int)3169);
                textureUnitRecord.textureGenT = false;
            }
        } else if (texture.getEnvironmentalMapMode() == 2) {
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenSMode != 9218) {
                GL11.glTexGeni((int)8192, (int)9472, (int)9218);
                textureUnitRecord.textureGenSMode = 9218;
            }
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenTMode != 9218) {
                GL11.glTexGeni((int)8193, (int)9472, (int)9218);
                textureUnitRecord.textureGenTMode = 9218;
            }
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenQ) {
                GL11.glDisable((int)3171);
                textureUnitRecord.textureGenQ = false;
            }
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenR) {
                GL11.glDisable((int)3170);
                textureUnitRecord.textureGenR = false;
            }
            if (!textureUnitRecord.isValid() || !textureUnitRecord.textureGenS) {
                GL11.glEnable((int)3168);
                textureUnitRecord.textureGenS = true;
            }
            if (!textureUnitRecord.isValid() || !textureUnitRecord.textureGenT) {
                GL11.glEnable((int)3169);
                textureUnitRecord.textureGenT = true;
            }
        } else if (texture.getEnvironmentalMapMode() == 1) {
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenQMode != 9216) {
                GL11.glTexGeni((int)8195, (int)9472, (int)9216);
                textureUnitRecord.textureGenSMode = 9216;
            }
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenRMode != 9216) {
                GL11.glTexGeni((int)8194, (int)9472, (int)9216);
                textureUnitRecord.textureGenTMode = 9216;
            }
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenSMode != 9216) {
                GL11.glTexGeni((int)8192, (int)9472, (int)9216);
                textureUnitRecord.textureGenSMode = 9216;
            }
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenTMode != 9216) {
                GL11.glTexGeni((int)8193, (int)9472, (int)9216);
                textureUnitRecord.textureGenTMode = 9216;
            }
            textureStateRecord.eyePlaneS.rewind();
            GL11.glTexGen((int)8192, (int)9474, (FloatBuffer)textureStateRecord.eyePlaneS);
            textureStateRecord.eyePlaneT.rewind();
            GL11.glTexGen((int)8193, (int)9474, (FloatBuffer)textureStateRecord.eyePlaneT);
            textureStateRecord.eyePlaneR.rewind();
            GL11.glTexGen((int)8194, (int)9474, (FloatBuffer)textureStateRecord.eyePlaneR);
            textureStateRecord.eyePlaneQ.rewind();
            GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)textureStateRecord.eyePlaneQ);
            if (!textureUnitRecord.isValid() || !textureUnitRecord.textureGenQ) {
                GL11.glEnable((int)3171);
                textureUnitRecord.textureGenQ = true;
            }
            if (!textureUnitRecord.isValid() || !textureUnitRecord.textureGenR) {
                GL11.glEnable((int)3170);
                textureUnitRecord.textureGenR = true;
            }
            if (!textureUnitRecord.isValid() || !textureUnitRecord.textureGenS) {
                GL11.glEnable((int)3168);
                textureUnitRecord.textureGenS = true;
            }
            if (!textureUnitRecord.isValid() || !textureUnitRecord.textureGenT) {
                GL11.glEnable((int)3169);
                textureUnitRecord.textureGenT = true;
            }
        } else if (texture.getEnvironmentalMapMode() == 4) {
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenQMode != 9217) {
                GL11.glTexGeni((int)8195, (int)9472, (int)9217);
                textureUnitRecord.textureGenSMode = 9217;
            }
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenRMode != 9217) {
                GL11.glTexGeni((int)8194, (int)9472, (int)9217);
                textureUnitRecord.textureGenTMode = 9217;
            }
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenSMode != 9217) {
                GL11.glTexGeni((int)8192, (int)9472, (int)9217);
                textureUnitRecord.textureGenSMode = 9217;
            }
            if (!textureUnitRecord.isValid() || textureUnitRecord.textureGenTMode != 9217) {
                GL11.glTexGeni((int)8193, (int)9472, (int)9217);
                textureUnitRecord.textureGenTMode = 9217;
            }
            textureStateRecord.eyePlaneS.rewind();
            GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)textureStateRecord.eyePlaneS);
            textureStateRecord.eyePlaneT.rewind();
            GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)textureStateRecord.eyePlaneT);
            textureStateRecord.eyePlaneR.rewind();
            GL11.glTexGen((int)8194, (int)9473, (FloatBuffer)textureStateRecord.eyePlaneR);
            textureStateRecord.eyePlaneQ.rewind();
            GL11.glTexGen((int)8195, (int)9473, (FloatBuffer)textureStateRecord.eyePlaneQ);
            if (!textureUnitRecord.isValid() || !textureUnitRecord.textureGenQ) {
                GL11.glEnable((int)3171);
                textureUnitRecord.textureGenQ = true;
            }
            if (!textureUnitRecord.isValid() || !textureUnitRecord.textureGenR) {
                GL11.glEnable((int)3170);
                textureUnitRecord.textureGenR = true;
            }
            if (!textureUnitRecord.isValid() || !textureUnitRecord.textureGenS) {
                GL11.glEnable((int)3168);
                textureUnitRecord.textureGenS = true;
            }
            if (!textureUnitRecord.isValid() || !textureUnitRecord.textureGenT) {
                GL11.glEnable((int)3169);
                textureUnitRecord.textureGenT = true;
            }
        }
    }

    private static int getGLEnvMode(int n) {
        switch (n) {
            case 0: {
                return 7681;
            }
            case 3: {
                return 3042;
            }
            case 4: {
                return 34160;
            }
            case 1: {
                return 8449;
            }
            case 5: {
                return 260;
            }
        }
        return 8448;
    }

    private static int getPerspHint(int n) {
        switch (n) {
            case 0: {
                return 4353;
            }
        }
        return 4354;
    }

    private void checkAndSetUnit(int n, TextureStateRecord textureStateRecord) {
        if (supportsMultiTexture && textureStateRecord.currentUnit != n) {
            GL13.glActiveTexture((int)(33984 + n));
            textureStateRecord.currentUnit = n;
        }
    }

    private void applyFilter(Texture texture, TextureRecord textureRecord, int n, TextureStateRecord textureStateRecord) {
        int n2 = LWJGLTextureState.getGLMagFilter(texture.getFilter());
        if (!textureRecord.isValid() || textureRecord.magFilter != n2) {
            this.checkAndSetUnit(n, textureStateRecord);
            GL11.glTexParameteri((int)3553, (int)10240, (int)n2);
            textureRecord.magFilter = n2;
        }
        int n3 = LWJGLTextureState.getGLMinFilter(texture.getMipmap());
        if (!textureRecord.isValid() || textureRecord.minFilter != n3) {
            this.checkAndSetUnit(n, textureStateRecord);
            GL11.glTexParameteri((int)3553, (int)10241, (int)n3);
            textureRecord.minFilter = n3;
        }
    }

    private static int getGLMagFilter(int n) {
        switch (n) {
            case 1: {
                return 9729;
            }
        }
        return 9728;
    }

    private static int getGLMinFilter(int n) {
        switch (n) {
            case 2: {
                return 9729;
            }
            case 6: {
                return 9987;
            }
            case 5: {
                return 9985;
            }
            case 1: {
                return 9728;
            }
            case 3: {
                return 9984;
            }
            case 0: {
                return 9728;
            }
        }
        return 9986;
    }

    private void applyWrap(Texture texture, TextureRecord textureRecord, int n, TextureStateRecord textureStateRecord) {
        int n2 = -1;
        int n3 = -1;
        switch (texture.getWrap()) {
            case 4: {
                n2 = 33071;
                n3 = 33071;
                break;
            }
            case 5: {
                n2 = 33069;
                n3 = 33069;
                break;
            }
            case 0: {
                n2 = 10496;
                n3 = 10496;
                break;
            }
            case 1: {
                n2 = 10496;
                n3 = 10497;
                break;
            }
            case 2: {
                n2 = 10497;
                n3 = 10496;
                break;
            }
            default: {
                n2 = 10497;
                n3 = 10497;
            }
        }
        if (!textureRecord.isValid() || textureRecord.wrapS != n2) {
            this.checkAndSetUnit(n, textureStateRecord);
            GL11.glTexParameteri((int)3553, (int)10242, (int)n2);
            textureRecord.wrapS = n2;
        }
        if (!textureRecord.isValid() || textureRecord.wrapT != n3) {
            this.checkAndSetUnit(n, textureStateRecord);
            GL11.glTexParameteri((int)3553, (int)10243, (int)n3);
            textureRecord.wrapT = n3;
        }
    }

    public static void checkTexAndUnit(int n, int n2, String string) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)16);
        intBuffer.rewind();
        GL11.glGetInteger((int)34016, (IntBuffer)intBuffer);
        int n3 = intBuffer.get(0) - 33984;
        if (n3 != n2) {
            LoggingSystem.getLogger().warning(string + ": expected unit: " + n2 + "  actual unit: " + n3);
        }
        intBuffer.rewind();
        GL11.glGetInteger((int)32873, (IntBuffer)intBuffer);
        int n4 = intBuffer.get(0);
        if (n4 != n) {
            LoggingSystem.getLogger().warning(string + ": expected tex: " + n + "  actual tex: " + n4);
        }
    }

    public RenderState extract(Stack stack, SceneElement sceneElement) {
        int n = sceneElement.getTextureCombineMode();
        if (n == 5 || n != 0 && stack.size() == 1) {
            return (LWJGLTextureState)stack.peek();
        }
        LWJGLTextureState lWJGLTextureState = new LWJGLTextureState();
        boolean bl = false;
        Object[] objectArray = stack.toArray();
        block0 : switch (n) {
            case 2: 
            case 3: {
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    TextureState textureState = (TextureState)objectArray[i];
                    if (!textureState.isEnabled()) {
                        if (n != 3) continue;
                        break block0;
                    }
                    bl = true;
                    int n2 = textureState.getNumberOfSetTextures();
                    for (int j = 0; j < n2; ++j) {
                        Texture texture = textureState.getTexture(j);
                        if (lWJGLTextureState.getTexture(j) != null) continue;
                        lWJGLTextureState.setTexture(texture, j);
                    }
                }
                break;
            }
            case 1: {
                int n3 = objectArray.length;
                for (int i = 0; i < n3; ++i) {
                    TextureState textureState = (TextureState)objectArray[i];
                    if (!textureState.isEnabled()) continue;
                    bl = true;
                    for (int j = 0; j < numTotalTexUnits; ++j) {
                        Texture texture = textureState.getTexture(j);
                        if (lWJGLTextureState.getTexture(j) != null) continue;
                        lWJGLTextureState.setTexture(texture, j);
                    }
                }
                break;
            }
        }
        lWJGLTextureState.setEnabled(bl);
        return lWJGLTextureState;
    }

    public void delete(int n) {
        if (n < 0 || n >= this.texture.size() || this.texture.get(n) == null) {
            return;
        }
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        TextureStateRecord textureStateRecord = (TextureStateRecord)renderContext.getStateRecord(6);
        Texture texture = (Texture)this.texture.get(n);
        int n2 = texture.getTextureId();
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        intBuffer.clear();
        intBuffer.put(n2);
        intBuffer.rewind();
        texture.setTextureId(0);
        GL11.glDeleteTextures((IntBuffer)intBuffer);
        textureStateRecord.removeTextureRecord(n2);
        this.idCache[n] = 0;
    }

    public void deleteAll() {
        this.deleteAll(false);
    }

    public void deleteAll(boolean bl) {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        TextureStateRecord textureStateRecord = (TextureStateRecord)renderContext.getStateRecord(6);
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)this.texture.size());
        for (int i = 0; i < this.texture.size(); ++i) {
            Texture texture = (Texture)this.texture.get(i);
            if (bl) {
                TextureManager.releaseTexture(texture);
            }
            int n = texture.getTextureId();
            if (texture == null) continue;
            intBuffer.put(n);
            texture.setTextureId(0);
            textureStateRecord.removeTextureRecord(n);
            this.idCache[i] = 0;
        }
        intBuffer.rewind();
        GL11.glDeleteTextures((IntBuffer)intBuffer);
    }

    public void deleteTextureId(int n) {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        TextureStateRecord textureStateRecord = (TextureStateRecord)renderContext.getStateRecord(6);
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        intBuffer.clear();
        intBuffer.put(n);
        intBuffer.rewind();
        GL11.glDeleteTextures((IntBuffer)intBuffer);
        textureStateRecord.removeTextureRecord(n);
    }

    public StateRecord createStateRecord() {
        return new TextureStateRecord(numTotalTexUnits);
    }

    protected static class LWJGLMipMap
    extends MipMap {
        protected LWJGLMipMap() {
        }

        protected static int glGetIntegerv(int n) {
            return Util.glGetIntegerv((int)n);
        }

        protected static int nearestPower(int n) {
            return Util.nearestPower((int)n);
        }

        protected static int bytesPerPixel(int n, int n2) {
            return Util.bytesPerPixel((int)n, (int)n2);
        }
    }
}

