/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl;

import com.jme.renderer.RenderContext;
import com.jme.scene.state.WireframeState;
import com.jme.scene.state.lwjgl.records.LineRecord;
import com.jme.scene.state.lwjgl.records.WireframeStateRecord;
import com.jme.system.DisplaySystem;
import org.lwjgl.opengl.GL11;

public class LWJGLWireframeState
extends WireframeState {
    private static final long serialVersionUID = 1L;

    public void apply() {
        RenderContext renderContext = DisplaySystem.getDisplaySystem().getCurrentContext();
        WireframeStateRecord wireframeStateRecord = (WireframeStateRecord)renderContext.getStateRecord(7);
        LineRecord lineRecord = (LineRecord)renderContext.getLineRecord();
        renderContext.currentStates[7] = this;
        if (this.isEnabled()) {
            lineRecord.applyLineWidth(this.lineWidth);
            lineRecord.applyLineSmooth(this.isAntialiased());
            lineRecord.applyLineStipple(false, -1, (short)-1);
            if (!lineRecord.isValid()) {
                lineRecord.validate();
            }
            switch (this.face) {
                case 1: {
                    this.applyPolyMode(6913, 6914, wireframeStateRecord);
                }
                case 2: {
                    this.applyPolyMode(6914, 6913, wireframeStateRecord);
                    break;
                }
                default: {
                    this.applyPolyMode(6913, 6913, wireframeStateRecord);
                    break;
                }
            }
        } else {
            this.applyPolyMode(6914, 6914, wireframeStateRecord);
        }
        if (!wireframeStateRecord.isValid()) {
            wireframeStateRecord.validate();
        }
    }

    private void applyPolyMode(int n, int n2, WireframeStateRecord wireframeStateRecord) {
        if (wireframeStateRecord.isValid()) {
            if (n == n2 && (wireframeStateRecord.frontMode != n || wireframeStateRecord.backMode != n2)) {
                GL11.glPolygonMode((int)1032, (int)n);
                wireframeStateRecord.frontMode = n;
                wireframeStateRecord.backMode = n2;
            } else if (n != n2) {
                if (wireframeStateRecord.frontMode != n) {
                    GL11.glPolygonMode((int)1028, (int)n);
                    wireframeStateRecord.frontMode = n;
                }
                if (wireframeStateRecord.backMode != n2) {
                    GL11.glPolygonMode((int)1029, (int)n2);
                    wireframeStateRecord.backMode = n2;
                }
            }
        } else {
            if (n == n2) {
                GL11.glPolygonMode((int)1032, (int)n);
            } else if (n != n2) {
                GL11.glPolygonMode((int)1028, (int)n);
                GL11.glPolygonMode((int)1029, (int)n2);
            }
            wireframeStateRecord.frontMode = n;
            wireframeStateRecord.backMode = n2;
        }
    }

    public WireframeStateRecord createStateRecord() {
        return new WireframeStateRecord();
    }
}

