/*
 * Decompiled with CFR 0.152.
 */
package com.jme.scene.state.lwjgl.records;

import com.jme.math.Vector3f;
import com.jme.scene.state.lwjgl.records.StateRecord;
import com.jme.scene.state.lwjgl.records.TextureRecord;
import com.jme.scene.state.lwjgl.records.TextureUnitRecord;
import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.HashMap;
import org.lwjgl.BufferUtils;

public class TextureStateRecord
extends StateRecord {
    public FloatBuffer eyePlaneS = BufferUtils.createFloatBuffer((int)4);
    public FloatBuffer eyePlaneT = BufferUtils.createFloatBuffer((int)4);
    public FloatBuffer eyePlaneR = BufferUtils.createFloatBuffer((int)4);
    public FloatBuffer eyePlaneQ = BufferUtils.createFloatBuffer((int)4);
    public HashMap<Integer, TextureRecord> textures;
    public TextureUnitRecord[] units;
    public int hint = -1;
    public int currentUnit = -1;
    public final Vector3f tmp_rotation1 = new Vector3f();
    public final FloatBuffer tmp_matrixBuffer = BufferUtils.createFloatBuffer((int)16);

    public TextureStateRecord(int n) {
        this.textures = new HashMap();
        this.units = new TextureUnitRecord[n];
        for (int i = 0; i < n; ++i) {
            this.units[i] = new TextureUnitRecord();
        }
        this.eyePlaneS.put(1.0f).put(0.0f).put(0.0f).put(0.0f);
        this.eyePlaneT.put(0.0f).put(1.0f).put(0.0f).put(0.0f);
        this.eyePlaneR.put(0.0f).put(0.0f).put(1.0f).put(0.0f);
        this.eyePlaneQ.put(0.0f).put(0.0f).put(0.0f).put(1.0f);
    }

    public TextureRecord getTextureRecord(int n) {
        TextureRecord textureRecord = this.textures.get(n);
        if (textureRecord == null) {
            textureRecord = new TextureRecord();
            this.textures.put(n, textureRecord);
        }
        return textureRecord;
    }

    public void removeTextureRecord(int n) {
        this.textures.remove(n);
        for (int i = 0; i < this.units.length; ++i) {
            if (this.units[i].boundTexture != n) continue;
            this.units[i].boundTexture = -1;
        }
    }

    public void invalidate() {
        super.invalidate();
        this.currentUnit = -1;
        Collection<TextureRecord> collection = this.textures.values();
        for (TextureRecord textureRecord : collection) {
            textureRecord.invalidate();
        }
        for (int i = 0; i < this.units.length; ++i) {
            this.units[i].invalidate();
        }
    }

    public void validate() {
        super.validate();
        Collection<TextureRecord> collection = this.textures.values();
        for (TextureRecord textureRecord : collection) {
            textureRecord.validate();
        }
        for (int i = 0; i < this.units.length; ++i) {
            this.units[i].validate();
        }
    }
}

