/*
 * Decompiled with CFR 0.152.
 */
package com.jme.system;

import com.jme.image.Image;
import com.jme.input.joystick.JoystickInput;
import com.jme.math.Ray;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.RenderContext;
import com.jme.renderer.Renderer;
import com.jme.renderer.TextureRenderer;
import com.jme.system.SystemProvider;
import com.jme.system.lwjgl.LWJGLSystemProvider;
import com.jmex.awt.JMECanvas;
import java.awt.Canvas;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sun.misc.Service;
import sun.misc.ServiceConfigurationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DisplaySystem {
    protected static SystemProvider system;
    protected int width;
    protected int height;
    protected int bpp;
    protected int frq;
    protected boolean fs;
    protected boolean created;
    protected int alphaBits = 0;
    protected int depthBits = 8;
    protected int stencilBits = 0;
    protected int samples = 0;
    protected float gamma = 1.0f;
    protected float brightness = 0.0f;
    protected float contrast = 1.0f;
    private static final Map<String, SystemProvider> systemProviderMap;

    protected DisplaySystem() {
    }

    public static DisplaySystem getDisplaySystem(String string) {
        JoystickInput.get();
        system = DisplaySystem.getCachedSystemProvider(string);
        if (system == null) {
            system = new LWJGLSystemProvider();
        }
        return DisplaySystem.getDisplaySystem();
    }

    private static SystemProvider getCachedSystemProvider(String string) {
        return DisplaySystem.getSystemProviderMap().get(string);
    }

    private static Map<String, SystemProvider> getSystemProviderMap() throws ServiceConfigurationError {
        if (systemProviderMap.isEmpty()) {
            SystemProvider systemProvider;
            Iterator iterator = Service.providers(SystemProvider.class);
            while (iterator.hasNext()) {
                systemProvider = (SystemProvider)iterator.next();
                systemProviderMap.put(systemProvider.getProviderIdentifier(), systemProvider);
            }
            if (systemProviderMap.isEmpty()) {
                systemProvider = new LWJGLSystemProvider();
                systemProviderMap.put(systemProvider.getProviderIdentifier(), systemProvider);
            }
        }
        return systemProviderMap;
    }

    public static String[] getSystemProviderIdentifiers() {
        Set<String> set = DisplaySystem.getSystemProviderMap().keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        return stringArray;
    }

    public static SystemProvider getSystemProvider() {
        if (system == null) {
            system = new LWJGLSystemProvider();
        }
        return system;
    }

    public static DisplaySystem getDisplaySystem() {
        return DisplaySystem.getSystemProvider().getDisplaySystem();
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBitDepth() {
        return this.bpp;
    }

    public int getFrequency() {
        return this.frq;
    }

    public boolean isFullScreen() {
        return this.fs;
    }

    public abstract String getAdapter();

    public abstract String getDriverVersion();

    public abstract String getDisplayVendor();

    public abstract String getDisplayRenderer();

    public abstract String getDisplayAPIVersion();

    public abstract boolean isValidDisplayMode(int var1, int var2, int var3, int var4);

    public abstract void setVSyncEnabled(boolean var1);

    public abstract void setTitle(String var1);

    public abstract void createWindow(int var1, int var2, int var3, int var4, boolean var5);

    public abstract void createHeadlessWindow(int var1, int var2, int var3);

    public abstract Canvas createCanvas(int var1, int var2);

    public abstract void recreateWindow(int var1, int var2, int var3, int var4, boolean var5);

    public abstract Renderer getRenderer();

    public abstract void setRenderer(Renderer var1);

    public boolean isCreated() {
        return this.created;
    }

    public abstract boolean isActive();

    public abstract boolean isClosing();

    public abstract void reset();

    public abstract void close();

    public int getMinAlphaBits() {
        return this.alphaBits;
    }

    public void setMinAlphaBits(int n) {
        this.alphaBits = n;
    }

    public int getMinDepthBits() {
        return this.depthBits;
    }

    public void setMinDepthBits(int n) {
        this.depthBits = n;
    }

    public int getMinStencilBits() {
        return this.stencilBits;
    }

    public void setMinStencilBits(int n) {
        this.stencilBits = n;
    }

    public int getMinSamples() {
        return this.samples;
    }

    public void setMinSamples(int n) {
        this.samples = n;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float f) {
        this.brightness = f;
        this.updateDisplayBGC();
    }

    public float getContrast() {
        return this.contrast;
    }

    public void setContrast(float f) {
        this.contrast = f;
        this.updateDisplayBGC();
    }

    public float getGamma() {
        return this.gamma;
    }

    public void setGamma(float f) {
        this.gamma = f;
        this.updateDisplayBGC();
    }

    public void setBrightnessGammaContrast(float f, float f2, float f3) {
        this.brightness = f;
        this.gamma = f2;
        this.contrast = f3;
        this.updateDisplayBGC();
    }

    public static void updateStates(Renderer renderer) {
        for (int i = 0; i < 17; ++i) {
            Renderer.defaultStateList[i] = renderer.createState(i);
            Renderer.defaultStateList[i].setEnabled(false);
        }
    }

    public abstract TextureRenderer createTextureRenderer(int var1, int var2, int var3);

    public Vector3f getScreenCoordinates(Vector3f vector3f) {
        return this.getScreenCoordinates(vector3f, null);
    }

    public Vector3f getScreenCoordinates(Vector3f vector3f, Vector3f vector3f2) {
        return this.getRenderer().getCamera().getScreenCoordinates(vector3f, vector3f2);
    }

    public Vector3f getWorldCoordinates(Vector2f vector2f, float f) {
        return this.getWorldCoordinates(vector2f, f, null);
    }

    public Vector3f getWorldCoordinates(Vector2f vector2f, float f, Vector3f vector3f) {
        return this.getRenderer().getCamera().getWorldCoordinates(vector2f, f, vector3f);
    }

    public Ray getPickRay(Vector2f vector2f, boolean bl, Ray ray) {
        if (bl) {
            vector2f.y = (float)this.getRenderer().getHeight() - vector2f.y;
        }
        if (ray == null) {
            ray = new Ray();
        }
        DisplaySystem.getDisplaySystem().getWorldCoordinates(vector2f, 0.0f, ray.origin);
        DisplaySystem.getDisplaySystem().getWorldCoordinates(vector2f, 0.3f, ray.direction).subtractLocal(ray.origin).normalizeLocal();
        return ray;
    }

    protected abstract void updateDisplayBGC();

    public abstract void setIcon(Image[] var1);

    public abstract void setCurrentCanvas(JMECanvas var1);

    public abstract RenderContext getCurrentContext();

    public static void resetSystemProvider() {
        if (system != null) {
            system.disposeDisplaySystem();
            system = null;
        }
    }

    static {
        systemProviderMap = new HashMap<String, SystemProvider>();
    }
}

