/*
 * Decompiled with CFR 0.152.
 */
package com.jme.system;

import com.jme.app.SimpleHeadlessApp;
import com.jme.math.FastMath;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import junit.framework.TestCase;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.glu.GLU;

public class DisplaySystemTest
extends TestCase {
    private boolean pass;
    private FloatBuffer tmp_FloatBuffer = BufferUtils.createFloatBuffer((int)16);
    private IntBuffer tmp_IntBuffer = BufferUtils.createIntBuffer((int)16);

    public void testGetScreenCoordinates() {
        if (!this.checkLWJGL()) {
            return;
        }
        this.pass = false;
        new SimpleHeadlessApp(){

            protected void simpleInitGame() {
                this.cam.setViewPort(-0.5f, 1.0f, 0.0f, 2.0f);
                this.cam.update();
                DisplaySystemTest.this.checkScreenCoordinates(new Vector3f(2.0f, 3.0f, 4.0f), this.cam);
                DisplaySystemTest.this.checkScreenCoordinates(new Vector3f(100.0f, 3.0f, 4.0f), this.cam);
                DisplaySystemTest.this.checkScreenCoordinates(new Vector3f(20.0f, 30.0f, 400.0f), this.cam);
                DisplaySystemTest.this.checkScreenCoordinates(new Vector3f(-20.0f, 3.0f, 4.0f), this.cam);
                DisplaySystemTest.this.checkScreenCoordinates(new Vector3f(-50.0f, 30.0f, 4.0f), this.cam);
                DisplaySystemTest.this.checkScreenCoordinates(new Vector3f(3.0f, 3.0f, 400.0f), this.cam);
                DisplaySystemTest.this.checkScreenCoordinates(new Vector3f(-7.0f, 30.0f, 4.0f), this.cam);
                DisplaySystemTest.this.pass = true;
                this.finished = true;
            }

            protected void quit() {
                if (this.display != null) {
                    this.display.close();
                }
            }
        }.start();
        DisplaySystemTest.assertTrue((String)"test was run", (boolean)this.pass);
    }

    private boolean checkLWJGL() {
        boolean lwjglOK = true;
        try {
            System.out.println("checking lwjgl: " + Arrays.asList(Display.getAvailableDisplayModes()));
        }
        catch (Throwable e) {
            lwjglOK = false;
            System.err.println("WARNING: no lwjgl available - test result unknown! (reporting success to let server pass)");
        }
        return lwjglOK;
    }

    public void testGetWorldCoordinates() {
        if (!this.checkLWJGL()) {
            return;
        }
        this.pass = false;
        new SimpleHeadlessApp(){

            protected void simpleInitGame() {
                DisplaySystemTest.this.checkWorldCoordinates(new Vector3f(2.0f, 3.0f, 4.0f), this.cam);
                DisplaySystemTest.this.checkWorldCoordinates(new Vector3f(100.0f, 3.0f, 4.0f), this.cam);
                DisplaySystemTest.this.checkWorldCoordinates(new Vector3f(20.0f, 30.0f, 400.0f), this.cam);
                DisplaySystemTest.this.checkWorldCoordinates(new Vector3f(-20.0f, 3.0f, 4.0f), this.cam);
                DisplaySystemTest.this.checkWorldCoordinates(new Vector3f(-50.0f, 30.0f, 4.0f), this.cam);
                DisplaySystemTest.this.checkWorldCoordinates(new Vector3f(3.0f, 3.0f, 400.0f), this.cam);
                DisplaySystemTest.this.checkWorldCoordinates(new Vector3f(-7.0f, 30.0f, 4.0f), this.cam);
                DisplaySystemTest.this.pass = true;
                this.finished = true;
            }

            protected void quit() {
                if (this.display != null) {
                    this.display.close();
                }
            }
        }.start();
        DisplaySystemTest.assertTrue((String)"test was run", (boolean)this.pass);
    }

    public void testWorldScreenSigsaw() {
        if (!this.checkLWJGL()) {
            return;
        }
        this.pass = false;
        new SimpleHeadlessApp(){

            protected void simpleInitGame() {
                DisplaySystemTest.this.checkWorldScreen(new Vector3f(2.0f, 3.0f, 4.0f), this.cam);
                DisplaySystemTest.this.checkWorldScreen(new Vector3f(100.0f, 3.0f, 4.0f), this.cam);
                DisplaySystemTest.this.checkWorldScreen(new Vector3f(20.0f, 30.0f, 400.0f), this.cam);
                DisplaySystemTest.this.checkWorldScreen(new Vector3f(-20.0f, 3.0f, 4.0f), this.cam);
                DisplaySystemTest.this.checkWorldScreen(new Vector3f(-50.0f, 30.0f, 4.0f), this.cam);
                DisplaySystemTest.this.checkWorldScreen(new Vector3f(3.0f, 3.0f, 400.0f), this.cam);
                DisplaySystemTest.this.checkWorldScreen(new Vector3f(-7.0f, 30.0f, 4.0f), this.cam);
                DisplaySystemTest.this.pass = true;
                this.finished = true;
            }

            protected void quit() {
                if (this.display != null) {
                    this.display.close();
                }
            }
        }.start();
        DisplaySystemTest.assertTrue((String)"test was run", (boolean)this.pass);
    }

    private void checkScreenCoordinates(Vector3f worldPosition, Camera cam) {
        Vector3f lwjglScreenCoordinates = this.getScreenCoordinates(worldPosition, null);
        Vector3f camScreenCoordinates = cam.getScreenCoordinates(worldPosition);
        this.assertEqualVectors("lwjgl <-> cam screen", lwjglScreenCoordinates, camScreenCoordinates);
    }

    private void checkWorldCoordinates(Vector3f screenPosition, Camera cam) {
        Vector3f lwjglWorldCoordinates = this.getWorldCoordinates(new Vector2f(screenPosition.x, screenPosition.y), screenPosition.z, null);
        Vector3f camWorldCoordinates = cam.getWorldCoordinates(new Vector2f(screenPosition.x, screenPosition.y), screenPosition.z);
        this.assertEqualVectors("lwjgl <-> cam world", lwjglWorldCoordinates, camWorldCoordinates);
    }

    private void assertEqualVectors(String message, Vector3f expected, Vector3f actual) {
        DisplaySystemTest.assertEquals((String)(message + " (x)"), (float)expected.x, (float)actual.x, (float)(FastMath.abs(expected.x) * 1.0E-5f));
        DisplaySystemTest.assertEquals((String)(message + " (y)"), (float)expected.y, (float)actual.y, (float)(FastMath.abs(expected.y) * 1.0E-5f));
        DisplaySystemTest.assertEquals((String)(message + " (z)"), (float)expected.z, (float)actual.z, (float)(FastMath.abs(expected.z) * 1.0E-5f));
    }

    private void checkWorldScreen(Vector3f worldPosition, Camera cam) {
        Vector3f screenPosition = cam.getScreenCoordinates(worldPosition);
        Vector3f worldCoordinatesBack = cam.getWorldCoordinates(new Vector2f(screenPosition.x, screenPosition.y), screenPosition.z);
        this.assertEqualVectors("world -> screen -> world", worldPosition, worldCoordinatesBack);
    }

    public Vector3f getWorldCoordinates(Vector2f screenPosition, float zPos, Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        this.tmp_FloatBuffer.rewind();
        GL11.glGetFloat((int)2982, (FloatBuffer)this.tmp_FloatBuffer);
        float[][] mvArray = new float[4][4];
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                mvArray[x][y] = this.tmp_FloatBuffer.get();
            }
        }
        this.tmp_FloatBuffer.rewind();
        FloatBuffer prBuffer = this.tmp_FloatBuffer;
        GL11.glGetFloat((int)2983, (FloatBuffer)prBuffer);
        float[][] prArray = new float[4][4];
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                prArray[x][y] = prBuffer.get();
            }
        }
        this.tmp_IntBuffer.rewind();
        GL11.glGetInteger((int)2978, (IntBuffer)this.tmp_IntBuffer);
        int[] vpArray = new int[this.tmp_IntBuffer.capacity()];
        for (int i = 0; i < vpArray.length; ++i) {
            vpArray[i] = this.tmp_IntBuffer.get();
        }
        float[] result = new float[4];
        GLU.gluUnProject((float)screenPosition.x, (float)screenPosition.y, (float)zPos, (float[][])mvArray, (float[][])prArray, (int[])vpArray, (float[])result);
        return store.set(result[0], result[1], result[2]);
    }

    public Vector3f getScreenCoordinates(Vector3f worldPosition, Vector3f store) {
        if (store == null) {
            store = new Vector3f();
        }
        this.tmp_FloatBuffer.rewind();
        GL11.glGetFloat((int)2982, (FloatBuffer)this.tmp_FloatBuffer);
        float[][] mvArray = new float[4][4];
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                mvArray[x][y] = this.tmp_FloatBuffer.get();
            }
        }
        this.tmp_FloatBuffer.rewind();
        GL11.glGetFloat((int)2983, (FloatBuffer)this.tmp_FloatBuffer);
        float[][] prArray = new float[4][4];
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                prArray[x][y] = this.tmp_FloatBuffer.get();
            }
        }
        this.tmp_IntBuffer.rewind();
        GL11.glGetInteger((int)2978, (IntBuffer)this.tmp_IntBuffer);
        int[] vpArray = new int[this.tmp_IntBuffer.capacity()];
        for (int i = 0; i < vpArray.length; ++i) {
            vpArray[i] = this.tmp_IntBuffer.get();
        }
        float[] result = new float[4];
        GLU.gluProject((float)worldPosition.x, (float)worldPosition.y, (float)worldPosition.z, (float[][])mvArray, (float[][])prArray, (int[])vpArray, (float[])result);
        return store.set(result[0], result[1], result[2]);
    }
}

