/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.math.FastMath;
import com.jme.math.Matrix3f;
import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.SharedBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.state.LightState;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.IdentityHashMap;

public class BumpMapColorController
extends Controller {
    private static final long serialVersionUID = 1L;
    private transient IdentityHashMap<TriangleBatch, BumpStore> store;
    private Spatial attachedTo = null;
    private boolean usePerVertex = true;
    private static Vector3f vert = new Vector3f();
    private static ColorRGBA workingColor = new ColorRGBA();

    public BumpMapColorController() {
        this.store = new IdentityHashMap();
    }

    public BumpMapColorController(Spatial spatial) {
        this.attachedTo = spatial;
        this.store = new IdentityHashMap();
    }

    protected void add(TriangleBatch triangleBatch) {
        if (triangleBatch == null) {
            return;
        }
        if (this.store.get(triangleBatch) == null) {
            BumpStore bumpStore = this.generateBumpStore(triangleBatch);
            this.store.put(triangleBatch, bumpStore);
        }
    }

    protected void updateBatchList() {
        if (this.attachedTo instanceof Node) {
            this.addChildrensBatches((Node)this.attachedTo);
        } else if (this.attachedTo instanceof Geometry) {
            this.addBatches((Geometry)this.attachedTo);
        }
    }

    protected void addChildrensBatches(Node node) {
        if (node == null) {
            return;
        }
        int n = node.getQuantity();
        while (--n >= 0) {
            Spatial spatial = node.getChild(n);
            if (spatial instanceof Node) {
                this.addChildrensBatches((Node)spatial);
                continue;
            }
            if (!(spatial instanceof Geometry)) continue;
            this.addBatches((Geometry)spatial);
        }
    }

    protected void addBatches(Geometry geometry) {
        if (geometry == null) {
            return;
        }
        int n = geometry.getBatchCount();
        while (--n >= 0) {
            GeomBatch geomBatch = geometry.getBatch(n);
            if (!(geomBatch instanceof TriangleBatch)) continue;
            this.add((TriangleBatch)geomBatch);
        }
    }

    public void update(float f) {
        this.updateBatchList();
        block14: for (TriangleBatch triangleBatch : this.store.keySet()) {
            Object object;
            Object object2;
            Object object3;
            boolean bl = false;
            BumpStore bumpStore = this.store.get(triangleBatch);
            if (bumpStore.verts.length != triangleBatch.getVertexCount()) {
                object3 = this.generateBumpStore(triangleBatch);
                bumpStore.verts = ((BumpStore)object3).verts;
            }
            if (!(bumpStore.oldTrans.equals(triangleBatch.getParentGeom().getWorldTranslation()) && bumpStore.oldRot.equals(triangleBatch.getParentGeom().getWorldRotation()) && bumpStore.oldScale.equals(triangleBatch.getParentGeom().getWorldScale()))) {
                bl = true;
                bumpStore.oldTrans.set(triangleBatch.getParentGeom().getWorldTranslation());
                bumpStore.oldRot.set(triangleBatch.getParentGeom().getWorldRotation());
                bumpStore.oldScale.set(triangleBatch.getParentGeom().getWorldScale());
            }
            if ((object3 = (LightState)triangleBatch.states[3]) == null || ((LightState)object3).getQuantity() < 1 || ((LightState)object3).get(0) == null) continue;
            Light light = ((LightState)object3).get(0);
            if (!bl) {
                object2 = this.store.get((Object)triangleBatch).oldLight;
                if (object2 != null && light.getType() == ((Light)object2).getType()) {
                    switch (light.getType()) {
                        case 0: {
                            if (!((DirectionalLight)object2).getDirection().equals(((DirectionalLight)light).getDirection())) break;
                            continue block14;
                        }
                        case 2: {
                            if (!((SpotLight)object2).getDirection().equals(((SpotLight)light).getDirection()) || !((SpotLight)object2).getLocation().equals(((SpotLight)light).getLocation())) break;
                            continue block14;
                        }
                        case 1: {
                            if (!((PointLight)object2).getLocation().equals(((PointLight)light).getLocation())) break;
                            continue block14;
                        }
                    }
                } else {
                    switch (light.getType()) {
                        case 0: {
                            object = new DirectionalLight();
                            ((DirectionalLight)object).getDirection().set(((DirectionalLight)light).getDirection());
                            break;
                        }
                        case 2: {
                            object = new SpotLight();
                            ((SpotLight)object).getLocation().set(((SpotLight)light).getLocation());
                            ((SpotLight)object).getDirection().set(((SpotLight)light).getDirection());
                            break;
                        }
                        default: {
                            object = new PointLight();
                            ((PointLight)object).getLocation().set(((PointLight)light).getLocation());
                        }
                    }
                    this.store.get((Object)triangleBatch).oldLight = object;
                }
            }
            object2 = triangleBatch.getVertexBuffer();
            object = triangleBatch.getColorBuffer();
            if (object == null) {
                if (triangleBatch instanceof SharedBatch) {
                    ((SharedBatch)triangleBatch).getTarget().setSolidColor(ColorRGBA.white);
                } else {
                    triangleBatch.setSolidColor(ColorRGBA.white);
                }
                object = triangleBatch.getColorBuffer();
            }
            Vector3f vector3f = null;
            switch (light.getType()) {
                case 0: {
                    vector3f = new Vector3f(((DirectionalLight)light).getDirection());
                    vector3f.negateLocal();
                    break;
                }
                case 1: {
                    vector3f = new Vector3f(((PointLight)light).getLocation());
                    vector3f.subtractLocal(triangleBatch.getParentGeom().getWorldTranslation());
                    break;
                }
                case 2: {
                    vector3f = new Vector3f(((SpotLight)light).getLocation());
                    vector3f.subtractLocal(triangleBatch.getParentGeom().getWorldTranslation());
                }
            }
            if (light.getType() != 0) {
                triangleBatch.getParentGeom().worldToLocal(vector3f, vector3f);
            }
            vert.set(vector3f);
            int n = triangleBatch.getVertexCount();
            for (int i = 0; i < n; ++i) {
                if (light.getType() != 0) {
                    BufferUtils.populateFromBuffer(vert, (FloatBuffer)object2, i);
                    triangleBatch.getParentGeom().localToWorld(vert, vert);
                    vert.negateLocal();
                    vert.addLocal(vector3f);
                } else {
                    vert.set(vector3f);
                }
                this.toModelSpace(vert, bumpStore, i);
                this.setWorkingColor(vert);
                BufferUtils.setInBuffer(workingColor, (FloatBuffer)object, i);
            }
        }
    }

    private void toModelSpace(Vector3f vector3f, BumpStore bumpStore, int n) {
        vector3f.normalizeLocal();
        Matrix3f matrix3f = bumpStore.verts[n].tbnMatrix;
        matrix3f.multLocal(vector3f);
    }

    private void setWorkingColor(Vector3f vector3f) {
        BumpMapColorController.workingColor.r = 0.5f * (vector3f.x + 1.0f);
        BumpMapColorController.workingColor.g = 0.5f * (vector3f.y + 1.0f);
        BumpMapColorController.workingColor.b = 0.5f * (vector3f.z + 1.0f);
    }

    public Spatial getAttachedTo() {
        return this.attachedTo;
    }

    public void setAttachedTo(Spatial spatial) {
        this.attachedTo = spatial;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        super.write(jMEExporter);
        jMEExporter.getCapsule(this).write(this.attachedTo, "attachedTo", null);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        super.read(jMEImporter);
        jMEImporter.getCapsule(this).readSavable("attachedTo", null);
    }

    private BumpStore generateBumpStore(TriangleBatch triangleBatch) {
        int n;
        if (triangleBatch == null) {
            return null;
        }
        BumpStore bumpStore = new BumpStore();
        bumpStore.verts = new BumpVert[triangleBatch.getVertexCount()];
        Vector3f[] vector3fArray = BufferUtils.getVector3Array(triangleBatch.getNormalBuffer());
        Vector3f[] vector3fArray2 = new Vector3f[vector3fArray.length];
        Vector3f[] vector3fArray3 = new Vector3f[vector3fArray.length];
        int[] nArray = new int[vector3fArray.length];
        int[] nArray2 = new int[3];
        for (n = 0; n < triangleBatch.getTriangleCount(); ++n) {
            triangleBatch.getTriangle(n, nArray2);
            for (int i = 0; i < 3; ++i) {
                int n2 = i == 0 ? 2 : i - 1;
                int n3 = (i + 1) % 3;
                int n4 = nArray2[i];
                int n5 = nArray2[n3];
                int n6 = nArray2[n2];
                int n7 = n4;
                nArray[n7] = nArray[n7] + 1;
                Vector3f vector3f = this.generateTangent(this.getTexCoord(n4, triangleBatch), this.getTexCoord(n5, triangleBatch), this.getTexCoord(n6, triangleBatch), this.getVertex(n4, triangleBatch), this.getVertex(n5, triangleBatch), this.getVertex(n6, triangleBatch));
                if (vector3f == null) continue;
                vector3f.subtractLocal(vector3fArray[n4].mult(vector3fArray[n4].dot(vector3f)));
                vector3f.normalizeLocal();
                Vector3f vector3f2 = vector3fArray[n4].cross(vector3f);
                if (vector3fArray2[n4] == null) {
                    vector3fArray2[n4] = new Vector3f();
                } else {
                    vector3fArray2[n4].multLocal(nArray[n4] - 1);
                }
                vector3fArray2[n4].addLocal(vector3f).divideLocal(nArray[n4]);
                if (vector3fArray3[n4] == null) {
                    vector3fArray3[n4] = new Vector3f();
                } else {
                    vector3fArray3[n4].multLocal(nArray[n4] - 1);
                }
                vector3fArray3[n4].addLocal(vector3f2).divideLocal(nArray[n4]);
            }
        }
        for (n = 0; n < bumpStore.verts.length; ++n) {
            bumpStore.verts[n] = new BumpVert();
            Matrix3f matrix3f = bumpStore.verts[n].tbnMatrix;
            matrix3f.setRow(0, vector3fArray2[n]);
            if (vector3fArray3[n] != null) {
                matrix3f.setRow(1, vector3fArray3[n].negateLocal());
            }
            matrix3f.setRow(2, vector3fArray[n]);
        }
        return bumpStore;
    }

    private Vector3f getVertex(int n, TriangleBatch triangleBatch) {
        Vector3f vector3f = new Vector3f();
        BufferUtils.populateFromBuffer(vector3f, triangleBatch.getVertexBuffer(), n);
        return vector3f;
    }

    private Vector2f getTexCoord(int n, TriangleBatch triangleBatch) {
        Vector2f vector2f = new Vector2f();
        BufferUtils.populateFromBuffer(vector2f, triangleBatch.getTextureBuffer(0), n);
        return vector2f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector3f generateTangent(Vector2f vector2f, Vector2f vector2f2, Vector2f vector2f3, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f();
        vector3f4.set(vector3f3).subtractLocal(vector3f);
        vector3f5.set(vector3f2).subtractLocal(vector3f);
        boolean bl = false;
        if (FastMath.abs(vector3f4.length()) < 1.0E-4f) return null;
        if (FastMath.abs(vector3f5.length()) < 1.0E-4f) {
            return null;
        }
        float f = vector2f2.y - vector2f.y;
        float f2 = vector2f2.x - vector2f.x;
        if (FastMath.abs(f) < 1.0E-4f) {
            if (!(FastMath.abs(f2) < 1.0E-4f)) return vector3f5.divideLocal(f2);
            return null;
        }
        float f3 = vector2f3.x - vector2f.x;
        float f4 = vector2f3.y - vector2f.y;
        float f5 = f * f3 - f4 * f2;
        if (!(FastMath.abs(f5) >= 1.0E-4f)) return null;
        vector3f4.multLocal(f);
        vector3f5.multLocal(f4);
        vector3f4.subtractLocal(vector3f5).divideLocal(f5);
        return vector3f4;
    }

    public boolean isUsePerVertex() {
        return this.usePerVertex;
    }

    public void setUsePerVertex(boolean bl) {
        this.usePerVertex = bl;
    }

    class BumpVert {
        Matrix3f tbnMatrix = new Matrix3f();

        BumpVert() {
        }
    }

    class BumpStore {
        Light oldLight = null;
        BumpVert[] verts = null;
        Vector3f oldTrans = new Vector3f();
        Quaternion oldRot = new Quaternion();
        Vector3f oldScale = new Vector3f();

        BumpStore() {
        }
    }
}

