/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import com.jme.util.CloneConfiguration;
import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import com.jme.util.geom.BufferUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneImportExport
implements JMEExporter,
JMEImporter {
    private HashMap<Object, CloneCapsule> all = new HashMap();
    private HashMap<Savable, Savable> newToOld = new HashMap();
    private HashMap<Savable, Savable> oldToNew = new HashMap();
    private String className;
    private boolean reading;
    private Savable root;
    private ArrayList<String> ignoredFields = new ArrayList();
    private ArrayList<String> shallowFields = new ArrayList();

    @Override
    public CloneCapsule getCapsule(Savable savable) {
        CloneCapsule cloneCapsule;
        Savable savable2 = savable;
        if (this.reading) {
            savable2 = this.newToOld.get(savable2);
        }
        if ((cloneCapsule = this.all.get(savable2)) == null) {
            if (this.reading) {
                return new CloneCapsule(savable.getClass().getName());
            }
            cloneCapsule = new CloneCapsule(savable.getClass().getName());
            this.all.put(savable, cloneCapsule);
        }
        return cloneCapsule;
    }

    private void resetLoadingState() {
        this.newToOld.clear();
        this.oldToNew.clear();
    }

    private void resetSavingState() {
        this.resetLoadingState();
        this.all.clear();
        this.ignoredFields.clear();
        this.className = null;
        this.reading = false;
        this.root = null;
    }

    public void applyConfiguration(CloneConfiguration cloneConfiguration) {
        this.addIgnoredFields(cloneConfiguration.getIgnored());
        this.addShallowCopyFields(cloneConfiguration.getShallow());
    }

    public void addShadowCopyField(String string) {
        this.shallowFields.add(string);
    }

    public void addShallowCopyFields(ArrayList<String> arrayList) {
        this.shallowFields.addAll(arrayList);
    }

    public void addIgnoredField(String string) {
        this.ignoredFields.add(string);
    }

    public void addIgnoredFields(ArrayList<String> arrayList) {
        this.ignoredFields.addAll(arrayList);
    }

    private boolean save(Savable savable) throws IOException {
        this.reading = false;
        if (savable != null && this.all.get(savable) == null) {
            savable.write(this);
        }
        return true;
    }

    private Savable load() throws IOException {
        if (this.root == null) {
            throw new RuntimeException("You need to save something to the CloneImportExport before loading from it");
        }
        this.reading = true;
        try {
            Savable savable = (Savable)Class.forName(this.className).newInstance();
            this.newToOld.put(savable, this.root);
            this.oldToNew.put(this.root, savable);
            savable.read(this);
            this.resetLoadingState();
            return savable;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public boolean saveClone(Savable savable) {
        this.resetSavingState();
        try {
            this.className = savable.getClass().getName();
            this.root = savable;
            return this.save(savable);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public boolean save(Savable savable, OutputStream outputStream) throws IOException {
        return this.saveClone(savable);
    }

    @Override
    public boolean save(Savable savable, File file) throws IOException {
        return this.saveClone(savable);
    }

    public Savable loadClone() {
        try {
            return this.load();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public Savable load(InputStream inputStream) throws IOException {
        return this.load();
    }

    @Override
    public Savable load(URL uRL) throws IOException {
        return this.load();
    }

    @Override
    public Savable load(File file) throws IOException {
        return this.load();
    }

    private Savable create(Savable savable) {
        if (savable == null) {
            return null;
        }
        try {
            Savable savable2 = (Savable)Class.forName(savable.getClass().getName()).newInstance();
            this.newToOld.put(savable2, savable);
            this.oldToNew.put(savable, savable2);
            return savable2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    private boolean ignoreField(String string) {
        return this.ignoredFields.contains(string);
    }

    private boolean shallowCopyField(String string) {
        return this.shallowFields.contains(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CloneCapsule
    implements OutputCapsule,
    InputCapsule {
        public String classname;
        public HashMap<String, Object> values = new HashMap();

        public CloneCapsule(String string) {
            this.classname = string;
        }

        @Override
        public void write(byte by, String string, byte by2) throws IOException {
            this.values.put(string, by);
        }

        @Override
        public void write(byte[] byArray, String string, byte[] byArray2) throws IOException {
            this.values.put(string, byArray);
        }

        @Override
        public void write(byte[][] byArray, String string, byte[][] byArray2) throws IOException {
            this.values.put(string, byArray);
        }

        @Override
        public void write(int n, String string, int n2) throws IOException {
            this.values.put(string, n);
        }

        @Override
        public void write(int[] nArray, String string, int[] nArray2) throws IOException {
            this.values.put(string, nArray);
        }

        @Override
        public void write(int[][] nArray, String string, int[][] nArray2) throws IOException {
            this.values.put(string, nArray);
        }

        @Override
        public void write(float f, String string, float f2) throws IOException {
            this.values.put(string, Float.valueOf(f));
        }

        @Override
        public void write(float[] fArray, String string, float[] fArray2) throws IOException {
            this.values.put(string, fArray);
        }

        @Override
        public void write(float[][] fArray, String string, float[][] fArray2) throws IOException {
            this.values.put(string, fArray);
        }

        @Override
        public void write(double d, String string, double d2) throws IOException {
            this.values.put(string, d);
        }

        @Override
        public void write(double[] dArray, String string, double[] dArray2) throws IOException {
            this.values.put(string, dArray);
        }

        @Override
        public void write(double[][] dArray, String string, double[][] dArray2) throws IOException {
            this.values.put(string, dArray);
        }

        @Override
        public void write(long l, String string, long l2) throws IOException {
            this.values.put(string, l);
        }

        @Override
        public void write(long[] lArray, String string, long[] lArray2) throws IOException {
            this.values.put(string, lArray);
        }

        @Override
        public void write(long[][] lArray, String string, long[][] lArray2) throws IOException {
            this.values.put(string, lArray);
        }

        @Override
        public void write(short s, String string, short s2) throws IOException {
            this.values.put(string, s);
        }

        @Override
        public void write(short[] sArray, String string, short[] sArray2) throws IOException {
            this.values.put(string, sArray);
        }

        @Override
        public void write(short[][] sArray, String string, short[][] sArray2) throws IOException {
            this.values.put(string, sArray);
        }

        @Override
        public void write(boolean bl, String string, boolean bl2) throws IOException {
            this.values.put(string, bl);
        }

        @Override
        public void write(boolean[] blArray, String string, boolean[] blArray2) throws IOException {
            this.values.put(string, blArray);
        }

        @Override
        public void write(boolean[][] blArray, String string, boolean[][] blArray2) throws IOException {
            this.values.put(string, blArray);
        }

        @Override
        public void write(String string, String string2, String string3) throws IOException {
            this.values.put(string2, string);
        }

        @Override
        public void write(String[] stringArray, String string, String[] stringArray2) throws IOException {
            this.values.put(string, stringArray);
        }

        @Override
        public void write(String[][] stringArray, String string, String[][] stringArray2) throws IOException {
            this.values.put(string, stringArray);
        }

        @Override
        public void write(BitSet bitSet, String string, BitSet bitSet2) throws IOException {
            this.values.put(string, bitSet);
        }

        @Override
        public void write(Savable savable, String string, Savable savable2) throws IOException {
            if (savable == null) {
                return;
            }
            CloneImportExport.this.save(savable);
            this.values.put(string, savable);
        }

        @Override
        public void write(Savable[] savableArray, String string, Savable[] savableArray2) throws IOException {
            if (savableArray == null) {
                return;
            }
            for (int i = 0; i < savableArray.length; ++i) {
                CloneImportExport.this.save(savableArray[i]);
            }
            this.values.put(string, savableArray);
        }

        @Override
        public void write(Savable[][] savableArray, String string, Savable[][] savableArray2) throws IOException {
            if (savableArray == null) {
                return;
            }
            for (int i = 0; i < savableArray[0].length; ++i) {
                for (int j = 0; j < savableArray.length; ++j) {
                    CloneImportExport.this.save(savableArray[j][i]);
                }
            }
            this.values.put(string, savableArray);
        }

        @Override
        public void write(FloatBuffer floatBuffer, String string, FloatBuffer floatBuffer2) throws IOException {
            this.values.put(string, floatBuffer);
        }

        @Override
        public void write(IntBuffer intBuffer, String string, IntBuffer intBuffer2) throws IOException {
            this.values.put(string, intBuffer);
        }

        @Override
        public void write(ByteBuffer byteBuffer, String string, ByteBuffer byteBuffer2) throws IOException {
            this.values.put(string, byteBuffer);
        }

        @Override
        public void write(ShortBuffer shortBuffer, String string, ShortBuffer shortBuffer2) throws IOException {
            this.values.put(string, shortBuffer);
        }

        @Override
        public void writeFloatBufferArrayList(ArrayList<FloatBuffer> arrayList, String string, ArrayList<FloatBuffer> arrayList2) throws IOException {
            this.values.put(string, arrayList);
        }

        @Override
        public void writeSavableArrayList(ArrayList arrayList, String string, ArrayList arrayList2) throws IOException {
            if (arrayList == null) {
                return;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                CloneImportExport.this.save((Savable)arrayList.get(i));
            }
            this.values.put(string, arrayList);
        }

        @Override
        public void writeSavableArrayListArray(ArrayList[] arrayListArray, String string, ArrayList[] arrayListArray2) throws IOException {
            if (arrayListArray == null) {
                return;
            }
            for (int i = 0; i < arrayListArray.length; ++i) {
                for (int j = 0; j < arrayListArray[i].size(); ++j) {
                    CloneImportExport.this.save((Savable)arrayListArray[i].get(j));
                }
            }
            this.values.put(string, arrayListArray);
        }

        @Override
        public void writeSavableArrayListArray2D(ArrayList[][] arrayListArray, String string, ArrayList[][] arrayListArray2) throws IOException {
            if (arrayListArray == null) {
                return;
            }
            for (int i = 0; i < arrayListArray[0].length; ++i) {
                for (int j = 0; j < arrayListArray.length; ++j) {
                    for (int k = 0; k < arrayListArray[j][i].size(); ++k) {
                        CloneImportExport.this.save((Savable)arrayListArray[j][i].get(k));
                    }
                }
            }
            this.values.put(string, arrayListArray);
        }

        @Override
        public BitSet readBitSet(String string, BitSet bitSet) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return bitSet;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return (BitSet)this.values.get(string);
            }
            return (BitSet)((BitSet)this.values.get(string)).clone();
        }

        @Override
        public boolean readBoolean(String string, boolean bl) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return bl;
            }
            return (Boolean)this.values.get(string);
        }

        @Override
        public boolean[] readBooleanArray(String string, boolean[] blArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return blArray;
            }
            boolean[] blArray2 = (boolean[])this.values.get(string);
            if (blArray2 == null) {
                return blArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return blArray2;
            }
            boolean[] blArray3 = new boolean[blArray2.length];
            for (int i = 0; i < blArray3.length; ++i) {
                blArray3[i] = blArray2[i];
            }
            return blArray3;
        }

        @Override
        public boolean[][] readBooleanArray2D(String string, boolean[][] blArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return blArray;
            }
            boolean[][] blArray2 = (boolean[][])this.values.get(string);
            if (blArray2 == null) {
                return blArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return blArray2;
            }
            boolean[][] blArray3 = new boolean[blArray2.length][blArray2[0].length];
            for (int i = 0; i < blArray3[0].length; ++i) {
                for (int j = 0; j < blArray3.length; ++j) {
                    blArray3[j][i] = blArray2[j][i];
                }
            }
            return blArray3;
        }

        @Override
        public byte readByte(String string, byte by) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return by;
            }
            return (Byte)this.values.get(string);
        }

        @Override
        public byte[] readByteArray(String string, byte[] byArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return byArray;
            }
            byte[] byArray2 = (byte[])this.values.get(string);
            if (byArray2 == null) {
                return byArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return byArray2;
            }
            byte[] byArray3 = new byte[byArray2.length];
            for (int i = 0; i < byArray3.length; ++i) {
                byArray3[i] = byArray2[i];
            }
            return byArray3;
        }

        @Override
        public byte[][] readByteArray2D(String string, byte[][] byArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return byArray;
            }
            byte[][] byArray2 = (byte[][])this.values.get(string);
            if (byArray2 == null) {
                return byArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return byArray2;
            }
            byte[][] byArray3 = new byte[byArray2.length][byArray2[0].length];
            for (int i = 0; i < byArray3[0].length; ++i) {
                for (int j = 0; j < byArray3.length; ++j) {
                    byArray3[j][i] = byArray2[j][i];
                }
            }
            return byArray3;
        }

        @Override
        public ByteBuffer readByteBuffer(String string, ByteBuffer byteBuffer) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return byteBuffer;
            }
            ByteBuffer byteBuffer2 = (ByteBuffer)this.values.get(string);
            if (CloneImportExport.this.shallowCopyField(string)) {
                return byteBuffer2;
            }
            return BufferUtils.clone(byteBuffer2);
        }

        @Override
        public double readDouble(String string, double d) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return d;
            }
            return (Double)this.values.get(string);
        }

        @Override
        public double[] readDoubleArray(String string, double[] dArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return dArray;
            }
            double[] dArray2 = (double[])this.values.get(string);
            if (dArray2 == null) {
                return dArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return dArray2;
            }
            double[] dArray3 = new double[dArray2.length];
            for (int i = 0; i < dArray3.length; ++i) {
                dArray3[i] = dArray2[i];
            }
            return dArray3;
        }

        @Override
        public double[][] readDoubleArray2D(String string, double[][] dArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return dArray;
            }
            double[][] dArray2 = (double[][])this.values.get(string);
            if (dArray2 == null) {
                return dArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return dArray2;
            }
            double[][] dArray3 = new double[dArray2.length][dArray2[0].length];
            for (int i = 0; i < dArray3[0].length; ++i) {
                for (int j = 0; j < dArray3.length; ++j) {
                    dArray3[j][i] = dArray2[j][i];
                }
            }
            return dArray3;
        }

        @Override
        public float readFloat(String string, float f) throws IOException {
            if (CloneImportExport.this.ignoreField(string) || this.values.get(string) == null) {
                return f;
            }
            return ((Float)this.values.get(string)).floatValue();
        }

        @Override
        public float[] readFloatArray(String string, float[] fArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return fArray;
            }
            float[] fArray2 = (float[])this.values.get(string);
            if (fArray2 == null) {
                return fArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return fArray2;
            }
            float[] fArray3 = new float[fArray2.length];
            for (int i = 0; i < fArray3.length; ++i) {
                fArray3[i] = fArray2[i];
            }
            return fArray3;
        }

        @Override
        public float[][] readFloatArray2D(String string, float[][] fArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return fArray;
            }
            float[][] fArray2 = (float[][])this.values.get(string);
            if (fArray2 == null) {
                return fArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return fArray2;
            }
            float[][] fArray3 = new float[fArray2.length][fArray2[0].length];
            for (int i = 0; i < fArray3[0].length; ++i) {
                for (int j = 0; j < fArray3.length; ++j) {
                    fArray3[j][i] = fArray2[j][i];
                }
            }
            return fArray3;
        }

        @Override
        public FloatBuffer readFloatBuffer(String string, FloatBuffer floatBuffer) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return floatBuffer;
            }
            FloatBuffer floatBuffer2 = (FloatBuffer)this.values.get(string);
            if (CloneImportExport.this.shallowCopyField(string)) {
                return floatBuffer2;
            }
            return BufferUtils.clone(floatBuffer2);
        }

        @Override
        public ArrayList readFloatBufferArrayList(String string, ArrayList<FloatBuffer> arrayList) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return arrayList;
            }
            ArrayList arrayList2 = (ArrayList)this.values.get(string);
            if (arrayList2 == null) {
                return arrayList;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return arrayList2;
            }
            ArrayList<FloatBuffer> arrayList3 = new ArrayList<FloatBuffer>();
            for (int i = 0; i < arrayList2.size(); ++i) {
                FloatBuffer floatBuffer = BufferUtils.clone((FloatBuffer)arrayList2.get(i));
                arrayList3.add(floatBuffer);
            }
            return arrayList3;
        }

        @Override
        public int readInt(String string, int n) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return n;
            }
            return (Integer)this.values.get(string);
        }

        @Override
        public int[] readIntArray(String string, int[] nArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return nArray;
            }
            int[] nArray2 = (int[])this.values.get(string);
            if (nArray2 == null) {
                return nArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return nArray2;
            }
            int[] nArray3 = new int[nArray2.length];
            for (int i = 0; i < nArray3.length; ++i) {
                nArray3[i] = nArray2[i];
            }
            return nArray3;
        }

        @Override
        public int[][] readIntArray2D(String string, int[][] nArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return nArray;
            }
            int[][] nArray2 = (int[][])this.values.get(string);
            if (nArray2 == null) {
                return nArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return nArray2;
            }
            int[][] nArray3 = new int[nArray2.length][nArray2[0].length];
            for (int i = 0; i < nArray3[0].length; ++i) {
                for (int j = 0; j < nArray3.length; ++j) {
                    nArray3[j][i] = nArray2[j][i];
                }
            }
            return nArray3;
        }

        @Override
        public IntBuffer readIntBuffer(String string, IntBuffer intBuffer) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return intBuffer;
            }
            IntBuffer intBuffer2 = (IntBuffer)this.values.get(string);
            if (CloneImportExport.this.shallowCopyField(string)) {
                return intBuffer2;
            }
            return BufferUtils.clone(intBuffer2);
        }

        @Override
        public long readLong(String string, long l) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return l;
            }
            return (Long)this.values.get(string);
        }

        @Override
        public long[] readLongArray(String string, long[] lArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return lArray;
            }
            long[] lArray2 = (long[])this.values.get(string);
            if (lArray2 == null) {
                return lArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return lArray2;
            }
            long[] lArray3 = new long[lArray2.length];
            for (int i = 0; i < lArray3.length; ++i) {
                lArray3[i] = lArray2[i];
            }
            return lArray3;
        }

        @Override
        public long[][] readLongArray2D(String string, long[][] lArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return lArray;
            }
            long[][] lArray2 = (long[][])this.values.get(string);
            if (lArray2 == null) {
                return lArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return lArray2;
            }
            long[][] lArray3 = new long[lArray2.length][lArray2[0].length];
            for (int i = 0; i < lArray3[0].length; ++i) {
                for (int j = 0; j < lArray3.length; ++j) {
                    lArray3[j][i] = lArray2[j][i];
                }
            }
            return lArray3;
        }

        @Override
        public Savable readSavable(String string, Savable savable) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return savable;
            }
            Savable savable2 = (Savable)this.values.get(string);
            if (savable2 == null) {
                return savable;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return savable2;
            }
            Savable savable3 = (Savable)CloneImportExport.this.oldToNew.get(savable2);
            if (savable3 == null) {
                savable3 = CloneImportExport.this.create(savable2);
                savable3.read(CloneImportExport.this);
            }
            return savable3;
        }

        @Override
        public Savable[] readSavableArray(String string, Savable[] savableArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return savableArray;
            }
            Savable[] savableArray2 = (Savable[])this.values.get(string);
            if (savableArray2 == null) {
                return savableArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return savableArray2;
            }
            Savable[] savableArray3 = new Savable[savableArray2.length];
            for (int i = 0; i < savableArray3.length; ++i) {
                savableArray3[i] = (Savable)CloneImportExport.this.oldToNew.get(savableArray2[i]);
                if (savableArray3[i] != null) continue;
                savableArray3[i] = CloneImportExport.this.create(savableArray2[i]);
                if (savableArray3[i] == null) {
                    return null;
                }
                savableArray3[i].read(CloneImportExport.this);
            }
            return savableArray3;
        }

        @Override
        public Savable[][] readSavableArray2D(String string, Savable[][] savableArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return savableArray;
            }
            Savable[][] savableArray2 = (Savable[][])this.values.get(string);
            if (savableArray2 == null) {
                return savableArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return savableArray2;
            }
            Savable[][] savableArray3 = new Savable[savableArray2.length][savableArray2[0].length];
            for (int i = 0; i < savableArray3[0].length; ++i) {
                for (int j = 0; j < savableArray3.length; ++j) {
                    savableArray3[j][i] = (Savable)CloneImportExport.this.oldToNew.get(savableArray2[j][i]);
                    if (savableArray3[j][i] != null) continue;
                    savableArray3[j][i] = CloneImportExport.this.create(savableArray2[j][i]);
                    savableArray3[j][i].read(CloneImportExport.this);
                }
            }
            return savableArray3;
        }

        @Override
        public ArrayList readSavableArrayList(String string, ArrayList arrayList) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return arrayList;
            }
            ArrayList arrayList2 = (ArrayList)this.values.get(string);
            if (arrayList2 == null) {
                return arrayList;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return arrayList2;
            }
            ArrayList<Savable> arrayList3 = new ArrayList<Savable>();
            for (int i = 0; i < arrayList2.size(); ++i) {
                Savable savable = (Savable)CloneImportExport.this.oldToNew.get(arrayList2.get(i));
                if (savable == null) {
                    savable = CloneImportExport.this.create((Savable)arrayList2.get(i));
                    savable.read(CloneImportExport.this);
                }
                arrayList3.add(savable);
            }
            return arrayList3;
        }

        @Override
        public ArrayList[] readSavableArrayListArray(String string, ArrayList[] arrayListArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return arrayListArray;
            }
            ArrayList[] arrayListArray2 = (ArrayList[])this.values.get(string);
            if (arrayListArray2 == null) {
                return arrayListArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return arrayListArray2;
            }
            ArrayList[] arrayListArray3 = new ArrayList[arrayListArray2.length];
            for (int i = 0; i < arrayListArray2.length; ++i) {
                arrayListArray3[i] = new ArrayList();
                for (int j = 0; j < arrayListArray2[i].size(); ++j) {
                    Savable savable = (Savable)CloneImportExport.this.oldToNew.get(arrayListArray2[i].get(j));
                    if (savable == null) {
                        savable = CloneImportExport.this.create((Savable)arrayListArray2[i].get(j));
                        savable.read(CloneImportExport.this);
                    }
                    arrayListArray3[i].add(savable);
                }
            }
            return arrayListArray3;
        }

        @Override
        public ArrayList[][] readSavableArrayListArray2D(String string, ArrayList[][] arrayListArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return arrayListArray;
            }
            ArrayList[][] arrayListArray2 = (ArrayList[][])this.values.get(string);
            if (arrayListArray2 == null) {
                return arrayListArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return arrayListArray2;
            }
            ArrayList[][] arrayListArray3 = new ArrayList[arrayListArray2.length][arrayListArray2[0].length];
            for (int i = 0; i < arrayListArray2[0].length; ++i) {
                for (int j = 0; j < arrayListArray2.length; ++j) {
                    arrayListArray3[j][i] = new ArrayList();
                    for (int k = 0; k < arrayListArray2[j][i].size(); ++k) {
                        Savable savable = (Savable)CloneImportExport.this.oldToNew.get(arrayListArray2[j][i].get(k));
                        if (savable == null) {
                            savable = CloneImportExport.this.create((Savable)arrayListArray2[j][i].get(k));
                            savable.read(CloneImportExport.this);
                        }
                        arrayListArray3[j][i].add(savable);
                    }
                }
            }
            return arrayListArray3;
        }

        @Override
        public short readShort(String string, short s) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return s;
            }
            return (Short)this.values.get(string);
        }

        @Override
        public short[] readShortArray(String string, short[] sArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return sArray;
            }
            short[] sArray2 = (short[])this.values.get(string);
            if (sArray2 == null) {
                return sArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return sArray2;
            }
            short[] sArray3 = new short[sArray2.length];
            for (int i = 0; i < sArray3.length; ++i) {
                sArray3[i] = sArray2[i];
            }
            return sArray3;
        }

        @Override
        public short[][] readShortArray2D(String string, short[][] sArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return sArray;
            }
            short[][] sArray2 = (short[][])this.values.get(string);
            if (sArray2 == null) {
                return sArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return sArray2;
            }
            short[][] sArray3 = new short[sArray2.length][sArray2[0].length];
            for (int i = 0; i < sArray3[0].length; ++i) {
                for (int j = 0; j < sArray3.length; ++j) {
                    sArray3[j][i] = sArray2[j][i];
                }
            }
            return sArray3;
        }

        @Override
        public ShortBuffer readShortBuffer(String string, ShortBuffer shortBuffer) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return shortBuffer;
            }
            ShortBuffer shortBuffer2 = (ShortBuffer)this.values.get(string);
            if (CloneImportExport.this.shallowCopyField(string)) {
                return shortBuffer2;
            }
            return BufferUtils.clone(shortBuffer2);
        }

        @Override
        public String readString(String string, String string2) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return string2;
            }
            return (String)this.values.get(string);
        }

        @Override
        public String[] readStringArray(String string, String[] stringArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return stringArray;
            }
            String[] stringArray2 = (String[])this.values.get(string);
            if (stringArray2 == null) {
                return stringArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return stringArray2;
            }
            String[] stringArray3 = new String[stringArray2.length];
            for (int i = 0; i < stringArray3.length; ++i) {
                stringArray3[i] = stringArray2[i];
            }
            return stringArray3;
        }

        @Override
        public String[][] readStringArray2D(String string, String[][] stringArray) throws IOException {
            if (CloneImportExport.this.ignoreField(string)) {
                return stringArray;
            }
            String[][] stringArray2 = (String[][])this.values.get(string);
            if (stringArray2 == null) {
                return stringArray;
            }
            if (CloneImportExport.this.shallowCopyField(string)) {
                return stringArray2;
            }
            String[][] stringArray3 = new String[stringArray2.length][stringArray2[0].length];
            for (int i = 0; i < stringArray3[0].length; ++i) {
                for (int j = 0; j < stringArray3.length; ++j) {
                    stringArray3[j][i] = stringArray2[j][i];
                }
            }
            return stringArray3;
        }

        @Override
        public void writeSavableMap(Map<Savable, Savable> map, String string, Map<Savable, Savable> map2) throws IOException {
        }

        @Override
        public Map<Savable, Savable> readSavableMap(String string, Map<Savable, Savable> map) throws IOException {
            return null;
        }

        @Override
        public void writeStringSavableMap(Map<String, Savable> map, String string, Map<String, Savable> map2) throws IOException {
        }

        @Override
        public Map<String, Savable> readStringSavableMap(String string, Map<String, Savable> map) throws IOException {
            return null;
        }
    }
}

