/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import com.jme.util.ErrorNotifier;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class ErrorManager {
    private static final int MAX_ERRORS = 100;
    private Handler handler;
    private static ErrorManager instance;
    private Stack<String> errorStack;
    private Map<String, Throwable> stackTraceMap;
    private static final Logger logger;
    private boolean enableStack = false;
    private boolean sendMail = false;
    private ErrorNotifier notifier;
    String fileName = "debug.txt";

    private ErrorManager() {
        try {
            this.handler = new FileHandler(this.fileName);
            this.handler.setFormatter(new SimpleFormatter());
            logger.addHandler(this.handler);
        }
        catch (IOException iOException) {
            System.err.println("Could not start Logging System with logging to file '" + this.fileName + "': ");
            iOException.printStackTrace();
        }
    }

    public static ErrorManager getInstance() {
        if (instance == null) {
            instance = new ErrorManager();
        }
        return instance;
    }

    public void setFilename(String string) {
        try {
            this.handler = new FileHandler(this.fileName);
            this.handler.setFormatter(new SimpleFormatter());
            logger.addHandler(this.handler);
        }
        catch (IOException iOException) {
            System.err.println("Could not start Logging System with logging to file '" + this.fileName + "': ");
            iOException.printStackTrace();
        }
    }

    public void setEnableStack(boolean bl) {
        if (this.errorStack == null) {
            this.errorStack = new Stack();
            this.stackTraceMap = new HashMap<String, Throwable>();
        }
        this.enableStack = bl;
    }

    public synchronized void addError(Level level, String string) {
        this.addError(level, string, null);
    }

    public synchronized void addError(Level level, String string, Throwable throwable) {
        if (this.enableStack) {
            if (throwable != null) {
                this.stackTraceMap.put(string, throwable);
            }
            if (level.equals(Level.WARNING) || level.equals(Level.SEVERE)) {
                if (this.errorStack.capacity() <= 100) {
                    this.errorStack.push(string);
                } else if (this.errorStack.capacity() == 100) {
                    this.errorStack.push("Error stack full, no more errors stored.");
                }
            }
            if (level.equals(Level.SEVERE) && this.sendMail) {
                this.sendMail(string);
            }
        }
        logger.log(level, string);
    }

    public void setSendMail(boolean bl) {
        this.sendMail = bl;
    }

    public void sendMail(String string) {
        if (this.notifier != null) {
            String string2 = this.getStackTrace(string);
            this.notifier.send(string, string2);
        }
    }

    public void loggerOn(boolean bl) {
        if (bl) {
            logger.setLevel(Level.FINE);
        } else {
            logger.setLevel(Level.OFF);
        }
    }

    public void setLevel(Level level) {
        logger.setLevel(level);
    }

    public synchronized boolean hasErrors() {
        if (this.errorStack == null) {
            return false;
        }
        return !this.errorStack.empty();
    }

    public synchronized String getError() {
        if (this.hasErrors()) {
            return this.errorStack.pop();
        }
        return "";
    }

    public synchronized String getStackTrace(String string) {
        Throwable throwable = this.stackTraceMap.get(string);
        if (throwable == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public ErrorNotifier getNotifier() {
        return this.notifier;
    }

    public void setNotifier(ErrorNotifier errorNotifier) {
        this.notifier = errorNotifier;
    }

    static {
        logger = Logger.getLogger("jme");
    }
}

