/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import com.jme.util.export.InputCapsule;
import com.jme.util.export.JMEExporter;
import com.jme.util.export.JMEImporter;
import com.jme.util.export.OutputCapsule;
import com.jme.util.export.Savable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class ShaderAttribute
implements Savable {
    public static final int SU_SHORT = 0;
    public static final int SU_SHORT2 = 1;
    public static final int SU_SHORT3 = 2;
    public static final int SU_SHORT4 = 3;
    public static final int SU_FLOAT = 4;
    public static final int SU_FLOAT2 = 5;
    public static final int SU_FLOAT3 = 6;
    public static final int SU_FLOAT4 = 7;
    public static final int SU_NORMALIZED_UBYTE4 = 8;
    public static final int SU_POINTER_BYTE = 9;
    public static final int SU_POINTER_FLOAT = 10;
    public static final int SU_POINTER_SHORT = 11;
    public static final int SU_POINTER_INT = 12;
    public static final int SB_FLOAT = 13;
    public static final int SB_DOUBLE = 14;
    public static final int SB_INT = 15;
    public static final int SB_SHORT = 16;
    public static final int SB_BYTE = 17;
    public String name;
    public int type;
    public int attributeID = -1;
    public short s1;
    public short s2;
    public short s3;
    public short s4;
    public float f1;
    public float f2;
    public float f3;
    public float f4;
    public byte b1;
    public byte b2;
    public byte b3;
    public byte b4;
    public Buffer data;
    public int bufferType;
    public boolean normalized;
    public boolean unsigned;
    public int stride;
    public int size;

    public ShaderAttribute(String string, int n) {
        this.name = string;
        this.type = n;
    }

    public boolean equals(Object object) {
        if (object instanceof ShaderAttribute) {
            ShaderAttribute shaderAttribute = (ShaderAttribute)object;
            if (this.name.equals(shaderAttribute.name)) {
                return true;
            }
        }
        return false;
    }

    public void write(JMEExporter jMEExporter) throws IOException {
        OutputCapsule outputCapsule = jMEExporter.getCapsule(this);
        outputCapsule.write(this.name, "name", "");
        outputCapsule.write(this.type, "type", 0);
        outputCapsule.write(this.attributeID, "attributeID", -1);
        outputCapsule.write((int)this.s1, "s1", 0);
        outputCapsule.write((int)this.s2, "s2", 0);
        outputCapsule.write((int)this.s3, "s3", 0);
        outputCapsule.write((int)this.s4, "s4", 0);
        outputCapsule.write(this.f1, "f1", 0.0f);
        outputCapsule.write(this.f2, "f2", 0.0f);
        outputCapsule.write(this.f3, "f3", 0.0f);
        outputCapsule.write(this.f4, "f4", 0.0f);
        outputCapsule.write((int)this.b1, "b1", 0);
        outputCapsule.write((int)this.b2, "b2", 0);
        outputCapsule.write((int)this.b3, "b3", 0);
        outputCapsule.write((int)this.b4, "b4", 0);
        outputCapsule.write(this.bufferType, "bufferType", 0);
        if (this.bufferType == 13) {
            outputCapsule.write((FloatBuffer)this.data, "data", null);
        } else if (this.bufferType == 17) {
            outputCapsule.write((ByteBuffer)this.data, "data", null);
        } else if (this.bufferType == 15) {
            outputCapsule.write((IntBuffer)this.data, "data", null);
        } else if (this.bufferType == 16) {
            outputCapsule.write((ShortBuffer)this.data, "data", null);
        }
        outputCapsule.write(this.normalized, "normalized", false);
        outputCapsule.write(this.unsigned, "boolean", false);
        outputCapsule.write(this.stride, "stride", 0);
        outputCapsule.write(this.size, "size", 0);
    }

    public void read(JMEImporter jMEImporter) throws IOException {
        InputCapsule inputCapsule = jMEImporter.getCapsule(this);
        this.name = inputCapsule.readString("name", "");
        this.type = inputCapsule.readInt("type", 0);
        this.attributeID = inputCapsule.readInt("attributeID", -1);
        this.s1 = inputCapsule.readShort("s1", (short)0);
        this.s2 = inputCapsule.readShort("s2", (short)0);
        this.s3 = inputCapsule.readShort("s3", (short)0);
        this.s4 = inputCapsule.readShort("s4", (short)0);
        this.f1 = inputCapsule.readFloat("f1", 0.0f);
        this.f2 = inputCapsule.readFloat("f2", 0.0f);
        this.f3 = inputCapsule.readFloat("f3", 0.0f);
        this.f4 = inputCapsule.readFloat("f4", 0.0f);
        this.b1 = inputCapsule.readByte("b1", (byte)0);
        this.b2 = inputCapsule.readByte("b2", (byte)0);
        this.b3 = inputCapsule.readByte("b3", (byte)0);
        this.b4 = inputCapsule.readByte("b4", (byte)0);
        this.bufferType = inputCapsule.readInt("bufferType", 0);
        if (this.bufferType == 13) {
            this.data = inputCapsule.readFloatBuffer("data", null);
        } else if (this.bufferType == 17) {
            this.data = inputCapsule.readByteBuffer("data", null);
        } else if (this.bufferType == 15) {
            this.data = inputCapsule.readIntBuffer("data", null);
        } else if (this.bufferType == 16) {
            this.data = inputCapsule.readShortBuffer("data", null);
        }
        this.normalized = inputCapsule.readBoolean("normalized", false);
        this.unsigned = inputCapsule.readBoolean("unsigned", false);
        this.stride = inputCapsule.readInt("stride", 0);
        this.size = inputCapsule.readInt("size", 0);
    }

    public Class getClassTag() {
        return this.getClass();
    }
}

