/*
 * Decompiled with CFR 0.152.
 */
package com.jme.util;

import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;

public abstract class Timer {
    private static Timer instance;

    public abstract long getTime();

    public float getTimeInSeconds() {
        return (float)this.getTime() / (float)this.getResolution();
    }

    public abstract long getResolution();

    public abstract float getFrameRate();

    public abstract float getTimePerFrame();

    public abstract void update();

    public static Timer getTimer() {
        if (instance == null) {
            if (DisplaySystem.getSystemProvider() == null) {
                throw new JmeException("Display System must be initialized before Timer.");
            }
            instance = DisplaySystem.getSystemProvider().getTimer();
        }
        return instance;
    }

    public static void setTimer(Timer timer) {
        instance = timer;
    }

    public abstract void reset();
}

