/*
 * Decompiled with CFR 0.152.
 */
package jmetest.unit.com.jme.math;

import com.jme.math.Line;
import com.jme.math.Vector3f;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestLine {
    @Test
    public void testOrthogonalLineFit() {
        Line ls = new Line();
        FloatBuffer points = BufferUtils.createFloatBuffer(18);
        points.put(6.0f).put(3.0f).put(9.0f);
        points.put(16.0f).put(-3.0f).put(0.0f);
        points.put(4.5f).put(8.0f).put(32.0f);
        points.put(0.0f).put(0.0f).put(1.0f);
        points.put(10.0f).put(3.0f).put(76.0f);
        points.put(-8.0f).put(-45.0f).put(-1.5f);
        ls.orthogonalLineFit(points);
        Assert.assertTrue((boolean)ls.getDirection().equals(new Vector3f(0.12209535f, 0.3713143f, 0.92044467f)));
        Assert.assertTrue((boolean)ls.getOrigin().equals(new Vector3f(4.75f, -5.666667f, 19.416668f)));
    }

    @Test
    public void testDistanceSquared() {
        Line l = new Line();
        l.setDirection(new Vector3f(-1.0f, 0.0f, 1.0f));
        l.setOrigin(new Vector3f(1.0f, 2.0f, 3.0f));
        Vector3f point = new Vector3f(10.0f, 34.0f, 9.0f);
        float distance = l.distanceSquared(point);
        Assert.assertTrue((distance == 1141.0f ? 1 : 0) != 0);
    }
}

