/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.sound.fmod.objects;

import com.jme.util.LoggingSystem;
import com.jmex.sound.fmod.scene.Configuration;
import com.jmex.sound.fmod.scene.Playable;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import org.lwjgl.fmod3.FSound;
import org.lwjgl.fmod3.FSoundStream;
import org.lwjgl.fmod3.callbacks.FSoundStreamCallback;

public class MusicStream
extends Playable {
    private ByteBuffer memoryData;
    private FSoundStream stream;
    private boolean opened;
    private boolean memory;
    private URL streamLoc;

    public MusicStream(String string, boolean bl) {
        this.streamLoc = MusicStream.class.getClassLoader().getResource(string);
        if (bl) {
            this.memoryData = MusicStream.getData(this.streamLoc);
            this.stream = FSound.FSOUND_Stream_Open((ByteBuffer)this.memoryData, (int)32768);
            this.memory = bl;
        } else {
            this.stream = FSound.FSOUND_Stream_Open((String)string, (int)131376, (int)0, (int)0);
            if (this.stream == null) {
                URL uRL = MusicStream.class.getClassLoader().getResource(string);
                string = uRL.getFile();
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                this.stream = FSound.FSOUND_Stream_Open((String)string, (int)131376, (int)0, (int)0);
            }
        }
        this.opened = this.stream != null;
    }

    public MusicStream(URL uRL, boolean bl) {
        this.streamLoc = uRL;
        if (bl) {
            this.memoryData = MusicStream.getData(this.streamLoc);
            this.stream = FSound.FSOUND_Stream_Open((ByteBuffer)this.memoryData, (int)32768);
            this.memory = bl;
        } else {
            this.stream = FSound.FSOUND_Stream_Open((String)this.streamLoc.toString(), (int)131376, (int)0, (int)0);
            if (this.stream == null) {
                String string = this.streamLoc.getFile();
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                this.stream = FSound.FSOUND_Stream_Open((String)string, (int)131376, (int)0, (int)0);
            }
        }
        if (this.stream == null) {
            LoggingSystem.getLogger().log(Level.SEVERE, "Unable to open stream: " + uRL);
        }
        this.opened = this.stream != null;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean play() {
        if (!this.isOpened()) {
            LoggingSystem.getLogger().log(Level.SEVERE, "Stream is not open.  Can not play.");
            return false;
        }
        if (!this.isPlaying()) {
            if (this.stream == null) {
                LoggingSystem.getLogger().log(Level.SEVERE, "STREAM NULL");
            }
            this.playingChannel = FSound.FSOUND_Stream_Play((int)-1, (FSoundStream)this.stream);
        }
        if (this.playingChannel == -1) {
            if (this.memory) {
                this.memoryData = MusicStream.getData(this.streamLoc);
                this.stream = FSound.FSOUND_Stream_Open((ByteBuffer)this.memoryData, (int)32768);
            } else {
                this.stream = FSound.FSOUND_Stream_Open((String)this.streamLoc.toString(), (int)131376, (int)0, (int)0);
            }
            this.opened = this.stream != null;
        }
        FSound.FSOUND_Stream_SetEndCallback((FSoundStream)this.stream, (FSoundStreamCallback)new EndCallback());
        return this.playingChannel != -2 || this.playingChannel != -1;
    }

    public boolean pause() {
        FSound.FSOUND_SetPaused((int)this.playingChannel, (!FSound.FSOUND_GetPaused((int)this.playingChannel) ? 1 : 0) != 0);
        return FSound.FSOUND_GetPaused((int)this.playingChannel);
    }

    public void stop() {
        FSound.FSOUND_Stream_Stop((FSoundStream)this.stream);
    }

    public void close() {
        FSound.FSOUND_Stream_Close((FSoundStream)this.stream);
    }

    public boolean isPlaying() {
        return FSound.FSOUND_IsPlaying((int)this.playingChannel);
    }

    public int length() {
        return FSound.FSOUND_Stream_GetLengthMs((FSoundStream)this.stream);
    }

    public void setVolume(int n) {
        FSound.FSOUND_SetVolume((int)this.playingChannel, (int)n);
    }

    public void loop(boolean bl) {
        FSound.FSOUND_Stream_SetMode((FSoundStream)this.stream, (int)(bl ? 2 : 1));
    }

    protected static ByteBuffer getData(URL uRL) {
        ByteBuffer byteBuffer = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 4096;
            byte[] byArray = new byte[n];
            int n2 = -1;
            while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            bufferedInputStream.close();
            byteBuffer = ByteBuffer.allocateDirect(byteArrayOutputStream.size());
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.put(byteArrayOutputStream.toByteArray());
            byteBuffer.flip();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteBuffer;
    }

    public boolean isOpened() {
        return this.opened;
    }

    private class EndCallback
    implements FSoundStreamCallback {
        private EndCallback() {
        }

        public void FSOUND_STREAMCALLBACK(FSoundStream fSoundStream, ByteBuffer byteBuffer, int n) {
            MusicStream.this.close();
        }
    }
}

