/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.sound.openAL.objects;

import com.jme.math.Vector3f;
import com.jme.util.LoggingSystem;
import com.jmex.sound.openAL.objects.Listener;
import com.jmex.sound.openAL.objects.util.Buffer;
import com.jmex.sound.openAL.objects.util.SampleLoader;
import com.jmex.sound.openAL.scene.Configuration;
import com.jmex.sound.openAL.scene.SoundSpatial;
import java.net.URL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.logging.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public class Sample3D
extends SoundSpatial
implements Cloneable {
    private int ray;
    private int min = 1;
    private FloatBuffer position = BufferUtils.createFloatBuffer((int)3);
    private FloatBuffer velocity = BufferUtils.createFloatBuffer((int)3);
    private static Vector3f workVec = new Vector3f();
    private Buffer buffer = null;
    private boolean handlesEvent;
    float posx = 0.0f;
    private int[] event;
    private int[] program;

    public Sample3D(String string) {
        LoggingSystem.getLogger().log(Level.INFO, "Load file:" + string);
        this.buffer = SampleLoader.loadBuffer(string);
        this.generateSource();
    }

    public Sample3D(URL uRL) {
        LoggingSystem.getLogger().log(Level.INFO, "Load file:" + uRL);
        this.buffer = SampleLoader.loadBuffer(uRL);
        this.generateSource();
    }

    private Sample3D() {
    }

    public Sample3D(Listener listener, String string) {
        this(string);
        this.listener = listener;
    }

    public Sample3D(Listener listener, URL uRL) {
        this(uRL);
        this.listener = listener;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void draw() {
        if (this.handlesEvent) {
            return;
        }
        workVec.set(this.position.get(0), this.position.get(1), this.position.get(2));
        if (workVec.distance(this.listener.getPosition()) > (float)this.ray) {
            if (this.sourceNumber >= 0) {
                this.stop();
            }
        } else if (!this.isPlaying()) {
            AL10.alSourcef((int)this.sourceNumber, (int)4131, (float)this.ray);
            this.play();
        }
    }

    public boolean play() {
        AL10.alSourcei((int)this.sourceNumber, (int)4105, (int)this.buffer.getBufferNumber());
        AL10.alSourcePlay((int)this.sourceNumber);
        return true;
    }

    public boolean pause() {
        AL10.alSourcePause((int)this.sourceNumber);
        return true;
    }

    public boolean stop() {
        AL10.alSourceStop((int)this.sourceNumber);
        return true;
    }

    public boolean isPlaying() {
        return this.sourceNumber >= 0 && AL10.alGetSourcei((int)this.sourceNumber, (int)4112) == 4114;
    }

    public void delete() {
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        intBuffer.put(this.sourceNumber);
        AL10.alDeleteSources((IntBuffer)intBuffer);
    }

    public void setPosition(float f, float f2, float f3) {
        this.position.clear();
        this.position.put(f);
        this.position.put(f2);
        this.position.put(f3);
        if (this.sourceNumber >= 0) {
            AL10.alSource3f((int)this.sourceNumber, (int)4100, (float)this.position.get(0), (float)this.position.get(1), (float)this.position.get(2));
        }
    }

    public void setVelocity(float f, float f2, float f3) {
        AL10.alSource3f((int)this.sourceNumber, (int)4102, (float)f, (float)f2, (float)f3);
    }

    public void setMinDistance(int n) {
        this.min = n;
    }

    public void setReferenceDistance(float f) {
        AL10.alSourcef((int)this.sourceNumber, (int)4128, (float)f);
    }

    public void setVolume(float f) {
        AL10.alSourcef((int)this.sourceNumber, (int)4106, (float)f);
        AL10.alSourcef((int)this.sourceNumber, (int)4099, (float)1.0f);
        AL10.alSourcei((int)this.sourceNumber, (int)4103, (int)1);
    }

    public void setMaxAudibleDistance(int n) {
        this.ray = n;
    }

    private void configure() {
    }

    private void generateSource() {
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGenSources((IntBuffer)intBuffer);
        this.sourceNumber = intBuffer.get(0);
    }

    public void bindEvent(int n) {
        if (this.event == null) {
            this.event = new int[1];
            this.event[0] = n;
            this.handlesEvent = true;
            return;
        }
        int[] nArray = new int[this.event.length + 1];
        System.arraycopy(this.event, 0, nArray, 0, this.event.length);
        nArray[this.event.length] = n;
        this.event = nArray;
    }

    public boolean fireEvent(int n) {
        if (this.event != null && (this.allowInterrupt || !this.isPlaying())) {
            for (int i = 0; i < this.event.length; ++i) {
                if (this.event[i] != n) continue;
                this.stop();
                this.play();
                return true;
            }
        }
        return false;
    }

    public void setRolloffFactor(float f) {
        AL10.alSourcef((int)this.sourceNumber, (int)4129, (float)f);
    }

    public Object clone() {
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGenSources((IntBuffer)intBuffer);
        Sample3D sample3D = new Sample3D();
        sample3D.buffer = this.buffer;
        sample3D.sourceNumber = intBuffer.get(0);
        sample3D.listener = this.listener;
        return sample3D;
    }
}

