/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.sound.openAL.objects.util;

import com.jcraft.jorbis.Info;
import com.jme.system.JmeException;
import com.jme.util.LoggingSystem;
import com.jmex.sound.openAL.objects.util.Buffer;
import com.jmex.sound.openAL.objects.util.OggInputStream;
import com.jmex.sound.openAL.objects.util.WavInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.logging.Level;
import javax.sound.sampled.AudioFormat;
import org.lwjgl.BufferUtils;

public class SampleLoader {
    public static Buffer loadBuffer(String string) {
        try {
            URL uRL = new URL("file:" + string);
            return SampleLoader.loadBuffer(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            LoggingSystem.getLogger().log(Level.WARNING, "Could not load: " + string);
            return null;
        }
    }

    public static Buffer loadBuffer(URL uRL) {
        String string = uRL.getFile();
        if (".wav".equalsIgnoreCase(string.substring(string.lastIndexOf(46)))) {
            return SampleLoader.loadWAV(uRL);
        }
        if (".ogg".equalsIgnoreCase(string.substring(string.lastIndexOf(46)))) {
            return SampleLoader.loadOGG(uRL);
        }
        return null;
    }

    private static Buffer loadWAV(URL uRL) {
        BufferedInputStream bufferedInputStream = null;
        Buffer[] bufferArray = null;
        try {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(262144);
            byteArrayOutputStream.reset();
            byte[] byArray = new byte[4096];
            WavInputStream wavInputStream = new WavInputStream(bufferedInputStream);
            boolean bl = false;
            int n = -1;
            boolean bl2 = false;
            while (!bl) {
                n = wavInputStream.read(byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n);
                bl = n != byArray.length || n < 0;
            }
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)byteArrayOutputStream.size());
            byteBuffer.put(byteArrayOutputStream.toByteArray());
            byteBuffer.rewind();
            if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
                ShortBuffer shortBuffer = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN).asShortBuffer();
                while (shortBuffer.hasRemaining()) {
                    byteBuffer.putShort(shortBuffer.get());
                }
                byteBuffer.rewind();
            }
            int n2 = wavInputStream.channels();
            bufferArray = Buffer.generateBuffers(1);
            float f = (float)byteArrayOutputStream.size() / (float)(wavInputStream.rate() * n2 * 2);
            LoggingSystem.getLogger().log(Level.INFO, "Wav estimated time " + f + "  rate: " + wavInputStream.rate() + "  channels: " + n2 + "  depth: " + wavInputStream.depth());
            bufferArray[0].configure(byteBuffer, SampleLoader.getChannels(wavInputStream), wavInputStream.rate(), f);
            byteBuffer.clear();
            byteBuffer = null;
            wavInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return bufferArray[0];
    }

    private static Buffer loadOGG(URL uRL) {
        BufferedInputStream bufferedInputStream = null;
        Buffer[] bufferArray = null;
        try {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(262144);
            byteArrayOutputStream.reset();
            byte[] byArray = new byte[4096];
            OggInputStream oggInputStream = new OggInputStream(bufferedInputStream);
            boolean bl = false;
            int n = -1;
            boolean bl2 = false;
            while (!bl) {
                n = oggInputStream.read(byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n);
                bl = n != byArray.length || n < 0;
            }
            ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)byteArrayOutputStream.size());
            byteBuffer.put(byteArrayOutputStream.toByteArray());
            byteBuffer.rewind();
            int n2 = oggInputStream.getInfo().channels;
            bufferArray = Buffer.generateBuffers(1);
            float f = (float)byteArrayOutputStream.size() / (float)(oggInputStream.getInfo().rate * n2 * 2);
            bufferArray[0].configure(byteBuffer, SampleLoader.getChannels(oggInputStream.getInfo()), oggInputStream.getInfo().rate, f);
            LoggingSystem.getLogger().log(Level.INFO, "Ogg estimated time " + f);
            LoggingSystem.getLogger().info("ogg loaded - time: " + f + "  channels: " + n2);
            byteBuffer.clear();
            byteBuffer = null;
            oggInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return bufferArray[0];
    }

    private static int getChannels(Info info) {
        if (info.channels == 1) {
            return 4353;
        }
        return 4355;
    }

    private static int getChannels(WavInputStream wavInputStream) {
        if (wavInputStream.channels() == 1) {
            if (wavInputStream.depth() == 8) {
                return 4352;
            }
            if (wavInputStream.depth() == 16) {
                return 4353;
            }
            throw new JmeException("Illegal sample size");
        }
        if (wavInputStream.channels() == 2) {
            if (wavInputStream.depth() == 8) {
                return 4354;
            }
            if (wavInputStream.depth() == 16) {
                return 4355;
            }
            throw new JmeException("Illegal sample size");
        }
        throw new JmeException("Only mono or stereo is supported");
    }

    private static float getPlayTime(byte[] byArray, AudioFormat audioFormat, int n) {
        if (audioFormat.getChannels() == 1) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                return (float)byArray.length / (float)n;
            }
            if (audioFormat.getSampleSizeInBits() == 16) {
                return (float)byArray.length / (float)(n * 2);
            }
            throw new JmeException("Illegal sample size");
        }
        if (audioFormat.getChannels() == 2) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                return (float)byArray.length / (float)(n * 2);
            }
            if (audioFormat.getSampleSizeInBits() == 16) {
                return (float)byArray.length / (float)(n * 4);
            }
            throw new JmeException("Illegal sample size");
        }
        throw new JmeException("Only mono or stereo is supported");
    }
}

