/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.sound.openAL.objects.util;

import com.jme.system.JmeException;
import com.jmex.sound.openAL.objects.util.JMEAudioInputStream;
import com.jmex.sound.openAL.objects.util.dsp.Filter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class WavInputStream
extends JMEAudioInputStream {
    private static final int RIFFid = 1380533830;
    private static final int WAVEid = 1463899717;
    private static final int fmtid = 1718449184;
    private static final int dataid = 1684108385;
    private int numChannels;
    private int sampleDepth;
    private int sampleRate;
    private int numSamples;
    private DataInputStream DataIn;
    private float length;

    private short readShort() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return (short)(n | n2 << 8);
    }

    private int readInt() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (n4 == -1) {
            throw new EOFException();
        }
        return n | n2 << 8 | n3 << 16 | n4 << 24;
    }

    public int read(ByteBuffer byteBuffer, int n, int n2) throws IOException {
        byte[] byArray = new byte[byteBuffer.capacity()];
        int n3 = this.read(byArray, n, n2);
        if (n3 > 0 && this.filters.size() > 0) {
            Iterator iterator = this.filters.iterator();
            while (iterator.hasNext()) {
                byArray = ((Filter)iterator.next()).filter(byArray);
            }
        }
        byteBuffer.put(byArray);
        byteBuffer.position(n);
        return n3;
    }

    public int channels() {
        return this.numChannels;
    }

    public int depth() {
        return this.sampleDepth;
    }

    public int rate() {
        return this.sampleRate;
    }

    public int length() {
        return this.numSamples;
    }

    public WavInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        this.DataIn = new DataInputStream(this.in);
        if (this.DataIn.readInt() != 1380533830) {
            throw new IOException("Not a valid RIFF file");
        }
        this.DataIn.readInt();
        if (this.DataIn.readInt() != 1463899717) {
            throw new IOException("Not a valid WAVE file");
        }
        this.SeekAudio();
    }

    public boolean marksupported() {
        return false;
    }

    public void readSample(byte[] byArray, int n, int n2) throws IOException {
        this.in.read(byArray, n * this.numChannels, n2 * this.numChannels);
    }

    public void readSample(short[] sArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < this.numChannels; ++j) {
                sArray[j + (n + i) * this.numChannels] = this.readShort();
            }
        }
    }

    public void readSample(int[] nArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < this.numChannels; ++j) {
                nArray[nArray[j + (n + i) * this.numChannels]] = this.readInt();
            }
        }
    }

    private void Readfmt(int n) throws IOException {
        if (this.readShort() != 1) {
            throw new IOException("Can only read PCM files");
        }
        this.numChannels = this.readShort();
        this.sampleRate = this.readInt();
        this.DataIn.readInt();
        this.DataIn.readShort();
        this.sampleDepth = this.readShort();
        if (this.sampleDepth != 8 && this.sampleDepth != 16 && this.sampleDepth != 32) {
            throw new IOException("Only 8, 16, or 32 bit samples are handled");
        }
        for (int i = 16; n > i; ++i) {
            this.read();
        }
    }

    private void SeekAudio() throws IOException {
        block4: while (true) {
            int n = this.DataIn.readInt();
            int n2 = this.readInt();
            switch (n) {
                case 1718449184: {
                    this.Readfmt(n2);
                    continue block4;
                }
                case 1684108385: {
                    this.numSamples = n2 * 8 / this.numChannels / this.sampleDepth;
                    return;
                }
            }
            if (this.in.skip(n2) != (long)n2) break;
        }
        throw new IOException("Input didn't fully skip chunk");
    }

    public int getChannels() {
        if (this.channels() == 1) {
            if (this.depth() == 8) {
                return 4352;
            }
            if (this.depth() == 16) {
                return 4353;
            }
            throw new JmeException("Illegal sample size");
        }
        if (this.channels() == 2) {
            if (this.depth() == 8) {
                return 4354;
            }
            if (this.depth() == 16) {
                return 4355;
            }
            throw new JmeException("Illegal sample size");
        }
        throw new JmeException("Only mono or stereo is supported");
    }

    public int getAudioChannels() {
        return this.channels();
    }

    protected void setLength(float f) {
        this.length = f;
    }

    public float getLength() {
        return this.length;
    }
}

