/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.sound.openAL.objects.util.dsp;

import com.jmex.sound.openAL.objects.util.dsp.Filter;
import java.util.HashMap;
import java.util.Map;

public class Equalizer {
    private int[] frequencies;
    private Map filterMap = new HashMap();
    private double minDB;
    private double maxDB;
    private double range;

    public Equalizer(int[] nArray, double d, double d2) {
        this.frequencies = nArray;
        this.minDB = d;
        this.maxDB = d2;
        this.range = d2 - d;
    }

    public int[] getFrequencies() {
        return this.frequencies;
    }

    public void addFilter(int n, Filter filter) {
        this.filterMap.put(new Integer(n), filter);
    }

    protected Filter getFilter(int n) {
        for (Integer n2 : this.filterMap.keySet()) {
            if (n2 != n) continue;
            return (Filter)this.filterMap.get(n2);
        }
        return null;
    }

    public void setDBValue(int n, int n2, double d) {
        Filter filter;
        if (d < this.minDB) {
            d = this.minDB;
        }
        if (d > this.maxDB) {
            d = this.maxDB;
        }
        if ((filter = this.getFilter(n)) != null) {
            int[] nArray = filter.frequencies;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n2) continue;
                double d2 = Math.pow(10.0, d / 20.0);
                d2 = d2 >= 1.0 ? d2 : -d2;
                filter.setAdjustement(i, d2);
            }
        }
    }
}

