/*
 * Decompiled with CFR 0.152.
 */
package jmetest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmetest.curve.TestBezierCurve;
import jmetest.effects.TestDynamicSmoker;
import jmetest.effects.TestParticleSystem;
import jmetest.effects.cloth.TestCloth;
import jmetest.input.TestThirdPersonController;
import jmetest.intersection.TestCollision;
import jmetest.intersection.TestCollisionTree;
import jmetest.intersection.TestPick;
import jmetest.intersection.TestTrianglePick;
import jmetest.renderer.TestAnisotropic;
import jmetest.renderer.TestAutoClodMesh;
import jmetest.renderer.TestBezierMesh;
import jmetest.renderer.TestBoxColor;
import jmetest.renderer.TestCameraMan;
import jmetest.renderer.TestDiscreteLOD;
import jmetest.renderer.TestEnvMap;
import jmetest.renderer.TestImposterNode;
import jmetest.renderer.TestMultitexture;
import jmetest.renderer.TestPQTorus;
import jmetest.renderer.TestRenderQueue;
import jmetest.renderer.TestRenderToTexture;
import jmetest.renderer.TestScenegraph;
import jmetest.renderer.TestSkybox;
import jmetest.renderer.loader.TestASEJmeWrite;
import jmetest.renderer.loader.TestFireMilk;
import jmetest.renderer.loader.TestMaxJmeWrite;
import jmetest.renderer.loader.TestMd2JmeWrite;
import jmetest.renderer.loader.TestMilkJmeWrite;
import jmetest.renderer.loader.TestObjJmeWrite;
import jmetest.renderer.state.TestFragmentProgramState;
import jmetest.renderer.state.TestGLSLShaderObjectsState;
import jmetest.renderer.state.TestLightState;
import jmetest.renderer.state.TestVertexProgramState;
import jmetest.terrain.TestTerrain;
import jmetest.terrain.TestTerrainLighting;
import jmetest.terrain.TestTerrainPage;
import org.lwjgl.Sys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestChooser
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Class selectedClass;

    public TestChooser() throws HeadlessException {
        super((Frame)null, "TestChooser", true);
    }

    protected Vector find(String string, boolean bl, Vector<Class> vector) {
        File file;
        String string2 = string;
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        string2 = string2.replace('.', '/');
        URL uRL = this.getClass().getResource(string2);
        string = string + ".";
        try {
            file = new File(URLDecoder.decode(uRL.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        if (file.exists()) {
            System.out.println("Searching for Demo classes in \"" + file.getName() + "\".");
            this.addAllFilesInDirectory(file, vector, string, bl);
        } else {
            try {
                System.out.println("Searching for Demo classes in \"" + uRL + "\".");
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
                    JarFile jarFile = jarURLConnection.getJarFile();
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = enumeration.nextElement();
                        Class clazz = this.load(zipEntry.getName());
                        if (clazz == null) continue;
                        vector.add(clazz);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    private Class load(String string) {
        if (string.endsWith(".class") && string.indexOf("Test") >= 0 && string.indexOf(36) < 0) {
            String string2 = string.substring(0, string.length() - ".class".length());
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            string2 = string2.replace('/', '.');
            try {
                Class<?> clazz = Class.forName(string2);
                clazz.getMethod("main", String[].class);
                if (!this.getClass().equals(clazz)) {
                    return clazz;
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
        return null;
    }

    private void addAllFilesInDirectory(File file, Collection<Class> collection, String string, boolean bl) {
        File[] fileArray = file.listFiles(this.getFileFilter());
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    if (!bl) continue;
                    this.addAllFilesInDirectory(fileArray[i], collection, string + fileArray[i].getName() + ".", true);
                    continue;
                }
                Class clazz = this.load(string + fileArray[i].getName());
                if (clazz == null) continue;
                collection.add(clazz);
            }
        }
    }

    private FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".class") && file.getName().indexOf("Test") >= 0 && file.getName().indexOf(36) < 0;
            }
        };
    }

    public Class getSelectedClass() {
        return this.selectedClass;
    }

    public void setSelectedClass(Class clazz) {
        Class clazz2 = this.selectedClass;
        if (clazz2 != clazz) {
            this.selectedClass = clazz;
            this.firePropertyChange("selectedClass", clazz2, clazz);
        }
    }

    private void setup(Vector<Class> vector) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)new JLabel("Choose a Demo to start: "), "North");
        final JList<Class> jList = new JList<Class>(vector);
        jPanel.add((Component)new JScrollPane(jList), "Center");
        jList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TestChooser.this.setSelectedClass((Class)jList.getSelectedValue());
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel.add((Component)jPanel2, "Last");
        JButton jButton = new JButton("Ok");
        jButton.setMnemonic('O');
        jPanel2.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestChooser.this.dispose();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.setMnemonic('C');
        jPanel2.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestChooser.this.setSelectedClass(null);
                TestChooser.this.dispose();
            }
        });
        this.pack();
        this.center();
    }

    private void center() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new TestChooser().start(stringArray);
    }

    protected void start(String[] stringArray) {
        Vector<Class> vector = new Vector<Class>();
        try {
            Class clazz;
            System.out.println("Composing Test list...");
            Sys.class.getName();
            this.addDisplayedClasses(vector);
            this.setup(vector);
            do {
                this.setVisible(true);
                clazz = this.getSelectedClass();
                if (clazz == null) continue;
                try {
                    Method method = clazz.getMethod("main", String[].class);
                    method.invoke(null, new Object[]{stringArray});
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            } while (clazz != null);
            System.exit(0);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            JOptionPane.showMessageDialog(null, "A required native library could not be loaded.\nSpecifying -Djava.library.path=./lib when invoking jME applications or copying native libraries to your Java bin directory might help.\nError message was: " + unsatisfiedLinkError.getMessage(), "Error loading library", 0);
            System.exit(-1);
        }
    }

    protected void addDisplayedClasses(Vector<Class> vector) {
        try {
            vector.add(TestCloth.class);
            vector.add(TestEnvMap.class);
            vector.add(TestMultitexture.class);
            vector.add(TestParticleSystem.class);
            vector.add(TestDynamicSmoker.class);
            vector.add(TestFireMilk.class);
            vector.add(TestThirdPersonController.class);
            vector.add(TestBoxColor.class);
            vector.add(TestLightState.class);
            vector.add(TestRenderQueue.class);
            vector.add(TestScenegraph.class);
            vector.add(TestBezierMesh.class);
            vector.add(TestBezierCurve.class);
            vector.add(TestPQTorus.class);
            vector.add(TestAnisotropic.class);
            vector.add(TestCollision.class);
            vector.add(TestCollisionTree.class);
            vector.add(TestPick.class);
            vector.add(TestTrianglePick.class);
            vector.add(TestImposterNode.class);
            vector.add(TestRenderToTexture.class);
            vector.add(TestCameraMan.class);
            vector.add(TestFragmentProgramState.class);
            vector.add(TestGLSLShaderObjectsState.class);
            vector.add(TestVertexProgramState.class);
            vector.add(TestAutoClodMesh.class);
            vector.add(TestDiscreteLOD.class);
            vector.add(TestASEJmeWrite.class);
            vector.add(TestMaxJmeWrite.class);
            vector.add(TestMd2JmeWrite.class);
            vector.add(TestMilkJmeWrite.class);
            vector.add(TestObjJmeWrite.class);
            vector.add(TestSkybox.class);
            vector.add(TestTerrain.class);
            vector.add(TestTerrainLighting.class);
            vector.add(TestTerrainPage.class);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            noClassDefFoundError.printStackTrace();
        }
        this.find("jmetest", true, vector);
    }
}

