/*
 * Decompiled with CFR 0.152.
 */
package jmetest.TutorialGuide;

import com.jme.app.AbstractGame;
import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.curve.BezierCurve;
import com.jme.curve.Curve;
import com.jme.curve.CurveController;
import com.jme.input.InputHandler;
import com.jme.input.action.InputActionInterface;
import com.jme.input.action.KeyExitAction;
import com.jme.math.Matrix3f;
import com.jme.math.Vector3f;
import com.jme.scene.CameraNode;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.lod.AreaClodMesh;
import com.jme.util.LoggingSystem;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.XMLparser.Converters.ObjToJme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import jmetest.TutorialGuide.HelloModelLoading;

public class HelloLOD
extends SimpleGame {
    CameraNode cn;
    Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
    Vector3f left = new Vector3f(1.0f, 0.0f, 0.0f);
    private static Vector3f tempVa = new Vector3f();
    private static Vector3f tempVb = new Vector3f();
    private static Vector3f tempVc = new Vector3f();
    private static Vector3f tempVd = new Vector3f();
    private static Matrix3f tempMa = new Matrix3f();

    public static void main(String[] stringArray) {
        HelloLOD helloLOD = new HelloLOD();
        helloLOD.setDialogBehaviour(2);
        helloLOD.start();
    }

    protected void simpleInitGame() {
        URL uRL = HelloModelLoading.class.getClassLoader().getResource("jmetest/data/model/maggie.obj");
        ObjToJme objToJme = new ObjToJme();
        objToJme.setProperty("mtllib", (Object)uRL);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Spatial spatial = null;
        try {
            objToJme.convert(uRL.openStream(), (OutputStream)byteArrayOutputStream);
            spatial = (Spatial)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            System.out.println("Damn exceptions!" + iOException);
            iOException.printStackTrace();
            System.exit(0);
        }
        Node node = this.getClodNodeFromParent((Node)spatial);
        node.setLocalScale(0.1f);
        this.rootNode.attachChild((Spatial)node);
        spatial.setLocalScale(0.1f);
        spatial.setLocalTranslation(new Vector3f(-15.0f, 0.0f, 0.0f));
        this.rootNode.attachChild(spatial);
        this.input = new InputHandler();
        this.input.addAction((InputActionInterface)new KeyExitAction((AbstractGame)this), "exit", 1, false);
        Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(0.0f, 5.0f, 20.0f), new Vector3f(0.0f, 20.0f, 90.0f), new Vector3f(0.0f, 30.0f, 200.0f), new Vector3f(0.0f, 100.0f, 300.0f), new Vector3f(0.0f, 150.0f, 400.0f)};
        BezierCurve bezierCurve = new BezierCurve("camera path", vector3fArray);
        this.cn = new CameraNode("camera node", this.cam);
        CurveController curveController = new CurveController((Curve)bezierCurve, (Spatial)this.cn);
        curveController.setRepeatType(2);
        curveController.setSpeed(0.25f);
        this.cn.addController((Controller)curveController);
        this.rootNode.attachChild((Spatial)this.cn);
    }

    private Node getClodNodeFromParent(Node node) {
        Node node2 = new Node("Clod node");
        for (int i = 0; i < node.getQuantity(); ++i) {
            Spatial spatial = node.getChild(i);
            if (spatial instanceof Node) {
                node2.attachChild((Spatial)this.getClodNodeFromParent((Node)spatial));
                continue;
            }
            if (spatial instanceof TriMesh) {
                AreaClodMesh areaClodMesh = new AreaClodMesh("part" + i, (TriMesh)spatial, null);
                areaClodMesh.setModelBound((BoundingVolume)new BoundingSphere());
                areaClodMesh.updateModelBound();
                areaClodMesh.setTrisPerPixel(0.5f);
                areaClodMesh.setDistanceTolerance(2.0f);
                areaClodMesh.setRenderState(spatial.getRenderState(4));
                node2.attachChild((Spatial)areaClodMesh);
                continue;
            }
            LoggingSystem.getLogger().warning("Unhandled Spatial type: " + spatial.getClass());
        }
        return node2;
    }

    protected void simpleUpdate() {
        Vector3f vector3f = this.rootNode.getWorldBound().getCenter(tempVa);
        Vector3f vector3f2 = tempVb.set(vector3f).subtractLocal(this.cam.getLocation()).normalizeLocal();
        tempMa.setColumn(0, this.up.cross(vector3f2, tempVc).normalizeLocal());
        tempMa.setColumn(1, this.left.cross(vector3f2, tempVd).normalizeLocal());
        tempMa.setColumn(2, vector3f2);
        this.cn.setLocalRotation(tempMa);
    }
}

