/*
 * Decompiled with CFR 0.152.
 */
package jmetest.TutorialGuide;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.AbsoluteMouse;
import com.jme.input.FirstPersonHandler;
import com.jme.input.MouseInput;
import com.jme.intersection.BoundingPickResults;
import com.jme.intersection.PickResults;
import com.jme.math.Ray;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;

public class HelloMousePick
extends SimpleGame {
    AbsoluteMouse am;
    Box b;
    PickResults pr;

    public static void main(String[] stringArray) {
        HelloMousePick helloMousePick = new HelloMousePick();
        helloMousePick.setDialogBehaviour(2);
        helloMousePick.start();
    }

    protected void simpleInitGame() {
        this.am = new AbsoluteMouse("The Mouse", this.display.getWidth(), this.display.getHeight());
        TextureState textureState = this.display.getRenderer().createTextureState();
        URL uRL = HelloMousePick.class.getClassLoader().getResource("jmetest/data/cursor/cursor1.png");
        Texture texture = TextureManager.loadTexture((URL)uRL, (int)2, (int)1);
        textureState.setTexture(texture);
        this.am.setRenderState((RenderState)textureState);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        this.am.setRenderState((RenderState)alphaState);
        this.am.setLocalTranslation(new Vector3f((float)(this.display.getWidth() / 2), (float)(this.display.getHeight() / 2), 0.0f));
        this.am.registerWithInputHandler(this.input);
        this.b = new Box("My Box", new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(1.0f, 1.0f, 1.0f));
        this.b.setModelBound((BoundingVolume)new BoundingBox());
        this.b.updateModelBound();
        this.rootNode.attachChild((Spatial)this.b);
        this.rootNode.attachChild((Spatial)this.am);
        this.lightState.detachAll();
        this.b.setLightCombineMode(0);
        this.pr = new BoundingPickResults();
        ((FirstPersonHandler)this.input).getMouseLookHandler().setEnabled(false);
    }

    protected void simpleUpdate() {
        if (MouseInput.get().isButtonDown(0)) {
            Vector2f vector2f = new Vector2f();
            vector2f.set(this.am.getHotSpotPosition().x, this.am.getHotSpotPosition().y);
            Vector3f vector3f = this.display.getWorldCoordinates(vector2f, 0.0f);
            Vector3f vector3f2 = this.display.getWorldCoordinates(vector2f, 1.0f);
            System.out.println(vector3f);
            Ray ray = new Ray(vector3f, vector3f2.subtractLocal(vector3f).normalizeLocal());
            this.pr.clear();
            this.rootNode.findPick(ray, this.pr);
            for (int i = 0; i < this.pr.getNumber(); ++i) {
                this.pr.getPickData(i).getTargetMesh().setRandomColors();
            }
        }
    }
}

