/*
 * Decompiled with CFR 0.152.
 */
package jmetest.TutorialGuide;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.ImageBasedHeightMap;
import com.jmex.terrain.util.MidPointHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;

public class HelloTerrain
extends SimpleGame {
    public static void main(String[] stringArray) {
        HelloTerrain helloTerrain = new HelloTerrain();
        helloTerrain.setDialogBehaviour(2);
        helloTerrain.start();
    }

    protected void simpleInitGame() {
        this.homeGrownHeightMap();
        this.generatedHeightMap();
        this.complexTerrain();
    }

    private void homeGrownHeightMap() {
        int[] nArray = new int[]{1, 2, 3, 4, 2, 1, 2, 3, 3, 2, 1, 2, 4, 3, 2, 1};
        TerrainBlock terrainBlock = new TerrainBlock("block", 4, new Vector3f(2.0f, 1.0f, 2.0f), nArray, new Vector3f(0.0f, 0.0f, 0.0f), false);
        terrainBlock.setModelBound((BoundingVolume)new BoundingBox());
        terrainBlock.updateModelBound();
        this.rootNode.attachChild((Spatial)terrainBlock);
    }

    private void generatedHeightMap() {
        URL uRL = HelloTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png");
        MidPointHeightMap midPointHeightMap = new MidPointHeightMap(64, 1.5f);
        TerrainBlock terrainBlock = new TerrainBlock("midpoint block", midPointHeightMap.getSize(), new Vector3f(1.0f, 0.11f, 1.0f), midPointHeightMap.getHeightMap(), new Vector3f(0.0f, -25.0f, 0.0f), false);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)uRL, (int)2, (int)1));
        terrainBlock.setRenderState((RenderState)textureState);
        terrainBlock.setModelBound((BoundingVolume)new BoundingBox());
        terrainBlock.updateModelBound();
        this.rootNode.attachChild((Spatial)terrainBlock);
    }

    private void complexTerrain() {
        URL uRL = HelloTerrain.class.getClassLoader().getResource("jmetest/data/texture/bubble.jpg");
        URL uRL2 = HelloTerrain.class.getClassLoader().getResource("jmetest/data/texture/water.png");
        URL uRL3 = HelloTerrain.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg");
        URL uRL4 = HelloTerrain.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg");
        ImageBasedHeightMap imageBasedHeightMap = new ImageBasedHeightMap(new ImageIcon(uRL).getImage());
        TerrainBlock terrainBlock = new TerrainBlock("image icon", imageBasedHeightMap.getSize(), new Vector3f(0.5f, 0.05f, 0.5f), imageBasedHeightMap.getHeightMap(), new Vector3f(0.0f, 0.0f, 0.0f), false);
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)imageBasedHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(uRL2), 0, 30, 60);
        proceduralTextureGenerator.addTexture(new ImageIcon(uRL3), 40, 80, 120);
        proceduralTextureGenerator.addTexture(new ImageIcon(uRL4), 110, 130, 256);
        proceduralTextureGenerator.createTexture(256);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true));
        terrainBlock.setRenderState((RenderState)textureState);
        terrainBlock.setModelBound((BoundingVolume)new BoundingBox());
        terrainBlock.updateModelBound();
        terrainBlock.setLocalTranslation(new Vector3f(0.0f, 0.0f, -50.0f));
        this.rootNode.attachChild((Spatial)terrainBlock);
    }
}

