/*
 * Decompiled with CFR 0.152.
 */
package jmetest.audio;

import com.jme.animation.SpatialTransformer;
import com.jme.app.SimpleGame;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Sphere;
import com.jmex.audio.AudioSystem;
import com.jmex.audio.AudioTrack;
import com.jmex.audio.MusicTrackQueue;
import com.jmex.audio.RangedAudioTracker;
import java.net.URL;
import java.util.ArrayList;

public class TestJmexAudio
extends SimpleGame {
    private AudioSystem audio;
    private ArrayList<RangedAudioTracker> trackers = new ArrayList();

    public static void main(String[] stringArray) {
        TestJmexAudio testJmexAudio = new TestJmexAudio();
        testJmexAudio.setDialogBehaviour(2);
        testJmexAudio.start();
    }

    protected void simpleInitGame() {
        Sphere sphere = new Sphere("emit1", new Vector3f(0.0f, 0.0f, 0.0f), 24, 16, 3.0f);
        this.rootNode.attachChild((Spatial)sphere);
        Box box = new Box("emit2", new Vector3f(0.0f, 0.0f, 0.0f), 1.0f, 1.0f, 1.0f);
        box.setLocalTranslation(new Vector3f(10.0f, 0.0f, 0.0f));
        this.rootNode.attachChild((Spatial)box);
        SpatialTransformer spatialTransformer = new SpatialTransformer(1);
        spatialTransformer.setObject((Spatial)box, 0, -1);
        spatialTransformer.setPosition(0, 0.0f, new Vector3f(8.0f, -8.0f, 0.0f));
        spatialTransformer.setPosition(0, 0.5f, new Vector3f(6.0f, -4.0f, -6.0f));
        spatialTransformer.setPosition(0, 1.0f, new Vector3f(0.0f, 0.0f, -8.0f));
        spatialTransformer.setPosition(0, 1.5f, new Vector3f(-6.0f, 4.0f, -6.0f));
        spatialTransformer.setPosition(0, 2.0f, new Vector3f(-8.0f, 8.0f, 0.0f));
        spatialTransformer.setPosition(0, 2.5f, new Vector3f(-6.0f, 4.0f, 6.0f));
        spatialTransformer.setPosition(0, 3.0f, new Vector3f(0.0f, 0.0f, 8.0f));
        spatialTransformer.setPosition(0, 3.5f, new Vector3f(6.0f, -4.0f, 6.0f));
        spatialTransformer.setPosition(0, 4.0f, new Vector3f(8.0f, -8.0f, 0.0f));
        spatialTransformer.interpolateMissing();
        spatialTransformer.setRepeatType(1);
        box.addController((Controller)spatialTransformer);
        this.audio = AudioSystem.getSystem();
        this.audio.getEar().trackOrientation(this.cam);
        this.audio.getEar().trackPosition(this.cam);
        AudioTrack audioTrack = this.getMusic(TestJmexAudio.class.getResource("/jmetest/data/sound/test.ogg"));
        this.audio.getMusicQueue().setRepeatType(MusicTrackQueue.RepeatType.ALL);
        this.audio.getMusicQueue().setCrossfadeinTime(2.5f);
        this.audio.getMusicQueue().setCrossfadeoutTime(2.5f);
        this.audio.getMusicQueue().addTrack(audioTrack);
        this.audio.getMusicQueue().play();
        AudioTrack audioTrack2 = this.getSFX(TestJmexAudio.class.getResource("/jmetest/data/sound/CHAR_CRE_1.ogg"));
        RangedAudioTracker rangedAudioTracker = new RangedAudioTracker(audioTrack2, 25.0f, 30.0f);
        rangedAudioTracker.setToTrack((Spatial)sphere);
        rangedAudioTracker.setTrackIn3D(true);
        rangedAudioTracker.setMaxVolume(0.35f);
        this.trackers.add(rangedAudioTracker);
        AudioTrack audioTrack3 = this.getSFX(TestJmexAudio.class.getResource("/jmetest/data/sound/Footsteps.wav"));
        RangedAudioTracker rangedAudioTracker2 = new RangedAudioTracker(audioTrack3, 25.0f, 30.0f);
        rangedAudioTracker2.setToTrack((Spatial)box);
        rangedAudioTracker2.setTrackIn3D(true);
        rangedAudioTracker2.setMaxVolume(1.0f);
        this.trackers.add(rangedAudioTracker2);
    }

    private AudioTrack getMusic(URL uRL) {
        AudioTrack audioTrack = AudioSystem.getSystem().createAudioTrack(uRL, false);
        audioTrack.setType(AudioTrack.TrackType.MUSIC);
        audioTrack.setRelative(true);
        audioTrack.setTargetVolume(0.7f);
        audioTrack.setLooping(false);
        return audioTrack;
    }

    private AudioTrack getSFX(URL uRL) {
        AudioTrack audioTrack = AudioSystem.getSystem().createAudioTrack(uRL, false);
        audioTrack.setType(AudioTrack.TrackType.POSITIONAL);
        audioTrack.setRelative(false);
        audioTrack.setLooping(true);
        return audioTrack;
    }

    protected void simpleUpdate() {
        this.audio.update();
        int n = this.trackers.size();
        while (--n >= 0) {
            RangedAudioTracker rangedAudioTracker = this.trackers.get(n);
            rangedAudioTracker.checkTrackAudible(this.cam.getLocation());
        }
    }

    protected void cleanup() {
        this.audio.cleanup();
    }
}

