/*
 * Decompiled with CFR 0.152.
 */
package jmetest.awt.swingui;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.AbsoluteMouse;
import com.jme.input.InputHandler;
import com.jme.input.KeyboardLookHandler;
import com.jme.input.MouseInput;
import com.jme.input.action.InputActionEvent;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jmex.awt.swingui.JMEAction;
import com.jmex.awt.swingui.JMEDesktop;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class TestJMEDesktop
extends SimpleGame {
    private JMEDesktop jmeDesktop;
    private Node desktopNode;
    private KeyboardLookHandler lookHandler;
    private boolean moreStuffCreated;
    private AbsoluteMouse cursor;
    int theme;

    protected void simpleUpdate() {
        if (this.jmeDesktop.getFocusOwner() == null) {
            this.lookHandler.setEnabled(true);
        } else {
            this.lookHandler.setEnabled(false);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        TestJMEDesktop testJMEDesktop = new TestJMEDesktop();
        testJMEDesktop.setDialogBehaviour(2);
        testJMEDesktop.start();
    }

    protected void simpleInitGame() {
        this.display.setTitle("jME-Desktop test");
        this.display.getRenderer().setBackgroundColor(ColorRGBA.blue);
        this.input = new InputHandler();
        this.lookHandler = new KeyboardLookHandler(this.cam, 50.0f, 1.0f);
        this.input.addToAttachedHandlers((InputHandler)this.lookHandler);
        this.jmeDesktop = new JMEDesktop("test internalFrame");
        this.jmeDesktop.setup(this.display.getWidth(), this.display.getHeight(), false, this.input);
        this.jmeDesktop.setLightCombineMode(0);
        this.desktopNode = new Node("desktop node");
        this.desktopNode.attachChild((Spatial)this.jmeDesktop);
        this.rootNode.attachChild((Spatial)this.desktopNode);
        this.rootNode.setCullMode(3);
        this.createBoxBorder();
        this.perspective();
        this.jmeDesktop.getJDesktop().setBackground(new Color(1.0f, 1.0f, 1.0f, 0.2f));
        this.createSwingStuff();
        this.create3DStuff();
        this.createCustomCursor();
    }

    private void createEditorPane() {
        JInternalFrame jInternalFrame = new JInternalFrame("html test");
        final JEditorPane jEditorPane = new JEditorPane("text/html", "<a href=\"test\">test</a>");
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    if (!Color.green.equals(jEditorPane.getBackground())) {
                        jEditorPane.setBackground(Color.GREEN);
                    } else {
                        jEditorPane.setBackground(Color.WHITE);
                    }
                }
            }
        });
        jEditorPane.setEditable(false);
        jInternalFrame.setLocation(350, 420);
        jInternalFrame.setSize(200, 80);
        jInternalFrame.getContentPane().add((Component)jEditorPane, "Center");
        jInternalFrame.setVisible(true);
        this.jmeDesktop.getJDesktop().add(jInternalFrame);
    }

    private void createCustomCursor() {
        this.cursor = new AbsoluteMouse("cursor", this.display.getWidth(), this.display.getHeight());
        TextureState textureState = this.display.getRenderer().createTextureState();
        URL uRL = TestJMEDesktop.class.getClassLoader().getResource("jmetest/data/cursor/cursor1.png");
        Texture texture = TextureManager.loadTexture((URL)uRL, (int)2, (int)1, (int)-2, (float)1.0f, (boolean)true);
        textureState.setTexture(texture);
        this.cursor.setRenderState((RenderState)textureState);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        this.cursor.setRenderState((RenderState)alphaState);
        this.cursor.registerWithInputHandler(this.input);
        this.fpsNode.attachChild((Spatial)this.cursor);
        this.cursor.setUsingDelta(false);
        this.cursor.getXUpdateAction().setSpeed(1.0f);
        this.cursor.getYUpdateAction().setSpeed(1.0f);
        this.cursor.setCullMode(3);
    }

    private void createBoxBorder() {
        float f = 10.0f;
        float f2 = f / 2.0f;
        int n = this.jmeDesktop.getJDesktop().getWidth() / 2;
        int n2 = this.jmeDesktop.getJDesktop().getHeight() / 2;
        Box box = new Box("top border", new Vector3f(), (float)n + f2, f2, f2);
        box.getLocalTranslation().set(0.0f, (float)(-n2), 0.0f);
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        this.desktopNode.attachChild((Spatial)box);
        Box box2 = new Box("bottom border", new Vector3f(), (float)n + f2, f2, f2);
        box2.getLocalTranslation().set(0.0f, (float)n2, 0.0f);
        box2.setModelBound((BoundingVolume)new BoundingBox());
        box2.updateModelBound();
        this.desktopNode.attachChild((Spatial)box2);
        Box box3 = new Box("left border", new Vector3f(), f2, (float)n2 + f2, f2);
        box3.getLocalTranslation().set((float)(-n), 0.0f, 0.0f);
        box3.setModelBound((BoundingVolume)new BoundingBox());
        box3.updateModelBound();
        this.desktopNode.attachChild((Spatial)box3);
        Box box4 = new Box("right border", new Vector3f(), f2, (float)n2 + f2, f2);
        box4.getLocalTranslation().set((float)n, 0.0f, 0.0f);
        box4.setModelBound((BoundingVolume)new BoundingBox());
        box4.updateModelBound();
        this.desktopNode.attachChild((Spatial)box4);
    }

    private void perspective() {
        this.desktopNode.getLocalRotation().fromAngleNormalAxis(-0.7f, new Vector3f(1.0f, 0.0f, 0.0f));
        this.desktopNode.setLocalScale(24.0f / (float)this.jmeDesktop.getJDesktop().getWidth());
        this.desktopNode.getLocalTranslation().set(0.0f, 0.0f, 0.0f);
        this.desktopNode.setRenderQueueMode(3);
        this.desktopNode.setCullMode(1);
    }

    private void fullScreen() {
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.desktopNode.getLocalRotation().set(0.0f, 0.0f, 0.0f, 1.0f);
        this.desktopNode.getLocalTranslation().set((float)(displaySystem.getWidth() / 2), (float)(displaySystem.getHeight() / 2), 0.0f);
        this.desktopNode.getLocalScale().set(1.0f, 1.0f, 1.0f);
        this.desktopNode.setRenderQueueMode(4);
        this.desktopNode.setCullMode(3);
    }

    protected void createSwingStuff() {
        JDesktopPane jDesktopPane = this.jmeDesktop.getJDesktop();
        jDesktopPane.removeAll();
        this.createSwingInternalFrame(jDesktopPane, "My Frame 1", 10, 150);
        this.createSwingInternalFrame(jDesktopPane, "My Frame 2", 20, 300);
        this.createSwingInternalFrame(jDesktopPane, null, 400, 350);
        final JButton jButton = new JButton("more stuff");
        jButton.setLocation(300, 100);
        jButton.setSize(jButton.getPreferredSize());
        jDesktopPane.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestJMEDesktop.this.createMoreSwingStuff();
                jButton.setVisible(false);
            }
        });
        JButton jButton2 = new JButton("toggle system/custom cursor");
        jButton2.setLocation(300, 70);
        jButton2.setSize(jButton2.getPreferredSize());
        jDesktopPane.add(jButton2);
        jButton2.addActionListener((ActionListener)new JMEAction("toggle mouse", this.input){

            public void performAction(InputActionEvent inputActionEvent) {
                if (MouseInput.get().isCursorVisible()) {
                    MouseInput.get().setCursorVisible(false);
                    TestJMEDesktop.this.cursor.setCullMode(3);
                } else {
                    TestJMEDesktop.this.cursor.setCullMode(2);
                    MouseInput.get().setCursorVisible(true);
                }
            }
        });
        jButton2.setMnemonic('m');
        JLabel jLabel = new JLabel("click scene to steer view (WASD+Arrows)");
        jLabel.setSize(jLabel.getPreferredSize());
        jLabel.setLocation(this.display.getWidth() - (int)jLabel.getSize().getWidth() - 10, 10);
        jDesktopPane.add(jLabel);
        this.moreStuffCreated = false;
        JButton jButton3 = new JButton("change l&f");
        jButton3.setLocation(10, 400);
        jButton3.setSize(jButton3.getPreferredSize());
        jDesktopPane.add(jButton3);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestJMEDesktop.this.jmeDesktop.getJDesktop().removeAll();
                TestJMEDesktop.this.switchLookAndFeel(TestJMEDesktop.this.theme + 1);
                TestJMEDesktop.this.createSwingStuff();
            }
        });
        JButton jButton4 = new JButton("<html><big>toggle fullscreen</big></html>");
        jButton4.setSize(jButton4.getPreferredSize());
        jButton4.setLocation((this.display.getWidth() - jButton4.getWidth()) / 2, this.display.getHeight() - 40 - jButton4.getHeight() / 2);
        jDesktopPane.add(jButton4);
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TestJMEDesktop.this.desktopNode.getRenderQueueMode() == 4) {
                    TestJMEDesktop.this.perspective();
                } else {
                    TestJMEDesktop.this.fullScreen();
                }
            }
        });
        this.createRotateButton(jDesktopPane, 0.25f);
        this.createRotateButton(jDesktopPane, -0.25f);
        this.createRotateButton(jDesktopPane, 0.15f);
        this.createRotateButton(jDesktopPane, -0.15f);
        this.createRotateButton(jDesktopPane, 0.45f);
        this.createRotateButton(jDesktopPane, -0.45f);
        this.createEditorPane();
        jDesktopPane.repaint();
        jDesktopPane.revalidate();
    }

    private void createRotateButton(JDesktopPane jDesktopPane, final float f) {
        JButton jButton = new JButton(f < 0.0f ? "<" : ">");
        jButton.setSize(jButton.getPreferredSize());
        jButton.setLocation((int)((float)((this.display.getWidth() - jButton.getWidth()) / 2) + f * (float)this.display.getWidth()), this.display.getHeight() - 40 - jButton.getHeight() / 2);
        jDesktopPane.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TestJMEDesktop.this.desktopNode.getRenderQueueMode() != 4) {
                    TestJMEDesktop.this.desktopNode.addController(new Controller(){
                        private static final long serialVersionUID = 1L;
                        float length = 1.0f;
                        float endTime;
                        Quaternion start;
                        Quaternion finish;
                        {
                            this.endTime = TestJMEDesktop.this.timer.getTimeInSeconds() + this.length;
                            this.start = new Quaternion().set(TestJMEDesktop.this.desktopNode.getLocalRotation());
                            this.finish = new Quaternion().set(TestJMEDesktop.this.desktopNode.getLocalRotation()).multLocal(new Quaternion().fromAngleNormalAxis(f, new Vector3f(0.0f, 1.0f, 0.0f)));
                        }

                        public void update(float f) {
                            if (TestJMEDesktop.this.timer.getTimeInSeconds() > this.endTime) {
                                TestJMEDesktop.this.desktopNode.removeController((Controller)this);
                            } else {
                                TestJMEDesktop.this.desktopNode.getLocalRotation().slerp(this.finish, this.start, (this.endTime - TestJMEDesktop.this.timer.getTimeInSeconds()) / this.length);
                                TestJMEDesktop.this.desktopNode.getLocalRotation().normalize();
                            }
                        }
                    });
                }
            }
        });
    }

    private void createMoreSwingStuff() {
        if (this.moreStuffCreated) {
            return;
        }
        this.moreStuffCreated = true;
        JDesktopPane jDesktopPane = this.jmeDesktop.getJDesktop();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        JScrollPane jScrollPane = new JScrollPane(jPanel, 22, 31);
        jScrollPane.setLocation(400, 100);
        jDesktopPane.add(jScrollPane);
        jPanel.add(new JCheckBox("check"));
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{"Item 1", "Item 2", "Item 3", "4", "5", "6", "7", "8", "9"});
        jComboBox.setEditable(true);
        jPanel.add(jComboBox);
        JProgressBar jProgressBar = new JProgressBar(0, 100);
        jPanel.add(jProgressBar);
        jProgressBar.setValue(30);
        JSlider jSlider = new JSlider(0, 100);
        jSlider.setValue(75);
        jPanel.add(jSlider);
        jPanel.setDoubleBuffered(false);
        jPanel.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < 10; ++i) {
            JRadioButton jRadioButton = new JRadioButton("radio " + i);
            jPanel.add(jRadioButton);
            buttonGroup.add(jRadioButton);
        }
        jScrollPane.setSize((int)jScrollPane.getPreferredSize().getWidth(), 200);
        jScrollPane.revalidate();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jDesktopPane.add(jTabbedPane);
        jTabbedPane.add("a", new JButton("abc"));
        jTabbedPane.add("d", new JButton("def"));
        jTabbedPane.add("g", new JButton("ghi"));
        jTabbedPane.setLocation(10, 30);
        jTabbedPane.setSize(150, 100);
        jTabbedPane.revalidate();
        jDesktopPane.repaint();
    }

    private void createSwingInternalFrame(JDesktopPane jDesktopPane, String string, int n, int n2) {
        JInternalFrame jInternalFrame = new JInternalFrame(string);
        if (string == null) {
            jInternalFrame.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        }
        jInternalFrame.setLocation(n, n2);
        jInternalFrame.setResizable(true);
        jInternalFrame.getContentPane().setLayout(new FlowLayout());
        JButton jButton = new JButton("button in " + string);
        jButton.setMnemonic('u');
        jInternalFrame.getContentPane().add(jButton);
        jInternalFrame.getContentPane().add(new JButton("<html><i>test</i> <big>2</big></html>"));
        jInternalFrame.setVisible(true);
        jInternalFrame.pack();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TestJMEDesktop.this.showDialog();
            }
        });
        JTextField jTextField = new JTextField("type in here");
        jInternalFrame.getContentPane().add(jTextField);
        jInternalFrame.pack();
        jDesktopPane.add(jInternalFrame);
    }

    private void showDialog() {
        final JDesktopPane jDesktopPane = this.jmeDesktop.getJDesktop();
        final JInternalFrame jInternalFrame = new JInternalFrame("Dialog");
        JOptionPane jOptionPane = new JOptionPane("This is a message box!");
        jInternalFrame.getContentPane().add(jOptionPane);
        this.jmeDesktop.setModalComponent((Component)jInternalFrame);
        jDesktopPane.add((Component)jInternalFrame, 0);
        jInternalFrame.setVisible(true);
        jInternalFrame.setSize(jInternalFrame.getPreferredSize());
        jInternalFrame.setLocation((jDesktopPane.getWidth() - jInternalFrame.getWidth()) / 2, (jDesktopPane.getHeight() - jInternalFrame.getHeight()) / 2);
        this.jmeDesktop.setFocusOwner((Component)jOptionPane);
        jOptionPane.addPropertyChangeListener("value", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                jInternalFrame.setVisible(false);
                TestJMEDesktop.this.jmeDesktop.setModalComponent(null);
                jDesktopPane.remove(jInternalFrame);
            }
        });
    }

    private void switchLookAndFeel(int n) {
        try {
            this.theme = n;
            switch (n) {
                case 1: {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    break;
                }
                default: {
                    UIManager.setLookAndFeel(new MetalLookAndFeel());
                    this.theme = 0;
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void create3DStuff() {
        final Vector3f vector3f = new Vector3f(1.0f, 1.0f, 0.5f).normalizeLocal();
        final Box box = new Box("Box", new Vector3f(-5.0f, -5.0f, -5.0f), new Vector3f(5.0f, 5.0f, 5.0f));
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        box.setLocalTranslation(new Vector3f(0.0f, 0.0f, -10.0f));
        box.setRandomColors();
        box.setLightCombineMode(0);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestJMEDesktop.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        box.setRenderState((RenderState)textureState);
        box.addController(new Controller(){
            private static final long serialVersionUID = 1L;

            public void update(float f) {
                box.getLocalRotation().fromAngleNormalAxis(TestJMEDesktop.this.timer.getTimeInSeconds(), vector3f);
            }
        });
        this.rootNode.attachChild((Spatial)box);
    }

    protected void cleanup() {
        if (this.jmeDesktop != null) {
            this.jmeDesktop.dispose();
        }
        super.cleanup();
    }
}

