/*
 * Decompiled with CFR 0.152.
 */
package jmetest.bounds;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import java.nio.FloatBuffer;
import junit.framework.TestCase;

public class BoundsTest
extends TestCase {
    public void testMergeBox() {
        BoundingBox b1 = new BoundingBox(new Vector3f(0.0f, 0.0f, -15.0f), 10.0f, 10.0f, 0.0f);
        BoundingBox b2 = new BoundingBox(new Vector3f(0.0f, 0.0f, -5.0f), 10.0f, 10.0f, 0.0f);
        BoundingBox result = new BoundingBox();
        b1.clone((BoundingVolume)result);
        result.merge((BoundingVolume)b2);
        System.out.println("merged");
        System.out.println(b1);
        System.out.println("and");
        System.out.println(b2);
        System.out.println("to");
        System.out.println(result);
        BoundsTest.assertEquals((String)"center x", (float)0.0f, (float)result.getCenter().x, (float)1.1920929E-7f);
        BoundsTest.assertEquals((String)"center y", (float)0.0f, (float)result.getCenter().y, (float)1.1920929E-7f);
        BoundsTest.assertEquals((String)"center z", (float)-10.0f, (float)result.getCenter().z, (float)1.1920929E-7f);
        BoundsTest.assertEquals((String)"extent x", (float)10.0f, (float)result.xExtent, (float)1.1920929E-7f);
        BoundsTest.assertEquals((String)"extent y", (float)10.0f, (float)result.yExtent, (float)1.1920929E-7f);
        BoundsTest.assertEquals((String)"extent z", (float)5.0f, (float)result.zExtent, (float)1.1920929E-7f);
    }

    public void testMergeSphereOBB() {
        BoundingSphere sphere = new BoundingSphere(1.0f, new Vector3f());
        OrientedBoundingBox obb = new OrientedBoundingBox();
        obb.setCenter(new Vector3f(1.0f, 1.0f, 0.0f));
        obb.setExtent(new Vector3f(1.0f, 1.0f, 1.0f));
        BoundingSphere merged = (BoundingSphere)sphere.merge((BoundingVolume)obb);
        BoundingSphere merged2 = (BoundingSphere)merged.merge((BoundingVolume)obb);
        BoundingSphere merged3 = (BoundingSphere)merged2.merge((BoundingVolume)obb);
        System.out.println(merged);
        System.out.println(merged2);
        System.out.println(merged3);
        BoundsTest.assertEquals((String)"center", (Object)merged.getCenter(), (Object)merged2.getCenter());
        BoundsTest.assertEquals((String)"radius", (float)merged.getRadius(), (float)merged2.getRadius(), (float)1.1920929E-7f);
        BoundsTest.assertEquals((String)"center", (Object)merged.getCenter(), (Object)merged3.getCenter());
        BoundsTest.assertEquals((String)"radius", (float)merged.getRadius(), (float)merged3.getRadius(), (float)1.1920929E-7f);
    }

    public void testComputeSphereFromPoints() {
        BoundingSphere sphere = new BoundingSphere();
        float radius = 2.0f;
        this.checkPointsOnCircle(radius, sphere, 2);
        this.checkPointsOnCircle(radius, sphere, 3);
        this.checkPointsOnCircle(radius, sphere, 4);
        this.checkPointsOnCircle(radius, sphere, 5);
        this.checkPointsOnCircle(radius, sphere, 10);
        this.checkPointsOnSphere(radius, sphere, 2);
        this.checkPointsOnSphere(radius, sphere, 3);
        this.checkPointsOnSphere(radius, sphere, 4);
    }

    private void checkPointsOnCircle(float radius, BoundingSphere sphere, int points) {
        int i;
        FloatBuffer buffer = FloatBuffer.allocate(points * 2 * 3);
        for (i = 0; i < points; ++i) {
            buffer.put(FastMath.cos((float)((float)(2 * i) * (float)Math.PI / (float)points)) * ((float)i * radius / (float)points)).put(FastMath.sin((float)((float)(2 * i) * (float)Math.PI / (float)points)) * ((float)i * radius / (float)points)).put(0.0f);
        }
        for (i = 0; i < points; ++i) {
            buffer.put(FastMath.cos((float)((float)(2 * i) * (float)Math.PI / (float)points)) * radius).put(FastMath.sin((float)((float)(2 * i) * (float)Math.PI / (float)points)) * radius).put(0.0f);
        }
        sphere.computeFromPoints(buffer);
        BoundsTest.assertEquals((String)("radius from " + points * 2 + " points"), (float)radius, (float)sphere.getRadius(), (float)0.001f);
    }

    private void checkPointsOnSphere(float radius, BoundingSphere sphere, int points) {
        int i;
        FloatBuffer buffer = FloatBuffer.allocate(points * 2 * 3);
        for (i = 0; i < points; ++i) {
            buffer.put(FastMath.cos((float)((float)(2 * i) * (float)Math.PI / (float)points)) * (radius * 0.9f)).put(FastMath.sin((float)((float)(2 * i) * (float)Math.PI / (float)points)) * (radius * 0.9f)).put(0.0f);
        }
        for (i = 0; i < points; ++i) {
            buffer.put(0.0f).put(FastMath.cos((float)((float)(2 * i) * (float)Math.PI / (float)points)) * radius).put(FastMath.sin((float)((float)(2 * i) * (float)Math.PI / (float)points)) * radius);
        }
        sphere.computeFromPoints(buffer);
        BoundsTest.assertEquals((String)("radius from " + points + " points"), (float)radius, (float)sphere.getRadius(), (float)0.001f);
    }
}

