/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.effects.particles.ParticleFactory;
import com.jmex.effects.particles.ParticleInfluence;
import com.jmex.effects.particles.ParticleMesh;
import com.jmex.effects.particles.SimpleParticleInfluenceFactory;
import java.net.URL;

public class TestBatchParticles
extends SimpleGame {
    private ParticleMesh pMesh;
    private ParticleInfluence wind;

    public static void main(String[] stringArray) {
        TestBatchParticles testBatchParticles = new TestBatchParticles();
        testBatchParticles.setDialogBehaviour(2);
        testBatchParticles.start();
    }

    protected void simpleUpdate() {
    }

    protected void simpleInitGame() {
        this.display.setTitle("Particle System - Batch Particles");
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((URL)TestBatchParticles.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1);
        textureState.setTexture(texture);
        Sphere sphere = new Sphere("sp", 16, 16, 2.0f);
        sphere.setModelBound((BoundingVolume)new BoundingBox());
        sphere.updateModelBound();
        sphere.setSolidColor(ColorRGBA.white);
        sphere.setRenderState((RenderState)textureState);
        this.rootNode.attachChild((Spatial)sphere);
        this.pMesh = ParticleFactory.buildBatchParticles((String)"particles", (TriangleBatch)sphere.getBatch(0));
        this.pMesh.setEmissionDirection(new Vector3f(1.0f, 1.0f, 1.0f));
        this.pMesh.setOriginOffset(new Vector3f(0.0f, 0.0f, 0.0f));
        this.pMesh.setInitialVelocity(0.002f);
        this.pMesh.setStartSize(1.0f);
        this.pMesh.setEndSize(1.0f);
        this.pMesh.setMinimumLifeTime(1000.0f);
        this.pMesh.setMaximumLifeTime(3000.0f);
        this.pMesh.setStartColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.pMesh.setEndColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f));
        this.pMesh.setMaximumAngle(0.0f);
        this.pMesh.setParticleSpinSpeed((float)Math.PI);
        this.wind = SimpleParticleInfluenceFactory.createBasicWind((float)0.008f, (Vector3f)new Vector3f(-1.0f, 0.0f, 0.0f), (boolean)true, (boolean)true);
        this.wind.setEnabled(true);
        this.pMesh.addInfluence(this.wind);
        this.pMesh.forceRespawn();
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        alphaState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)alphaState);
        this.pMesh.setRenderState((RenderState)textureState);
        this.pMesh.setModelBound((BoundingVolume)new BoundingBox());
        this.pMesh.updateModelBound();
        this.rootNode.attachChild((Spatial)this.pMesh);
    }
}

