/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Torus;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.util.BumpMapColorController;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import java.net.URL;
import java.util.logging.Level;

public class TestBumpMapping
extends SimpleGame {
    private float angle0;
    private Torus t;

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.OFF);
        TestBumpMapping testBumpMapping = new TestBumpMapping();
        testBumpMapping.setDialogBehaviour(2);
        testBumpMapping.start();
    }

    protected void simpleUpdate() {
        this.angle0 += 2.0f * this.tpf;
        ((DirectionalLight)this.lightState.get(0)).setDirection(new Vector3f(2.0f * FastMath.cos((float)this.angle0), 2.0f * FastMath.sin((float)this.angle0), -1.5f));
    }

    protected void simpleInitGame() {
        this.t = new Torus("Torus", 30, 30, 5.0f, 10.0f);
        this.t.setModelBound((BoundingVolume)new BoundingBox());
        this.t.updateModelBound();
        BumpMapColorController bumpMapColorController = new BumpMapColorController((Spatial)this.t);
        this.t.addController((Controller)bumpMapColorController);
        MaterialState materialState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
        materialState.setColorMaterial(2);
        this.t.setRenderState((RenderState)materialState);
        this.t.updateRenderState();
        this.rootNode.attachChild((Spatial)this.t);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((URL)TestBumpMapping.class.getClassLoader().getResource("jmetest/data/texture/NormalMap.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        texture.setApply(4);
        texture.setCombineFuncRGB(6);
        texture.setCombineSrc0RGB(0);
        texture.setCombineSrc1RGB(1);
        textureState.setTexture(texture, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestBumpMapping.class.getClassLoader().getResource("jmetest/data/texture/decal.PNG"), (int)6, (int)1, (float)1.0f, (boolean)true);
        texture2.setApply(4);
        texture2.setWrap(3);
        texture2.setCombineFuncRGB(1);
        texture2.setCombineSrc0RGB(3);
        texture2.setCombineSrc1RGB(0);
        textureState.setTexture(texture2, 1);
        this.t.copyTextureCoords(0, 0, 1);
        this.t.getBatch(0).scaleTextureCoordinates(0, 8.0f);
        this.t.setRenderState((RenderState)textureState);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.t.setRenderState((RenderState)zBufferState);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setAmbient(new ColorRGBA(0.75f, 0.75f, 0.75f, 1.0f));
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setEnabled(true);
        directionalLight.setDirection(new Vector3f(1.0f, 1.0f, -1.0f));
        this.lightState.detachAll();
        this.lightState.attach((Light)directionalLight);
        this.rootNode.updateRenderState();
        this.rootNode.updateGeometricState(0.0f, true);
    }
}

