/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.ZBufferState;
import com.jmex.effects.particles.ParticleFactory;
import com.jmex.effects.particles.ParticlePoints;

public class TestPointParticles
extends SimpleGame {
    private ParticlePoints pPoints;
    private Vector3f currentPos = new Vector3f();
    private Vector3f newPos = new Vector3f();
    private float frameRate = 0.0f;

    public static void main(String[] stringArray) {
        TestPointParticles testPointParticles = new TestPointParticles();
        testPointParticles.setDialogBehaviour(2);
        testPointParticles.start();
    }

    protected void simpleUpdate() {
        if (this.tpf > 1.0f) {
            this.tpf = 1.0f;
        }
        if ((int)this.currentPos.x == (int)this.newPos.x && (int)this.currentPos.y == (int)this.newPos.y && (int)this.currentPos.z == (int)this.newPos.z) {
            this.newPos.x = (float)Math.random() * 50.0f - 25.0f;
            this.newPos.y = (float)Math.random() * 50.0f - 25.0f;
            this.newPos.z = (float)Math.random() * 50.0f - 150.0f;
        }
        this.frameRate = this.timer.getFrameRate() / 2.0f;
        this.currentPos.x -= (this.currentPos.x - this.newPos.x) / this.frameRate;
        this.currentPos.y -= (this.currentPos.y - this.newPos.y) / this.frameRate;
        this.currentPos.z -= (this.currentPos.z - this.newPos.z) / this.frameRate;
        this.pPoints.setOriginOffset(this.currentPos);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Particle System - Point Particles");
        this.lightState.setEnabled(false);
        this.pPoints = ParticleFactory.buildPointParticles((String)"particles", (int)300);
        this.pPoints.setPointSize(5.0f);
        this.pPoints.setAntialiased(true);
        this.pPoints.setEmissionDirection(new Vector3f(0.0f, 1.0f, 0.0f));
        this.pPoints.setOriginOffset(new Vector3f(0.0f, 0.0f, 0.0f));
        this.pPoints.setInitialVelocity(0.006f);
        this.pPoints.setStartSize(2.5f);
        this.pPoints.setEndSize(0.5f);
        this.pPoints.setMinimumLifeTime(1200.0f);
        this.pPoints.setMaximumLifeTime(1400.0f);
        this.pPoints.setStartColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        this.pPoints.setEndColor(new ColorRGBA(0.0f, 1.0f, 0.0f, 0.0f));
        this.pPoints.setMaximumAngle((float)Math.PI * 2);
        this.pPoints.getParticleController().setControlFlow(false);
        this.pPoints.warmUp(120);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)alphaState);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(false);
        this.pPoints.setRenderState((RenderState)zBufferState);
        this.pPoints.setModelBound((BoundingVolume)new BoundingSphere());
        this.pPoints.updateModelBound();
        this.rootNode.attachChild((Spatial)this.pPoints);
    }
}

