/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects.cloth;

import com.jme.animation.SpatialTransformer;
import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.CollisionTreeManager;
import com.jme.input.KeyBindingManager;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.math.spring.SpringPointForce;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.effects.cloth.ClothUtils;
import com.jmex.effects.cloth.CollidingClothPatch;
import java.net.URL;

public class TestCloth
extends SimpleGame {
    private CollidingClothPatch cloth;
    private float windStrength = 40.0f;
    private Vector3f windDirection = new Vector3f(0.3f, 0.0f, 0.8f);
    private SpringPointForce wind;
    private SpringPointForce gravity;
    private SpringPointForce drag;
    private Sphere sphere;

    public static void main(String[] stringArray) {
        TestCloth testCloth = new TestCloth();
        testCloth.setDialogBehaviour(2);
        testCloth.start();
    }

    public void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("wind", false)) {
            this.wind.setEnabled(!this.wind.isEnabled());
            System.err.println("wind is: " + (this.wind.isEnabled() ? "on" : "off"));
        }
    }

    protected void simpleInitGame() {
        this.display.setTitle("jME Cloth Demo");
        KeyBindingManager.getKeyBindingManager().set("wind", 28);
        ((PointLight)this.lightState.get(0)).setLocation(new Vector3f(0.0f, -30.0f, 150.0f));
        this.lightState.setTwoSidedLighting(true);
        this.cam.setLocation(new Vector3f(0.0f, -30.0f, 100.0f));
        this.cam.update();
        this.cloth = new CollidingClothPatch("cloth", 50, 50, 1.0f, 10.0f);
        this.wind = ClothUtils.createBasicWind((float)this.windStrength, (Vector3f)this.windDirection, (boolean)true);
        this.cloth.addForce(this.wind);
        this.gravity = ClothUtils.createBasicGravity();
        this.cloth.addForce(this.gravity);
        this.drag = ClothUtils.createBasicDrag((float)20.0f);
        this.cloth.addForce(this.drag);
        CollisionTreeManager.getInstance().setTreeType(1);
        this.sphere = new Sphere("sphere", 20, 20, 6.0f);
        this.sphere.setModelBound((BoundingVolume)new BoundingBox());
        this.sphere.updateModelBound();
        this.rootNode.attachChild((Spatial)this.sphere);
        SpatialTransformer spatialTransformer = new SpatialTransformer(1);
        spatialTransformer.setObject((Spatial)this.sphere, 0, -1);
        spatialTransformer.setPosition(0, 0.0f, new Vector3f(10.0f, 10.0f, 30.0f));
        spatialTransformer.setPosition(0, 2.0f, new Vector3f(-10.0f, -10.0f, -30.0f));
        spatialTransformer.interpolateMissing();
        spatialTransformer.setRepeatType(2);
        this.sphere.addController((Controller)spatialTransformer);
        this.cloth.addCollider((TriMesh)this.sphere);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)TestCloth.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1));
        this.cloth.setRenderState((RenderState)textureState);
        this.rootNode.attachChild((Spatial)this.cloth);
        for (int i = 0; i < 50; ++i) {
            this.cloth.getSystem().getNode((int)i).position.x *= 0.8f;
            this.cloth.getSystem().getNode(i).setMass(Float.POSITIVE_INFINITY);
        }
    }
}

