/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects.glsl;

import com.jme.app.SimplePassGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.KeyBindingManager;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.pass.Pass;
import com.jme.renderer.pass.RenderPass;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Quad;
import com.jme.scene.shape.Sphere;
import com.jme.scene.shape.Torus;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.effects.glsl.MotionBlurRenderPass;
import java.net.URL;

public class TestMotionBlur
extends SimplePassGame {
    private MotionBlurRenderPass motionBlurRenderPass;
    private int screenshotIndex = 0;
    private Node debugQuadsNode;
    private Spatial torus;
    private Spatial sphere;

    public static void main(String[] stringArray) {
        TestMotionBlur testMotionBlur = new TestMotionBlur();
        testMotionBlur.setDialogBehaviour(2);
        testMotionBlur.start();
    }

    protected void cleanup() {
        super.cleanup();
        if (this.motionBlurRenderPass != null) {
            this.motionBlurRenderPass.cleanup();
        }
    }

    protected void simpleInitGame() {
        Text text;
        this.display.setTitle("MotionBlur Test");
        this.cam.setFrustumPerspective(45.0f, (float)this.display.getWidth() / (float)this.display.getHeight(), 1.0f, 5000.0f);
        this.cam.setLocation(new Vector3f(200.0f, 150.0f, 200.0f));
        this.cam.lookAt(new Vector3f(0.0f, 0.0f, 0.0f), Vector3f.UNIT_Y);
        this.cam.update();
        this.setupKeyBindings();
        PointLight pointLight = new PointLight();
        pointLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        pointLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        pointLight.setLocation(new Vector3f(0.0f, 30.0f, 0.0f));
        pointLight.setEnabled(true);
        this.lightState.attach((Light)pointLight);
        this.rootNode.attachChild((Spatial)this.createObjects());
        RenderPass renderPass = new RenderPass();
        renderPass.add((Spatial)this.rootNode);
        this.pManager.add((Pass)renderPass);
        this.motionBlurRenderPass = new MotionBlurRenderPass(this.cam);
        if (!this.motionBlurRenderPass.isSupported()) {
            text = new Text("Text", "GLSL Not supported on this computer.");
            text.setRenderQueueMode(4);
            text.setLightCombineMode(0);
            text.setLocalTranslation(new Vector3f(0.0f, 20.0f, 0.0f));
            this.fpsNode.attachChild((Spatial)text);
        } else {
            this.motionBlurRenderPass.add((Spatial)this.rootNode);
            this.motionBlurRenderPass.addMotionBlurSpatial(this.sphere);
            this.motionBlurRenderPass.addMotionBlurSpatial(this.torus);
            this.motionBlurRenderPass.setUseCurrentScene(true);
            this.pManager.add((Pass)this.motionBlurRenderPass);
        }
        this.createDebugQuads();
        this.fpsNode.attachChild((Spatial)this.debugQuadsNode);
        text = new RenderPass();
        text.add((Spatial)this.fpsNode);
        this.pManager.add((Pass)text);
    }

    protected void simpleUpdate() {
        if (!this.motionBlurRenderPass.isFreeze()) {
            float f = (FastMath.sin((float)(this.timer.getTimeInSeconds() * 0.5f)) + 1.0f) * 10.0f;
            this.torus.getLocalRotation().fromAngles(f * 2.0f, f * 2.0f, f * 1.0f);
            this.torus.getLocalTranslation().x = FastMath.sin((float)(f * 1.0f)) * 100.0f;
            this.torus.getLocalTranslation().z = FastMath.cos((float)(f * 1.0f)) * 100.0f;
            float f2 = (FastMath.sin((float)(this.timer.getTimeInSeconds() * 10.0f)) + 2.0f) * 0.5f;
            this.sphere.getLocalScale().set(f2, f2, f2);
            this.sphere.getLocalTranslation().z = FastMath.sin((float)(f * 1.0f)) * 200.0f;
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("1", false)) {
            this.motionBlurRenderPass.setEnabled(!this.motionBlurRenderPass.isEnabled());
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("2", false)) {
            this.motionBlurRenderPass.setBlurStrength(this.motionBlurRenderPass.getBlurStrength() * 0.5f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("3", false)) {
            this.motionBlurRenderPass.setBlurStrength(this.motionBlurRenderPass.getBlurStrength() * 2.0f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("f", false)) {
            this.motionBlurRenderPass.setFreeze(!this.motionBlurRenderPass.isFreeze());
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("g", false)) {
            this.motionBlurRenderPass.reloadShader();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("0", false)) {
            this.motionBlurRenderPass.resetParameters();
            this.motionBlurRenderPass.setUseCurrentScene(true);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("shot", false)) {
            this.display.getRenderer().takeScreenShot("shot" + this.screenshotIndex++);
        }
    }

    private void setupKeyBindings() {
        KeyBindingManager.getKeyBindingManager().set("1", 2);
        KeyBindingManager.getKeyBindingManager().set("2", 3);
        KeyBindingManager.getKeyBindingManager().set("3", 4);
        KeyBindingManager.getKeyBindingManager().set("0", 11);
        KeyBindingManager.getKeyBindingManager().set("g", 34);
        KeyBindingManager.getKeyBindingManager().set("f", 33);
        KeyBindingManager.getKeyBindingManager().set("shot", 62);
        Text text = new Text("Text", "1: enable/disable motionblur pass");
        text.setRenderQueueMode(4);
        text.setLightCombineMode(0);
        text.setLocalTranslation(new Vector3f(0.0f, 20.0f, 1.0f));
        this.fpsNode.attachChild((Spatial)text);
        text = new Text("Text", "2/3: decrease/increase blur strength");
        text.setRenderQueueMode(4);
        text.setLightCombineMode(0);
        text.setLocalTranslation(new Vector3f(0.0f, 40.0f, 1.0f));
        this.fpsNode.attachChild((Spatial)text);
        text = new Text("Text", "f: freeze/unfreeze movement");
        text.setRenderQueueMode(4);
        text.setLightCombineMode(0);
        text.setLocalTranslation(new Vector3f(0.0f, 60.0f, 1.0f));
        this.fpsNode.attachChild((Spatial)text);
    }

    private Node createObjects() {
        Node node = new Node("objects");
        this.torus = new Torus("Torus", 50, 50, 10.0f, 25.0f);
        this.torus.setLocalTranslation(new Vector3f(50.0f, -5.0f, 20.0f));
        TextureState textureState = this.display.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)TestMotionBlur.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1);
        Texture texture2 = TextureManager.loadTexture((URL)TestMotionBlur.class.getClassLoader().getResource("jmetest/data/texture/north.jpg"), (int)6, (int)1);
        texture2.setEnvironmentalMapMode(2);
        textureState.setTexture(texture, 0);
        textureState.setTexture(texture2, 1);
        textureState.setEnabled(true);
        this.torus.setRenderState((RenderState)textureState);
        node.attachChild(this.torus);
        textureState = this.display.getRenderer().createTextureState();
        texture = TextureManager.loadTexture((URL)TestMotionBlur.class.getClassLoader().getResource("jmetest/data/texture/wall.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        textureState = this.display.getRenderer().createTextureState();
        texture = TextureManager.loadTexture((URL)TestMotionBlur.class.getClassLoader().getResource("jmetest/data/texture/cloud_land.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        this.sphere = new Sphere("sphere", 16, 16, 10.0f);
        this.sphere.setLocalTranslation(new Vector3f(0.0f, -10.0f, 15.0f));
        this.sphere.setRenderState((RenderState)textureState);
        node.attachChild(this.sphere);
        Box box = new Box("floor", new Vector3f(-1000.0f, -10.0f, -1000.0f), new Vector3f(1000.0f, 10.0f, 1000.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -100.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        node.attachChild((Spatial)box);
        textureState = this.display.getRenderer().createTextureState();
        texture = TextureManager.loadTexture((URL)TestMotionBlur.class.getClassLoader().getResource("jmetest/data/texture/wall.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        box = new Box("box1", new Vector3f(-10.0f, -10.0f, -10.0f), new Vector3f(10.0f, 10.0f, 10.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -20.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        box = new Box("box2", new Vector3f(-5.0f, -5.0f, -5.0f), new Vector3f(5.0f, 5.0f, 5.0f));
        box.setLocalTranslation(new Vector3f(15.0f, 30.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        box = new Box("box3", new Vector3f(-5.0f, -5.0f, -5.0f), new Vector3f(5.0f, 5.0f, 5.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -10.0f, 45.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        return node;
    }

    private void createDebugQuads() {
        this.debugQuadsNode = new Node("quadNode");
        this.debugQuadsNode.setCullMode(3);
        float f = this.display.getWidth() / 8;
        float f2 = this.display.getWidth() / 8;
        Quad quad = new Quad("reflectionQuad", f, f2);
        quad.setRenderQueueMode(4);
        quad.setCullMode(3);
        quad.setLightCombineMode(0);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(this.motionBlurRenderPass.getMainTexture());
        quad.setRenderState((RenderState)textureState);
        quad.updateRenderState();
        quad.getLocalTranslation().set(f * 0.6f, f2 * 1.0f, 1.0f);
        this.debugQuadsNode.attachChild((Spatial)quad);
    }
}

