/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects.transients;

import com.jme.app.VariableTimestepGame;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Pyramid;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import com.jmex.effects.transients.FadeInOut;
import com.jmex.effects.transients.FadeInOutController;
import java.net.URL;

public class TestFadeInOutTransientEffect
extends VariableTimestepGame {
    private Camera cam;
    private FadeInOut fio;
    private FadeInOutController fioC;
    private Node rootNode;
    private Node fadeOutNode;
    private Node fadeInNode;

    protected void update(float f) {
        this.rootNode.updateWorldData(f * 10.0f);
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.rootNode);
        this.display.getRenderer().clearStatistics();
    }

    protected void initSystem() {
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth(), this.properties.getFreq(), this.properties.getFullscreen());
            this.display.setTitle("FadeInOut Test");
            this.cam = this.display.getRenderer().createCamera(this.properties.getWidth(), this.properties.getHeight());
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        this.display.getRenderer().setBackgroundColor(new ColorRGBA(0.1f, 0.1f, 0.0f, 1.0f));
        this.cam.setFrustum(1.0f, 1000.0f, -0.55f, 0.55f, 0.4125f, -0.4125f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 5.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.display.getRenderer().setCamera(this.cam);
        this.display.getRenderer().enableStatistics(true);
    }

    protected void initGame() {
        this.rootNode = new Node("Scene Graph Root Node");
        this.fadeOutNode = new Node("Fade Out Node");
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        this.setFadeOutNode();
        this.setFadeInNode();
        Quad quad = new Quad("Fade Quad");
        quad.initialize(5.0f, 5.0f);
        quad.setColorBuffer(0, null);
        quad.getLocalTranslation().z = 1.0f;
        this.fio = new FadeInOut("FadeInOut", (Geometry)quad, this.fadeOutNode, this.fadeInNode, new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f), 0.01f);
        this.fio.setLocalTranslation(new Vector3f(0.0f, 0.0f, 1.0f));
        this.fioC = new FadeInOutController(this.fio);
        this.fio.addController((Controller)this.fioC);
        this.rootNode.setRenderState((RenderState)zBufferState);
        this.rootNode.attachChild((Spatial)this.fio);
        this.rootNode.attachChild((Spatial)quad);
        this.rootNode.updateRenderState();
    }

    private void setFadeOutNode() {
        this.fadeOutNode = new Node("FadeOut Node");
        Vector3f vector3f = new Vector3f(-0.1f, -0.1f, -0.1f);
        Vector3f vector3f2 = new Vector3f(0.1f, 0.1f, 0.1f);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)TestFadeInOutTransientEffect.class.getClassLoader().getResource("jmetest/data/images/Monkey.png"), (int)2, (int)1));
        textureState.setEnabled(true);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis(45.0f, new Vector3f(1.0f, 1.0f, 0.0f));
        Box box = new Box("FadeOutBox", vector3f.mult(5.0f), vector3f2.mult(5.0f));
        box.setLocalRotation(quaternion);
        box.setRenderState((RenderState)textureState);
        this.fadeOutNode.attachChild((Spatial)box);
    }

    private void setFadeInNode() {
        this.fadeInNode = new Node("FadeIn Node");
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)TestFadeInOutTransientEffect.class.getClassLoader().getResource("jmetest/data/images/Monkey.png"), (int)2, (int)1));
        textureState.setEnabled(true);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis(45.0f, new Vector3f(1.0f, 1.0f, 0.0f));
        Pyramid pyramid = new Pyramid("FadeInPyramid", 2.0f, 3.0f);
        pyramid.setLocalRotation(quaternion);
        pyramid.setRenderState((RenderState)textureState);
        this.fadeInNode.attachChild((Spatial)pyramid);
    }

    protected void reinit() {
    }

    protected void cleanup() {
    }

    public static void main(String[] stringArray) {
        TestFadeInOutTransientEffect testFadeInOutTransientEffect = new TestFadeInOutTransientEffect();
        testFadeInOutTransientEffect.setDialogBehaviour(1);
        testFadeInOutTransientEffect.start();
    }
}

