/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects.water;

import com.jme.app.SimplePassGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.KeyBindingManager;
import com.jme.math.Plane;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.pass.Pass;
import com.jme.renderer.pass.RenderPass;
import com.jme.scene.Node;
import com.jme.scene.Skybox;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Quad;
import com.jme.scene.shape.Torus;
import com.jme.scene.state.CullState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.TextureManager;
import com.jmex.effects.water.HeightGenerator;
import com.jmex.effects.water.ProjectedGrid;
import com.jmex.effects.water.WaterHeightGenerator;
import com.jmex.effects.water.WaterRenderPass;
import java.net.URL;
import jmetest.effects.water.TestSimpleQuadWater;

public class TestProjectedWater
extends SimplePassGame {
    private WaterRenderPass waterEffectRenderPass;
    private Skybox skybox;
    private ProjectedGrid projectedGrid;
    private float farPlane = 10000.0f;
    private Node debugQuadsNode;

    public static void main(String[] stringArray) {
        TestProjectedWater testProjectedWater = new TestProjectedWater();
        testProjectedWater.setDialogBehaviour(2);
        testProjectedWater.start();
    }

    protected void cleanup() {
        super.cleanup();
        this.waterEffectRenderPass.cleanup();
    }

    protected void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("f", false)) {
            this.projectedGrid.switchFreeze();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("e", false)) {
            this.switchShowDebug();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("g", false)) {
            this.waterEffectRenderPass.setUseRefraction(!this.waterEffectRenderPass.isUseRefraction());
            this.waterEffectRenderPass.reloadShader();
        }
        this.skybox.getLocalTranslation().set(this.cam.getLocation());
        this.cam.update();
    }

    protected void simpleInitGame() {
        this.display.setTitle("Water Test");
        this.cam.setFrustumPerspective(45.0f, (float)this.display.getWidth() / (float)this.display.getHeight(), 1.0f, this.farPlane);
        this.cam.setLocation(new Vector3f(100.0f, 50.0f, 100.0f));
        this.cam.lookAt(new Vector3f(0.0f, 0.0f, 0.0f), Vector3f.UNIT_Y);
        this.cam.update();
        this.setupKeyBindings();
        this.setupFog();
        Node node = new Node("reflectNode");
        this.buildSkyBox();
        node.attachChild((Spatial)this.skybox);
        node.attachChild((Spatial)this.createObjects());
        this.rootNode.attachChild((Spatial)node);
        this.waterEffectRenderPass = new WaterRenderPass(this.cam, 4, true, true);
        this.waterEffectRenderPass.setClipBias(0.5f);
        this.waterEffectRenderPass.setWaterMaxAmplitude(5.0f);
        this.waterEffectRenderPass.setWaterPlane(new Plane(new Vector3f(0.0f, 1.0f, 0.0f), 0.0f));
        this.projectedGrid = new ProjectedGrid("ProjectedGrid", this.cam, 100, 70, 0.01f, (HeightGenerator)new WaterHeightGenerator());
        this.waterEffectRenderPass.setWaterEffectOnSpatial((Spatial)this.projectedGrid);
        this.rootNode.attachChild((Spatial)this.projectedGrid);
        this.createDebugQuads();
        this.rootNode.attachChild((Spatial)this.debugQuadsNode);
        this.waterEffectRenderPass.setReflectedScene((Spatial)node);
        this.waterEffectRenderPass.setSkybox((Node)this.skybox);
        this.pManager.add((Pass)this.waterEffectRenderPass);
        RenderPass renderPass = new RenderPass();
        renderPass.add((Spatial)this.rootNode);
        this.pManager.add((Pass)renderPass);
        RenderPass renderPass2 = new RenderPass();
        renderPass2.add((Spatial)this.fpsNode);
        this.pManager.add((Pass)renderPass2);
        this.rootNode.setCullMode(3);
        this.rootNode.setRenderQueueMode(2);
        this.fpsNode.setRenderQueueMode(2);
    }

    private void setupFog() {
        FogState fogState = this.display.getRenderer().createFogState();
        fogState.setDensity(1.0f);
        fogState.setEnabled(true);
        fogState.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        fogState.setEnd(this.farPlane);
        fogState.setStart(this.farPlane / 10.0f);
        fogState.setDensityFunction(0);
        fogState.setApplyFunction(0);
        this.rootNode.setRenderState((RenderState)fogState);
    }

    private void buildSkyBox() {
        this.skybox = new Skybox("skybox", 10.0f, 10.0f, 10.0f);
        String string = "jmetest/effects/water/data/";
        Texture texture = TextureManager.loadTexture((URL)TestProjectedWater.class.getClassLoader().getResource(string + "1.jpg"), (int)2, (int)1);
        Texture texture2 = TextureManager.loadTexture((URL)TestProjectedWater.class.getClassLoader().getResource(string + "3.jpg"), (int)2, (int)1);
        Texture texture3 = TextureManager.loadTexture((URL)TestProjectedWater.class.getClassLoader().getResource(string + "2.jpg"), (int)2, (int)1);
        Texture texture4 = TextureManager.loadTexture((URL)TestProjectedWater.class.getClassLoader().getResource(string + "4.jpg"), (int)2, (int)1);
        Texture texture5 = TextureManager.loadTexture((URL)TestProjectedWater.class.getClassLoader().getResource(string + "6.jpg"), (int)2, (int)1);
        Texture texture6 = TextureManager.loadTexture((URL)TestProjectedWater.class.getClassLoader().getResource(string + "5.jpg"), (int)2, (int)1);
        this.skybox.setTexture(0, texture);
        this.skybox.setTexture(3, texture4);
        this.skybox.setTexture(1, texture2);
        this.skybox.setTexture(2, texture3);
        this.skybox.setTexture(4, texture5);
        this.skybox.setTexture(5, texture6);
        this.skybox.preloadTextures();
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(0);
        cullState.setEnabled(true);
        this.skybox.setRenderState((RenderState)cullState);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(false);
        this.skybox.setRenderState((RenderState)zBufferState);
        FogState fogState = this.display.getRenderer().createFogState();
        fogState.setEnabled(false);
        this.skybox.setRenderState((RenderState)fogState);
        this.skybox.setLightCombineMode(0);
        this.skybox.setCullMode(3);
        this.skybox.setTextureCombineMode(5);
        this.skybox.updateRenderState();
        this.skybox.lockBounds();
        this.skybox.lockMeshes();
    }

    private Node createObjects() {
        Node node = new Node("objects");
        Torus torus = new Torus("Torus", 50, 50, 10.0f, 20.0f);
        torus.setLocalTranslation(new Vector3f(50.0f, -5.0f, 20.0f));
        TextureState textureState = this.display.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)TestProjectedWater.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1);
        Texture texture2 = TextureManager.loadTexture((URL)TestProjectedWater.class.getClassLoader().getResource("jmetest/data/texture/north.jpg"), (int)6, (int)1);
        texture2.setEnvironmentalMapMode(2);
        textureState.setTexture(texture, 0);
        textureState.setTexture(texture2, 1);
        textureState.setEnabled(true);
        torus.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)torus);
        textureState = this.display.getRenderer().createTextureState();
        texture = TextureManager.loadTexture((URL)TestProjectedWater.class.getClassLoader().getResource("jmetest/data/texture/wall.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        Box box = new Box("box1", new Vector3f(-10.0f, -10.0f, -10.0f), new Vector3f(10.0f, 10.0f, 10.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -7.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        box = new Box("box2", new Vector3f(-5.0f, -5.0f, -5.0f), new Vector3f(5.0f, 5.0f, 5.0f));
        box.setLocalTranslation(new Vector3f(15.0f, 10.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        box = new Box("box3", new Vector3f(-5.0f, -5.0f, -5.0f), new Vector3f(5.0f, 5.0f, 5.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -10.0f, 15.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        box = new Box("box4", new Vector3f(-5.0f, -5.0f, -5.0f), new Vector3f(5.0f, 5.0f, 5.0f));
        box.setLocalTranslation(new Vector3f(20.0f, 0.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        textureState = this.display.getRenderer().createTextureState();
        texture = TextureManager.loadTexture((URL)TestSimpleQuadWater.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        box = new Box("box5", new Vector3f(-50.0f, -2.0f, -50.0f), new Vector3f(50.0f, 2.0f, 50.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -15.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        node.attachChild((Spatial)box);
        return node;
    }

    private void setupKeyBindings() {
        KeyBindingManager.getKeyBindingManager().set("f", 33);
        KeyBindingManager.getKeyBindingManager().set("e", 18);
        KeyBindingManager.getKeyBindingManager().set("g", 34);
        Text text = new Text("Text", "F: switch freeze/unfreeze projected grid");
        text.setRenderQueueMode(4);
        text.setLightCombineMode(0);
        text.setLocalTranslation(new Vector3f(0.0f, 20.0f, 1.0f));
        this.fpsNode.attachChild((Spatial)text);
        text = new Text("Text", "E: debug show/hide reflection and refraction textures");
        text.setRenderQueueMode(4);
        text.setLightCombineMode(0);
        text.setLocalTranslation(new Vector3f(0.0f, 40.0f, 1.0f));
        this.fpsNode.attachChild((Spatial)text);
    }

    private void switchShowDebug() {
        if (this.debugQuadsNode.getCullMode() == 3) {
            this.debugQuadsNode.setCullMode(2);
        } else {
            this.debugQuadsNode.setCullMode(3);
        }
    }

    private void createDebugQuads() {
        this.debugQuadsNode = new Node("quadNode");
        this.debugQuadsNode.setCullMode(3);
        float f = this.display.getWidth() / 8;
        float f2 = this.display.getWidth() / 8;
        Quad quad = new Quad("reflectionQuad", f, f2);
        quad.setRenderQueueMode(4);
        quad.setCullMode(3);
        quad.setLightCombineMode(0);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(this.waterEffectRenderPass.getTextureReflect());
        quad.setRenderState((RenderState)textureState);
        quad.updateRenderState();
        quad.getLocalTranslation().set(f * 0.6f, f2 * 1.0f, 1.0f);
        this.debugQuadsNode.attachChild((Spatial)quad);
        if (this.waterEffectRenderPass.getTextureRefract() != null) {
            quad = new Quad("refractionQuad", f, f2);
            quad.setRenderQueueMode(4);
            quad.setCullMode(3);
            quad.setLightCombineMode(0);
            textureState = this.display.getRenderer().createTextureState();
            textureState.setTexture(this.waterEffectRenderPass.getTextureRefract());
            quad.setRenderState((RenderState)textureState);
            quad.updateRenderState();
            quad.getLocalTranslation().set(f * 0.6f, f2 * 2.1f, 1.0f);
            this.debugQuadsNode.attachChild((Spatial)quad);
        }
    }
}

