/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects.water;

import com.jme.app.SimplePassGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.KeyBindingManager;
import com.jme.math.Plane;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.pass.Pass;
import com.jme.renderer.pass.RenderPass;
import com.jme.scene.Node;
import com.jme.scene.Skybox;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Quad;
import com.jme.scene.shape.Torus;
import com.jme.scene.state.CullState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.TextureManager;
import com.jmex.effects.water.WaterRenderPass;
import java.net.URL;
import java.nio.FloatBuffer;
import jmetest.effects.water.TestSimpleQuadWater;

public class TestQuadWater
extends SimplePassGame {
    private WaterRenderPass waterEffectRenderPass;
    private Skybox skybox;
    private Quad waterQuad;
    private float farPlane = 10000.0f;
    private float textureScale = 0.02f;
    private Node debugQuadsNode;

    public static void main(String[] stringArray) {
        TestQuadWater testQuadWater = new TestQuadWater();
        testQuadWater.setDialogBehaviour(2);
        testQuadWater.start();
    }

    protected void cleanup() {
        super.cleanup();
        this.waterEffectRenderPass.cleanup();
    }

    protected void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("g", false)) {
            this.waterEffectRenderPass.reloadShader();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("e", false)) {
            this.switchShowDebug();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("1", false)) {
            this.waterEffectRenderPass.resetParameters();
            this.textureScale = 0.02f;
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("2", false)) {
            this.waterEffectRenderPass.setWaterColorStart(ColorRGBA.black);
            this.waterEffectRenderPass.setWaterColorEnd(ColorRGBA.black);
            this.textureScale = 0.01f;
            this.waterEffectRenderPass.setSpeedReflection(0.05f);
            this.waterEffectRenderPass.setSpeedRefraction(0.01f);
        }
        float f = this.timer.getTimePerFrame();
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("lower", true)) {
            this.waterEffectRenderPass.setWaterHeight(this.waterEffectRenderPass.getWaterHeight() - f * 10.0f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("higher", true)) {
            this.waterEffectRenderPass.setWaterHeight(this.waterEffectRenderPass.getWaterHeight() + f * 10.0f);
        }
        this.skybox.getLocalTranslation().set(this.cam.getLocation());
        this.skybox.updateGeometricState(0.0f, true);
        Vector3f vector3f = new Vector3f(this.cam.getLocation().x, this.waterEffectRenderPass.getWaterHeight(), this.cam.getLocation().z);
        this.setTextureCoords(0, vector3f.x, -vector3f.z, this.textureScale);
        this.setVertexCoords(vector3f.x, vector3f.y, vector3f.z);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Water Test");
        this.cam.setFrustumPerspective(45.0f, (float)this.display.getWidth() / (float)this.display.getHeight(), 1.0f, this.farPlane);
        this.cam.setLocation(new Vector3f(100.0f, 50.0f, 100.0f));
        this.cam.lookAt(new Vector3f(0.0f, 0.0f, 0.0f), Vector3f.UNIT_Y);
        this.cam.update();
        this.setupKeyBindings();
        this.setupFog();
        Node node = new Node("reflectNode");
        this.buildSkyBox();
        node.attachChild((Spatial)this.skybox);
        node.attachChild((Spatial)this.createObjects());
        this.rootNode.attachChild((Spatial)node);
        this.waterEffectRenderPass = new WaterRenderPass(this.cam, 4, false, true);
        this.waterEffectRenderPass.setWaterPlane(new Plane(new Vector3f(0.0f, 1.0f, 0.0f), 0.0f));
        this.waterQuad = new Quad("waterQuad", 1.0f, 1.0f);
        FloatBuffer floatBuffer = this.waterQuad.getNormalBuffer(0);
        floatBuffer.clear();
        floatBuffer.put(0.0f).put(1.0f).put(0.0f);
        floatBuffer.put(0.0f).put(1.0f).put(0.0f);
        floatBuffer.put(0.0f).put(1.0f).put(0.0f);
        floatBuffer.put(0.0f).put(1.0f).put(0.0f);
        this.waterEffectRenderPass.setWaterEffectOnSpatial((Spatial)this.waterQuad);
        this.rootNode.attachChild((Spatial)this.waterQuad);
        this.createDebugQuads();
        this.rootNode.attachChild((Spatial)this.debugQuadsNode);
        this.waterEffectRenderPass.setReflectedScene((Spatial)node);
        this.waterEffectRenderPass.setSkybox((Node)this.skybox);
        this.pManager.add((Pass)this.waterEffectRenderPass);
        RenderPass renderPass = new RenderPass();
        renderPass.add((Spatial)this.rootNode);
        this.pManager.add((Pass)renderPass);
        RenderPass renderPass2 = new RenderPass();
        renderPass2.add((Spatial)this.fpsNode);
        this.pManager.add((Pass)renderPass2);
        this.rootNode.setCullMode(3);
        this.rootNode.setRenderQueueMode(2);
        this.fpsNode.setRenderQueueMode(2);
    }

    private void setVertexCoords(float f, float f2, float f3) {
        FloatBuffer floatBuffer = this.waterQuad.getVertexBuffer(0);
        floatBuffer.clear();
        floatBuffer.put(f - this.farPlane).put(f2).put(f3 - this.farPlane);
        floatBuffer.put(f - this.farPlane).put(f2).put(f3 + this.farPlane);
        floatBuffer.put(f + this.farPlane).put(f2).put(f3 + this.farPlane);
        floatBuffer.put(f + this.farPlane).put(f2).put(f3 - this.farPlane);
    }

    private void setTextureCoords(int n, float f, float f2, float f3) {
        f *= f3 * 0.5f;
        f2 *= f3 * 0.5f;
        f3 = this.farPlane * f3;
        FloatBuffer floatBuffer = this.waterQuad.getTextureBuffer(0, n);
        floatBuffer.clear();
        floatBuffer.put(f).put(f3 + f2);
        floatBuffer.put(f).put(f2);
        floatBuffer.put(f3 + f).put(f2);
        floatBuffer.put(f3 + f).put(f3 + f2);
    }

    private void setupFog() {
        FogState fogState = this.display.getRenderer().createFogState();
        fogState.setDensity(1.0f);
        fogState.setEnabled(true);
        fogState.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        fogState.setEnd(this.farPlane);
        fogState.setStart(this.farPlane / 10.0f);
        fogState.setDensityFunction(0);
        fogState.setApplyFunction(0);
        this.rootNode.setRenderState((RenderState)fogState);
    }

    private void buildSkyBox() {
        this.skybox = new Skybox("skybox", 10.0f, 10.0f, 10.0f);
        String string = "jmetest/effects/water/data/";
        Texture texture = TextureManager.loadTexture((URL)TestQuadWater.class.getClassLoader().getResource(string + "1.jpg"), (int)2, (int)1);
        Texture texture2 = TextureManager.loadTexture((URL)TestQuadWater.class.getClassLoader().getResource(string + "3.jpg"), (int)2, (int)1);
        Texture texture3 = TextureManager.loadTexture((URL)TestQuadWater.class.getClassLoader().getResource(string + "2.jpg"), (int)2, (int)1);
        Texture texture4 = TextureManager.loadTexture((URL)TestQuadWater.class.getClassLoader().getResource(string + "4.jpg"), (int)2, (int)1);
        Texture texture5 = TextureManager.loadTexture((URL)TestQuadWater.class.getClassLoader().getResource(string + "6.jpg"), (int)2, (int)1);
        Texture texture6 = TextureManager.loadTexture((URL)TestQuadWater.class.getClassLoader().getResource(string + "5.jpg"), (int)2, (int)1);
        this.skybox.setTexture(0, texture);
        this.skybox.setTexture(3, texture4);
        this.skybox.setTexture(1, texture2);
        this.skybox.setTexture(2, texture3);
        this.skybox.setTexture(4, texture5);
        this.skybox.setTexture(5, texture6);
        this.skybox.preloadTextures();
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(0);
        cullState.setEnabled(true);
        this.skybox.setRenderState((RenderState)cullState);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(false);
        this.skybox.setRenderState((RenderState)zBufferState);
        FogState fogState = this.display.getRenderer().createFogState();
        fogState.setEnabled(false);
        this.skybox.setRenderState((RenderState)fogState);
        this.skybox.setLightCombineMode(0);
        this.skybox.setCullMode(3);
        this.skybox.setTextureCombineMode(5);
        this.skybox.updateRenderState();
        this.skybox.lockBounds();
        this.skybox.lockMeshes();
    }

    private Node createObjects() {
        Node node = new Node("objects");
        Torus torus = new Torus("Torus", 50, 50, 10.0f, 20.0f);
        torus.setLocalTranslation(new Vector3f(50.0f, -5.0f, 20.0f));
        TextureState textureState = this.display.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)TestQuadWater.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1);
        Texture texture2 = TextureManager.loadTexture((URL)TestQuadWater.class.getClassLoader().getResource("jmetest/data/texture/north.jpg"), (int)6, (int)1);
        texture2.setEnvironmentalMapMode(2);
        textureState.setTexture(texture, 0);
        textureState.setTexture(texture2, 1);
        textureState.setEnabled(true);
        torus.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)torus);
        textureState = this.display.getRenderer().createTextureState();
        texture = TextureManager.loadTexture((URL)TestQuadWater.class.getClassLoader().getResource("jmetest/data/texture/wall.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        Box box = new Box("box1", new Vector3f(-10.0f, -10.0f, -10.0f), new Vector3f(10.0f, 10.0f, 10.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -7.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        box = new Box("box2", new Vector3f(-5.0f, -5.0f, -5.0f), new Vector3f(5.0f, 5.0f, 5.0f));
        box.setLocalTranslation(new Vector3f(15.0f, 10.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        box = new Box("box3", new Vector3f(-5.0f, -5.0f, -5.0f), new Vector3f(5.0f, 5.0f, 5.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -10.0f, 15.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        box = new Box("box4", new Vector3f(-5.0f, -5.0f, -5.0f), new Vector3f(5.0f, 5.0f, 5.0f));
        box.setLocalTranslation(new Vector3f(20.0f, 0.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        textureState = this.display.getRenderer().createTextureState();
        texture = TextureManager.loadTexture((URL)TestSimpleQuadWater.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        box = new Box("box5", new Vector3f(-50.0f, -2.0f, -50.0f), new Vector3f(50.0f, 2.0f, 50.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -15.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        node.attachChild((Spatial)box);
        return node;
    }

    private void setupKeyBindings() {
        KeyBindingManager.getKeyBindingManager().set("g", 34);
        KeyBindingManager.getKeyBindingManager().set("e", 18);
        KeyBindingManager.getKeyBindingManager().set("lower", 35);
        KeyBindingManager.getKeyBindingManager().set("higher", 21);
        KeyBindingManager.getKeyBindingManager().set("1", 2);
        KeyBindingManager.getKeyBindingManager().set("2", 3);
        Text text = new Text("Text", "Y/H: raise/lower waterheight");
        text.setRenderQueueMode(4);
        text.setLightCombineMode(0);
        text.setLocalTranslation(new Vector3f(0.0f, 20.0f, 1.0f));
        this.fpsNode.attachChild((Spatial)text);
        text = new Text("Text", "E: debug show/hide reflection and refraction textures");
        text.setRenderQueueMode(4);
        text.setLightCombineMode(0);
        text.setLocalTranslation(new Vector3f(0.0f, 40.0f, 1.0f));
        this.fpsNode.attachChild((Spatial)text);
    }

    private void switchShowDebug() {
        if (this.debugQuadsNode.getCullMode() == 3) {
            this.debugQuadsNode.setCullMode(2);
        } else {
            this.debugQuadsNode.setCullMode(3);
        }
    }

    private void createDebugQuads() {
        this.debugQuadsNode = new Node("quadNode");
        this.debugQuadsNode.setCullMode(3);
        float f = this.display.getWidth() / 8;
        float f2 = this.display.getWidth() / 8;
        Quad quad = new Quad("reflectionQuad", f, f2);
        quad.setRenderQueueMode(4);
        quad.setCullMode(3);
        quad.setLightCombineMode(0);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(this.waterEffectRenderPass.getTextureReflect());
        quad.setRenderState((RenderState)textureState);
        quad.updateRenderState();
        quad.getLocalTranslation().set(f * 0.6f, f2 * 1.0f, 1.0f);
        this.debugQuadsNode.attachChild((Spatial)quad);
        if (this.waterEffectRenderPass.getTextureRefract() != null) {
            quad = new Quad("refractionQuad", f, f2);
            quad.setRenderQueueMode(4);
            quad.setCullMode(3);
            quad.setLightCombineMode(0);
            textureState = this.display.getRenderer().createTextureState();
            textureState.setTexture(this.waterEffectRenderPass.getTextureRefract());
            quad.setRenderState((RenderState)textureState);
            quad.updateRenderState();
            quad.getLocalTranslation().set(f * 0.6f, f2 * 2.1f, 1.0f);
            this.debugQuadsNode.attachChild((Spatial)quad);
        }
    }
}

