/*
 * Decompiled with CFR 0.152.
 */
package jmetest.flagrushtut;

import com.jme.app.BaseGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.input.KeyBindingManager;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import java.net.URL;

public class Lesson2
extends BaseGame {
    protected Timer timer;
    private Camera cam;
    private Node scene;
    private TextureState ts;
    private int width;
    private int height;
    private int depth;
    private int freq;
    private boolean fullscreen;

    public static void main(String[] stringArray) {
        Lesson2 lesson2 = new Lesson2();
        lesson2.setDialogBehaviour(2, Lesson2.class.getClassLoader().getResource("jmetest/data/images/FlagRush.png"));
        lesson2.start();
    }

    protected void update(float f) {
        this.timer.update();
        f = this.timer.getTimePerFrame();
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("exit")) {
            this.finished = true;
        }
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.scene);
    }

    protected void initSystem() {
        this.width = this.properties.getWidth();
        this.height = this.properties.getHeight();
        this.depth = this.properties.getDepth();
        this.freq = this.properties.getFreq();
        this.fullscreen = this.properties.getFullscreen();
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.width, this.height, this.depth, this.freq, this.fullscreen);
            this.cam = this.display.getRenderer().createCamera(this.width, this.height);
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        this.display.getRenderer().setBackgroundColor(ColorRGBA.black);
        this.cam.setFrustumPerspective(45.0f, (float)this.width / (float)this.height, 1.0f, 1000.0f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 25.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.cam.update();
        this.timer = Timer.getTimer();
        this.display.getRenderer().setCamera(this.cam);
        KeyBindingManager.getKeyBindingManager().set("exit", 1);
    }

    protected void initGame() {
        this.scene = new Node("Scene graph node");
        this.cam.update();
        Sphere sphere = new Sphere("Sphere", 30, 30, 25.0f);
        sphere.setLocalTranslation(new Vector3f(0.0f, 0.0f, -40.0f));
        sphere.setModelBound((BoundingVolume)new BoundingBox());
        sphere.updateModelBound();
        this.ts = this.display.getRenderer().createTextureState();
        this.ts.setEnabled(true);
        this.ts.setTexture(TextureManager.loadTexture((URL)Lesson2.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1));
        sphere.setRenderState((RenderState)this.ts);
        this.scene.attachChild((Spatial)sphere);
        this.scene.updateGeometricState(0.0f, true);
        this.scene.updateRenderState();
    }

    protected void reinit() {
        this.display.recreateWindow(this.width, this.height, this.depth, this.freq, this.fullscreen);
    }

    protected void quit() {
        super.quit();
        System.exit(0);
    }

    protected void cleanup() {
        this.ts.deleteAll();
    }
}

