/*
 * Decompiled with CFR 0.152.
 */
package jmetest.flagrushtut;

import com.jme.app.BaseGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.KeyBindingManager;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.SceneElement;
import com.jme.scene.SharedMesh;
import com.jme.scene.Skybox;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Cylinder;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import com.jme.util.geom.Debugger;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.MidPointHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import jmetest.flagrushtut.Lesson2;
import jmetest.renderer.TestSkybox;
import jmetest.terrain.TestTerrain;

public class Lesson4
extends BaseGame {
    private TerrainBlock tb;
    private Texture t;
    private Skybox skybox;
    protected Timer timer;
    private Camera cam;
    private Node scene;
    private int width;
    private int height;
    private int depth;
    private int freq;
    private boolean fullscreen;

    public static void main(String[] stringArray) {
        Lesson4 lesson4 = new Lesson4();
        lesson4.setDialogBehaviour(2, Lesson4.class.getClassLoader().getResource("jmetest/data/images/FlagRush.png"));
        lesson4.start();
    }

    protected void update(float f) {
        this.timer.update();
        f = this.timer.getTimePerFrame();
        this.t.getTranslation().y += 0.3f * f;
        if (this.t.getTranslation().y > 1.0f) {
            this.t.getTranslation().y = 0.0f;
        }
        this.skybox.setLocalTranslation(this.cam.getLocation());
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("exit")) {
            this.finished = true;
        }
        this.scene.updateGeometricState(f, true);
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.scene);
        Debugger.drawBounds((SceneElement)this.scene, (Renderer)this.display.getRenderer());
    }

    protected void initSystem() {
        this.width = this.properties.getWidth();
        this.height = this.properties.getHeight();
        this.depth = this.properties.getDepth();
        this.freq = this.properties.getFreq();
        this.fullscreen = this.properties.getFullscreen();
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.width, this.height, this.depth, this.freq, this.fullscreen);
            this.cam = this.display.getRenderer().createCamera(this.width, this.height);
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        this.display.getRenderer().setBackgroundColor(ColorRGBA.black);
        this.cam.setFrustumPerspective(45.0f, (float)this.width / (float)this.height, 1.0f, 5000.0f);
        Vector3f vector3f = new Vector3f(250.0f, 100.0f, 250.0f);
        Vector3f vector3f2 = new Vector3f(-0.5f, 0.0f, 0.5f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(-0.5f, 0.0f, -0.5f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.cam.update();
        this.timer = Timer.getTimer();
        this.display.getRenderer().setCamera(this.cam);
        KeyBindingManager.getKeyBindingManager().set("exit", 1);
    }

    protected void initGame() {
        this.display.setTitle("Flag Rush");
        this.scene = new Node("Scene graph node");
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.scene.setRenderState((RenderState)zBufferState);
        this.buildTerrain();
        this.buildLighting();
        this.buildEnvironment();
        this.buildSkyBox();
        this.scene.updateGeometricState(0.0f, true);
        this.scene.updateRenderState();
    }

    private void buildEnvironment() {
        Node node = new Node("fence");
        Cylinder cylinder = new Cylinder("post", 10, 10, 1.0f, 10.0f);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis(1.5707964f, new Vector3f(1.0f, 0.0f, 0.0f));
        cylinder.setLocalRotation(quaternion);
        cylinder.setModelBound((BoundingVolume)new BoundingBox());
        cylinder.updateModelBound();
        SharedMesh sharedMesh = new SharedMesh("post1", (TriMesh)cylinder);
        sharedMesh.setLocalTranslation(new Vector3f(0.0f, 0.5f, 0.0f));
        SharedMesh sharedMesh2 = new SharedMesh("post2", (TriMesh)cylinder);
        sharedMesh2.setLocalTranslation(new Vector3f(32.0f, 0.5f, 0.0f));
        SharedMesh sharedMesh3 = new SharedMesh("post3", (TriMesh)cylinder);
        sharedMesh3.setLocalTranslation(new Vector3f(0.0f, 0.5f, 32.0f));
        SharedMesh sharedMesh4 = new SharedMesh("post4", (TriMesh)cylinder);
        sharedMesh4.setLocalTranslation(new Vector3f(32.0f, 0.5f, 32.0f));
        Cylinder cylinder2 = new Cylinder("strut", 10, 10, 0.125f, 32.0f);
        cylinder2.setModelBound((BoundingVolume)new BoundingBox());
        cylinder2.updateModelBound();
        SharedMesh sharedMesh5 = new SharedMesh("strut1", (TriMesh)cylinder2);
        Quaternion quaternion2 = new Quaternion();
        quaternion2.fromAngleAxis(1.5707964f, new Vector3f(0.0f, 1.0f, 0.0f));
        sharedMesh5.setLocalRotation(quaternion2);
        sharedMesh5.setLocalTranslation(new Vector3f(16.0f, 3.0f, 0.0f));
        SharedMesh sharedMesh6 = new SharedMesh("strut2", (TriMesh)cylinder2);
        sharedMesh6.setLocalTranslation(new Vector3f(0.0f, 3.0f, 16.0f));
        SharedMesh sharedMesh7 = new SharedMesh("strut3", (TriMesh)cylinder2);
        sharedMesh7.setLocalTranslation(new Vector3f(32.0f, 3.0f, 16.0f));
        SharedMesh sharedMesh8 = new SharedMesh("strut4", (TriMesh)cylinder2);
        sharedMesh8.setLocalRotation(quaternion2);
        sharedMesh8.setLocalTranslation(new Vector3f(16.0f, 3.0f, 32.0f));
        Box box = new Box("forceFieldX", new Vector3f(-16.0f, -3.0f, -0.1f), new Vector3f(16.0f, 3.0f, 0.1f));
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        SharedMesh sharedMesh9 = new SharedMesh("forceFieldX1", (TriMesh)box);
        sharedMesh9.setLocalTranslation(new Vector3f(16.0f, 0.0f, 0.0f));
        SharedMesh sharedMesh10 = new SharedMesh("forceFieldX2", (TriMesh)box);
        sharedMesh10.setLocalTranslation(new Vector3f(16.0f, 0.0f, 32.0f));
        Box box2 = new Box("forceFieldZ", new Vector3f(-0.1f, -3.0f, -16.0f), new Vector3f(0.1f, 3.0f, 16.0f));
        box2.setModelBound((BoundingVolume)new BoundingBox());
        box2.updateModelBound();
        SharedMesh sharedMesh11 = new SharedMesh("forceFieldZ1", (TriMesh)box2);
        sharedMesh11.setLocalTranslation(new Vector3f(0.0f, 0.0f, 16.0f));
        SharedMesh sharedMesh12 = new SharedMesh("forceFieldZ2", (TriMesh)box2);
        sharedMesh12.setLocalTranslation(new Vector3f(32.0f, 0.0f, 16.0f));
        Node node2 = new Node("forceFieldNode");
        node2.setRenderQueueMode(3);
        node2.attachChild((Spatial)sharedMesh9);
        node2.attachChild((Spatial)sharedMesh10);
        node2.attachChild((Spatial)sharedMesh11);
        node2.attachChild((Spatial)sharedMesh12);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        node2.setRenderState((RenderState)alphaState);
        TextureState textureState = this.display.getRenderer().createTextureState();
        this.t = TextureManager.loadTexture((URL)Lesson2.class.getClassLoader().getResource("jmetest/data/texture/reflector.PNG"), (int)6, (int)1);
        this.t.setWrap(3);
        this.t.setTranslation(new Vector3f());
        textureState.setTexture(this.t);
        node2.setRenderState((RenderState)textureState);
        Node node3 = new Node("tower");
        node3.attachChild((Spatial)sharedMesh);
        node3.attachChild((Spatial)sharedMesh2);
        node3.attachChild((Spatial)sharedMesh3);
        node3.attachChild((Spatial)sharedMesh4);
        node3.setRenderQueueMode(2);
        TextureState textureState2 = this.display.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)Lesson2.class.getClassLoader().getResource("jmetest/data/texture/post.PNG"), (int)6, (int)1);
        textureState2.setTexture(texture);
        node3.setRenderState((RenderState)textureState2);
        Node node4 = new Node("strutNode");
        node4.attachChild((Spatial)sharedMesh5);
        node4.attachChild((Spatial)sharedMesh6);
        node4.attachChild((Spatial)sharedMesh7);
        node4.attachChild((Spatial)sharedMesh8);
        node4.setRenderQueueMode(2);
        TextureState textureState3 = this.display.getRenderer().createTextureState();
        Texture texture2 = TextureManager.loadTexture((URL)Lesson2.class.getClassLoader().getResource("jmetest/data/texture/rust.PNG"), (int)6, (int)1);
        textureState3.setTexture(texture2);
        node4.setRenderState((RenderState)textureState3);
        node.setLocalScale(new Vector3f(5.0f, 4.0f, 4.0f));
        node.setLocalTranslation(new Vector3f(25.0f, this.tb.getHeight(25.0f, 25.0f) + 15.0f, 25.0f));
        node.attachChild((Spatial)node2);
        node.attachChild((Spatial)node3);
        node.attachChild((Spatial)node4);
        this.scene.attachChild((Spatial)node);
    }

    private void buildLighting() {
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        directionalLight.setDirection(new Vector3f(1.0f, -1.0f, 0.0f));
        directionalLight.setEnabled(true);
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.setEnabled(true);
        lightState.attach((Light)directionalLight);
        this.scene.setRenderState((RenderState)lightState);
    }

    private void buildTerrain() {
        MidPointHeightMap midPointHeightMap = new MidPointHeightMap(64, 1.0f);
        Vector3f vector3f = new Vector3f(4.0f, 0.0575f, 4.0f);
        this.tb = new TerrainBlock("Terrain", midPointHeightMap.getSize(), vector3f, midPointHeightMap.getHeightMap(), new Vector3f(0.0f, 0.0f, 0.0f), false);
        this.tb.setModelBound((BoundingVolume)new BoundingBox());
        this.tb.updateModelBound();
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)midPointHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
        proceduralTextureGenerator.createTexture(32);
        TextureState textureState = this.display.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
        textureState.setTexture(texture, 0);
        this.tb.setRenderState((RenderState)textureState);
        this.tb.setRenderQueueMode(2);
        this.scene.attachChild((Spatial)this.tb);
    }

    private void buildSkyBox() {
        this.skybox = new Skybox("skybox", 10.0f, 10.0f, 10.0f);
        Texture texture = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/north.jpg"), (int)2, (int)1);
        Texture texture2 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/south.jpg"), (int)2, (int)1);
        Texture texture3 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/east.jpg"), (int)2, (int)1);
        Texture texture4 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/west.jpg"), (int)2, (int)1);
        Texture texture5 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/top.jpg"), (int)2, (int)1);
        Texture texture6 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/bottom.jpg"), (int)2, (int)1);
        this.skybox.setTexture(0, texture);
        this.skybox.setTexture(3, texture4);
        this.skybox.setTexture(1, texture2);
        this.skybox.setTexture(2, texture3);
        this.skybox.setTexture(4, texture5);
        this.skybox.setTexture(5, texture6);
        this.skybox.preloadTextures();
        this.scene.attachChild((Spatial)this.skybox);
    }

    protected void reinit() {
        this.display.recreateWindow(this.width, this.height, this.depth, this.freq, this.fullscreen);
    }

    protected void quit() {
        super.quit();
        System.exit(0);
    }

    protected void cleanup() {
    }
}

