/*
 * Decompiled with CFR 0.152.
 */
package jmetest.flagrushtut.lesson5;

import com.jme.app.BaseGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.ChaseCamera;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Skybox;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.MidPointHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import jmetest.flagrushtut.lesson5.FlagRushHandler;
import jmetest.flagrushtut.lesson5.ForceFieldFence;
import jmetest.renderer.TestSkybox;
import jmetest.terrain.TestTerrain;

public class Lesson5
extends BaseGame {
    private TerrainBlock tb;
    private ForceFieldFence fence;
    private Skybox skybox;
    private Node player;
    protected InputHandler input;
    protected Timer timer;
    private Camera cam;
    private ChaseCamera chaser;
    private Node scene;
    private int width;
    private int height;
    private int depth;
    private int freq;
    private boolean fullscreen;

    public static void main(String[] stringArray) {
        Lesson5 lesson5 = new Lesson5();
        lesson5.setDialogBehaviour(2, Lesson5.class.getClassLoader().getResource("jmetest/data/images/FlagRush.png"));
        lesson5.start();
    }

    protected void update(float f) {
        float f2;
        this.timer.update();
        f = this.timer.getTimePerFrame();
        this.input.update(f);
        this.chaser.update(f);
        this.fence.update(f);
        this.skybox.setLocalTranslation(this.cam.getLocation());
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("exit")) {
            this.finished = true;
        }
        if (this.cam.getLocation().y < this.tb.getHeight(this.cam.getLocation()) + 2.0f) {
            this.cam.getLocation().y = this.tb.getHeight(this.cam.getLocation()) + 2.0f;
            this.cam.update();
        }
        if (!Float.isInfinite(f2 = this.tb.getHeight(this.player.getLocalTranslation()) + ((BoundingBox)this.player.getWorldBound()).yExtent) && !Float.isNaN(f2)) {
            this.player.getLocalTranslation().y = f2;
        }
        this.scene.updateGeometricState(f, true);
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.scene);
    }

    protected void initSystem() {
        this.width = this.properties.getWidth();
        this.height = this.properties.getHeight();
        this.depth = this.properties.getDepth();
        this.freq = this.properties.getFreq();
        this.fullscreen = this.properties.getFullscreen();
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.width, this.height, this.depth, this.freq, this.fullscreen);
            this.cam = this.display.getRenderer().createCamera(this.width, this.height);
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        this.display.getRenderer().setBackgroundColor(ColorRGBA.black);
        this.cam.setFrustumPerspective(45.0f, (float)this.width / (float)this.height, 1.0f, 5000.0f);
        this.cam.update();
        this.timer = Timer.getTimer();
        this.display.getRenderer().setCamera(this.cam);
        KeyBindingManager.getKeyBindingManager().set("exit", 1);
    }

    protected void initGame() {
        this.display.setTitle("Flag Rush");
        this.scene = new Node("Scene graph node");
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.scene.setRenderState((RenderState)zBufferState);
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        this.scene.setRenderState((RenderState)cullState);
        this.buildTerrain();
        this.buildLighting();
        this.buildEnvironment();
        this.buildSkyBox();
        this.buildPlayer();
        this.buildChaseCamera();
        this.buildInput();
        this.scene.updateGeometricState(0.0f, true);
        this.scene.updateRenderState();
    }

    private void buildPlayer() {
        Box box = new Box("box", new Vector3f(), 0.35f, 0.25f, 0.5f);
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        this.player = new Node("Player Node");
        this.player.setLocalTranslation(new Vector3f(100.0f, 0.0f, 100.0f));
        this.scene.attachChild((Spatial)this.player);
        this.player.attachChild((Spatial)box);
        this.player.updateWorldBound();
    }

    private void buildEnvironment() {
        this.fence = new ForceFieldFence("fence");
        this.fence.setLocalScale(5.0f);
        this.fence.setLocalTranslation(new Vector3f(25.0f, this.tb.getHeight(25.0f, 25.0f) + 10.0f, 25.0f));
        this.scene.attachChild((Spatial)this.fence);
    }

    private void buildLighting() {
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        directionalLight.setDirection(new Vector3f(1.0f, -1.0f, 0.0f));
        directionalLight.setEnabled(true);
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.setEnabled(true);
        lightState.attach((Light)directionalLight);
        this.scene.setRenderState((RenderState)lightState);
    }

    private void buildTerrain() {
        MidPointHeightMap midPointHeightMap = new MidPointHeightMap(64, 1.0f);
        Vector3f vector3f = new Vector3f(4.0f, 0.0575f, 4.0f);
        this.tb = new TerrainBlock("Terrain", midPointHeightMap.getSize(), vector3f, midPointHeightMap.getHeightMap(), new Vector3f(0.0f, 0.0f, 0.0f), false);
        this.tb.setModelBound((BoundingVolume)new BoundingBox());
        this.tb.updateModelBound();
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)midPointHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
        proceduralTextureGenerator.createTexture(32);
        TextureState textureState = this.display.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
        textureState.setTexture(texture, 0);
        this.tb.setRenderState((RenderState)textureState);
        this.tb.setRenderQueueMode(2);
        this.scene.attachChild((Spatial)this.tb);
    }

    private void buildSkyBox() {
        this.skybox = new Skybox("skybox", 10.0f, 10.0f, 10.0f);
        Texture texture = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/north.jpg"), (int)2, (int)1);
        Texture texture2 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/south.jpg"), (int)2, (int)1);
        Texture texture3 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/east.jpg"), (int)2, (int)1);
        Texture texture4 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/west.jpg"), (int)2, (int)1);
        Texture texture5 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/top.jpg"), (int)2, (int)1);
        Texture texture6 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/bottom.jpg"), (int)2, (int)1);
        this.skybox.setTexture(0, texture);
        this.skybox.setTexture(3, texture4);
        this.skybox.setTexture(1, texture2);
        this.skybox.setTexture(2, texture3);
        this.skybox.setTexture(4, texture5);
        this.skybox.setTexture(5, texture6);
        this.skybox.preloadTextures();
        this.scene.attachChild((Spatial)this.skybox);
    }

    private void buildChaseCamera() {
        Vector3f vector3f = new Vector3f();
        vector3f.y = ((BoundingBox)this.player.getWorldBound()).yExtent * 1.5f;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("maxRollOut", "6");
        hashMap.put("minRollOut", "3");
        hashMap.put("maxAscent", "0.7853982");
        hashMap.put("sphereCoords", (String)new Vector3f(5.0f, 0.0f, 0.5235988f));
        hashMap.put("targetOffset", (String)vector3f);
        this.chaser = new ChaseCamera(this.cam, (Spatial)this.player, hashMap);
        this.chaser.setMaxDistance(8.0f);
        this.chaser.setMinDistance(2.0f);
    }

    private void buildInput() {
        this.input = new FlagRushHandler((Spatial)this.player, this.properties.getRenderer());
    }

    protected void reinit() {
        this.display.recreateWindow(this.width, this.height, this.depth, this.freq, this.fullscreen);
    }

    protected void quit() {
        super.quit();
        System.exit(0);
    }

    protected void cleanup() {
    }
}

