/*
 * Decompiled with CFR 0.152.
 */
package jmetest.flagrushtut.lesson7;

import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;

public class Vehicle
extends Node {
    private static final long serialVersionUID = 1L;
    private Spatial model;
    private float weight;
    private float velocity;
    private float acceleration;
    private float braking;
    private float turnSpeed;
    private float maxSpeed = 30.0f;
    private float minSpeed = 10.0f;
    private static final Vector3f tempVa = new Vector3f();

    public Vehicle(String string, Spatial spatial) {
        super(string);
        this.setModel(spatial);
    }

    public Vehicle(String string, Spatial spatial, float f, float f2, float f3, float f4, float f5, float f6) {
        super(string);
        this.setModel(spatial);
        this.maxSpeed = f;
        this.minSpeed = f2;
        this.weight = f3;
        this.acceleration = f4;
        this.braking = f5;
        this.turnSpeed = f6;
    }

    public void update(float f) {
        this.localTranslation.addLocal(this.localRotation.getRotationColumn(2, tempVa).multLocal(this.velocity * f));
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    public float getWeight() {
        return this.weight;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(float f) {
        this.acceleration = f;
    }

    public float getBraking() {
        return this.braking;
    }

    public void setBraking(float f) {
        this.braking = f;
    }

    public Spatial getModel() {
        return this.model;
    }

    public void setModel(Spatial spatial) {
        this.detachChild(this.model);
        this.model = spatial;
        this.attachChild(this.model);
    }

    public float getVelocity() {
        return this.velocity;
    }

    public void setVelocity(float f) {
        this.velocity = f;
    }

    public float getTurnSpeed() {
        return this.turnSpeed;
    }

    public void setTurnSpeed(float f) {
        this.turnSpeed = f;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float f) {
        this.maxSpeed = f;
    }

    public float getMinSpeed() {
        return this.minSpeed;
    }

    public void setMinSpeed(float f) {
        this.minSpeed = f;
    }

    public void brake(float f) {
        this.velocity -= f * this.braking;
        if (this.velocity < -this.minSpeed) {
            this.velocity = -this.minSpeed;
        }
    }

    public void accelerate(float f) {
        this.velocity += f * this.acceleration;
        if (this.velocity > this.maxSpeed) {
            this.velocity = this.maxSpeed;
        }
    }

    public void drift(float f) {
        this.velocity = this.velocity < 0.0f ? (this.velocity += this.weight / 5.0f * f) : (this.velocity -= this.weight / 5.0f * f);
    }
}

