/*
 * Decompiled with CFR 0.152.
 */
package jmetest.flagrushtut.lesson8;

import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.action.InputActionInterface;
import jmetest.flagrushtut.lesson8.Vehicle;
import jmetest.flagrushtut.lesson8.actions.DriftAction;
import jmetest.flagrushtut.lesson8.actions.ForwardAndBackwardAction;
import jmetest.flagrushtut.lesson8.actions.VehicleRotateAction;

public class FlagRushHandler
extends InputHandler {
    private Vehicle vehicle;
    private DriftAction drift;

    public void update(float f) {
        if (!this.isEnabled()) {
            return;
        }
        super.update(f);
        this.drift.performAction(this.event);
        this.vehicle.update(f);
    }

    public FlagRushHandler(Vehicle vehicle, String string) {
        this.vehicle = vehicle;
        this.setKeyBindings(string);
        this.setActions(vehicle);
    }

    private void setKeyBindings(String string) {
        KeyBindingManager keyBindingManager = KeyBindingManager.getKeyBindingManager();
        keyBindingManager.set("forward", 17);
        keyBindingManager.set("backward", 31);
        keyBindingManager.set("turnRight", 32);
        keyBindingManager.set("turnLeft", 30);
    }

    private void setActions(Vehicle vehicle) {
        ForwardAndBackwardAction forwardAndBackwardAction = new ForwardAndBackwardAction(vehicle, 0);
        this.addAction((InputActionInterface)forwardAndBackwardAction, "forward", true);
        ForwardAndBackwardAction forwardAndBackwardAction2 = new ForwardAndBackwardAction(vehicle, 1);
        this.addAction((InputActionInterface)forwardAndBackwardAction2, "backward", true);
        VehicleRotateAction vehicleRotateAction = new VehicleRotateAction(vehicle, 1);
        this.addAction((InputActionInterface)vehicleRotateAction, "turnLeft", true);
        VehicleRotateAction vehicleRotateAction2 = new VehicleRotateAction(vehicle, 0);
        this.addAction((InputActionInterface)vehicleRotateAction2, "turnRight", true);
        this.drift = new DriftAction(vehicle);
    }
}

