/*
 * Decompiled with CFR 0.152.
 */
package jmetest.flagrushtut.lesson9;

import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;

public class Vehicle
extends Node {
    private static final long serialVersionUID = 1L;
    private static final float LEAN_BUFFER = 0.05f;
    private Spatial model;
    private float weight;
    private float velocity;
    private float acceleration;
    private float braking;
    private float turnSpeed;
    private float maxSpeed = 30.0f;
    private float minSpeed = 10.0f;
    private static final Vector3f tempVa = new Vector3f();
    private int lean;
    private float leanAngle;
    private Vector3f leanAxis = new Vector3f(0.0f, 0.0f, 1.0f);
    private Quaternion q = new Quaternion();
    Spatial frontwheel;
    Spatial backwheel;
    private Vector3f wheelAxis = new Vector3f(0.0f, 1.0f, 0.0f);
    private float angle = 0.0f;
    private Quaternion rotQuat = new Quaternion();

    public Vehicle(String string, Spatial spatial) {
        super(string);
        this.setModel(spatial);
    }

    public Vehicle(String string, Spatial spatial, float f, float f2, float f3, float f4, float f5, float f6) {
        super(string);
        this.setModel(spatial);
        this.maxSpeed = f;
        this.minSpeed = f2;
        this.weight = f3;
        this.acceleration = f4;
        this.braking = f5;
        this.turnSpeed = f6;
    }

    public void update(float f) {
        this.localTranslation.addLocal(this.localRotation.getRotationColumn(2, tempVa).multLocal(this.velocity * f));
        this.rotateWheels(f);
        this.processLean(f);
    }

    private void rotateWheels(float f) {
        if (this.vehicleIsMoving()) {
            if (this.velocity > 1.1920929E-7f) {
                this.angle -= f * this.velocity * 0.5f;
                if (this.angle < -360.0f) {
                    this.angle = 0.0f;
                }
            } else {
                this.angle += f * this.velocity * 0.5f;
                if (this.angle > 360.0f) {
                    this.angle = 0.0f;
                }
            }
            this.rotQuat.fromAngleAxis(this.angle, this.wheelAxis);
            this.frontwheel.getLocalRotation().multLocal(this.rotQuat);
            this.backwheel.setLocalRotation(this.frontwheel.getLocalRotation());
        }
    }

    public boolean vehicleIsMoving() {
        return this.velocity > 1.1920929E-7f || this.velocity < -1.1920929E-7f;
    }

    private void processLean(float f) {
        if (this.lean != 0) {
            this.leanAngle = this.lean == -1 && this.leanAngle < 0.0f ? (this.leanAngle += (float)(-this.lean * 4) * f) : (this.lean == 1 && this.leanAngle > 0.0f ? (this.leanAngle += (float)(-this.lean * 4) * f) : (this.leanAngle += (float)(-this.lean * 2) * f));
            if (this.leanAngle > 1.0f) {
                this.leanAngle = 1.0f;
            } else if (this.leanAngle < -1.0f) {
                this.leanAngle = -1.0f;
            }
        } else {
            this.leanAngle = this.leanAngle < 0.05f && this.leanAngle > -0.05f ? 0.0f : (this.leanAngle < -1.1920929E-7f ? (this.leanAngle += f * 4.0f) : (this.leanAngle > 1.1920929E-7f ? (this.leanAngle -= f * 4.0f) : 0.0f));
        }
        this.q.fromAngleAxis(this.leanAngle, this.leanAxis);
        this.model.setLocalRotation(this.q);
        this.lean = 0;
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    public float getWeight() {
        return this.weight;
    }

    public float getAcceleration() {
        return this.acceleration;
    }

    public void setAcceleration(float f) {
        this.acceleration = f;
    }

    public float getBraking() {
        return this.braking;
    }

    public void setBraking(float f) {
        this.braking = f;
    }

    public Spatial getModel() {
        return this.model;
    }

    public void setModel(Spatial spatial) {
        this.detachChild(this.model);
        this.model = spatial;
        this.attachChild(this.model);
        this.backwheel = ((Node)((Node)spatial).getChild(0)).getChild(1);
        this.frontwheel = ((Node)((Node)spatial).getChild(0)).getChild(5);
    }

    public float getVelocity() {
        return this.velocity;
    }

    public void setVelocity(float f) {
        this.velocity = f;
    }

    public float getTurnSpeed() {
        return this.turnSpeed;
    }

    public void setTurnSpeed(float f) {
        this.turnSpeed = f;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public void setMaxSpeed(float f) {
        this.maxSpeed = f;
    }

    public float getMinSpeed() {
        return this.minSpeed;
    }

    public void setMinSpeed(float f) {
        this.minSpeed = f;
    }

    public void brake(float f) {
        this.velocity -= f * this.braking;
        if (this.velocity < -this.minSpeed) {
            this.velocity = -this.minSpeed;
        }
    }

    public void accelerate(float f) {
        this.velocity += f * this.acceleration;
        if (this.velocity > this.maxSpeed) {
            this.velocity = this.maxSpeed;
        }
    }

    public void drift(float f) {
        if (this.velocity < -1.1920929E-7f) {
            this.velocity += this.weight / 5.0f * f;
            if (this.velocity > 0.0f) {
                this.velocity = 0.0f;
            }
        } else if (this.velocity > 1.1920929E-7f) {
            this.velocity -= this.weight / 5.0f * f;
            if (this.velocity < 0.0f) {
                this.velocity = 0.0f;
            }
        }
    }

    public void setRotateOn(int n) {
        this.lean = n;
    }
}

