/*
 * Decompiled with CFR 0.152.
 */
package jmetest.game.state;

import com.jme.image.Texture;
import com.jme.input.AbsoluteMouse;
import com.jme.input.InputHandler;
import com.jme.input.Mouse;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jmex.game.state.CameraGameState;
import com.jmex.game.state.GameState;
import java.net.URL;
import jmetest.game.state.MenuHandler;

public class MenuState
extends CameraGameState {
    private Node cursor;
    private DisplaySystem display = DisplaySystem.getDisplaySystem();
    private Text text;
    private InputHandler input;
    private Mouse mouse;

    public MenuState(String string) {
        super(string);
        this.initInput();
        this.initCursor();
        this.initText();
        this.rootNode.setLightCombineMode(0);
        this.rootNode.setRenderQueueMode(4);
        this.rootNode.updateRenderState();
        this.rootNode.updateGeometricState(0.0f, true);
    }

    public void onActivate() {
        this.display.setTitle("Test Game State System - Menu State");
        super.onActivate();
    }

    protected void initInput() {
        this.input = new MenuHandler((GameState)this);
        DisplaySystem displaySystem = DisplaySystem.getDisplaySystem();
        this.mouse = new AbsoluteMouse("Mouse Input", displaySystem.getWidth(), displaySystem.getHeight());
        this.mouse.registerWithInputHandler(this.input);
    }

    private void initCursor() {
        Texture texture = TextureManager.loadTexture((URL)MenuState.class.getClassLoader().getResource("jmetest/data/cursor/cursor1.png"), (int)6, (int)1);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(texture);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        this.mouse.setRenderState((RenderState)textureState);
        this.mouse.setRenderState((RenderState)alphaState);
        this.mouse.setLocalScale(new Vector3f(1.0f, 1.0f, 1.0f));
        this.cursor = new Node("Cursor");
        this.cursor.attachChild((Spatial)this.mouse);
        this.rootNode.attachChild((Spatial)this.cursor);
    }

    private void initText() {
        this.text = Text.createDefaultTextLabel((String)"info");
        this.text.print("press enter");
        this.text.getLocalTranslation().set(100.0f, 100.0f, 0.0f);
        this.rootNode.attachChild((Spatial)this.text);
    }

    protected void stateUpdate(float f) {
        this.input.update(f);
        this.rootNode.updateGeometricState(f, true);
    }
}

