/*
 * Decompiled with CFR 0.152.
 */
package jmetest.input;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.ChaseCamera;
import com.jme.input.ThirdPersonHandler;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.CullState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.awt.SimpleCanvasImpl;
import com.jmex.terrain.TerrainPage;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.FaultFractalHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import jmetest.input.TestThirdPersonController;
import jmetest.terrain.TestTerrain;

public class ControlImplementor
extends SimpleCanvasImpl {
    public Node m_character;
    public ChaseCamera chaser;
    public TerrainPage page;
    public ThirdPersonHandler input;
    public long startTime;
    public Geometry target;
    private Vector3f normal = new Vector3f();

    public ControlImplementor(int n, int n2) {
        super(n, n2);
    }

    public void simpleSetup() {
        this.setupCharacter();
        this.setupTerrain();
        this.setupChaseCamera();
        this.setupInput();
        this.startTime = System.currentTimeMillis() + 5000L;
    }

    public void simpleUpdate() {
        float f;
        float f2;
        this.input.update(this.tpf);
        this.chaser.update(this.tpf);
        if (!Vector3f.isValidVector((Vector3f)this.cam.getLocation())) {
            this.cam.getLocation().set(0.0f, 0.0f, 0.0f);
        }
        if (!Float.isInfinite(f2 = this.page.getHeight(this.cam.getLocation()) + 2.0f) && !Float.isNaN(f2) && this.cam.getLocation().y <= f2) {
            this.cam.getLocation().y = f2;
            this.cam.update();
        }
        if (!Float.isInfinite(f = this.page.getHeight(this.m_character.getLocalTranslation()) + ((BoundingBox)this.m_character.getWorldBound()).yExtent) && !Float.isNaN(f)) {
            this.m_character.getLocalTranslation().y = f;
        }
        this.page.getSurfaceNormal(this.m_character.getLocalTranslation(), this.normal);
        if (this.normal != null) {
            this.m_character.rotateUpTo(this.normal);
        }
    }

    private void setupCharacter() {
        this.target = new Box("box", new Vector3f(), 0.5f, 0.5f, 0.5f);
        this.target.setLocalScale(10.0f);
        this.target.setModelBound((BoundingVolume)new BoundingBox());
        this.target.updateModelBound();
        this.m_character = new Node("char node");
        this.rootNode.attachChild((Spatial)this.m_character);
        this.m_character.attachChild((Spatial)this.target);
        this.m_character.getLocalTranslation().y = 255.0f;
        this.m_character.updateWorldBound();
        TextureState textureState = this.renderer.createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestThirdPersonController.class.getClassLoader().getResource("jmetest/data/images/Monkey.tga"), (int)2, (int)1));
        this.m_character.setRenderState((RenderState)textureState);
    }

    private void setupTerrain() {
        this.rootNode.setRenderQueueMode(2);
        this.renderer.setBackgroundColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setEnabled(true);
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        directionalLight.setDirection(new Vector3f(0.5f, -0.5f, 0.0f));
        CullState cullState = this.renderer.createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)cullState);
        LightState lightState = this.renderer.createLightState();
        lightState.setEnabled(true);
        lightState.attach((Light)directionalLight);
        this.rootNode.setRenderState((RenderState)lightState);
        FaultFractalHeightMap faultFractalHeightMap = new FaultFractalHeightMap(257, 32, 0, 255, 0.75f);
        Vector3f vector3f = new Vector3f(10.0f, 1.0f, 10.0f);
        faultFractalHeightMap.setHeightScale(0.001f);
        this.page = new TerrainPage("Terrain", 33, faultFractalHeightMap.getSize(), vector3f, faultFractalHeightMap.getHeightMap(), false);
        this.page.setDetailTexture(1, 16);
        this.rootNode.attachChild((Spatial)this.page);
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)faultFractalHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
        proceduralTextureGenerator.createTexture(512);
        TextureState textureState = this.renderer.createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
        textureState.setTexture(texture, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestThirdPersonController.class.getClassLoader().getResource("jmetest/data/texture/Detail.jpg"), (int)6, (int)1);
        textureState.setTexture(texture2, 1);
        texture2.setWrap(3);
        texture.setApply(4);
        texture.setCombineFuncRGB(1);
        texture.setCombineSrc0RGB(0);
        texture.setCombineOp0RGB(0);
        texture.setCombineSrc1RGB(1);
        texture.setCombineOp1RGB(0);
        texture.setCombineScaleRGB(1.0f);
        texture2.setApply(4);
        texture2.setCombineFuncRGB(3);
        texture2.setCombineSrc0RGB(0);
        texture2.setCombineOp0RGB(0);
        texture2.setCombineSrc1RGB(3);
        texture2.setCombineOp1RGB(0);
        texture2.setCombineScaleRGB(1.0f);
        this.rootNode.setRenderState((RenderState)textureState);
        FogState fogState = this.renderer.createFogState();
        fogState.setDensity(0.5f);
        fogState.setEnabled(true);
        fogState.setColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 0.5f));
        fogState.setEnd(1000.0f);
        fogState.setStart(500.0f);
        fogState.setDensityFunction(0);
        fogState.setApplyFunction(0);
        this.rootNode.setRenderState((RenderState)fogState);
    }

    private void setupChaseCamera() {
        Vector3f vector3f = new Vector3f();
        vector3f.y = ((BoundingBox)this.m_character.getWorldBound()).yExtent * 1.5f;
        float f = this.page.getHeight(this.cam.getLocation()) + 2.0f;
        if (!Float.isInfinite(f) && !Float.isNaN(f) && this.cam.getLocation().y <= f) {
            this.cam.getLocation().y = f;
            this.cam.update();
        }
        this.chaser = new ChaseCamera(this.cam, (Spatial)this.m_character);
        this.chaser.setTargetOffset(vector3f);
    }

    private void setupInput() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("doGradual", "true");
        hashMap.put("turnSpeed", "3.1415927");
        hashMap.put("lockBackwards", "false");
        hashMap.put("cameraAlignedMovement", "true");
        this.input = new ThirdPersonHandler((Spatial)this.m_character, this.cam, hashMap);
        this.input.setActionSpeed(100.0f);
    }
}

