/*
 * Decompiled with CFR 0.152.
 */
package jmetest.input;

import com.jme.bounding.BoundingBox;
import com.jme.input.KeyBindingManager;
import com.jme.input.KeyInput;
import com.jme.input.MouseInput;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.system.DisplaySystem;
import com.jmex.awt.JMECanvas;
import com.jmex.awt.JMECanvasImplementor;
import com.jmex.awt.input.AWTKeyInput;
import com.jmex.awt.input.AWTMouseInput;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmetest.input.ControlImplementor;
import jmetest.input.KeyInputDialog;
import jmetest.input.VTextIcon;

public class RenControlEditor
extends JFrame {
    private JCheckBox strafeAlignTargetBox;
    private static final long serialVersionUID = 1L;
    private static final Dimension MIN_DIMENSION = new Dimension(400, 300);
    private JTextField scaleZField;
    private JTextField scaleYField;
    private JTextField minDistanceField;
    private JTextField moveSpeedField;
    private JTextField camSpeedField;
    private JTextField scaleXField;
    private JComboBox targetTypeCB;
    private JComboBox landTypeCB;
    private JTextArea codeArea;
    private ButtonGroup offsetGroup = new ButtonGroup();
    private JTextField offsetRatioField;
    private JTextField offsetYField;
    private JTextField offsetZField;
    private JTextField offsetXField;
    private JTextField maxDistanceField;
    private JTextField polarField;
    private JTextField radiusField;
    private JCheckBox maintainSpringRatioBox;
    private JCheckBox gradualTurnsCheckBox;
    private JCheckBox lockBackwardsCheckBox;
    private JCheckBox stayBehindTargetBox;
    private JCheckBox turnWithCameraBox;
    private JCheckBox rotateOnlyBox;
    private JCheckBox enableMouseLookBox;
    private JList examplesList;
    private JRadioButton alignCameraRadio;
    private JRadioButton alignTargetRadio;
    private ButtonGroup alignmentGroup = new ButtonGroup();
    private JTextField turnSpeedField;
    private JTextField springKField;
    private JTextField dampingKField;
    private JTextField maxZoomField;
    private JTextField minZoomField;
    private JTextField turnWithCamSpeedField;
    private JTextField accelHorizontalField;
    private JTextField accelVerticalField;
    private JTextField accelZoomField;
    private JCheckBox enableSpringsCheckBox;
    private JRadioButton offsetRelativeRadio;
    private JRadioButton offsetAbsRadio;
    private JCheckBox invertControlCheckBox;
    private JCheckBox lockPolarBox;
    private JSlider maxAscentSlider;
    private JSlider minAscentSlider;
    private JButton applyExampleButton;
    private Canvas glCanvas;
    private int width = 640;
    private int height = 480;
    private ControlImplementor impl;
    private HashMap<String, Object> keys = new HashMap();

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            JFrame.setDefaultLookAndFeelDecorated(true);
            new RenControlEditor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RenControlEditor() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        this.setTitle("RenControlEditor - 3rd Person  v. 1.0 rc1");
        this.setBounds(100, 100, 760, 480);
        this.setDefaultCloseOperation(3);
        String string = System.getProperty("os.name").toLowerCase();
        boolean bl = false;
        if (string.indexOf("mac") != -1) {
            bl = true;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(new Dimension(50, 50));
        jPanel2.setMinimumSize(new Dimension(100, 100));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.7;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.getGlCanvas(), "Center");
        jPanel2.setBorder(new TitledBorder(null, "Quick Test Here", 0, 0, null, null));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBackground(Color.LIGHT_GRAY);
        jTabbedPane.setForeground(Color.BLACK);
        jTabbedPane.setTabPlacement(4);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 0.3;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        jPanel.add((Component)jTabbedPane, gridBagConstraints2);
        jTabbedPane.setMinimumSize(new Dimension(200, 100));
        jTabbedPane.setPreferredSize(new Dimension(200, 100));
        jTabbedPane.setBorder(new TitledBorder(null, "Settings", 0, 0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        jPanel3.setLayout(new GridBagLayout());
        if (!bl) {
            object8 = new VTextIcon(jTabbedPane, "Camera");
            jTabbedPane.addTab(null, (Icon)object8, jPanel3, null);
        } else {
            jTabbedPane.addTab("Camera", null, jPanel3, null);
        }
        object8 = new JPanel();
        ((JComponent)object8).setOpaque(false);
        ((Container)object8).setLayout(new GridBagLayout());
        if (!bl) {
            object7 = new VTextIcon(jTabbedPane, "Mouse");
            jTabbedPane.addTab(null, (Icon)object7, (Component)object8, null);
        } else {
            jTabbedPane.addTab("Mouse", null, (Component)object8, null);
        }
        object7 = new JPanel();
        ((JComponent)object7).setOpaque(false);
        ((JComponent)object7).setBorder(new TitledBorder(null, "Vertical Control", 0, 0, null, null));
        ((Container)object7).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        ((Container)object8).add((Component)object7, gridBagConstraints3);
        JLabel jLabel = new JLabel();
        jLabel.setText("Max Ascent:");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints4.anchor = 12;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        ((Container)object7).add((Component)jLabel, gridBagConstraints4);
        final JLabel jLabel2 = new JLabel();
        jLabel2.setText("30 deg");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.insets = new Insets(4, 2, 0, 0);
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.gridx = 2;
        ((Container)object7).add((Component)jLabel2, gridBagConstraints5);
        this.maxAscentSlider = new JSlider();
        this.maxAscentSlider.setToolTipText("Maximum angle from the ground that the camera can rise.");
        this.maxAscentSlider.setOpaque(false);
        this.maxAscentSlider.setMinorTickSpacing(15);
        this.maxAscentSlider.setValue(30);
        this.maxAscentSlider.setMajorTickSpacing(30);
        this.maxAscentSlider.setMinimum(-90);
        this.maxAscentSlider.setMaximum(90);
        this.maxAscentSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = RenControlEditor.this.maxAscentSlider.getValue();
                jLabel2.setText(n + " deg");
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getMouseLook().setMaxAscent((float)Math.PI / 180 * (float)n);
                RenControlEditor.this.updateCode();
            }
        });
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.gridx = 1;
        ((Container)object7).add((Component)this.maxAscentSlider, gridBagConstraints6);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Min Ascent:");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints7.anchor = 12;
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 1;
        ((Container)object7).add((Component)jLabel3, gridBagConstraints7);
        final JLabel jLabel4 = new JLabel();
        jLabel4.setText("-15 deg");
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.anchor = 18;
        gridBagConstraints8.insets = new Insets(4, 2, 0, 0);
        gridBagConstraints8.gridy = 1;
        gridBagConstraints8.gridx = 2;
        ((Container)object7).add((Component)jLabel4, gridBagConstraints8);
        this.minAscentSlider = new JSlider();
        this.minAscentSlider.setToolTipText("Maximum angle below level that the camera can fall.");
        this.minAscentSlider.setOpaque(false);
        this.minAscentSlider.setMinorTickSpacing(15);
        this.minAscentSlider.setValue(-15);
        this.minAscentSlider.setMajorTickSpacing(30);
        this.minAscentSlider.setMinimum(-90);
        this.minAscentSlider.setMaximum(90);
        this.minAscentSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = RenControlEditor.this.minAscentSlider.getValue();
                jLabel4.setText(n + " deg");
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getMouseLook().setMinAscent((float)Math.PI / 180 * (float)n);
                RenControlEditor.this.updateCode();
            }
        });
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.weightx = 1.0;
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints9.gridy = 1;
        gridBagConstraints9.gridx = 1;
        ((Container)object7).add((Component)this.minAscentSlider, gridBagConstraints9);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Inverted Control:");
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.anchor = 12;
        gridBagConstraints10.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints10.gridy = 2;
        gridBagConstraints10.gridx = 0;
        ((Container)object7).add((Component)jLabel5, gridBagConstraints10);
        this.invertControlCheckBox = new JCheckBox();
        this.invertControlCheckBox.setToolTipText("Invert the direction the camera moves when the mouse goes up/down.");
        this.invertControlCheckBox.setSelected(false);
        this.invertControlCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.invertControlCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getMouseLook().setInvertedY(RenControlEditor.this.invertControlCheckBox.isSelected());
                RenControlEditor.this.updateCode();
            }
        });
        this.invertControlCheckBox.setOpaque(false);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints11.anchor = 18;
        gridBagConstraints11.gridy = 2;
        gridBagConstraints11.gridx = 1;
        ((Container)object7).add((Component)this.invertControlCheckBox, gridBagConstraints11);
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel4.setBorder(new TitledBorder(null, "Zoom Control (scrollwheel)", 0, 0, null, null));
        jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints12.fill = 1;
        gridBagConstraints12.anchor = 18;
        gridBagConstraints12.weightx = 1.0;
        gridBagConstraints12.gridy = 2;
        gridBagConstraints12.gridx = 0;
        ((Container)object8).add((Component)jPanel4, gridBagConstraints12);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Min:");
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.anchor = 12;
        gridBagConstraints13.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints13.gridy = 0;
        gridBagConstraints13.gridx = 0;
        jPanel4.add((Component)jLabel6, gridBagConstraints13);
        this.minZoomField = new JTextField();
        this.minZoomField.setToolTipText("Minimum radius between camera and target (controlled by mousewheel)");
        this.minZoomField.setHorizontalAlignment(4);
        this.minZoomField.setText("20.0");
        RenControlEditor.addExpandedNumericVerifier(this.minZoomField);
        this.minZoomField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.minZoomField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getMouseLook().setMinRollOut(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.minZoomField.setColumns(5);
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints14.anchor = 18;
        gridBagConstraints14.gridy = 0;
        gridBagConstraints14.gridx = 1;
        jPanel4.add((Component)this.minZoomField, gridBagConstraints14);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Max:");
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.insets = new Insets(4, 8, 0, 0);
        gridBagConstraints15.anchor = 12;
        gridBagConstraints15.gridy = 0;
        gridBagConstraints15.gridx = 2;
        jPanel4.add((Component)jLabel7, gridBagConstraints15);
        this.maxZoomField = new JTextField();
        this.maxZoomField.setToolTipText("Maximum radius between camera and target (controlled by mousewheel)");
        this.maxZoomField.setHorizontalAlignment(4);
        this.maxZoomField.setText("240.0");
        RenControlEditor.addExpandedNumericVerifier(this.maxZoomField);
        this.maxZoomField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.maxZoomField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getMouseLook().setMaxRollOut(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.maxZoomField.setColumns(5);
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints16.anchor = 18;
        gridBagConstraints16.gridy = 0;
        gridBagConstraints16.gridx = 3;
        jPanel4.add((Component)this.maxZoomField, gridBagConstraints16);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(new TitledBorder(null, "Acceleration", 0, 0, null, null));
        jPanel5.setOpaque(false);
        jPanel5.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.weightx = 1.0;
        gridBagConstraints17.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints17.fill = 1;
        gridBagConstraints17.anchor = 18;
        gridBagConstraints17.gridy = 3;
        gridBagConstraints17.gridx = 0;
        ((Container)object8).add((Component)jPanel5, gridBagConstraints17);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Base Speed:");
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints18.anchor = 12;
        gridBagConstraints18.gridx = 0;
        gridBagConstraints18.gridy = 0;
        jPanel5.add((Component)jLabel8, gridBagConstraints18);
        this.camSpeedField = new JTextField();
        this.camSpeedField.setToolTipText("Base mouse motion speed");
        this.camSpeedField.setHorizontalAlignment(4);
        this.camSpeedField.setText("1.0");
        RenControlEditor.addExpandedNumericVerifier(this.camSpeedField);
        this.camSpeedField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.camSpeedField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.setActionSpeed(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.camSpeedField.setColumns(5);
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.insets = new Insets(2, 4, 10, 0);
        gridBagConstraints19.anchor = 18;
        gridBagConstraints19.gridy = 0;
        gridBagConstraints19.gridx = 1;
        jPanel5.add((Component)this.camSpeedField, gridBagConstraints19);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Horizontal:");
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints20.anchor = 12;
        gridBagConstraints20.gridy = 1;
        gridBagConstraints20.gridx = 0;
        jPanel5.add((Component)jLabel9, gridBagConstraints20);
        this.accelHorizontalField = new JTextField();
        this.accelHorizontalField.setToolTipText("acceleration to apply to speed in the horizontal direction");
        this.accelHorizontalField.setHorizontalAlignment(4);
        this.accelHorizontalField.setText("2.0");
        RenControlEditor.addExpandedNumericVerifier(this.accelHorizontalField);
        this.accelHorizontalField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.accelHorizontalField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getMouseLook().setMouseXMultiplier(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.accelHorizontalField.setColumns(5);
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints21.anchor = 18;
        gridBagConstraints21.gridy = 1;
        gridBagConstraints21.gridx = 1;
        jPanel5.add((Component)this.accelHorizontalField, gridBagConstraints21);
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Vertical:");
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.insets = new Insets(4, 8, 0, 0);
        gridBagConstraints22.anchor = 12;
        gridBagConstraints22.gridy = 1;
        gridBagConstraints22.gridx = 2;
        jPanel5.add((Component)jLabel10, gridBagConstraints22);
        this.accelVerticalField = new JTextField();
        this.accelVerticalField.setToolTipText("acceleration to apply to speed in the vertical direction");
        this.accelVerticalField.setHorizontalAlignment(4);
        this.accelVerticalField.setText("30.0");
        RenControlEditor.addExpandedNumericVerifier(this.accelVerticalField);
        this.accelVerticalField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.accelVerticalField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getMouseLook().setMouseYMultiplier(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.accelVerticalField.setColumns(5);
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints23.anchor = 18;
        gridBagConstraints23.gridy = 1;
        gridBagConstraints23.gridx = 3;
        jPanel5.add((Component)this.accelVerticalField, gridBagConstraints23);
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Zoom:");
        GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
        gridBagConstraints24.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints24.anchor = 12;
        gridBagConstraints24.gridy = 2;
        gridBagConstraints24.gridx = 0;
        jPanel5.add((Component)jLabel11, gridBagConstraints24);
        this.accelZoomField = new JTextField();
        this.accelZoomField.setToolTipText("acceleration to apply to speed during zooming");
        this.accelZoomField.setHorizontalAlignment(4);
        this.accelZoomField.setText("50.0");
        RenControlEditor.addExpandedNumericVerifier(this.accelZoomField);
        this.accelZoomField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.accelZoomField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getMouseLook().setMouseRollMultiplier(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.accelZoomField.setColumns(5);
        GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
        gridBagConstraints25.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints25.anchor = 18;
        gridBagConstraints25.gridy = 2;
        gridBagConstraints25.gridx = 1;
        jPanel5.add((Component)this.accelZoomField, gridBagConstraints25);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(new TitledBorder(null, "Initial Positioning", 0, 0, null, null));
        jPanel6.setOpaque(false);
        jPanel6.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        gridBagConstraints26.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints26.fill = 1;
        gridBagConstraints26.anchor = 18;
        gridBagConstraints26.weightx = 1.0;
        gridBagConstraints26.gridy = 0;
        gridBagConstraints26.gridx = 0;
        jPanel3.add((Component)jPanel6, gridBagConstraints26);
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Radius:");
        GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
        gridBagConstraints27.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints27.anchor = 12;
        gridBagConstraints27.gridy = 0;
        gridBagConstraints27.gridx = 0;
        jPanel6.add((Component)jLabel12, gridBagConstraints27);
        this.radiusField = new JTextField();
        this.radiusField.setToolTipText("Initial \"ideal\" distance to start camera at");
        this.radiusField.setHorizontalAlignment(4);
        this.radiusField.setText("100");
        RenControlEditor.addExpandedNumericVerifier(this.radiusField);
        this.radiusField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.radiusField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getIdealSphereCoords().x = f;
                RenControlEditor.this.updateCode();
            }
        });
        this.radiusField.setColumns(5);
        GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
        gridBagConstraints28.anchor = 18;
        gridBagConstraints28.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints28.gridy = 0;
        gridBagConstraints28.gridx = 1;
        jPanel6.add((Component)this.radiusField, gridBagConstraints28);
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("Polar Angle:");
        GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
        gridBagConstraints29.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints29.anchor = 12;
        gridBagConstraints29.gridy = 2;
        gridBagConstraints29.gridx = 0;
        jPanel6.add((Component)jLabel13, gridBagConstraints29);
        this.polarField = new JTextField();
        this.polarField.setToolTipText("Initial \"ideal\" angle from ground to start camera at");
        this.polarField.setHorizontalAlignment(4);
        this.polarField.setText("30");
        RenControlEditor.addExpandedNumericVerifier(this.polarField);
        this.polarField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.polarField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getIdealSphereCoords().z = (float)Math.PI / 180 * f;
                RenControlEditor.this.updateCode();
            }
        });
        this.polarField.setColumns(5);
        GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
        gridBagConstraints30.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints30.anchor = 18;
        gridBagConstraints30.gridy = 2;
        gridBagConstraints30.gridx = 1;
        jPanel6.add((Component)this.polarField, gridBagConstraints30);
        JLabel jLabel14 = new JLabel();
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints31.anchor = 18;
        gridBagConstraints31.gridy = 2;
        gridBagConstraints31.gridx = 2;
        jPanel6.add((Component)jLabel14, gridBagConstraints31);
        jLabel14.setText("degrees");
        this.lockPolarBox = new JCheckBox();
        this.lockPolarBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getMouseLook().setLockAscent(RenControlEditor.this.lockPolarBox.isSelected());
                RenControlEditor.this.updateCode();
            }
        });
        this.lockPolarBox.setToolTipText("Lock the Camera's height to the initial Polar Angle.");
        this.lockPolarBox.setMargin(new Insets(0, 0, 0, 0));
        this.lockPolarBox.setOpaque(false);
        this.lockPolarBox.setText("Lock Polar Height");
        GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
        gridBagConstraints32.insets = new Insets(2, 4, 0, 4);
        gridBagConstraints32.gridwidth = 3;
        gridBagConstraints32.gridy = 3;
        gridBagConstraints32.gridx = 0;
        jPanel6.add((Component)this.lockPolarBox, gridBagConstraints32);
        JPanel jPanel7 = new JPanel();
        jPanel7.setBorder(new TitledBorder(null, "Target", 0, 0, null, null));
        jPanel7.setLayout(new GridBagLayout());
        jPanel7.setOpaque(false);
        GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
        gridBagConstraints33.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints33.fill = 1;
        gridBagConstraints33.anchor = 18;
        gridBagConstraints33.gridy = 1;
        gridBagConstraints33.gridx = 0;
        jPanel3.add((Component)jPanel7, gridBagConstraints33);
        this.stayBehindTargetBox = new JCheckBox();
        this.stayBehindTargetBox.setToolTipText("Keep camera's ideal position behind target facing direction.");
        this.stayBehindTargetBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((RenControlEditor)RenControlEditor.this).impl.chaser.setStayBehindTarget(RenControlEditor.this.stayBehindTargetBox.isSelected());
                RenControlEditor.this.updateCode();
            }
        });
        this.stayBehindTargetBox.setOpaque(false);
        this.stayBehindTargetBox.setMargin(new Insets(0, 0, 0, 0));
        this.stayBehindTargetBox.setText("Stay Behind Target");
        GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
        gridBagConstraints34.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints34.anchor = 18;
        gridBagConstraints34.gridy = 0;
        gridBagConstraints34.gridx = 0;
        gridBagConstraints34.gridwidth = 2;
        jPanel7.add((Component)this.stayBehindTargetBox, gridBagConstraints34);
        this.turnWithCameraBox = new JCheckBox();
        this.turnWithCameraBox.setToolTipText("Keep camera's ideal position behind target facing direction.");
        this.turnWithCameraBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getMouseLook().setRotateTarget(RenControlEditor.this.turnWithCameraBox.isSelected());
                RenControlEditor.this.turnWithCamSpeedField.setEnabled(RenControlEditor.this.turnWithCameraBox.isSelected());
                RenControlEditor.this.updateCode();
            }
        });
        this.turnWithCameraBox.setOpaque(false);
        this.turnWithCameraBox.setMargin(new Insets(0, 0, 0, 0));
        this.turnWithCameraBox.setText("Turn Target With Camera");
        GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
        gridBagConstraints35.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints35.anchor = 18;
        gridBagConstraints35.gridy = 1;
        gridBagConstraints35.gridx = 0;
        gridBagConstraints35.gridwidth = 2;
        jPanel7.add((Component)this.turnWithCameraBox, gridBagConstraints35);
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("Target Turn Speed:");
        GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
        gridBagConstraints36.anchor = 12;
        gridBagConstraints36.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints36.gridy = 2;
        gridBagConstraints36.gridx = 0;
        jPanel7.add((Component)jLabel15, gridBagConstraints36);
        this.turnWithCamSpeedField = new JTextField();
        this.turnWithCamSpeedField.setEnabled(false);
        this.turnWithCamSpeedField.setToolTipText("Speed (in degrees) that target turns towards camera facing direction.");
        this.turnWithCamSpeedField.setHorizontalAlignment(4);
        this.turnWithCamSpeedField.setText("360.0");
        RenControlEditor.addExpandedNumericVerifier(this.turnWithCamSpeedField);
        this.turnWithCamSpeedField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.turnWithCamSpeedField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string) * ((float)Math.PI / 180);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getMouseLook().setMinRollOut(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.turnWithCamSpeedField.setColumns(5);
        GridBagConstraints gridBagConstraints37 = new GridBagConstraints();
        gridBagConstraints37.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints37.anchor = 18;
        gridBagConstraints37.gridy = 2;
        gridBagConstraints37.gridx = 1;
        jPanel7.add((Component)this.turnWithCamSpeedField, gridBagConstraints37);
        JLabel jLabel16 = new JLabel();
        GridBagConstraints gridBagConstraints38 = new GridBagConstraints();
        gridBagConstraints38.weighty = 1.0;
        gridBagConstraints38.anchor = 18;
        gridBagConstraints38.fill = 1;
        gridBagConstraints38.gridy = 6;
        gridBagConstraints38.gridx = 0;
        jPanel3.add((Component)jLabel16, gridBagConstraints38);
        JLabel jLabel17 = new JLabel();
        GridBagConstraints gridBagConstraints39 = new GridBagConstraints();
        gridBagConstraints39.weighty = 1.0;
        gridBagConstraints39.fill = 1;
        gridBagConstraints39.anchor = 18;
        gridBagConstraints39.gridy = 5;
        gridBagConstraints39.gridx = 0;
        ((Container)object8).add((Component)jLabel17, gridBagConstraints39);
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(new TitledBorder(null, "Enabled", 0, 0, null, null));
        jPanel8.setOpaque(false);
        jPanel8.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints40 = new GridBagConstraints();
        gridBagConstraints40.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints40.fill = 1;
        gridBagConstraints40.anchor = 18;
        gridBagConstraints40.gridx = 0;
        gridBagConstraints40.gridy = 0;
        ((Container)object8).add((Component)jPanel8, gridBagConstraints40);
        this.enableMouseLookBox = new JCheckBox();
        this.enableMouseLookBox.setToolTipText("Enable mouse interaction with the camera");
        this.enableMouseLookBox.setSelected(true);
        this.enableMouseLookBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = RenControlEditor.this.enableMouseLookBox.isSelected();
                ((RenControlEditor)RenControlEditor.this).impl.chaser.getMouseLook().setEnabled(bl);
                RenControlEditor.this.maxAscentSlider.setEnabled(bl);
                RenControlEditor.this.minAscentSlider.setEnabled(bl);
                RenControlEditor.this.invertControlCheckBox.setEnabled(bl);
                RenControlEditor.this.minZoomField.setEnabled(bl);
                RenControlEditor.this.maxZoomField.setEnabled(bl);
                RenControlEditor.this.camSpeedField.setEnabled(bl);
                RenControlEditor.this.accelHorizontalField.setEnabled(bl);
                RenControlEditor.this.accelVerticalField.setEnabled(bl);
                RenControlEditor.this.accelZoomField.setEnabled(bl);
                RenControlEditor.this.updateCode();
            }
        });
        this.enableMouseLookBox.setMargin(new Insets(0, 0, 0, 0));
        this.enableMouseLookBox.setOpaque(false);
        this.enableMouseLookBox.setText("Enable MouseLook");
        GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
        gridBagConstraints41.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints41.gridy = 0;
        gridBagConstraints41.gridx = 0;
        jPanel8.add((Component)this.enableMouseLookBox, gridBagConstraints41);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        jPanel9.setOpaque(false);
        if (!bl) {
            object6 = new VTextIcon(jTabbedPane, "Springs");
            jTabbedPane.addTab(null, (Icon)object6, jPanel9, null);
        } else {
            jTabbedPane.addTab("Springs", null, jPanel9, null);
        }
        object6 = new JPanel();
        ((JComponent)object6).setBorder(new TitledBorder(null, "Enabled", 0, 0, null, null));
        ((JComponent)object6).setOpaque(false);
        ((Container)object6).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints42 = new GridBagConstraints();
        gridBagConstraints42.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints42.fill = 1;
        gridBagConstraints42.anchor = 18;
        gridBagConstraints42.weightx = 1.0;
        gridBagConstraints42.gridx = 0;
        gridBagConstraints42.gridy = 0;
        jPanel9.add((Component)object6, gridBagConstraints42);
        this.enableSpringsCheckBox = new JCheckBox();
        this.enableSpringsCheckBox.setToolTipText("Enable spring controlled movement of the camera (more fluid and lifelike)");
        this.enableSpringsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.enableSpringsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = RenControlEditor.this.enableSpringsCheckBox.isSelected();
                RenControlEditor.this.springKField.setEnabled(bl);
                RenControlEditor.this.dampingKField.setEnabled(bl);
                RenControlEditor.this.maintainSpringRatioBox.setEnabled(bl);
                RenControlEditor.this.maxDistanceField.setEnabled(bl);
                RenControlEditor.this.minDistanceField.setEnabled(bl);
                ((RenControlEditor)RenControlEditor.this).impl.chaser.setEnableSpring(bl);
                RenControlEditor.this.updateCode();
            }
        });
        this.enableSpringsCheckBox.setSelected(true);
        this.enableSpringsCheckBox.setOpaque(false);
        this.enableSpringsCheckBox.setText("Enable Springs");
        GridBagConstraints gridBagConstraints43 = new GridBagConstraints();
        gridBagConstraints43.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints43.gridy = 0;
        gridBagConstraints43.gridx = 0;
        ((Container)object6).add((Component)this.enableSpringsCheckBox, gridBagConstraints43);
        JPanel jPanel10 = new JPanel();
        jPanel10.setOpaque(false);
        jPanel10.setLayout(new GridBagLayout());
        jPanel10.setBorder(new TitledBorder(null, "Spring Coefficients", 0, 0, null, null));
        GridBagConstraints gridBagConstraints44 = new GridBagConstraints();
        gridBagConstraints44.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints44.fill = 1;
        gridBagConstraints44.anchor = 18;
        gridBagConstraints44.weightx = 1.0;
        gridBagConstraints44.gridy = 1;
        gridBagConstraints44.gridx = 0;
        jPanel9.add((Component)jPanel10, gridBagConstraints44);
        this.maintainSpringRatioBox = new JCheckBox();
        this.maintainSpringRatioBox.setToolTipText("Keep constant values at a ratio where the camera will stop asap without ocillating.");
        this.maintainSpringRatioBox.setMargin(new Insets(0, 0, 0, 0));
        this.maintainSpringRatioBox.setOpaque(false);
        this.maintainSpringRatioBox.setSelected(true);
        this.maintainSpringRatioBox.setText("Maintain Critically Damped Ratio");
        GridBagConstraints gridBagConstraints45 = new GridBagConstraints();
        gridBagConstraints45.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints45.gridwidth = 3;
        gridBagConstraints45.gridx = 0;
        gridBagConstraints45.gridy = 0;
        jPanel10.add((Component)this.maintainSpringRatioBox, gridBagConstraints45);
        JLabel jLabel18 = new JLabel();
        jLabel18.setText("Damping K:");
        GridBagConstraints gridBagConstraints46 = new GridBagConstraints();
        gridBagConstraints46.anchor = 12;
        gridBagConstraints46.gridx = 0;
        gridBagConstraints46.gridy = 1;
        gridBagConstraints46.insets = new Insets(4, 4, 0, 0);
        jPanel10.add((Component)jLabel18, gridBagConstraints46);
        this.dampingKField = new JTextField();
        this.dampingKField.setToolTipText("constant affecting the damping of the spring's power");
        this.dampingKField.setText("12.0");
        this.dampingKField.setHorizontalAlignment(4);
        RenControlEditor.addExpandedNumericVerifier(this.dampingKField);
        this.dampingKField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                if (!RenControlEditor.this.dampingKField.hasFocus()) {
                    return;
                }
                String string = RenControlEditor.this.dampingKField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (RenControlEditor.this.maintainSpringRatioBox.isSelected()) {
                    float f2 = f * f * 0.25f;
                    RenControlEditor.this.springKField.setText("" + f2);
                    ((RenControlEditor)RenControlEditor.this).impl.chaser.setSpringK(f2);
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.setDampingK(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.dampingKField.setColumns(6);
        GridBagConstraints gridBagConstraints47 = new GridBagConstraints();
        gridBagConstraints47.fill = 2;
        gridBagConstraints47.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints47.anchor = 18;
        gridBagConstraints47.gridy = 1;
        gridBagConstraints47.gridx = 1;
        jPanel10.add((Component)this.dampingKField, gridBagConstraints47);
        JLabel jLabel19 = new JLabel();
        jLabel19.setText("Spring K:");
        GridBagConstraints gridBagConstraints48 = new GridBagConstraints();
        gridBagConstraints48.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints48.anchor = 12;
        gridBagConstraints48.gridy = 2;
        gridBagConstraints48.gridx = 0;
        jPanel10.add((Component)jLabel19, gridBagConstraints48);
        this.springKField = new JTextField();
        this.springKField.setToolTipText("constant affecting the power of the spring");
        this.springKField.setText("36.0");
        this.springKField.setHorizontalAlignment(4);
        RenControlEditor.addExpandedNumericVerifier(this.springKField);
        this.springKField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                if (!RenControlEditor.this.springKField.hasFocus()) {
                    return;
                }
                String string = RenControlEditor.this.springKField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (RenControlEditor.this.maintainSpringRatioBox.isSelected()) {
                    float f2 = 2.0f * FastMath.sqrt((float)f);
                    RenControlEditor.this.dampingKField.setText("" + f2);
                    ((RenControlEditor)RenControlEditor.this).impl.chaser.setDampingK(f2);
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.setSpringK(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.springKField.setColumns(6);
        GridBagConstraints gridBagConstraints49 = new GridBagConstraints();
        gridBagConstraints49.fill = 2;
        gridBagConstraints49.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints49.anchor = 18;
        gridBagConstraints49.gridy = 2;
        gridBagConstraints49.gridx = 1;
        jPanel10.add((Component)this.springKField, gridBagConstraints49);
        JPanel jPanel11 = new JPanel();
        jPanel11.setBorder(new TitledBorder(null, "Limits", 0, 0, null, null));
        jPanel11.setOpaque(false);
        jPanel11.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints50 = new GridBagConstraints();
        gridBagConstraints50.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints50.fill = 1;
        gridBagConstraints50.anchor = 18;
        gridBagConstraints50.gridy = 2;
        gridBagConstraints50.gridx = 0;
        jPanel9.add((Component)jPanel11, gridBagConstraints50);
        JLabel jLabel20 = new JLabel();
        jLabel20.setText("Max Spring Length:");
        GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
        gridBagConstraints51.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints51.anchor = 18;
        gridBagConstraints51.gridy = 0;
        gridBagConstraints51.gridx = 0;
        jPanel11.add((Component)jLabel20, gridBagConstraints51);
        this.maxDistanceField = new JTextField();
        this.maxDistanceField.setToolTipText("at what distance to force camera to maintain distance regardless of spring");
        this.maxDistanceField.setText("0");
        this.maxDistanceField.setHorizontalAlignment(4);
        RenControlEditor.addExpandedNumericVerifier(this.maxDistanceField);
        this.maxDistanceField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.maxDistanceField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.setMaxDistance(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.maxDistanceField.setColumns(5);
        GridBagConstraints gridBagConstraints52 = new GridBagConstraints();
        gridBagConstraints52.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints52.anchor = 18;
        gridBagConstraints52.gridy = 0;
        gridBagConstraints52.gridx = 1;
        jPanel11.add((Component)this.maxDistanceField, gridBagConstraints52);
        JLabel jLabel21 = new JLabel();
        jLabel21.setFont(new Font("", 0, 10));
        jLabel21.setText("(0 - no limit)");
        GridBagConstraints gridBagConstraints53 = new GridBagConstraints();
        gridBagConstraints53.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints53.anchor = 18;
        gridBagConstraints53.gridy = 0;
        gridBagConstraints53.gridx = 2;
        jPanel11.add((Component)jLabel21, gridBagConstraints53);
        JLabel jLabel22 = new JLabel();
        jLabel22.setText("Min Spring Length:");
        GridBagConstraints gridBagConstraints54 = new GridBagConstraints();
        gridBagConstraints54.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints54.anchor = 12;
        gridBagConstraints54.gridy = 1;
        gridBagConstraints54.gridx = 0;
        jPanel11.add((Component)jLabel22, gridBagConstraints54);
        this.minDistanceField = new JTextField();
        this.minDistanceField.setToolTipText("at what distance to push away camera to maintain distance regardless of spring");
        this.minDistanceField.setHorizontalAlignment(4);
        this.minDistanceField.setText("0");
        RenControlEditor.addExpandedNumericVerifier(this.minDistanceField);
        this.minDistanceField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.minDistanceField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.chaser.setMinDistance(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.minDistanceField.setColumns(5);
        GridBagConstraints gridBagConstraints55 = new GridBagConstraints();
        gridBagConstraints55.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints55.anchor = 18;
        gridBagConstraints55.gridy = 1;
        gridBagConstraints55.gridx = 1;
        jPanel11.add((Component)this.minDistanceField, gridBagConstraints55);
        JLabel jLabel23 = new JLabel();
        jLabel23.setFont(new Font("", 0, 10));
        jLabel23.setText("(0 - no limit)");
        GridBagConstraints gridBagConstraints56 = new GridBagConstraints();
        gridBagConstraints56.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints56.anchor = 18;
        gridBagConstraints56.gridy = 1;
        gridBagConstraints56.gridx = 2;
        jPanel11.add((Component)jLabel23, gridBagConstraints56);
        JLabel jLabel24 = new JLabel();
        GridBagConstraints gridBagConstraints57 = new GridBagConstraints();
        gridBagConstraints57.fill = 1;
        gridBagConstraints57.anchor = 18;
        gridBagConstraints57.weighty = 1.0;
        gridBagConstraints57.gridy = 3;
        gridBagConstraints57.gridx = 0;
        jPanel9.add((Component)jLabel24, gridBagConstraints57);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridBagLayout());
        jPanel12.setOpaque(false);
        if (!bl) {
            object5 = new VTextIcon(jTabbedPane, "Movement");
            jTabbedPane.addTab(null, (Icon)object5, jPanel12, null);
        } else {
            jTabbedPane.addTab("Movement", null, jPanel12, null);
        }
        object5 = new JPanel();
        ((JComponent)object5).setBorder(new TitledBorder(null, "Target Turning", 0, 0, null, null));
        ((JComponent)object5).setOpaque(false);
        ((Container)object5).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints58 = new GridBagConstraints();
        gridBagConstraints58.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints58.fill = 1;
        gridBagConstraints58.anchor = 18;
        gridBagConstraints58.weightx = 1.0;
        gridBagConstraints58.gridy = 1;
        gridBagConstraints58.gridx = 0;
        jPanel12.add((Component)object5, gridBagConstraints58);
        JLabel jLabel25 = new JLabel();
        jLabel25.setText("Turn Speed:");
        GridBagConstraints gridBagConstraints59 = new GridBagConstraints();
        gridBagConstraints59.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints59.anchor = 12;
        gridBagConstraints59.gridy = 2;
        gridBagConstraints59.gridx = 0;
        ((Container)object5).add((Component)jLabel25, gridBagConstraints59);
        this.turnSpeedField = new JTextField();
        this.turnSpeedField.setHorizontalAlignment(4);
        this.turnSpeedField.setToolTipText("radians per second to turn");
        this.turnSpeedField.setText("3.1415");
        RenControlEditor.addExpandedNumericVerifier(this.turnSpeedField);
        this.turnSpeedField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.turnSpeedField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.input.setTurnSpeed(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.turnSpeedField.setColumns(5);
        GridBagConstraints gridBagConstraints60 = new GridBagConstraints();
        gridBagConstraints60.anchor = 18;
        gridBagConstraints60.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints60.gridy = 2;
        gridBagConstraints60.gridx = 1;
        ((Container)object5).add((Component)this.turnSpeedField, gridBagConstraints60);
        this.rotateOnlyBox = new JCheckBox();
        this.rotateOnlyBox.setToolTipText("Rotate in place if only left/right keys are held. (otherwise, moves forward while turning)");
        this.rotateOnlyBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((RenControlEditor)RenControlEditor.this).impl.input.setRotateOnly(RenControlEditor.this.rotateOnlyBox.isSelected());
                RenControlEditor.this.updateCode();
            }
        });
        this.rotateOnlyBox.setMargin(new Insets(0, 0, 0, 0));
        this.rotateOnlyBox.setOpaque(false);
        this.rotateOnlyBox.setAutoscrolls(true);
        this.rotateOnlyBox.setText("Rotate In Place");
        GridBagConstraints gridBagConstraints61 = new GridBagConstraints();
        gridBagConstraints61.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints61.anchor = 18;
        gridBagConstraints61.gridwidth = 2;
        gridBagConstraints61.gridx = 0;
        gridBagConstraints61.gridy = 0;
        ((Container)object5).add((Component)this.rotateOnlyBox, gridBagConstraints61);
        this.gradualTurnsCheckBox = new JCheckBox();
        this.gradualTurnsCheckBox.setToolTipText("turn gradually to face indicated direction (else turn is immediate)");
        this.gradualTurnsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((RenControlEditor)RenControlEditor.this).impl.input.setDoGradualRotation(RenControlEditor.this.gradualTurnsCheckBox.isSelected());
                RenControlEditor.this.turnSpeedField.setEnabled(RenControlEditor.this.gradualTurnsCheckBox.isSelected());
                RenControlEditor.this.updateCode();
            }
        });
        this.gradualTurnsCheckBox.setSelected(true);
        this.gradualTurnsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.gradualTurnsCheckBox.setOpaque(false);
        this.gradualTurnsCheckBox.setText("Gradual Turns");
        GridBagConstraints gridBagConstraints62 = new GridBagConstraints();
        gridBagConstraints62.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints62.anchor = 18;
        gridBagConstraints62.gridwidth = 2;
        gridBagConstraints62.gridy = 1;
        gridBagConstraints62.gridx = 0;
        ((Container)object5).add((Component)this.gradualTurnsCheckBox, gridBagConstraints62);
        this.lockBackwardsCheckBox = new JCheckBox();
        this.lockBackwardsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((RenControlEditor)RenControlEditor.this).impl.input.setLockBackwards(RenControlEditor.this.lockBackwardsCheckBox.isSelected());
                RenControlEditor.this.updateCode();
            }
        });
        this.lockBackwardsCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.lockBackwardsCheckBox.setToolTipText("Don't turn around target to face backwards when backing up.");
        this.lockBackwardsCheckBox.setOpaque(false);
        this.lockBackwardsCheckBox.setText("Lock Backwards Motion");
        GridBagConstraints gridBagConstraints63 = new GridBagConstraints();
        gridBagConstraints63.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints63.anchor = 18;
        gridBagConstraints63.gridwidth = 2;
        gridBagConstraints63.gridy = 3;
        gridBagConstraints63.gridx = 0;
        ((Container)object5).add((Component)this.lockBackwardsCheckBox, gridBagConstraints63);
        JPanel jPanel13 = new JPanel();
        jPanel13.setOpaque(false);
        jPanel13.setBorder(new TitledBorder(null, "Movement Alignment", 0, 0, null, null));
        jPanel13.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints64 = new GridBagConstraints();
        gridBagConstraints64.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints64.fill = 1;
        gridBagConstraints64.anchor = 18;
        gridBagConstraints64.weightx = 1.0;
        gridBagConstraints64.gridy = 2;
        gridBagConstraints64.gridx = 0;
        jPanel12.add((Component)jPanel13, gridBagConstraints64);
        this.alignCameraRadio = new JRadioButton();
        this.alignCameraRadio.setToolTipText("movements are in relation to the direction the camera is facing");
        this.alignCameraRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((RenControlEditor)RenControlEditor.this).impl.input.setCameraAlignedMovement(true);
                RenControlEditor.this.lockBackwardsCheckBox.setEnabled(true);
                RenControlEditor.this.updateCode();
            }
        });
        this.alignCameraRadio.setMargin(new Insets(0, 0, 0, 0));
        this.alignmentGroup.add(this.alignCameraRadio);
        this.alignCameraRadio.setOpaque(false);
        this.alignCameraRadio.setSelected(true);
        this.alignCameraRadio.setText("Camera Aligned");
        GridBagConstraints gridBagConstraints65 = new GridBagConstraints();
        gridBagConstraints65.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints65.anchor = 18;
        gridBagConstraints65.gridy = 0;
        gridBagConstraints65.gridx = 0;
        jPanel13.add((Component)this.alignCameraRadio, gridBagConstraints65);
        this.alignTargetRadio = new JRadioButton();
        this.alignTargetRadio.setToolTipText("movements are in relation to the direction the target is currently facing");
        this.alignTargetRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((RenControlEditor)RenControlEditor.this).impl.input.setCameraAlignedMovement(false);
                ((RenControlEditor)RenControlEditor.this).impl.input.setLockBackwards(true);
                RenControlEditor.this.lockBackwardsCheckBox.setSelected(true);
                RenControlEditor.this.lockBackwardsCheckBox.setEnabled(false);
                RenControlEditor.this.updateCode();
            }
        });
        this.alignTargetRadio.setMargin(new Insets(0, 0, 0, 0));
        this.alignmentGroup.add(this.alignTargetRadio);
        this.alignTargetRadio.setOpaque(false);
        this.alignTargetRadio.setText("Target Aligned");
        GridBagConstraints gridBagConstraints66 = new GridBagConstraints();
        gridBagConstraints66.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints66.anchor = 18;
        gridBagConstraints66.gridy = 0;
        gridBagConstraints66.gridx = 1;
        jPanel13.add((Component)this.alignTargetRadio, gridBagConstraints66);
        this.strafeAlignTargetBox = new JCheckBox();
        this.strafeAlignTargetBox.setToolTipText("force strafe movements to be target aligned");
        this.strafeAlignTargetBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((RenControlEditor)RenControlEditor.this).impl.input.setStrafeAlignTarget(RenControlEditor.this.strafeAlignTargetBox.isSelected());
                RenControlEditor.this.updateCode();
            }
        });
        this.strafeAlignTargetBox.setOpaque(false);
        this.strafeAlignTargetBox.setText("Strafe is always Target Aligned");
        GridBagConstraints gridBagConstraints67 = new GridBagConstraints();
        gridBagConstraints67.gridwidth = 2;
        gridBagConstraints67.gridy = 1;
        gridBagConstraints67.gridx = 0;
        jPanel13.add((Component)this.strafeAlignTargetBox, gridBagConstraints67);
        JPanel jPanel14 = new JPanel();
        jPanel14.setBorder(new TitledBorder(null, "Speed", 0, 0, null, null));
        jPanel14.setOpaque(false);
        jPanel14.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints68 = new GridBagConstraints();
        gridBagConstraints68.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints68.weightx = 1.0;
        gridBagConstraints68.fill = 1;
        gridBagConstraints68.anchor = 18;
        gridBagConstraints68.gridy = 0;
        gridBagConstraints68.gridx = 0;
        jPanel12.add((Component)jPanel14, gridBagConstraints68);
        JLabel jLabel26 = new JLabel();
        jLabel26.setText("Movement Speed:");
        GridBagConstraints gridBagConstraints69 = new GridBagConstraints();
        gridBagConstraints69.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints69.anchor = 12;
        gridBagConstraints69.gridy = 0;
        gridBagConstraints69.gridx = 0;
        jPanel14.add((Component)jLabel26, gridBagConstraints69);
        this.moveSpeedField = new JTextField();
        this.moveSpeedField.setToolTipText("base acceleration for target movement");
        this.moveSpeedField.setHorizontalAlignment(4);
        this.moveSpeedField.setText("100");
        RenControlEditor.addExpandedNumericVerifier(this.moveSpeedField);
        this.moveSpeedField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.moveSpeedField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.input.setActionSpeed(f);
                RenControlEditor.this.updateCode();
            }
        });
        this.moveSpeedField.setColumns(5);
        GridBagConstraints gridBagConstraints70 = new GridBagConstraints();
        gridBagConstraints70.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints70.anchor = 18;
        gridBagConstraints70.gridy = 0;
        gridBagConstraints70.gridx = 1;
        jPanel14.add((Component)this.moveSpeedField, gridBagConstraints70);
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new GridBagLayout());
        jPanel15.setBorder(new TitledBorder(null, "Keys", 0, 0, null, null));
        jPanel15.setOpaque(false);
        GridBagConstraints gridBagConstraints71 = new GridBagConstraints();
        gridBagConstraints71.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints71.fill = 1;
        gridBagConstraints71.anchor = 18;
        gridBagConstraints71.gridy = 3;
        gridBagConstraints71.gridx = 0;
        jPanel12.add((Component)jPanel15, gridBagConstraints71);
        JLabel jLabel27 = new JLabel();
        jLabel27.setText("Movement Keys:");
        GridBagConstraints gridBagConstraints72 = new GridBagConstraints();
        gridBagConstraints72.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints72.gridwidth = 3;
        gridBagConstraints72.gridx = 0;
        gridBagConstraints72.gridy = 0;
        jPanel15.add((Component)jLabel27, gridBagConstraints72);
        JButton jButton = new JButton();
        this.addKeyDialog(jButton, "fwdKey");
        jButton.setMargin(new Insets(2, 10, 2, 10));
        jButton.setText("W");
        jButton.setToolTipText("forward key");
        this.keys.put("fwdKey", "KEY_W");
        GridBagConstraints gridBagConstraints73 = new GridBagConstraints();
        gridBagConstraints73.anchor = 18;
        gridBagConstraints73.fill = 1;
        gridBagConstraints73.gridy = 1;
        gridBagConstraints73.gridx = 1;
        jPanel15.add((Component)jButton, gridBagConstraints73);
        JButton jButton2 = new JButton();
        this.addKeyDialog(jButton2, "leftKey");
        jButton2.setMargin(new Insets(2, 10, 2, 10));
        jButton2.setText("A");
        jButton2.setToolTipText("left key");
        this.keys.put("leftKey", "KEY_A");
        GridBagConstraints gridBagConstraints74 = new GridBagConstraints();
        gridBagConstraints74.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints74.anchor = 18;
        gridBagConstraints74.fill = 1;
        gridBagConstraints74.gridy = 2;
        gridBagConstraints74.gridx = 0;
        jPanel15.add((Component)jButton2, gridBagConstraints74);
        JButton jButton3 = new JButton();
        this.addKeyDialog(jButton3, "backKey");
        this.keys.put("backKey", "KEY_S");
        jButton3.setMargin(new Insets(2, 10, 2, 10));
        jButton3.setText("S");
        jButton3.setToolTipText("backward key");
        GridBagConstraints gridBagConstraints75 = new GridBagConstraints();
        gridBagConstraints75.anchor = 18;
        gridBagConstraints75.fill = 1;
        gridBagConstraints75.gridy = 2;
        gridBagConstraints75.gridx = 1;
        jPanel15.add((Component)jButton3, gridBagConstraints75);
        JButton jButton4 = new JButton();
        this.addKeyDialog(jButton4, "rightKey");
        this.keys.put("rightKey", "KEY_D");
        jButton4.setText("D");
        jButton4.setToolTipText("right key");
        jButton4.setMargin(new Insets(2, 10, 2, 10));
        GridBagConstraints gridBagConstraints76 = new GridBagConstraints();
        gridBagConstraints76.anchor = 18;
        gridBagConstraints76.fill = 1;
        gridBagConstraints76.gridy = 2;
        gridBagConstraints76.gridx = 2;
        jPanel15.add((Component)jButton4, gridBagConstraints76);
        JLabel jLabel28 = new JLabel();
        jLabel28.setText("Strafe Keys:");
        GridBagConstraints gridBagConstraints77 = new GridBagConstraints();
        gridBagConstraints77.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints77.gridwidth = 3;
        gridBagConstraints77.gridy = 3;
        gridBagConstraints77.gridx = 0;
        jPanel15.add((Component)jLabel28, gridBagConstraints77);
        JButton jButton5 = new JButton();
        this.addKeyDialog(jButton5, "strfLeftKey");
        this.keys.put("strfLeftKey", "KEY_Q");
        jButton5.setText("Q");
        jButton5.setToolTipText("strafe left key");
        jButton5.setMargin(new Insets(2, 10, 2, 10));
        GridBagConstraints gridBagConstraints78 = new GridBagConstraints();
        gridBagConstraints78.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints78.fill = 1;
        gridBagConstraints78.anchor = 18;
        gridBagConstraints78.gridy = 4;
        gridBagConstraints78.gridx = 0;
        jPanel15.add((Component)jButton5, gridBagConstraints78);
        JButton jButton6 = new JButton();
        this.addKeyDialog(jButton6, "strfRightKey");
        this.keys.put("strfRightKey", "KEY_E");
        jButton6.setText("E");
        jButton6.setToolTipText("strafe right key");
        jButton6.setMargin(new Insets(2, 10, 2, 10));
        GridBagConstraints gridBagConstraints79 = new GridBagConstraints();
        gridBagConstraints79.fill = 1;
        gridBagConstraints79.anchor = 18;
        gridBagConstraints79.gridy = 4;
        gridBagConstraints79.gridx = 2;
        jPanel15.add((Component)jButton6, gridBagConstraints79);
        JLabel jLabel29 = new JLabel();
        GridBagConstraints gridBagConstraints80 = new GridBagConstraints();
        gridBagConstraints80.fill = 1;
        gridBagConstraints80.anchor = 18;
        gridBagConstraints80.weighty = 1.0;
        gridBagConstraints80.gridy = 4;
        gridBagConstraints80.gridx = 0;
        jPanel12.add((Component)jLabel29, gridBagConstraints80);
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new GridBagLayout());
        jPanel16.setOpaque(false);
        if (!bl) {
            object4 = new VTextIcon(jTabbedPane, "Tracking");
            jTabbedPane.addTab(null, (Icon)object4, jPanel16, null);
        } else {
            jTabbedPane.addTab("Tracking", null, jPanel16, null);
        }
        object4 = new JPanel();
        ((JComponent)object4).setBorder(new TitledBorder(null, "View Offset", 0, 0, null, null));
        ((JComponent)object4).setOpaque(false);
        ((Container)object4).setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints81 = new GridBagConstraints();
        gridBagConstraints81.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints81.fill = 1;
        gridBagConstraints81.anchor = 18;
        gridBagConstraints81.weightx = 1.0;
        gridBagConstraints81.gridy = 0;
        gridBagConstraints81.gridx = 0;
        jPanel16.add((Component)object4, gridBagConstraints81);
        this.offsetRelativeRadio = new JRadioButton();
        this.offsetRelativeRadio.setToolTipText("lock view onto a point defined by a ratio of target height");
        this.offsetRelativeRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RenControlEditor.this.offsetRatioField.setEnabled(true);
                RenControlEditor.this.offsetXField.setEnabled(false);
                RenControlEditor.this.offsetYField.setEnabled(false);
                RenControlEditor.this.offsetZField.setEnabled(false);
                RenControlEditor.this.updateCode();
            }
        });
        this.offsetRelativeRadio.setSelected(true);
        this.offsetGroup.add(this.offsetRelativeRadio);
        this.offsetRelativeRadio.setMargin(new Insets(0, 0, 0, 0));
        this.offsetRelativeRadio.setOpaque(false);
        this.offsetRelativeRadio.setText("By Height Ratio (of bounds)");
        GridBagConstraints gridBagConstraints82 = new GridBagConstraints();
        gridBagConstraints82.anchor = 18;
        gridBagConstraints82.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints82.gridwidth = 3;
        gridBagConstraints82.gridy = 0;
        gridBagConstraints82.gridx = 0;
        ((Container)object4).add((Component)this.offsetRelativeRadio, gridBagConstraints82);
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            public void update() {
                RenControlEditor.this.updateOffset();
                RenControlEditor.this.updateCode();
            }
        };
        this.offsetRatioField = new JTextField();
        this.offsetRatioField.setToolTipText("height ratio to use");
        this.offsetRatioField.setText("1.5");
        RenControlEditor.addExpandedNumericVerifier(this.offsetRatioField);
        this.offsetRatioField.getDocument().addDocumentListener(documentAdapter);
        this.offsetRatioField.setColumns(5);
        GridBagConstraints gridBagConstraints83 = new GridBagConstraints();
        gridBagConstraints83.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints83.anchor = 18;
        gridBagConstraints83.gridy = 1;
        gridBagConstraints83.gridx = 0;
        ((Container)object4).add((Component)this.offsetRatioField, gridBagConstraints83);
        this.offsetAbsRadio = new JRadioButton();
        this.offsetAbsRadio.setToolTipText("lock view onto a point defined as an offset of the current target location");
        this.offsetGroup.add(this.offsetAbsRadio);
        this.offsetAbsRadio.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RenControlEditor.this.offsetRatioField.setEnabled(false);
                RenControlEditor.this.offsetXField.setEnabled(true);
                RenControlEditor.this.offsetYField.setEnabled(true);
                RenControlEditor.this.offsetZField.setEnabled(true);
                RenControlEditor.this.updateCode();
            }
        });
        this.offsetAbsRadio.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints84 = new GridBagConstraints();
        gridBagConstraints84.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints84.anchor = 18;
        gridBagConstraints84.gridwidth = 3;
        gridBagConstraints84.gridy = 2;
        gridBagConstraints84.gridx = 0;
        ((Container)object4).add((Component)this.offsetAbsRadio, gridBagConstraints84);
        this.offsetAbsRadio.setOpaque(false);
        this.offsetAbsRadio.setText("Absolute Offset (x, y, z)");
        this.offsetXField = new JTextField();
        this.offsetXField.setToolTipText("X value of offset");
        this.offsetXField.setText("0.0");
        this.offsetXField.setEnabled(false);
        RenControlEditor.addExpandedNumericVerifier(this.offsetXField);
        this.offsetXField.getDocument().addDocumentListener(documentAdapter);
        this.offsetXField.setColumns(5);
        GridBagConstraints gridBagConstraints85 = new GridBagConstraints();
        gridBagConstraints85.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints85.anchor = 18;
        gridBagConstraints85.gridy = 3;
        gridBagConstraints85.gridx = 0;
        ((Container)object4).add((Component)this.offsetXField, gridBagConstraints85);
        this.offsetYField = new JTextField();
        this.offsetYField.setToolTipText("Y value of offset");
        this.offsetYField.setText("0.0");
        this.offsetYField.setEnabled(false);
        RenControlEditor.addExpandedNumericVerifier(this.offsetYField);
        this.offsetYField.getDocument().addDocumentListener(documentAdapter);
        this.offsetYField.setColumns(5);
        GridBagConstraints gridBagConstraints86 = new GridBagConstraints();
        gridBagConstraints86.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints86.anchor = 18;
        gridBagConstraints86.gridy = 3;
        gridBagConstraints86.gridx = 1;
        ((Container)object4).add((Component)this.offsetYField, gridBagConstraints86);
        this.offsetZField = new JTextField();
        this.offsetZField.setToolTipText("Z value of offset");
        this.offsetZField.setText("0.0");
        this.offsetZField.setEnabled(false);
        RenControlEditor.addExpandedNumericVerifier(this.offsetZField);
        this.offsetZField.getDocument().addDocumentListener(documentAdapter);
        this.offsetZField.setColumns(5);
        GridBagConstraints gridBagConstraints87 = new GridBagConstraints();
        gridBagConstraints87.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints87.anchor = 18;
        gridBagConstraints87.gridy = 3;
        gridBagConstraints87.gridx = 2;
        ((Container)object4).add((Component)this.offsetZField, gridBagConstraints87);
        JLabel jLabel30 = new JLabel();
        GridBagConstraints gridBagConstraints88 = new GridBagConstraints();
        gridBagConstraints88.fill = 1;
        gridBagConstraints88.anchor = 18;
        gridBagConstraints88.weighty = 1.0;
        gridBagConstraints88.gridy = 1;
        gridBagConstraints88.gridx = 0;
        jPanel16.add((Component)jLabel30, gridBagConstraints88);
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new GridBagLayout());
        jPanel17.setOpaque(false);
        if (!bl) {
            object3 = new VTextIcon(jTabbedPane, "Test Scene");
            jTabbedPane.addTab(null, (Icon)object3, jPanel17, null);
        } else {
            jTabbedPane.addTab("Test Scene", null, jPanel17, null);
        }
        object3 = new JPanel();
        ((JComponent)object3).setBorder(new TitledBorder(null, "World", 0, 0, null, null));
        ((Container)object3).setLayout(new GridBagLayout());
        ((JComponent)object3).setOpaque(false);
        GridBagConstraints gridBagConstraints89 = new GridBagConstraints();
        gridBagConstraints89.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints89.fill = 1;
        gridBagConstraints89.anchor = 18;
        gridBagConstraints89.weightx = 1.0;
        gridBagConstraints89.gridy = 0;
        gridBagConstraints89.gridx = 0;
        jPanel17.add((Component)object3, gridBagConstraints89);
        JLabel jLabel31 = new JLabel();
        jLabel31.setText("Landscape:");
        GridBagConstraints gridBagConstraints90 = new GridBagConstraints();
        gridBagConstraints90.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints90.anchor = 12;
        gridBagConstraints90.gridy = 0;
        gridBagConstraints90.gridx = 0;
        ((Container)object3).add((Component)jLabel31, gridBagConstraints90);
        this.landTypeCB = new JComboBox<String>(new String[]{"Random Terrain"});
        this.landTypeCB.setToolTipText("Landscape of world to use in demo");
        GridBagConstraints gridBagConstraints91 = new GridBagConstraints();
        gridBagConstraints91.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints91.anchor = 18;
        gridBagConstraints91.gridy = 0;
        gridBagConstraints91.gridx = 1;
        ((Container)object3).add((Component)this.landTypeCB, gridBagConstraints91);
        JPanel jPanel18 = new JPanel();
        jPanel18.setBorder(new TitledBorder(null, "Target", 0, 0, null, null));
        jPanel18.setOpaque(false);
        jPanel18.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints92 = new GridBagConstraints();
        gridBagConstraints92.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints92.fill = 1;
        gridBagConstraints92.anchor = 18;
        gridBagConstraints92.weightx = 1.0;
        gridBagConstraints92.gridy = 1;
        gridBagConstraints92.gridx = 0;
        jPanel17.add((Component)jPanel18, gridBagConstraints92);
        JLabel jLabel32 = new JLabel();
        jLabel32.setText("Model:");
        GridBagConstraints gridBagConstraints93 = new GridBagConstraints();
        gridBagConstraints93.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints93.anchor = 12;
        gridBagConstraints93.gridy = 0;
        gridBagConstraints93.gridx = 0;
        jPanel18.add((Component)jLabel32, gridBagConstraints93);
        this.targetTypeCB = new JComboBox<String>(new String[]{"1 unit Box (.5,.5,.5)"});
        this.targetTypeCB.setToolTipText("Model to use as target in demo");
        GridBagConstraints gridBagConstraints94 = new GridBagConstraints();
        gridBagConstraints94.gridwidth = 3;
        gridBagConstraints94.anchor = 18;
        gridBagConstraints94.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints94.gridy = 0;
        gridBagConstraints94.gridx = 1;
        jPanel18.add((Component)this.targetTypeCB, gridBagConstraints94);
        JLabel jLabel33 = new JLabel();
        jLabel33.setText("Scale (x,y,z):");
        GridBagConstraints gridBagConstraints95 = new GridBagConstraints();
        gridBagConstraints95.anchor = 18;
        gridBagConstraints95.gridwidth = 6;
        gridBagConstraints95.insets = new Insets(4, 4, 0, 0);
        gridBagConstraints95.gridy = 1;
        gridBagConstraints95.gridx = 0;
        jPanel18.add((Component)jLabel33, gridBagConstraints95);
        this.scaleXField = new JTextField();
        this.scaleXField.setToolTipText("X scale of target model in demo");
        this.scaleXField.setHorizontalAlignment(4);
        this.scaleXField.setText("10");
        RenControlEditor.addExpandedNumericVerifier(this.scaleXField);
        this.scaleXField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.scaleXField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.target.getLocalScale().x = f;
                RenControlEditor.this.updateOffset();
                RenControlEditor.this.updateCode();
            }
        });
        this.scaleXField.setColumns(5);
        GridBagConstraints gridBagConstraints96 = new GridBagConstraints();
        gridBagConstraints96.gridwidth = 2;
        gridBagConstraints96.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints96.anchor = 12;
        gridBagConstraints96.gridy = 2;
        gridBagConstraints96.gridx = 0;
        jPanel18.add((Component)this.scaleXField, gridBagConstraints96);
        this.scaleYField = new JTextField();
        this.scaleYField.setToolTipText("Y scale of target model in demo");
        this.scaleYField.setHorizontalAlignment(4);
        this.scaleYField.setText("10");
        RenControlEditor.addExpandedNumericVerifier(this.scaleYField);
        this.scaleYField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.scaleYField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.target.getLocalScale().y = f;
                ((RenControlEditor)RenControlEditor.this).impl.m_character.updateGeometricState(0.0f, true);
                RenControlEditor.this.updateOffset();
                RenControlEditor.this.updateCode();
            }
        });
        this.scaleYField.setColumns(5);
        GridBagConstraints gridBagConstraints97 = new GridBagConstraints();
        gridBagConstraints97.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints97.anchor = 18;
        gridBagConstraints97.gridy = 2;
        gridBagConstraints97.gridx = 2;
        jPanel18.add((Component)this.scaleYField, gridBagConstraints97);
        this.scaleZField = new JTextField();
        this.scaleZField.setToolTipText("Z scale of target model in demo");
        this.scaleZField.setHorizontalAlignment(4);
        this.scaleZField.setText("10");
        RenControlEditor.addExpandedNumericVerifier(this.scaleZField);
        this.scaleZField.getDocument().addDocumentListener(new DocumentAdapter(){

            public void update() {
                String string = RenControlEditor.this.scaleZField.getText();
                float f = 0.0f;
                try {
                    f = Float.parseFloat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                ((RenControlEditor)RenControlEditor.this).impl.target.getLocalScale().z = f;
                RenControlEditor.this.updateOffset();
                RenControlEditor.this.updateCode();
            }
        });
        this.scaleZField.setColumns(5);
        GridBagConstraints gridBagConstraints98 = new GridBagConstraints();
        gridBagConstraints98.insets = new Insets(2, 4, 0, 0);
        gridBagConstraints98.anchor = 18;
        gridBagConstraints98.gridy = 2;
        gridBagConstraints98.gridx = 3;
        jPanel18.add((Component)this.scaleZField, gridBagConstraints98);
        JLabel jLabel34 = new JLabel();
        GridBagConstraints gridBagConstraints99 = new GridBagConstraints();
        gridBagConstraints99.fill = 1;
        gridBagConstraints99.anchor = 18;
        gridBagConstraints99.weighty = 1.0;
        gridBagConstraints99.gridy = 2;
        gridBagConstraints99.gridx = 0;
        jPanel17.add((Component)jLabel34, gridBagConstraints99);
        JPanel jPanel19 = new JPanel();
        jPanel19.setOpaque(false);
        jPanel19.setLayout(new GridBagLayout());
        if (!bl) {
            object2 = new VTextIcon(jTabbedPane, "Examples");
            jTabbedPane.addTab(null, (Icon)object2, jPanel19, null);
        } else {
            jTabbedPane.addTab("Examples", null, jPanel19, null);
        }
        object2 = new JLabel();
        ((JLabel)object2).setText("Example Control Settings:");
        GridBagConstraints gridBagConstraints100 = new GridBagConstraints();
        gridBagConstraints100.insets = new Insets(10, 4, 0, 4);
        gridBagConstraints100.gridx = 0;
        gridBagConstraints100.gridy = 0;
        jPanel19.add((Component)object2, gridBagConstraints100);
        JScrollPane jScrollPane = new JScrollPane();
        GridBagConstraints gridBagConstraints101 = new GridBagConstraints();
        gridBagConstraints101.weighty = 0.8;
        gridBagConstraints101.weightx = 1.0;
        gridBagConstraints101.fill = 1;
        gridBagConstraints101.insets = new Insets(4, 10, 0, 10);
        gridBagConstraints101.gridy = 1;
        gridBagConstraints101.gridx = 0;
        jPanel19.add((Component)jScrollPane, gridBagConstraints101);
        this.examplesList = new JList<String>(new String[]{"Plumber 64", "Max Payne-ish"});
        this.examplesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RenControlEditor.this.applyExampleButton.setEnabled(RenControlEditor.this.examplesList.getSelectedIndex() > -1);
            }
        });
        jScrollPane.setViewportView(this.examplesList);
        this.applyExampleButton = new JButton();
        this.applyExampleButton.setEnabled(false);
        this.applyExampleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RenControlEditor.this.applyExample(RenControlEditor.this.examplesList.getSelectedIndex());
            }
        });
        this.applyExampleButton.setText("Apply");
        GridBagConstraints gridBagConstraints102 = new GridBagConstraints();
        gridBagConstraints102.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints102.gridy = 2;
        gridBagConstraints102.gridx = 0;
        jPanel19.add((Component)this.applyExampleButton, gridBagConstraints102);
        JLabel jLabel35 = new JLabel();
        GridBagConstraints gridBagConstraints103 = new GridBagConstraints();
        gridBagConstraints103.weightx = 1.0;
        gridBagConstraints103.weighty = 0.2;
        gridBagConstraints103.fill = 1;
        gridBagConstraints103.anchor = 18;
        gridBagConstraints103.gridy = 3;
        gridBagConstraints103.gridx = 0;
        jPanel19.add((Component)jLabel35, gridBagConstraints103);
        JPanel jPanel20 = new JPanel();
        jPanel20.setOpaque(false);
        jPanel20.setLayout(new GridBagLayout());
        if (!bl) {
            object = new VTextIcon(jTabbedPane, "Code");
            jTabbedPane.addTab(null, (Icon)object, jPanel20, null);
        } else {
            jTabbedPane.addTab("Code", null, jPanel20, null);
        }
        object = new JButton();
        ((JComponent)object).setToolTipText("Copy code to system clipboard.");
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RenControlEditor.this.codeArea.selectAll();
                RenControlEditor.this.codeArea.copy();
                RenControlEditor.this.codeArea.setCaretPosition(0);
            }
        });
        ((AbstractButton)object).setText("Copy");
        GridBagConstraints gridBagConstraints104 = new GridBagConstraints();
        gridBagConstraints104.insets = new Insets(4, 4, 0, 4);
        gridBagConstraints104.gridx = 0;
        gridBagConstraints104.gridy = 2;
        jPanel20.add((Component)object, gridBagConstraints104);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setHorizontalScrollBarPolicy(32);
        GridBagConstraints gridBagConstraints105 = new GridBagConstraints();
        gridBagConstraints105.insets = new Insets(4, 10, 0, 10);
        gridBagConstraints105.fill = 1;
        gridBagConstraints105.anchor = 18;
        gridBagConstraints105.weighty = 0.8;
        gridBagConstraints105.weightx = 1.0;
        gridBagConstraints105.gridy = 1;
        gridBagConstraints105.gridx = 0;
        jPanel20.add((Component)jScrollPane2, gridBagConstraints105);
        this.codeArea = new JTextArea();
        this.codeArea.setFont(new Font("Monospaced", 0, 10));
        this.codeArea.setText("");
        this.codeArea.setEditable(false);
        this.codeArea.setAutoscrolls(true);
        jScrollPane2.setViewportView(this.codeArea);
        JLabel jLabel36 = new JLabel();
        GridBagConstraints gridBagConstraints106 = new GridBagConstraints();
        gridBagConstraints106.fill = 1;
        gridBagConstraints106.anchor = 18;
        gridBagConstraints106.weighty = 0.2;
        gridBagConstraints106.gridy = 3;
        gridBagConstraints106.gridx = 0;
        jPanel20.add((Component)jLabel36, gridBagConstraints106);
        JLabel jLabel37 = new JLabel();
        jLabel37.setText("Current Handler Code:");
        GridBagConstraints gridBagConstraints107 = new GridBagConstraints();
        gridBagConstraints107.insets = new Insets(10, 4, 0, 4);
        gridBagConstraints107.gridx = 0;
        gridBagConstraints107.gridy = 0;
        jPanel20.add((Component)jLabel37, gridBagConstraints107);
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints108 = new GridBagConstraints();
        gridBagConstraints108.anchor = 18;
        gridBagConstraints108.gridwidth = 2;
        gridBagConstraints108.weightx = 1.0;
        gridBagConstraints108.fill = 1;
        gridBagConstraints108.gridx = 0;
        gridBagConstraints108.gridy = 1;
        jPanel.add((Component)jPanel21, gridBagConstraints108);
        JLabel jLabel38 = new JLabel();
        jLabel38.setText("Click and drag in the Test area to control.  WASDQE controls target.");
        GridBagConstraints gridBagConstraints109 = new GridBagConstraints();
        gridBagConstraints109.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints109.anchor = 18;
        gridBagConstraints109.gridx = 0;
        gridBagConstraints109.gridy = 0;
        jPanel21.add((Component)jLabel38, gridBagConstraints109);
        JLabel jLabel39 = new JLabel();
        GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
        gridBagConstraints110.anchor = 18;
        gridBagConstraints110.fill = 1;
        gridBagConstraints110.weightx = 1.0;
        gridBagConstraints110.gridy = 0;
        gridBagConstraints110.gridx = 1;
        jPanel21.add((Component)jLabel39, gridBagConstraints110);
        JScrollPane jScrollPane3 = new JScrollPane(jPanel);
        this.getContentPane().add((Component)jScrollPane3, "Center");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        while (this.glCanvas == null || this.impl.startTime == 0L) {
        }
        new Thread(){
            {
                this.setDaemon(true);
            }

            public void run() {
                while (true) {
                    RenControlEditor.this.glCanvas.repaint();
                    39.yield();
                }
            }
        }.start();
        this.glCanvas.setSize(this.glCanvas.getWidth(), this.glCanvas.getHeight() + 1);
        this.glCanvas.setSize(this.glCanvas.getWidth(), this.glCanvas.getHeight() - 1);
        this.updateCode();
    }

    private void addKeyDialog(final JButton jButton, final String string) {
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyInputDialog keyInputDialog = new KeyInputDialog(RenControlEditor.this);
                keyInputDialog.setLocationRelativeTo(jButton);
                keyInputDialog.setVisible(true);
                int n = keyInputDialog.event.getKeyCode();
                jButton.setText(KeyEvent.getKeyText(n));
                KeyBindingManager keyBindingManager = KeyBindingManager.getKeyBindingManager();
                keyBindingManager.set(string, AWTKeyInput.toInputCode((int)n));
                RenControlEditor.this.keys.put(string, AWTKeyInput.getKeyParam((int)n));
                RenControlEditor.this.updateCode();
            }
        });
    }

    private void updateFromImpl() {
        this.rotateOnlyBox.setSelected(this.impl.input.isRotateOnly());
        this.gradualTurnsCheckBox.setSelected(this.impl.input.isDoGradualRotation());
        this.turnSpeedField.setText("" + this.impl.input.getTurnSpeed());
        this.lockBackwardsCheckBox.setSelected(this.impl.input.isLockBackwards());
        if (this.impl.input.isCameraAlignedMovement()) {
            this.alignCameraRadio.setSelected(true);
        } else {
            this.alignTargetRadio.setSelected(true);
        }
        this.strafeAlignTargetBox.setSelected(this.impl.input.isStrafeAlignTarget());
        this.moveSpeedField.setText("" + this.impl.input.getSpeed());
        this.enableSpringsCheckBox.setSelected(this.impl.chaser.isEnableSpring());
        this.dampingKField.setText("" + this.impl.chaser.getDampingK());
        this.springKField.setText("" + this.impl.chaser.getSpringK());
        this.maxDistanceField.setText("" + this.impl.chaser.getMaxDistance());
        this.minDistanceField.setText("" + this.impl.chaser.getMinDistance());
        this.radiusField.setText("" + this.impl.chaser.getIdealSphereCoords().x);
        this.polarField.setText("" + this.impl.chaser.getIdealSphereCoords().z / ((float)Math.PI / 180));
        this.stayBehindTargetBox.setSelected(this.impl.chaser.isStayBehindTarget());
        this.offsetXField.setText("" + this.impl.chaser.getTargetOffset().x);
        this.offsetYField.setText("" + this.impl.chaser.getTargetOffset().y);
        this.offsetZField.setText("" + this.impl.chaser.getTargetOffset().z);
        this.rotateOnlyBox.setSelected(this.impl.chaser.getMouseLook().isEnabled());
        this.maxAscentSlider.setValue((int)(this.impl.chaser.getMouseLook().getMaxAscent() / ((float)Math.PI / 180)));
        this.minAscentSlider.setValue((int)(this.impl.chaser.getMouseLook().getMinAscent() / ((float)Math.PI / 180)));
        this.invertControlCheckBox.setSelected(this.impl.chaser.getMouseLook().isInvertedY());
        this.turnWithCameraBox.setSelected(this.impl.chaser.getMouseLook().isRotateTarget());
        this.turnWithCamSpeedField.setText("" + this.impl.chaser.getMouseLook().getTargetTurnSpeed() / ((float)Math.PI / 180));
        this.minZoomField.setText("" + this.impl.chaser.getMouseLook().getMinRollOut());
        this.maxZoomField.setText("" + this.impl.chaser.getMouseLook().getMaxRollOut());
        this.accelHorizontalField.setText("" + this.impl.chaser.getMouseLook().getMouseXMultiplier());
        this.accelVerticalField.setText("" + this.impl.chaser.getMouseLook().getMouseYMultiplier());
        this.accelZoomField.setText("" + this.impl.chaser.getMouseLook().getMouseRollMultiplier());
        this.lockPolarBox.setSelected(this.impl.chaser.getMouseLook().isLockAscent());
        this.camSpeedField.setText("" + this.impl.chaser.getSpeed());
        this.updateCode();
    }

    private void updateCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HashMap handlerProps = new HashMap();\n");
        stringBuffer.append("handlerProps.put(ThirdPersonHandler.PROP_ROTATEONLY, \"" + this.rotateOnlyBox.isSelected() + "\");\n");
        stringBuffer.append("handlerProps.put(ThirdPersonHandler.PROP_DOGRADUAL, \"" + this.gradualTurnsCheckBox.isSelected() + "\");\n");
        if (this.gradualTurnsCheckBox.isSelected()) {
            stringBuffer.append("handlerProps.put(ThirdPersonHandler.PROP_TURNSPEED, \"" + this.turnSpeedField.getText() + "\");\n");
        }
        stringBuffer.append("handlerProps.put(ThirdPersonHandler.PROP_LOCKBACKWARDS, \"" + this.lockBackwardsCheckBox.isSelected() + "\");\n");
        stringBuffer.append("handlerProps.put(ThirdPersonHandler.PROP_STRAFETARGETALIGN, \"" + this.strafeAlignTargetBox.isSelected() + "\");\n");
        stringBuffer.append("handlerProps.put(ThirdPersonHandler.PROP_CAMERAALIGNEDMOVE, \"" + this.alignCameraRadio.isSelected() + "\");\n\n");
        stringBuffer.append("handlerProps.put(ThirdPersonHandler.PROP_KEY_FORWARD, \"\"+KeyInput." + this.keys.get("fwdKey") + ");\n");
        stringBuffer.append("handlerProps.put(ThirdPersonHandler.PROP_KEY_LEFT, \"\"+KeyInput." + this.keys.get("leftKey") + ");\n");
        stringBuffer.append("handlerProps.put(ThirdPersonHandler.PROP_KEY_BACKWARD, \"\"+KeyInput." + this.keys.get("backKey") + ");\n");
        stringBuffer.append("handlerProps.put(ThirdPersonHandler.PROP_KEY_RIGHT, \"\"+KeyInput." + this.keys.get("rightKey") + ");\n");
        stringBuffer.append("handlerProps.put(ThirdPersonHandler.PROP_KEY_STRAFELEFT, \"\"+KeyInput." + this.keys.get("strfLeftKey") + ");\n");
        stringBuffer.append("handlerProps.put(ThirdPersonHandler.PROP_KEY_STRAFERIGHT, \"\"+KeyInput." + this.keys.get("strfRightKey") + ");\n");
        stringBuffer.append("input = new ThirdPersonHandler(myTarget, cam, handlerProps);\n");
        stringBuffer.append("input.setActionSpeed(" + this.moveSpeedField.getText() + "f);\n");
        stringBuffer.append("\nHashMap chaserProps = new HashMap();\n");
        stringBuffer.append("chaserProps.put(ChaseCamera.PROP_ENABLESPRING, \"" + this.enableSpringsCheckBox.isSelected() + "\");\n");
        if (this.enableSpringsCheckBox.isSelected()) {
            stringBuffer.append("chaserProps.put(ChaseCamera.PROP_DAMPINGK, \"" + this.dampingKField.getText() + "\");\n");
            stringBuffer.append("chaserProps.put(ChaseCamera.PROP_SPRINGK, \"" + this.springKField.getText() + "\");\n");
            stringBuffer.append("chaserProps.put(ChaseCamera.PROP_MAXDISTANCE, \"" + this.maxDistanceField.getText() + "\");\n");
            stringBuffer.append("chaserProps.put(ChaseCamera.PROP_MINDISTANCE, \"" + this.minDistanceField.getText() + "\");\n");
        }
        stringBuffer.append("chaserProps.put(ChaseCamera.PROP_INITIALSPHERECOORDS, new Vector3f(" + this.radiusField.getText() + "f, 0f, FastMath.DEG_TO_RAD * " + this.polarField.getText() + "f));\n");
        stringBuffer.append("chaserProps.put(ChaseCamera.PROP_STAYBEHINDTARGET, \"" + this.stayBehindTargetBox.isSelected() + "\");\n");
        if (this.offsetRelativeRadio.isSelected()) {
            stringBuffer.append("chaserProps.put(ChaseCamera.PROP_TARGETOFFSET, new Vector3f(0f, ((BoundingBox) myTarget.getWorldBound()).yExtent * " + this.offsetRatioField.getText() + "f, 0f));\n");
        } else {
            stringBuffer.append("chaserProps.put(ChaseCamera.PROP_TARGETOFFSET, new Vector3f(" + this.offsetXField.getText() + "f, " + this.offsetYField.getText() + "f, " + this.offsetZField.getText() + "f));\n");
        }
        stringBuffer.append("chaserProps.put(ThirdPersonMouseLook.PROP_ENABLED, \"" + this.enableMouseLookBox.isSelected() + "\");\n");
        if (this.enableMouseLookBox.isSelected()) {
            stringBuffer.append("chaserProps.put(ThirdPersonMouseLook.PROP_MAXASCENT, \"\" + FastMath.DEG_TO_RAD * " + this.maxAscentSlider.getValue() + ");\n");
            stringBuffer.append("chaserProps.put(ThirdPersonMouseLook.PROP_MINASCENT, \"\" + FastMath.DEG_TO_RAD * " + this.minAscentSlider.getValue() + ");\n");
            stringBuffer.append("chaserProps.put(ThirdPersonMouseLook.PROP_INVERTEDY, \"" + this.invertControlCheckBox.isSelected() + "\");\n");
            stringBuffer.append("chaserProps.put(ThirdPersonMouseLook.PROP_ROTATETARGET, \"" + this.turnWithCameraBox.isSelected() + "\");\n");
            if (this.turnWithCameraBox.isSelected()) {
                stringBuffer.append("chaserProps.put(ThirdPersonMouseLook.PROP_TARGETTURNSPEED, \"\" + FastMath.DEG_TO_RAD * " + this.turnWithCamSpeedField.getText() + ");\n");
            }
            stringBuffer.append("chaserProps.put(ThirdPersonMouseLook.PROP_MINROLLOUT, \"" + this.minZoomField.getText() + "\");\n");
            stringBuffer.append("chaserProps.put(ThirdPersonMouseLook.PROP_MAXROLLOUT, \"" + this.maxZoomField.getText() + "\");\n");
            stringBuffer.append("chaserProps.put(ThirdPersonMouseLook.PROP_MOUSEXMULT, \"" + this.accelHorizontalField.getText() + "\");\n");
            stringBuffer.append("chaserProps.put(ThirdPersonMouseLook.PROP_MOUSEYMULT, \"" + this.accelVerticalField.getText() + "\");\n");
            stringBuffer.append("chaserProps.put(ThirdPersonMouseLook.PROP_MOUSEROLLMULT, \"" + this.accelZoomField.getText() + "\");\n");
            stringBuffer.append("chaserProps.put(ThirdPersonMouseLook.PROP_LOCKASCENT, \"" + this.lockPolarBox.isSelected() + "\");\n");
        }
        stringBuffer.append("chaser = new ChaseCamera(cam, m_character, chaserProps);\n");
        stringBuffer.append("chaser.setActionSpeed(" + this.camSpeedField.getText() + "f);");
        this.codeArea.setText(stringBuffer.toString());
        this.codeArea.setCaretPosition(0);
    }

    private void updateOffset() {
        Vector3f vector3f = this.impl.chaser.getTargetOffset();
        if (this.offsetRelativeRadio.isSelected()) {
            String string = this.offsetRatioField.getText();
            float f = 0.0f;
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            vector3f.set(0.0f, ((BoundingBox)this.impl.m_character.getWorldBound()).yExtent * f, 0.0f);
        } else {
            String string = this.offsetXField.getText();
            float f = 0.0f;
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            vector3f.x = f;
            string = this.offsetYField.getText();
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            vector3f.y = f;
            string = this.offsetZField.getText();
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            vector3f.z = f;
        }
    }

    public Dimension getMinimumSize() {
        return MIN_DIMENSION;
    }

    protected Canvas getGlCanvas() {
        if (this.glCanvas == null) {
            this.glCanvas = DisplaySystem.getDisplaySystem((String)"LWJGL").createCanvas(this.width, this.height);
            this.glCanvas.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    RenControlEditor.this.impl.resizeCanvas(((RenControlEditor)RenControlEditor.this).glCanvas.getSize().width, ((RenControlEditor)RenControlEditor.this).glCanvas.getSize().height);
                }
            });
            this.glCanvas.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    ((AWTKeyInput)KeyInput.get()).setEnabled(true);
                    ((AWTMouseInput)MouseInput.get()).setEnabled(true);
                }

                public void focusLost(FocusEvent focusEvent) {
                    ((AWTKeyInput)KeyInput.get()).setEnabled(false);
                    ((AWTMouseInput)MouseInput.get()).setEnabled(false);
                }
            });
            ((JMECanvas)this.glCanvas).setUpdateInput(true);
            KeyInput.setProvider((String)"AWT");
            ((AWTKeyInput)KeyInput.get()).setEnabled(false);
            KeyListener keyListener = (KeyListener)KeyInput.get();
            this.glCanvas.addKeyListener(keyListener);
            AWTMouseInput.setup((Canvas)this.glCanvas, (boolean)true);
            this.impl = new ControlImplementor(this.width, this.height);
            ((JMECanvas)this.glCanvas).setImplementor((JMECanvasImplementor)this.impl);
        }
        return this.glCanvas;
    }

    public static void addExpandedNumericVerifier(final JTextField jTextField) {
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c != '\b' && c != '\u007f') {
                    String string = jTextField.getText();
                    if (jTextField.getSelectedText() != null && jTextField.getSelectedText().length() > 0) {
                        string = jTextField.getSelectionStart() == 0 ? (jTextField.getSelectionEnd() == string.length() ? "" : string.substring(jTextField.getSelectionEnd() + 1)) : (jTextField.getSelectionEnd() == string.length() ? string.substring(0, jTextField.getSelectionStart()) : string.substring(0, jTextField.getSelectionStart()) + string.substring(jTextField.getSelectionEnd() + 1));
                    }
                    boolean bl = false;
                    if (c == '.' || c == '-') {
                        if (c == '-' && jTextField.getCaretPosition() == 0) {
                            bl = true;
                        }
                        if (c == '.' && (string.length() == 0 || string.substring(0, string.length()).indexOf(46) == -1)) {
                            bl = true;
                        }
                    } else if (Character.isDigit(c) && jTextField.getCaretPosition() > string.indexOf("-")) {
                        bl = true;
                    }
                    if (!bl) {
                        jTextField.getToolkit().beep();
                        keyEvent.consume();
                    }
                }
            }
        });
    }

    private void applyExample(int n) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        switch (n) {
            case 0: {
                hashMap2.put("rotateOnly", "false");
                hashMap2.put("doGradual", "true");
                hashMap2.put("turnSpeed", "3.1415");
                hashMap2.put("lockBackwards", "false");
                hashMap2.put("targetAlignStrafe", "true");
                hashMap2.put("cameraAlignedMovement", "true");
                hashMap2.put("fwdKey", "17");
                hashMap2.put("leftKey", "30");
                hashMap2.put("backKey", "31");
                hashMap2.put("rightKey", "32");
                hashMap2.put("strfLeftKey", "16");
                hashMap2.put("strfRightKey", "18");
                this.impl.input.updateProperties(hashMap2);
                this.impl.input.setActionSpeed(180.0f);
                hashMap.put("disableSpring", "true");
                hashMap.put("dampingK", "10");
                hashMap.put("springK", "25.0");
                hashMap.put("maxDistance", "200");
                hashMap.put("minDistance", "0");
                hashMap.put("sphereCoords", (String)new Vector3f(100.0f, 0.0f, 0.5235988f));
                hashMap.put("stayBehindTarget", "false");
                hashMap.put("targetOffset", (String)new Vector3f(0.0f, ((BoundingBox)this.impl.m_character.getWorldBound()).yExtent * 1.5f, 0.0f));
                hashMap.put("lookEnabled", "true");
                hashMap.put("maxAscent", "0.7853982");
                hashMap.put("invertedY", "false");
                hashMap.put("minRollOut", "20.0");
                hashMap.put("maxRollOut", "200.0");
                hashMap.put("mouseXMult", "2.0");
                hashMap.put("mouseYMult", "30.0");
                hashMap.put("mouseRollMult", "80.0");
                hashMap.put("lockAscent", "false");
                this.impl.chaser.updateProperties(hashMap);
                this.impl.chaser.setActionSpeed(1.0f);
                break;
            }
            case 1: {
                hashMap2.put("rotateOnly", "true");
                hashMap2.put("doGradual", "true");
                hashMap2.put("turnSpeed", "3.1415");
                hashMap2.put("lockBackwards", "true");
                hashMap2.put("cameraAlignedMovement", "false");
                hashMap2.put("targetAlignStrafe", "true");
                hashMap2.put("fwdKey", "17");
                hashMap2.put("leftKey", "30");
                hashMap2.put("backKey", "31");
                hashMap2.put("rightKey", "32");
                hashMap2.put("strfLeftKey", "16");
                hashMap2.put("strfRightKey", "18");
                this.impl.input.updateProperties(hashMap2);
                this.impl.input.setActionSpeed(250.0f);
                hashMap.put("disableSpring", "true");
                hashMap.put("dampingK", "55");
                hashMap.put("springK", "756.25");
                hashMap.put("maxDistance", "0");
                hashMap.put("minDistance", "0");
                hashMap.put("sphereCoords", (String)new Vector3f(65.0f, 0.0f, 0.20943952f));
                hashMap.put("stayBehindTarget", "true");
                hashMap.put("targetOffset", (String)new Vector3f(0.0f, ((BoundingBox)this.impl.m_character.getWorldBound()).yExtent * 1.6f, 0.0f));
                hashMap.put("maxAscent", "1.4835298");
                hashMap.put("invertedY", "false");
                hashMap.put("minRollOut", "30");
                hashMap.put("maxRollOut", "240.0");
                hashMap.put("mouseXMult", "2.0");
                hashMap.put("mouseYMult", "30.0");
                hashMap.put("mouseRollMult", "50.0");
                hashMap.put("lockAscent", "true");
                this.impl.chaser.updateProperties(hashMap);
                this.impl.chaser.setActionSpeed(1.0f);
                break;
            }
        }
        this.updateFromImpl();
    }

    class DocumentAdapter
    implements DocumentListener {
        DocumentAdapter() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void update() {
        }
    }
}

