/*
 * Decompiled with CFR 0.152.
 */
package jmetest.input;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.AbsoluteMouse;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.MouseInput;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.shape.Box;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;
import jmetest.renderer.TestEnvMap;

public class TestHardwareMouse
extends SimpleGame {
    private AbsoluteMouse mouse;
    private Box spinningBox;
    private boolean useHardwareCursor;
    private Text currentTypeText;
    private final long SLEEPING_TIME = 20L;

    public static void main(String[] stringArray) {
        TestHardwareMouse testHardwareMouse = new TestHardwareMouse();
        testHardwareMouse.setDialogBehaviour(2);
        testHardwareMouse.start();
    }

    protected void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("g", false)) {
            boolean bl = this.useHardwareCursor = !this.useHardwareCursor;
            if (this.useHardwareCursor) {
                this.currentTypeText.print("Current cursor type: [HARDWARE]");
                this.mouse.setCullMode(2);
                MouseInput.get().setHardwareCursor(TestHardwareMouse.class.getClassLoader().getResource("jmetest/data/cursor/cursor1.png"));
                MouseInput.get().setCursorPosition((int)this.mouse.getLocalTranslation().x - this.mouse.getImageWidth() / 2, (int)this.mouse.getLocalTranslation().y + this.mouse.getImageHeight() / 2);
            } else {
                this.currentTypeText.print("Current cursor type: [SOFTWARE]");
                this.mouse.setCullMode(3);
                MouseInput.get().setCursorVisible(false);
            }
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    protected void simpleInitGame() {
        this.input = new InputHandler();
        this.cam.getLocation().set(0.0f, 0.0f, 150.0f);
        this.cam.update();
        this.mouse = new AbsoluteMouse("Mouse Input", this.display.getWidth(), this.display.getHeight());
        this.mouse.registerWithInputHandler(this.input);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)TestHardwareMouse.class.getClassLoader().getResource("jmetest/data/cursor/cursor1.png"), (int)2, (int)1));
        this.mouse.setRenderState((RenderState)textureState);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        this.mouse.setRenderState((RenderState)alphaState);
        this.rootNode.attachChild((Spatial)this.mouse);
        this.spinningBox = new Box("SpinBox", new Vector3f(), 10.0f, 10.0f, 10.0f);
        this.spinningBox.setModelBound((BoundingVolume)new BoundingBox());
        this.spinningBox.updateModelBound();
        TextureState textureState2 = this.display.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)TestEnvMap.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState2.setTexture(texture);
        this.spinningBox.setRenderState((RenderState)textureState2);
        this.rootNode.attachChild((Spatial)this.spinningBox);
        this.spinningBox.addController(new Controller(){
            float spinTime = 0.0f;

            public void update(float f) {
                this.spinTime += f;
                TestHardwareMouse.this.spinningBox.getLocalRotation().fromAngles(this.spinTime, this.spinTime, this.spinTime);
            }
        });
        KeyBindingManager.getKeyBindingManager().set("g", 34);
        Text text = new Text("Text", "Using forced sleep(20) to clearly show the difference...");
        text.setRenderQueueMode(4);
        text.setLightCombineMode(0);
        text.setLocalTranslation(new Vector3f(0.0f, (float)(this.display.getHeight() - 20), 1.0f));
        this.fpsNode.attachChild((Spatial)text);
        Text text2 = new Text("Text", "Key 'G': Switch between software/hardware mouse cursor");
        text2.setRenderQueueMode(4);
        text2.setLightCombineMode(0);
        text2.setLocalTranslation(new Vector3f(0.0f, 60.0f, 1.0f));
        this.fpsNode.attachChild((Spatial)text2);
        this.currentTypeText = new Text("Text", "Current cursor type: [SOFTWARE]");
        this.currentTypeText.setRenderQueueMode(4);
        this.currentTypeText.setLightCombineMode(0);
        this.currentTypeText.setLocalTranslation(new Vector3f(0.0f, 40.0f, 1.0f));
        this.fpsNode.attachChild((Spatial)this.currentTypeText);
    }
}

