/*
 * Decompiled with CFR 0.152.
 */
package jmetest.input;

import com.jme.app.BaseGame;
import com.jme.input.KeyBindingManager;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestKeyBinding
extends BaseGame {
    private Text text;
    private Camera cam;
    private Node scene;

    public static void main(String[] stringArray) {
        TestKeyBinding testKeyBinding = new TestKeyBinding();
        testKeyBinding.setDialogBehaviour(2);
        testKeyBinding.start();
    }

    protected void update(float f) {
        KeyBindingManager keyBindingManager = KeyBindingManager.getKeyBindingManager();
        if (keyBindingManager.isValidCommand("zero")) {
            this.text.print("You pressed 0.");
        }
        if (keyBindingManager.isValidCommand("one")) {
            this.text.print("You pressed 1 or L.");
        }
        if (keyBindingManager.isValidCommand("Combo")) {
            this.text.print("You pressed Shift and I");
        }
        if (keyBindingManager.isValidCommand("single") && !keyBindingManager.isValidCommand("Combo")) {
            this.text.print("You pressed I");
        }
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.scene);
    }

    protected void initSystem() {
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth(), this.properties.getFreq(), this.properties.getFullscreen());
            this.cam = this.display.getRenderer().createCamera(this.properties.getWidth(), this.properties.getHeight());
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        ColorRGBA colorRGBA = new ColorRGBA();
        colorRGBA.r = 0.0f;
        colorRGBA.g = 0.0f;
        this.display.getRenderer().setBackgroundColor(colorRGBA);
        this.cam.setFrustum(1.0f, 1000.0f, -0.55f, 0.55f, 0.4125f, -0.4125f);
        Vector3f vector3f = new Vector3f(4.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(0.0f, -1.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f vector3f4 = new Vector3f(-1.0f, 0.0f, 0.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.display.getRenderer().setCamera(this.cam);
        KeyBindingManager keyBindingManager = KeyBindingManager.getKeyBindingManager();
        keyBindingManager.set("zero", 11);
        keyBindingManager.set("one", 2);
        keyBindingManager.add("one", 38);
        int[] nArray = new int[]{54, 23};
        int[] nArray2 = new int[]{42, 23};
        keyBindingManager.set("Combo", nArray);
        keyBindingManager.add("Combo", nArray2);
        keyBindingManager.set("single", 23);
    }

    protected void initGame() {
        this.text = new Text("Text Label", "Press I, Shift-I, 0, 1, or L");
        this.text.setLocalTranslation(new Vector3f(1.0f, 60.0f, 0.0f));
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestKeyBinding.class.getClassLoader().getResource("jmetest/data/font/font.png"), (int)2, (int)1));
        this.text.setRenderState((RenderState)textureState);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        this.text.setRenderState((RenderState)alphaState);
        this.scene = new Node("Scene graph node");
        this.scene.attachChild((Spatial)this.text);
        this.cam.update();
        this.scene.updateGeometricState(0.0f, true);
        this.scene.updateRenderState();
    }

    protected void reinit() {
    }

    protected void cleanup() {
    }
}

