/*
 * Decompiled with CFR 0.152.
 */
package jmetest.input;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.ChaseCamera;
import com.jme.input.ThirdPersonHandler;
import com.jme.input.joystick.Joystick;
import com.jme.input.joystick.JoystickInput;
import com.jme.input.thirdperson.ThirdPersonJoystickPlugin;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.CullState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import com.jmex.terrain.TerrainPage;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.FaultFractalHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import jmetest.terrain.TestTerrain;

public class TestThirdPersonController
extends SimpleGame {
    private Node m_character;
    private ChaseCamera chaser;
    private TerrainPage page;

    public static void main(String[] stringArray) {
        try {
            JoystickInput.setProvider((String)"LWJGL");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        LoggingSystem.getLogger().setLevel(Level.OFF);
        TestThirdPersonController testThirdPersonController = new TestThirdPersonController();
        testThirdPersonController.setDialogBehaviour(2);
        testThirdPersonController.start();
    }

    protected void simpleInitGame() {
        this.display.setTitle("jME - 3rd person controller test");
        this.setupCharacter();
        this.setupTerrain();
        this.setupChaseCamera();
        this.setupInput();
        this.setupJoystick();
    }

    protected void simpleUpdate() {
        float f;
        this.chaser.update(this.tpf);
        float f2 = this.page.getHeight(this.cam.getLocation()) + 2.0f;
        if (!Float.isInfinite(f2) && !Float.isNaN(f2) && this.cam.getLocation().y <= f2) {
            this.cam.getLocation().y = f2;
            this.cam.update();
        }
        if (!Float.isInfinite(f = this.page.getHeight(this.m_character.getLocalTranslation()) + ((BoundingBox)this.m_character.getWorldBound()).yExtent) && !Float.isNaN(f)) {
            this.m_character.getLocalTranslation().y = f;
        }
    }

    private void setupCharacter() {
        Box box = new Box("box", new Vector3f(), 5.0f, 5.0f, 5.0f);
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        this.m_character = new Node("char node");
        this.rootNode.attachChild((Spatial)this.m_character);
        this.m_character.attachChild((Spatial)box);
        this.m_character.updateWorldBound();
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestThirdPersonController.class.getClassLoader().getResource("jmetest/data/images/Monkey.tga"), (int)2, (int)1));
        this.m_character.setRenderState((RenderState)textureState);
    }

    private void setupTerrain() {
        this.rootNode.setRenderQueueMode(2);
        this.fpsNode.setRenderQueueMode(4);
        this.display.getRenderer().setBackgroundColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setEnabled(true);
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        directionalLight.setDirection(new Vector3f(0.5f, -0.5f, 0.0f));
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)cullState);
        this.lightState.detachAll();
        this.lightState.attach((Light)directionalLight);
        FaultFractalHeightMap faultFractalHeightMap = new FaultFractalHeightMap(257, 32, 0, 255, 0.75f);
        Vector3f vector3f = new Vector3f(10.0f, 1.0f, 10.0f);
        faultFractalHeightMap.setHeightScale(0.001f);
        this.page = new TerrainPage("Terrain", 33, faultFractalHeightMap.getSize(), vector3f, faultFractalHeightMap.getHeightMap(), false);
        this.page.setDetailTexture(1, 16);
        this.rootNode.attachChild((Spatial)this.page);
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)faultFractalHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
        proceduralTextureGenerator.createTexture(512);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
        textureState.setTexture(texture, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestThirdPersonController.class.getClassLoader().getResource("jmetest/data/texture/Detail.jpg"), (int)6, (int)1);
        textureState.setTexture(texture2, 1);
        texture2.setWrap(3);
        texture.setApply(4);
        texture.setCombineFuncRGB(1);
        texture.setCombineSrc0RGB(0);
        texture.setCombineOp0RGB(0);
        texture.setCombineSrc1RGB(1);
        texture.setCombineOp1RGB(0);
        texture.setCombineScaleRGB(1.0f);
        texture2.setApply(4);
        texture2.setCombineFuncRGB(3);
        texture2.setCombineSrc0RGB(0);
        texture2.setCombineOp0RGB(0);
        texture2.setCombineSrc1RGB(3);
        texture2.setCombineOp1RGB(0);
        texture2.setCombineScaleRGB(1.0f);
        this.rootNode.setRenderState((RenderState)textureState);
        FogState fogState = this.display.getRenderer().createFogState();
        fogState.setDensity(0.5f);
        fogState.setEnabled(true);
        fogState.setColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 0.5f));
        fogState.setEnd(1000.0f);
        fogState.setStart(500.0f);
        fogState.setDensityFunction(0);
        fogState.setApplyFunction(0);
        this.rootNode.setRenderState((RenderState)fogState);
    }

    private void setupChaseCamera() {
        Vector3f vector3f = new Vector3f();
        vector3f.y = ((BoundingBox)this.m_character.getWorldBound()).yExtent * 1.5f;
        this.chaser = new ChaseCamera(this.cam, (Spatial)this.m_character);
        this.chaser.setTargetOffset(vector3f);
    }

    private void setupInput() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("doGradual", "true");
        hashMap.put("turnSpeed", "3.1415927");
        hashMap.put("lockBackwards", "false");
        hashMap.put("cameraAlignedMovement", "true");
        this.input = new ThirdPersonHandler((Spatial)this.m_character, this.cam, hashMap);
        this.input.setActionSpeed(100.0f);
    }

    private void setupJoystick() {
        Joystick joystick;
        ArrayList arrayList = JoystickInput.get().findJoysticksByAxis(new String[]{"X Axis", "Y Axis", "Z Axis", "Z Rotation"});
        Joystick joystick2 = joystick = arrayList.size() >= 1 ? (Joystick)arrayList.get(0) : null;
        if (joystick != null) {
            ThirdPersonJoystickPlugin thirdPersonJoystickPlugin = new ThirdPersonJoystickPlugin(joystick, joystick.findAxis("X Axis"), joystick.findAxis("Y Axis"), joystick.findAxis("Z Axis"), joystick.findAxis("Z Rotation"));
            ((ThirdPersonHandler)this.input).setJoystickPlugin(thirdPersonJoystickPlugin);
            this.chaser.getMouseLook().setJoystickPlugin(thirdPersonJoystickPlugin);
        }
    }
}

